/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.RSAKeyFactory;
import com.ibm.crypto.plus.provider.icc.RSAKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class RSAPrivateCrtKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateCrtKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -4315189411360884318L;
    private IBMJCEPlusProvider provider;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private transient boolean destroyed;
    private transient RSAKey rsaKey;
    private static final String[] z;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        block18: {
            this.provider = null;
            this.destroyed = false;
            this.rsaKey = null;
            this.algid = new AlgIdRSA();
            this.provider = iBMJCEPlusProvider;
            this.modulus = bigInteger;
            this.publicExponent = bigInteger2;
            this.privateExponent = bigInteger3;
            this.primeP = bigInteger4;
            this.primeQ = bigInteger5;
            this.primeExponentP = bigInteger6;
            this.primeExponentQ = bigInteger7;
            this.crtCoefficient = bigInteger8;
            if (this.modulus == null) throw new InvalidKeyException(z[8]);
            if (this.publicExponent == null || this.privateExponent == null) throw new InvalidKeyException(z[8]);
            if (this.primeP == null) throw new InvalidKeyException(z[8]);
            if (this.primeQ == null) throw new InvalidKeyException(z[8]);
            if (this.primeExponentP == null) throw new InvalidKeyException(z[8]);
            if (this.primeExponentQ == null) throw new InvalidKeyException(z[8]);
            if (this.crtCoefficient != null) break block18;
            throw new InvalidKeyException(z[8]);
        }
        RSAKeyFactory.a(this.provider, this.modulus.bitLength(), this.publicExponent);
        try {
            this.key = RSAPrivateCrtKey.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[7] + iOException.getMessage());
        }
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
            return;
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[6]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = null;
        this.destroyed = false;
        this.rsaKey = null;
        this.provider = iBMJCEPlusProvider;
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0] + iOException.getMessage());
        }
        RSAKeyFactory.a(iBMJCEPlusProvider, this.modulus.bitLength(), this.publicExponent);
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[1]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.provider = null;
        this.destroyed = false;
        this.rsaKey = null;
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = new AlgIdRSA();
            this.key = rSAKey.getPrivateKeyBytes();
            this.rsaKey = rSAKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[9]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    @Override
    public String getAlgorithm() {
        this.b();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.b();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.b();
        return super.getEncoded();
    }

    RSAKey a() {
        return this.rsaKey;
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            int n2 = derValue.getData().getInteger().intValue();
            if (n2 != 0) {
                throw new IOException(z[3]);
            }
            this.modulus = derValue.getData().getPositiveBigInteger();
            this.publicExponent = derValue.getData().getPositiveBigInteger();
            this.privateExponent = derValue.getData().getPositiveBigInteger();
            this.primeP = derValue.getData().getPositiveBigInteger();
            this.primeQ = derValue.getData().getPositiveBigInteger();
            this.primeExponentP = derValue.getData().getPositiveBigInteger();
            this.primeExponentQ = derValue.getData().getPositiveBigInteger();
            this.crtCoefficient = derValue.getData().getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[2]);
            }
        }
        catch (IOException iOException) {
            throw new IOException(z[4], iOException);
        }
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray()), new DerValue(2, bigInteger3.toByteArray()), new DerValue(2, bigInteger4.toByteArray()), new DerValue(2, bigInteger5.toByteArray()), new DerValue(2, bigInteger6.toByteArray()), new DerValue(2, bigInteger7.toByteArray()), new DerValue(2, bigInteger8.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    @Override
    public BigInteger getPrivateExponent() {
        this.b();
        return this.privateExponent;
    }

    @Override
    public BigInteger getModulus() {
        this.b();
        return this.modulus;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        this.b();
        return this.crtCoefficient;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        this.b();
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        this.b();
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getPrimeP() {
        this.b();
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        this.b();
        return this.primeQ;
    }

    @Override
    public BigInteger getPublicExponent() {
        this.b();
        return this.publicExponent;
    }

    private Object writeReplace() throws ObjectStreamException {
        this.b();
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.rsaKey = null;
            this.modulus = null;
            this.publicExponent = null;
            this.privateExponent = null;
            this.primeP = null;
            this.primeQ = null;
            this.primeExponentP = null;
            this.primeExponentQ = null;
            this.crtCoefficient = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void b() {
        if (this.destroyed) {
            throw new IllegalStateException(z[5]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "!N_\"BbOE:\u0006\u0006dxnC,BE*Cx\u0001";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                block20: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block20;
                    n5 = n5;
                    if (n5 <= n4) break block21;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 66;
                            break;
                        }
                        case 1: {
                            n6 = 33;
                            break;
                        }
                        case 2: {
                            n6 = 42;
                            break;
                        }
                        case 3: {
                            n6 = 78;
                            break;
                        }
                        default: {
                            n6 = 38;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0004@C\"C&\u0001^!\u0006!SO/R'\u0001x\u001dgbQX'P#UOnM'X";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u000bO\\/J+E\n\u001cu\u0003qX'P#UO\rT6jO7\u0006'OI!B+OMb\u0006&@^/\u0006-WO<T7O";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0014DX=O-O\n#S1U\n,Cb\u0011";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u000bO\\/J+E\n\u001cu\u0003\u0001Z<O4@^+\u0006)DS";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0016IC=\u0006)DSnO1\u0001D!\u0006.ND)C0\u0001\\/J+E";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0004@C\"C&\u0001^!\u0006!SO/R'\u0001x\u001dgbQX'P#UOnM'X";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "!N_\"BbOE:\u0006\u0006dxnC,BE*Cx\u0001";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0010rknm'X\n>G0@G+R'SYnE#OD!RbCOnH7MF";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0004@C\"C&\u0001^!\u0006!SO/R'\u0001x\u001dgbQX'P#UOnM'X";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

