/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.DSAKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = 8751667575123698655L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger y;
    private transient boolean destroyed = false;
    private transient DSAKey dsaKey = null;
    private static final String[] z;

    public DSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        byte[] byArray;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        try {
            byArray = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0] + iOException.getMessage());
        }
        try {
            byArray = this.b();
            this.dsaKey = DSAKey.createPublicKey(iBMJCEPlusProvider.a(), byArray);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[1]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public DSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.decode(byArray);
        try {
            byte[] byArray2 = this.b();
            this.dsaKey = DSAKey.createPublicKey(iBMJCEPlusProvider.a(), byArray2);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[3]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public DSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, DSAKey dSAKey) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = new AlgorithmId(AlgorithmId.DSA_oid, dSAKey.getParameters());
            byte[] byArray = this.a(dSAKey.getPublicKeyBytes());
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.dsaKey = dSAKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[5]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DSAParams getParams() {
        this.c();
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
        {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters != null) return algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            return null;
        }
    }

    @Override
    public BigInteger getY() {
        this.c();
        return this.y;
    }

    @Override
    public String getAlgorithm() {
        this.c();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.c();
        return super.getEncoded();
    }

    DSAKey a() {
        return this.dsaKey;
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.getKey().toByteArray());
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[4], iOException);
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(4);
        BigInteger bigInteger = derValueArray[0].getInteger();
        BigInteger bigInteger2 = derValueArray[1].getInteger();
        BigInteger bigInteger3 = derValueArray[2].getInteger();
        BigInteger bigInteger4 = derValueArray[3].getInteger();
        DerValue derValue = new DerValue(2, bigInteger.toByteArray());
        return derValue.toByteArray();
    }

    private byte[] b() throws IOException {
        DSAParams dSAParams = this.getParams();
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.y.toByteArray()), new DerValue(2, dSAParams.getP().toByteArray()), new DerValue(2, dSAParams.getQ().toByteArray()), new DerValue(2, dSAParams.getG().toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    public String toString() {
        return this.provider.getName() + z[2] + this.y.toString() + "\n";
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.dsaKey = null;
            this.y = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[6]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "v[8=\u0018{[9y|Pfm<Vv[)<\u0018l\u000em";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                block17: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block17;
                    n5 = n5;
                    if (n5 <= n4) break block18;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 21;
                            break;
                        }
                        case 1: {
                            n6 = 52;
                            break;
                        }
                        case 2: {
                            n6 = 77;
                            break;
                        }
                        case 3: {
                            n6 = 89;
                            break;
                        }
                        default: {
                            n6 = 56;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "SU$5]q\u001496\u0018vF(8Lp\u0014\t\ny5D8;T|Wm2]l";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "5p\u001e\u0018\u0018EA/5Qv\u0014\u0006<A/>";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "SU$5]q\u001496\u0018vF(8Lp\u0014\t\ny5D8;T|Wm2]l";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\\Z;8T|Pm\u001dkT\u0014=,Zy].ySpM";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "SU$5]q\u001496\u0018vF(8Lp\u0014\t\ny5D8;T|Wm2]l";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "A\\$*\u0018~Q4yQf\u0014#6\u0018y[#>]g\u0014;8T|P";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

