/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.DHParameters;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.DHKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class DHPublicKey
extends X509Key
implements javax.crypto.interfaces.DHPublicKey,
PublicKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -2993913181811776154L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger y = null;
    private DHParameters dhParams = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private transient boolean destroyed = false;
    private transient DHKey dhKey = null;
    private static final String[] z;

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        this.dhParams = new DHParameters(iBMJCEPlusProvider);
        try {
            this.dhParams.engineInit(new DHParameterSpec(bigInteger2, bigInteger3, n2));
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[6]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z[7]);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, DHParameters dHParameters) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        this.dhParams = dHParameters;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[9]);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, DHKey dHKey) {
        try {
            this.provider = iBMJCEPlusProvider;
            this.algid = new AlgorithmId(AlgorithmId.DH_oid, dHKey.getParameters());
            byte[] byArray = this.a(dHKey.getPublicKeyBytes());
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.dhKey = dHKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[1], (Throwable)exception);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.a(byArray);
            byte[] byArray2 = this.a();
            this.dhKey = DHKey.createPublicKey(iBMJCEPlusProvider.a(), this.encodedKey);
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[8], (Throwable)exception);
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new IOException(z[13]);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new IOException(z[11]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new IOException(z[20]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new IOException(z[16]);
            }
            if (derValue3.getTag() != 48) {
                throw new IOException(z[15]);
            }
            derValue3.getData().reset();
            BigInteger bigInteger = derValue3.getData().getInteger();
            BigInteger bigInteger2 = derValue3.getData().getInteger();
            int n2 = -1;
            if (derValue3.getData().available() != 0) {
                n2 = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new IOException(z[12]);
            }
            DHParameters dHParameters = this.dhParams = new DHParameters(this.provider);
            DHParameterSpec dHParameterSpec = n2 == -1 ? new DHParameterSpec(bigInteger, bigInteger2) : new DHParameterSpec(bigInteger, bigInteger2, n2);
            dHParameters.engineInit(dHParameterSpec);
            this.key = derValue.getData().getBitString();
            this.parseKeyBits();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(z[14]);
            }
            this.encodedKey = (byte[])byArray.clone();
            DerValue derValue4 = new DerValue(2, this.key);
            return derValue4.toByteArray();
        }
        catch (IOException | NumberFormatException exception) {
            throw new IOException(z[19], exception);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException(z[17], invalidKeyException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[18], invalidParameterSpecException);
        }
    }

    private byte[] a() throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.y.toByteArray()), new DerValue(2, this.dhParams.a().toByteArray()), new DerValue(2, this.dhParams.b().toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new InvalidKeyException(iOException.toString());
        }
    }

    @Override
    public DHParameterSpec getParams() {
        this.c();
        try {
            return this.dhParams.engineGetParameterSpec(DHParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw this.provider.a(z[21], (Throwable)invalidParameterSpecException);
        }
    }

    @Override
    public String getAlgorithm() {
        this.c();
        return z[0];
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.c();
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.dhParams.a());
                derOutputStream2.putInteger(this.dhParams.b());
                if (this.dhParams.c() != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.dhParams.c()));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream.putDerValue(derValue);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream);
                derOutputStream3.putBitString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        this.c();
        return this.y;
    }

    DHKey b() {
        return this.dhKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.dhKey = null;
            this.y = null;
            this.dhParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[10]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[2] + this.y.toString() + z[3] + this.dhParams.a().toString() + z[4] + this.dhParams.b().toString());
        if (this.dhParams.c() != 0) {
            stringBuffer.append(z[5] + this.dhParams.c());
        }
        return stringBuffer.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[22];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0002\u001a";
        int n3 = -1;
        block29: while (true) {
            char[] cArray;
            block33: {
                int n4;
                int n5;
                block32: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block32;
                    n5 = n5;
                    if (n5 <= n4) break block33;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 70;
                            break;
                        }
                        case 1: {
                            n6 = 82;
                            break;
                        }
                        case 2: {
                            n6 = 15;
                            break;
                        }
                        case 3: {
                            n6 = 62;
                            break;
                        }
                        default: {
                            n6 = 25;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u00003fRl47/Wwf\u0016Gnl$>f]R#+";
                    n3 = 0;
                    continue block29;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u000f\u0010BtZ\u0003rKW\u007f ;j\u0013Q#>cSx(r_K{*;l\u001eR#+54`|X";
                    n3 = 1;
                    continue block29;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "L\"54";
                    n3 = 2;
                    continue block29;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "L554";
                    n3 = 3;
                    continue block29;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "L>549fr/";
                    n3 = 4;
                    continue block29;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u00053aPv2r\u007fLv\"'l[9\u0007\u0001A\u0010(f7a]v\";aY";
                    n3 = 5;
                    continue block29;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u00053aPv2rfPp2;nRp<7/Nx43b[m# |";
                    n3 = 6;
                    continue block29;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u00003fRl47/Wwf\u0016Gnl$>f]R#+";
                    n3 = 7;
                    continue block29;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u00053aPv2r\u007fLv\"'l[9\u0007\u0001A\u0010(f7a]v\";aY";
                    n3 = 8;
                    continue block29;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0012:fM9-7v\u001ep5raQ9*=aY|4ry_u/6";
                    n3 = 9;
                    continue block29;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0007>hw}f;|\u001ew)&/_9\u0015\u0017^k\\\b\u0011J";
                    n3 = 10;
                    continue block29;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u0003*{Lxf\"nLx+7{[kf6nJx";
                    n3 = 11;
                    continue block29;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u000f<y_u/6/U|?riQk+3{";
                    n3 = 12;
                    continue block29;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u0003*l[j5rd[`f6nJx";
                    n3 = 13;
                    continue block29;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u00163}_t#&jLjf<`J9'r\\{H\u0013\u0017A}\\";
                    n3 = 14;
                    continue block29;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\b'cR963}_t#&jLj";
                    n3 = 15;
                    continue block29;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\u0003 }Qkf\"nLj/<h\u001er#+/Sx27}Wx*";
                    n3 = 16;
                    continue block29;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u0003 }Qkf1}[x2;aY9\u0002\u001a__k'?jJ|4!";
                    n3 = 17;
                    continue block29;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u0003 }Qkf\"nLj/<h\u001er#+/[w%=kWw!";
                    n3 = 18;
                    continue block29;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\u00163}_t#&jLjf?fMj/<h";
                    n3 = 19;
                    continue block29;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "\u00003fRl47/Wwf\u0016Gnl$>f]R#+";
                    n3 = 20;
                    continue block29;
                }
                case 20: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

