/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.DHKey;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private static final DHParameterSpec a;
    private static final DHParameterSpec b;
    private static final DHParameterSpec c;
    private static final DHParameterSpec d;
    private static final DHParameterSpec e;
    private static final DHParameterSpec f;
    private IBMJCEPlusProvider g = null;
    private int h = 0;
    private static final String[] z;

    public DHParameterGenerator(IBMJCEPlusProvider iBMJCEPlusProvider) {
        this.g = iBMJCEPlusProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(int n2, SecureRandom secureRandom) {
        if (n2 >= 512 && n2 <= 4096 && n2 % 64 == 0) {
            this.h = n2;
            return;
        }
        throw new InvalidParameterException(z[5]);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[4]);
        }
        throw new InvalidAlgorithmParameterException(z[3]);
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(z[0], this.g);
            if (this.h <= 0) {
                throw new ProviderException(z[1]);
            }
            byte[] byArray = DHKey.generateParameters(this.g.a(), this.h);
            algorithmParameters.init(byArray);
            return algorithmParameters;
        }
        catch (Exception exception) {
            throw this.g.a(z[2], (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DHParameterSpec a(int n2) {
        switch (n2) {
            case 512: {
                return a;
            }
            case 768: {
                return b;
            }
            case 1024: {
                return c;
            }
            case 2048: {
                return d;
            }
            case 3072: {
                return e;
            }
            case 4096: {
                return f;
            }
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[18];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "~f";
        int n3 = -1;
        block25: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                block28: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block28;
                    n5 = n5;
                    if (n5 <= n4) break block29;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 58;
                            break;
                        }
                        case 1: {
                            n6 = 46;
                            break;
                        }
                        case 2: {
                            n6 = 40;
                            break;
                        }
                        case 3: {
                            n6 = 113;
                            break;
                        }
                        default: {
                            n6 = 95;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "~fo\u00141jOZ\u00102_ZM\u0003\fJKKQ1UZ\b\u0002*J^G\u0003+_J";
                    n3 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "|OA\u001d*HK\b\u00181\u001aIM\u001f:HO\\\u0014\u0018_@M\u0003>NKx\u0010-[CM\u0005:H]";
                    n3 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "~fo\u00141jOZ\u00102_ZM\u0003\fJKKQ1UZ\b\u0002*J^G\u0003+_J";
                    n3 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "jOZ\u00102I\u000eE\u0004,N\u000eJ\u0014\u007fS@[\u0005>TMMQ0\\\u000el9\u0018_@x\u0010-[CM\u0005:H}X\u0014<";
                    n3 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "j\\A\u001c:\u001a]A\u000b:\u001aC]\u0002+\u001a\\I\u001f8_\u000eN\u00030W\u000e\u001d@m\u001aZGQk\n\u0017\u001eQ>TJ\b\u0013:\u001aO\b\u001c*VZA\u00013_\u000eG\u0017\u007f\f\u001a";
                    n3 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0003\u001b\u0010Ek\tO\u001fF:\\KI\u0010<\u000e\u001e\u0019A=\r\u001bN@9_\u001cIH=^\u001aL\u0010i\u0002\u0018JBj\u0003\u001b\u0010Ek\tO\u001eF:\\KI\u0010<\u000e\u001e\u0019A=\r\u001bN@9_\u001cIH=^\u001aL\u0010i\u0002\u0018JBj\u0003\u001b\u0010Ek\tO\u001dEi\f\u0017IDh\r\u0017M\u0013kYJ\u001b\u0017h\u000bM\u0019Hh\fHKA=\u0003\u001d\u001aAjX\u001dI\u0013nYHJ";
                    n3 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\t\u001b\u0011\u0012k\fJ\u001cHf\bK\u001e\u0010>Y\u001b\u001bDi\f\u0016\u001a@9\n\u001aK\u0014gY\u001fL\u0014>\u000f\u001f\u001b\u0017>[\u001bKC9\u000f\u001e\u001aD9\u000fHM\u0015nXJ\u001cDj\fJ\u001e\u0015<\f\u0016\u001f@n^J\u001c\u0010gY\u001eIBj^\u001e\u0018@:X\u001eL\u0010=\\\u001b\u0011\u0012f\u000b\u0018I\u0015>XO\u0011Am\t\u0016\u0010H:YL\u0011F<\b\u0018MHl\u000e\u001e\u0010\u0017l\u000f\u0019\u001bH<\u0003\u001a\u001aFi\u000f\u0019\u001bE;\r\u0016\u001f\u0012h^\u001f\u0018\u00149XHI\u0017;_\u001cKIf_\u001f\u001b\u0012m\u0003\u0016\u001fA=Y\u001a\u0010H9\u0002\u001eLB9\\JIGk\u0002\u001e\u001a\u0012n\fO";
                    n3 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0003\u0019\u0018Ig^LNB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^LMB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^LLB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^LKB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^LJB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^LIB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u0011B=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u0010B=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u001fB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u001eB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u001dB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u001cB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u001bB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u001aB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u0019B=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^L\u0018B=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^ONB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^OMB=XL\u0010\u0010n\r\u001e\u0010Bm\u000e\u001a\u0018\u0010mY\u0018JFg\r\u0016\u0019I>Y\u0016\u001d\u00179\u000b\u0019\u0018Ig^OKF=\u000fM\u0010\u0014<\fHNI<\u0003\u001bKH9\b\u001dKFm\\K\u001b\u0014j\u000f\u0018\u0010\u0017<YJM\u0015m^KN";
                    n3 = 7;
                    continue block25;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0002KNDg\u0003O\u001d\u0010=_\u001aKA=YK\u001fIi\r\u0018\u0010Ho_O\u0010\u0017m\u000f\u0019\u001cDk\n\u001b\u001c\u0014j\tH\u001eF=\u000f\u0018\u0019A9\u0003\u001f\u0019\u00129_L\u001c\u00149\u000b\u001c\u0010\u0013m\u0002\u001f\u001aC=\tJ\u001bH>\tJKCf^\u0016LA>\b\u001eMFf\r\u001aLA9\n\u001d\u0010IjXL\u0018\u0010j_MLEo\t\u0019\u0010Hm[\u001dMEi\u000f\u0016\u001cGj[M\u0018Il\u000b\u001fKBn\n\u0018N\u0017=X\u0018\u001bEo\r\u001a\u001cDf\\KKBk\fH\u001dIh\u0002\u001b\u0019\u0010m\r\u001dMG=\u000fJ\u001c\u0014g\r\u001f\u0011F=YM\u001e\u0017m\bM\u001d\u0013o\u0003\u001fI\u0015i\u000b\u001a\u001b\u0014j\f\u001aJ\u0015k\t\u001e\u0011Bo^L\u001eEm\fHIB9\u000eM\u001f\u0015=\u000fO\u001aA=[L\u001cBk[\u0019\u001cD<\u0002\u0017M\u0013h_K\u001a\u0015g[\u001b\u0011Bl\b\u0019I\u0013;\f\u0018\u001a\u0017f\\JM\u0012:\u000eO\u0010\u0015n[\u001dL\u0012>\n\u0018\u0011G;Y\u001a\u001b\u0013:\f\u001d\u0011\u0015<\\MKDf\u0002\u0017IA>Y\u0017M\u0014m\u000b\u0017\u001eA9\fJKFo\u000f\u0017JEi\u0002MN@j\tM\u001bHl[\u0016\u001aG:^\u001a\u0010\u0012<_LICf\nMND>\u000e\u001eM\u0014f\\\u001a\u001c\u0012j\n\u001b\u001a\u0014jYM\u0010Eg\u000f\u0016KEg\u0003\u001a\u001bH9\r\u001dJDl\u000eK\u0018Dg[J\u0011\u0012<\f\u0018JI:X\u001f\u001aGh\u000f\u001a\u001dGjY\u001dJ\u0017<\u0002OJEo[\u0018NCl\u000eO\u001e@i\u000f\u001b\u0010A>X\u001b\u001fGiYK\u001c@:\fKK\u0015n^\u001c\u001fE=\u0003\u001bI@kX\u0016\u0019H:\rK\u0011Im\u0002\u0016\u001e\u0014l\nJL\u0010f\tL\u001aIl^\u0017N@g\u0002\u001c\u001b\u0010n^L\u0018Am\\\u0017\u001cCi[\u0017\u0010I=\u000f\u0016JDo\u0002K\u001cHk^\u0016\u001d\u0014f\fHLH9[K\u0018Cm\f\u0018\u001cEk\t\u0019\u001dD=\u0002H\u001eG:_O\u001fEn\u000e\u001e\u0010\u0010hYJ\u001d\u0017h\n\u0017\u001fBh\r\u001bL\u0017<\f\u001bLD:\\\u001aII;[\u001d\u0018@;\u0003\u0017M\u0010n[\u001a\u001cF>\u000bMK\u0015:\rKNGk\u0003\u001eIDh\f\u0019\u001d@=_L\u0018@9\b\u0016\u0019\u0010f[\u001b\u0019@<[\u001eKBk\f\u001f\u001c\u0010o\b\u0018\u0011Em\u0003M\u0018\u0012o^\u001e\u001d\u0012k\\\u001d\u001eDh\r\u001e\u001d\u0012h\nMJCm\u000b\u0018KFk\tK\u001bHk\\L\u001cF>\u0003\u001c\u001aDi\\\u001e\u001cA:[\u001a\u001f\u0017;Y\u001a\u0018\u0015<\u000f\u0018\u001bH>\\\u001f\u0010\u00139_\u001d\u001a\u0015o\u000eL\u001aHn\n\u001a\u001bAk\u0003\u001bMC;\bM\u001eD<\fKJAf\\HIAf\u000e\u001fKFj\tJNA=Y\u001e\u001bF9\u000e\u001d\u001aFo[\u0018\u001fA;\t\u001d\u001f\u0014m^KI\u0014i_\u001e\u0010G<[\u001aI@m\rOK\u0012<\u000b\u001c\u0019B=\u0003\u0017\u001a\u0013kY\u0017\u001d\u0010j[O\u001fBo\t\u0019\u0011A=^\u001b\u0018Gg\u000f\u001cMD:_\u0019\u001a\u0014l_H\u001aCf\r\u0018\u001cBo\u000f\u0018\u0018Bm\u0003\u0019M\u0013o[M\u001a\u0014jXK\u001c\u0015k\u000f\u001a\u0018\u0012;\bOL\u0013:\u0002\u001fLBm_\u001f\u0018@g\bJ\u001bH;\u000b\u0017JFf[\u0016\u001c\u0017j\u000f\u0017\u001eGh^\u001bJ\u0017o_\u001c\u001f\u0014h\nJMChYL\u001dHn[\u001f\u0011Dh\nM\u0018\u0015g\u0002\u001c\u001bCh\u0003HK\u00139^OK\u00109\tO\u0018Gh\u000eK\u001dC<\u000b\u001b\u0010G=\b\u001cI\u0010;\n\u001b\u001bEg[\u001fK\u0014<\u000e\u001aI@i^J\u001fGo\u000f\u0017\u0019Di\r\u001cN\u0013k\u000e\u001a\u0010\u0017n_O\u001dB";
                    n3 = 8;
                    continue block25;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u000fL\u001f\u0010k\bK\u001d\u0014lY\u001bIB;Y\u001b\u001f\u0012=\\M\u0011\u0017=\n\u001aLH;\\\u001f\u001dAi\f\u001c\u001aD9[\u001f\u001eHl[LLHg\u0002\u001b\u001fB>\rKKDf\fLLBi\\\u001e\u001f\u0015;\u000bO\u001d@k\b\u0017\u001eBk\u000eJ\u001d@i\\J\u001fGh^J\u001bCm\u000fOMBj\n\u001e\u001b\u0013n\nJ\u001fHj\r\u0016\u0010\u0014:^\u001a\u001f\u0017i\u000bH\u0011C9\b\u0016N\u0013:[K\u0018\u0015<[\u0019NEk[M\u001d\u0017gX\u0019\u0011Io_\u001c\u001cF=^\u001b\u001b\u0015l\u000eK\u001f\u0017nX\u001d\u001f\u0015l\t\u001d\u0010\u0010i^J\u0018Cj\\KKFj_\u0019\u001c@fXMN@;\f\u0019I\u0012i[O\u001aFk_MME9\u0003\u0017K\u0012f\u000eKJGj\\\u0019\u001d\u0017o\u000fLM\u0012h\u000eO\u0019Ik\r\u001bMD>\u000fML\u0013l\u0003\u0017LGl\u000b\u0016\u001eD:\t";
                    n3 = 9;
                    continue block25;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "X\u0019\u0010@9\u000b\u0016\u0019An\b\u001fIIg\u000bJ\u001a\u0013k\f\u001cKB<\t\u001a\u001eI<Y\u0016MFf\u000b\u0017\u001f@<\bH\u001a\u0010g\t\u0019K\u0017m\nK\u001cDm\r\u001fN\u0010<\\\u001d\u0019@h\bO\u001b\u0015<\u000e\u001c\u0010Gg\u000f\u0017IE9\bL\u001cCf\u000f\u001eL\u0015h^\u0018KDg\f\u0017MHm\\\u0016\u001eBf\t\u001dI\u0010l\u0002\u0016\u001fCg\u000e\u001d\u001fBm[\u0017\u001bF=\rHL\u0012;_\u001eIDgYK\u001bAm\f\u0017\u001bCh\b\u001eL\u0012k\\J\u001d\u0014k\n\u001c\u001aD=\u000fM\u001f\u0015k\u0002\u001e\u001e\u0010=[\u0019\u001a\u0017o\u000e\u001e\u0018Do^LMAnY\u001aKI>\u0002\u0018\u001aG<\n\u0016\u0010\u00109\tHJFn^L\u001b\u0015i\nM\u001a\u0012:\u0002\u001e\u001fC:\f\u001e\u0018Bg\u000b\u001fI@<\\\u0016\u0011Ej\bO\u001e\u0015;\nKLIj\u000f\u001b\u001a@i\u0003\u001d\u001fCk\fMIC:^\u0017ID9\f\u001d\u001bI9^\u0019\u001dGf\bMKBj\u000bHM\u00139\nH\u001d\u0012o\u000e\u001eME=Y\u001eNDf\u0003H\u001dB:^\u001a\u0018\u0015>\r\u001e\u001fGl\u0003\u001a\u0010\u0017g_OK\u0012<\f\u0017\u0018\u0012k^JN\u0015n\u0003\u001fJE=_\u001dIH;\n\u001e\u001cF9Y\u0019\u001aE=\fM\u0011I:\u0003H\u001fI=^HIBf\bM\u001fDm\rK\u001b\u0013<\u000f\u001f\u001b\u0017jY\u0018N\u0010mYK\u0018I:\b\u001aI\u0014g\\\u0017\u001f\u0014<\u000fM\u001e\u0013;_\u0016N\u0015g\nJMChXHK\u0017h^\u001e\u001dC:\n\u001c\u0018D;_\u0017\u0011\u0014f^LMB:\u000b\u0018N@<\u000f\u001c\u001a@g\u000b\u001b\u0011A9Y\u0016J\u0017k^\u001e\u0019\u0013h\b\u001aLF=YOKGj\tJNG:\u0003\u0017\u001cA;XKL@>\u0003\u001f\u0019\u0017iX\u001dJG>^OK\u0010;\f\u001f";
                    n3 = 10;
                    continue block25;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "XHN@f\fK\u001dAk\u000fLJFf\u000f\u001fL\u0012=\tKN\u0012j\n\u0016\u001eHf_\u001e\u0019\u0012o^\u001aJCo\u0002HIEj\u0002J\u001b\u0010g^\u001b\u001a\u0012k\u000b\u001e\u0010@<\r\u001e\u0019\u0013l\\H\u0019Hi_\u001b\u0018EjXL\u001fHj\u000bJK\u0013l_HKDo\u0002\u0018\u0011H:\n\u001fKA;\u000eL\u001aAg\\O\u001cDg^\u001dII;\u000f\u001cKEn\n\u0016\u0019\u0012h\n\u001fIB9\\\u001f\u0011G:\u000f\u001e\u001cD=X\u0019\u0011Dn^MJB:\\M\u001dAg\f\u0017\u0011\u0014o\u000bM\u0018\u0015kX\u001c\u0018I9[\u001a\u001dI;\tO\u0010\u0015j\bM\u001c@o\u0002\u001fKFo\u000b\u0017\u001b\u00179\u000b\u0017\u001e\u0014j\n\u001a\u001d\u0013=\r\u0017\u001d@;YL\u001b\u00149Y\u001b\u0018Ii\u0003\u0017MAnY\u001eLE=\b\u001e\u0010\u0017>\u000e\u001b\u0010\u0015l[\u0016LDmY\u001a\u0019Ag\u000bM\u001fAn\u0002\u001dN\u0017n\u0003\u0018MDo\u000e\u001bJ\u0013h\u0003\u001b\u0019\u0015<X\u001dM\u0017<\u000f\u001e\u0010Gf\u0003K\u0018@<\nJ\u001c\u0013m\n\u0016N\u0010k\u000f\u0016LB>\u0002J\u001dC<\u000e\u001f\u0018InY\u0019\u0018@h\tHN@f\fK\u001dAk\u000fLJFf\u000f\u001fL\u0012=\tKN\u0012j\n\u0016\u001eHf_\u001e\u0019\u0012o^\u001aJCo\u0002HIEj\u0002J\u001b\u0010g^\u001b\u001a\u0012k\u000b\u001e\u0010@<\r\u001e\u0019Gl\\H\u0019Hi_\u001b\u0018EjXL\u001fHj\u000bJK\u0013l_HKDo\u0002\u0018\u0011H:\n\u001fKA;\u000eL\u001aAg\\O\u001cDg^\u001dII;\u000f\u001cKEn\n\u0016\u0019\u0012h\n\u001f\u001c\u0015g\nJ\u001b@g\u000b\u0016NFl\u000b\u001bI@k\u000fM\u0011\u0015o\u000e\u001a\u001dB=\u0003O\u001cI=_\u001d\u001dDl\bOK\u0012k\t\u001bLHi\u000bK\u0011Go\u000fJL\u0015;\\K\u001d\u00129X\u0017";
                    n3 = 11;
                    continue block25;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0003\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001eE<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001eB<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001eC<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001e@<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001eA<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001d\u0017<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001d\u0014<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001d\u0015<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001d\u0012<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001d\u0013<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001d\u0010<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001dH<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001dI<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001dF<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001dG<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001dD<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001dE<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001dB<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001dC<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001d@<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001dA<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001c\u0017<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001c\u0014<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001c\u0015<\u000e\u001eKDn\\\u001dLHf\n\u001d\u001c\u0010:\u000b\u0016\u0018\u00129\u0003J\u001dC9\u000e\u0019IC<\u000b\u0018JBh\b\u001d\u001c\u0013:YMJ\u0012=^\u001d\u001a\u0017l\u000eL\u001c\u0015=\u000bHN\u0014jYKL\u0015i\b\u001cN@j\u000b\u0019IE>Y\u0016\u0019F";
                    n3 = 12;
                    continue block25;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\t\u0019\u0011A:\f\u001bMBk_L\u001b\u0012h\b\u0017\u0018Dk\u000fJ\u001eCn[LN\u0012i^J\u001e\u0010i\u000eO\u001b\u0013k\u000b\u001b\u001f@f\u0002\u001dJFl\u0003\u0019MBh_\u001a\u001a\u0010h\u000b\u001e\u001b@>\u000eO\u001a\u0014f_\u001b\u001b\u0013lY\u001eMC=[\u001dL@h\u000bK\u0019B>\bM\u001dGo\u000f\u001dNDg^LL\u0014hXM\u001eF;\rM\u0019F;^OJ\u0012f_KK\u0017g\u0003MIFi\u000b\u001cMFk\u0003O\u0018C;\t\u0016N\u0017>\b\u001e\u0018\u0015j\n\u0016LDm\u000e\u001eM@j\f\u001fMHh[\u001d\u001f@>_JL\u0017n\nOLFl\t\u0019\u001eD:Y\u0017\u001dD;_\u0016\u0019\u0010<_\u001eMDi\u000bL\u0010Eg\u0002\u0018\u001d\u00129^\u001cJ\u0013;_O\u001a\u0014nY\u0016LFj\u000e\u001e\u001e\u0014f\u0002\u001cJ\u0012i\rM\u001fCk_O\u0019Df\b\u001d\u001a\u0017<\u000b\u0018LGn\u000e\u001d\u001f\u0012k\u000e\u001aMD;\\J\u001dH9_\u001d\u001dFk\t\u001eMIl\\J\u001f\u0014<\u000e\u0019\u001fIh\u0003\u001a\u001f\u0017l\nOMBh^\u001a\u001fHl\u000fK\u001aI;^OJGg\b\u0019\u0010@<^HJCh\u000f\u001a\u0018\u0017>[KL\u0010:\u0002\u001b\u001e@;_\u001d\u0019\u0010o\u000e\u001cJ\u0012m[MLD=\fL\u001dDiYLKI:^\u0018\u0011E;\t\u001a\u001cC9\r\u0017\u0018An[\u0018MHm\f\u001c\u0010A:_\u0019LHn\n\u001dMAk\t\u001d\u001d\u0012>\u0002\u001f\u0019\u0013jX\u001f\u001bGn\u000eM\u001a\u0017fX\u001d\u001aI:\\O\u001a\u0017g\n\u0016I\u0017o^M\u0010@l\u000b\u001b\u0010Cg\b\u001e\u001cE:YH\u0010G<\t\u001b\u001cDh\fL\u001eEj\\MN\u0015<\u0003\u001fMIl\t\u0017\u001e@;\u000fK\u0018\u0010hX\u001f\u001aBo\f\u001aLCl\n\u001b\u0011\u0010g\u000eON\u0014o\\M\u001aAn\u000e\u001dJCgX\u001aMCf[H\u001dGfY\u001c\u0018E=\fJI\u0012h\\\u001a\u001dB>\\\u0017LIi\rJ\u001aB<\u000e\u0019K\u0015l\u000fL\u0019Df^OLCgYJ\u0010B9^KL\u0015l\bONF=\u0003\u001eMIj^MN\u0010m^\u0019\u001d\u0013o\tO\u001d\u0015;\rLKFj\tK\u001aBi\t\u0018IB=\n\u001eKDn\n\u001f\u0018\u0012:\u0003\u001e\u001dC=\\\u0018\u001c\u0010o\u0002\u0018\u0018B=Y\u0018\u001aBf\r\u0017\u001fDl\b\u0017JGkX\u001dLEj\u000e\u0019JD<_\u001c\u0011B<X\u001dLBo\u000e\u001a\u0018Il\f\u0019\u0019\u0014i^\u0018NIgX\u001b\u0011Gi^\u001c\u0019A9\n\u001f\u001cGj\bO\u0010\u0013<_\u001e\u001cA;^\u001eMI:\\JMGo\rO\u001e\u0017jY\u0017\u0010Eo[MMH>\r\u001b\u001bGh\u0003MK\u0013n\\M\u0018H:\bLMBh_\u001fM\u0012n\u0002L\u0019";
                    n3 = 13;
                    continue block25;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "[\u0016\u0018\u0017i\t\u0016\u0018C:\\\u001f\u0019\u0013;[\u001c\u0011Ai^L\u0018\u0017h\u000e\u0018\u0019\u0013<YJI@gX\u0016K\u0014<\b\u0016\u0018\u0017i\t\u0016\u0018C:\\\u001f\u0019\u0013;\u0003\u001c\u0011Ai^L\u0018\u0017h\u000e\u0018\u0019\u0013<YJI@gX\u0016K\u0014<\b\u0016\u0018\u0017i\t\u0016\u0018C:\\\u001f\u0019\u0013;\u0002\u001c\u0011Ai^L\u0018\u0017h\u000e\u0018\u0019\u0013<YJI@gX\u0016K\u0014<\b\u0016\u0018\u0017i\t\u0016\u0018C:\\\u001f\u0019\u0013;\r\u001c\u0011Ai^L\u0018\u0017h\u000e\u0018\u0019\u0013<YJI@gX\u0016K\u0014<\b\u0016\u0018\u0017i\t\u0016\u0018C:\\\u001f\u0019\u0013;\f\u001c\u0011Ai^L\u0018\u0017h\u000e\u0018\u0019\u0013<YJI@gX\u0016K\u0014<\b\u0016\u0018\u0017i\t\u0016\u0018C:\\\u001f\u0019\u0013;\u000eM\u001bEl^K\u0011\u0013>^\u0016\u0019\u0017=\\HL\u0017nY\u001b\u001a\u00139\\\u001d\u001bG>\u0002\u001a\u001dFn\u0003HKGk\u000b";
                    n3 = 14;
                    continue block25;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\tK\u0019\u0013o\fLL\u0017iX\u001c\u001b\u0012<\t\u0018\u001bC:\u0003\u0016\u0019GkYM\u001f\u0012m\\\u001d\u001b\u0013>\fK\u001dEi\r\u001e\u0018@f\fJL\u0017k\u000b\u001bN\u0017k[\u0016\u0018Ef[\u001e\u001f@9\b\u001a\u001e\u0010<\u000e\u0016\u0019@m\u000b\u001aLB9\u0002\u001f\u0010Af\f\u0016\u001fC;\u0003\u0019IH>\rLKG<\bJ\u0018Fk\f\u001dLCj\f\u0016NA;\u000f\u0016\u0011\u0014j[HNBj\\\u001eJ";
                    n3 = 15;
                    continue block25;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\u0003\u001e\u0011Dh\u000f\u001a\u001c\u0017f\u000f\u0016\u0010\u0013l[\u0017LH;\bOKC;\b\u0019NI;[\u0017LFh\n\u0017NBm\u000b\u001e\u0011Dh\u000f\u001a\u001c\u0017f\u000f\u0016\u0010\u0013l[\u0017LH;\bOKC;\b\u0019NI;[\u0016LFh\n\u0017NBm\u000b\u001e\u0011Dh\u000f\u001a\u001c\u0017f\u000f\u0016\u0010\u0013l[\u0017LH;\bOKC;\b\u0019NI;[\u0019LFh\n\u0017NBm\u000b\u001e\u0011Dh\u000f\u001a\u001c\u0017f\u000f\u0016\u0010\u0013l[\u0017LH;\bOKC;\b\u0019NI;[\u0018\u001dGh_JK@lXMKI9\nK\u0011\u0010j^K\u001bHl\r\u001fMEj\t\u001bLFh\u000b\u001c\u001fIo\u000bJ";
                    n3 = 16;
                    continue block25;
                }
                case 16: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        BigInteger bigInteger = new BigInteger(z[6], 16);
        BigInteger bigInteger2 = new BigInteger(z[16], 16);
        a = new DHParameterSpec(bigInteger, bigInteger2);
        BigInteger bigInteger3 = new BigInteger(z[17], 16);
        BigInteger bigInteger4 = new BigInteger(z[7], 16);
        b = new DHParameterSpec(bigInteger3, bigInteger4);
        BigInteger bigInteger5 = new BigInteger(z[15], 16);
        BigInteger bigInteger6 = new BigInteger(z[10], 16);
        c = new DHParameterSpec(bigInteger5, bigInteger6);
        BigInteger bigInteger7 = new BigInteger(z[12], 16);
        BigInteger bigInteger8 = new BigInteger(z[11], 16);
        d = new DHParameterSpec(bigInteger7, bigInteger8);
        BigInteger bigInteger9 = new BigInteger(z[8], 16);
        BigInteger bigInteger10 = new BigInteger(z[14], 16);
        e = new DHParameterSpec(bigInteger9, bigInteger10);
        BigInteger bigInteger11 = new BigInteger(z[13], 16);
        BigInteger bigInteger12 = new BigInteger(z[9], 16);
        f = new DHParameterSpec(bigInteger11, bigInteger12);
    }
}

