/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.security.CachedCertificatesHelper;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.GeneralUtil;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.xml.CustomParser;
import com.sun.deploy.xml.XMLAttribute;
import com.sun.deploy.xml.XMLEncoding;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.Globals;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtDownloadDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JavaFXAppDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LibraryDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.javaws.jnl.UpdateDesc;
import com.sun.javaws.jnl.XMLUtils;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.xml.sax.SAXParseException;

public class XMLFormat {
    public static XMLNode parseBits(byte[] byArray) throws JNLParseException {
        String string = XMLFormat.decode(byArray).trim();
        try {
            return new XMLParser(string).parse();
        }
        catch (SAXParseException sAXParseException) {
            try {
                return new CustomParser(string).parse();
            }
            catch (Exception exception) {
                throw new JNLParseException(string, sAXParseException, "exception parsing jnlp file", sAXParseException.getLineNumber());
            }
        }
        catch (Exception exception) {
            throw new JNLParseException(string, exception, "exception parsing jnlp file", 0);
        }
    }

    private static String decode(byte[] byArray) throws JNLParseException {
        try {
            return XMLEncoding.decodeXML((byte[])byArray);
        }
        catch (Exception exception) {
            throw new JNLParseException(null, exception, "exception determining encoding of jnlp file", 0);
        }
    }

    public static LaunchDesc parse(byte[] byArray, URL uRL, URL uRL2, URL uRL3) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        String string = XMLFormat.decode(byArray).trim();
        XMLNode xMLNode = null;
        JNLParseException jNLParseException = null;
        SAXParseException sAXParseException = null;
        try {
            xMLNode = new XMLParser(string).parse();
        }
        catch (SAXParseException sAXParseException2) {
            sAXParseException = sAXParseException2;
            jNLParseException = new JNLParseException(string, sAXParseException2, "exception parsing jnlp file", sAXParseException2.getLineNumber());
            try {
                xMLNode = new CustomParser(string).parse();
            }
            catch (Exception exception) {
                throw jNLParseException;
            }
        }
        catch (Exception exception) {
            throw new JNLParseException(string, exception, "exception parsing jnlp file", 0);
        }
        try {
            LaunchDesc launchDesc = XMLFormat.process(xMLNode, string, uRL, uRL2, uRL3);
            if (sAXParseException != null) {
                Trace.println((String)("-----------\nWARNING: the jnlp file is invalid and will be blocked in a future release.\nException: " + sAXParseException + "\n" + "-----------"));
            }
            return launchDesc;
        }
        catch (JNLParseException jNLParseException2) {
            if (jNLParseException != null) {
                throw jNLParseException;
            }
            throw jNLParseException2;
        }
        catch (BadFieldException badFieldException) {
            if (jNLParseException != null) {
                throw jNLParseException;
            }
            throw badFieldException;
        }
        catch (MissingFieldException missingFieldException) {
            if (jNLParseException != null) {
                throw jNLParseException;
            }
            throw missingFieldException;
        }
        catch (IOException iOException) {
            if (jNLParseException != null) {
                throw jNLParseException;
            }
            throw iOException;
        }
    }

    private static LaunchDesc process(XMLNode xMLNode, String string, URL uRL, URL uRL2, URL uRL3) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        URL uRL4;
        InformationDesc informationDesc = null;
        ResourcesDesc resourcesDesc = null;
        UpdateDesc updateDesc = null;
        ApplicationDesc applicationDesc = null;
        AppletDesc appletDesc = null;
        JavaFXAppDesc javaFXAppDesc = null;
        LibraryDesc libraryDesc = null;
        InstallerDesc installerDesc = null;
        String string2 = null;
        if (xMLNode == null || xMLNode.getName() == null) {
            throw new JNLParseException(string, null, null, 0);
        }
        if (xMLNode.getName().equals("player") || xMLNode.getName().equals("viewer")) {
            String string3 = XMLUtils.getAttribute(xMLNode, null, "tab");
            return LaunchDescFactory.buildInternalLaunchDesc(xMLNode, string3);
        }
        if (!xMLNode.getName().equals("jnlp")) {
            throw new MissingFieldException(string, "<jnlp>");
        }
        String string4 = XMLUtils.getAttribute(xMLNode, "", "spec", "1.0+");
        String string5 = XMLUtils.getAttribute(xMLNode, "", "version");
        URL uRL5 = URLUtil.asPathURL((URL)XMLUtils.getAttributeURL(string, uRL, xMLNode, "", "codebase"));
        if (uRL5 == null && uRL != null) {
            uRL5 = uRL;
        }
        if ((uRL4 = XMLUtils.getAttributeURL(string, uRL5, xMLNode, "<applet-desc>", "documentbase")) == null) {
            uRL4 = XMLUtils.getAttributeURL(string, uRL5, xMLNode, "<applet-desc>", "documentBase");
        }
        if (uRL2 != null) {
            uRL4 = uRL2;
        }
        URL uRL6 = XMLUtils.getAttributeURL(string, uRL5, xMLNode, "", "href");
        int n = 0;
        CachedCertificatesHelper[] cachedCertificatesHelperArray = null;
        if (XMLUtils.isElementPath(xMLNode, "<security><all-permissions>")) {
            n = 1;
            cachedCertificatesHelperArray = XMLFormat.buildCachedCertificates(xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<security><j2ee-application-client-permissions>")) {
            n = 2;
            cachedCertificatesHelperArray = XMLFormat.buildCachedCertificates(xMLNode);
        }
        if (XMLUtils.isElementPath(xMLNode, "<javafx-desc>")) {
            javaFXAppDesc = XMLFormat.buildFXAppDesc(string, xMLNode, "<javafx-desc>");
        }
        int n2 = 0;
        if (XMLUtils.isElementPath(xMLNode, "<application-desc>")) {
            n2 = 1;
            applicationDesc = XMLFormat.buildApplicationDesc(string, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<component-desc>")) {
            n2 = 3;
            libraryDesc = XMLFormat.buildLibraryDesc(string, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<installer-desc>")) {
            if (!Cache.isCacheEnabled()) {
                throw new BadFieldException(string, "<installer-desc>", "");
            }
            n2 = 4;
            installerDesc = XMLFormat.buildInstallerDesc(string, uRL5, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<applet-desc>")) {
            n2 = 2;
            appletDesc = XMLFormat.buildAppletDesc(string, uRL5, uRL4, xMLNode);
        } else if (javaFXAppDesc != null) {
            n2 = 6;
        } else {
            throw new MissingFieldException(string, "<jnlp>(<application-desc>|<applet-desc>|<installer-desc>|<component-desc>)");
        }
        updateDesc = XMLFormat.getUpdateDesc(xMLNode);
        informationDesc = XMLFormat.buildInformationDesc(string, uRL5, xMLNode);
        resourcesDesc = XMLFormat.buildResourcesDesc(string, uRL5, xMLNode, false);
        URL uRL7 = n2 == 3 ? uRL3 : uRL6;
        LaunchDesc launchDesc = new LaunchDesc(string4, uRL5, uRL7, string5, informationDesc, n, cachedCertificatesHelperArray, updateDesc, resourcesDesc, n2, applicationDesc, appletDesc, javaFXAppDesc, libraryDesc, installerDesc, string2, xMLNode, string);
        XMLFormat.setSourceURL(launchDesc, uRL3);
        if (Trace.isEnabled((TraceLevel)TraceLevel.TEMP)) {
            Trace.println((String)("returning LaunchDesc from XMLFormat.parse():\n" + launchDesc), (TraceLevel)TraceLevel.TEMP);
        }
        return launchDesc;
    }

    private static InformationDesc combineInformationDesc(InformationDesc informationDesc, InformationDesc informationDesc2) {
        if (informationDesc == null) {
            return informationDesc2;
        }
        if (informationDesc2 == null) {
            return informationDesc;
        }
        String string = informationDesc.getTitle() != null ? informationDesc.getTitle() : informationDesc2.getTitle();
        String string2 = informationDesc.getVendor() != null ? informationDesc.getVendor() : informationDesc2.getVendor();
        URL uRL = informationDesc.getHome() != null ? informationDesc.getHome() : informationDesc2.getHome();
        String[] stringArray = new String[4];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = informationDesc.getDescription(i) != null ? informationDesc.getDescription(i) : informationDesc2.getDescription(i);
        }
        ArrayList<IconDesc> arrayList = new ArrayList<IconDesc>();
        if (informationDesc2.getIcons() != null) {
            arrayList.addAll(Arrays.asList(informationDesc2.getIcons()));
        }
        if (informationDesc.getIcons() != null) {
            arrayList.addAll(Arrays.asList(informationDesc.getIcons()));
        }
        IconDesc[] iconDescArray = new IconDesc[arrayList.size()];
        iconDescArray = arrayList.toArray(iconDescArray);
        boolean bl = informationDesc.supportsOfflineOperation() || informationDesc2.supportsOfflineOperation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut() != null ? informationDesc.getShortcut() : informationDesc2.getShortcut();
        AssociationDesc[] associationDescArray = (AssociationDesc[])XMLFormat.addArrays(informationDesc.getAssociations(), informationDesc2.getAssociations());
        RContentDesc[] rContentDescArray = (RContentDesc[])XMLFormat.addArrays(informationDesc.getRelatedContent(), informationDesc2.getRelatedContent());
        return new InformationDesc(string, string2, uRL, stringArray, iconDescArray, shortcutDesc, rContentDescArray, associationDescArray, bl);
    }

    private static InformationDesc buildInformationDesc(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<information>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                String[] stringArray = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "os", null));
                String[] stringArray2 = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "arch", null));
                String[] stringArray3 = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "locale", null));
                if (GeneralUtil.prefixMatchStringList((String[])stringArray, (String)Config.getOSFullName()) && GeneralUtil.prefixMatchArch((String[])stringArray2) && XMLFormat.matchDefaultLocale(stringArray3)) {
                    String string3 = XMLUtils.getElementContents(xMLNode, "<title>");
                    String string2 = XMLUtils.getElementContents(xMLNode, "<vendor>");
                    URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<homepage>", "href");
                    String[] stringArray4 = new String[4];
                    stringArray4[0] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "", null);
                    stringArray4[2] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "one-line", null);
                    stringArray4[1] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "short", null);
                    stringArray4[3] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "tooltip", null);
                    IconDesc[] iconDescArray = XMLFormat.getIconDescs(string, uRL, xMLNode);
                    ShortcutDesc shortcutDesc = XMLFormat.getShortcutDesc(xMLNode);
                    RContentDesc[] rContentDescArray = XMLFormat.getRContentDescs(string, uRL, xMLNode);
                    AssociationDesc[] associationDescArray = XMLFormat.getAssociationDesc(string, uRL, xMLNode);
                    arrayList.add(new InformationDesc(string3, string2, uRL2, stringArray4, iconDescArray, shortcutDesc, rContentDescArray, associationDescArray, XMLUtils.isElementPath(xMLNode, "<offline-allowed>")));
                }
            }
        });
        InformationDesc informationDesc = new InformationDesc(null, null, null, null, null, null, null, null, false);
        for (int i = 0; i < arrayList.size(); ++i) {
            InformationDesc informationDesc2 = (InformationDesc)arrayList.get(i);
            informationDesc = XMLFormat.combineInformationDesc(informationDesc2, informationDesc);
        }
        return informationDesc;
    }

    private static Object[] addArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2;
        }
        if (objectArray2 == null) {
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n++]);
        }
        n = 0;
        while (n < objectArray2.length) {
            arrayList.add(objectArray2[n++]);
        }
        return arrayList.toArray(objectArray);
    }

    public static boolean matchDefaultLocale(String[] stringArray) {
        return GeneralUtil.matchLocale((String[])stringArray, (Locale)Globals.getDefaultLocale());
    }

    static ResourcesDesc buildResourcesDesc(final String string, final URL uRL, XMLNode xMLNode, final boolean bl) throws MissingFieldException, BadFieldException {
        final ResourcesDesc resourcesDesc = new ResourcesDesc();
        XMLUtils.visitElements(xMLNode, "<resources>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String[] stringArray = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "os", null));
                final String string2 = XMLUtils.getAttribute(xMLNode, "", "arch", null);
                String[] stringArray2 = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "locale", null));
                if (GeneralUtil.prefixMatchStringList((String[])stringArray, (String)Config.getOSFullName()) && XMLFormat.matchDefaultLocale(stringArray2)) {
                    XMLUtils.visitChildrenElements(xMLNode, new XMLUtils.ElementVisitor(){

                        public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                            XMLFormat.handleResourceElement(string, uRL, xMLNode, resourcesDesc, bl, string2);
                        }
                    });
                }
            }
        });
        if (!resourcesDesc.isEmpty()) {
            boolean bl2 = resourcesDesc.isPack200Enabled();
            boolean bl3 = resourcesDesc.isVersionEnabled();
            if (bl2 || bl3) {
                JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
                for (int i = 0; i < jARDescArray.length; ++i) {
                    JARDesc jARDesc = jARDescArray[i];
                    if (bl2) {
                        jARDesc.setPack200Enabled();
                    }
                    if (!bl3) continue;
                    jARDesc.setVersionEnabled();
                }
            }
        }
        return resourcesDesc.isEmpty() ? null : resourcesDesc;
    }

    private static IconDesc[] getIconDescs(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<icon>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getAttribute(xMLNode, "", "kind", "");
                URL uRL2 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "version", null);
                int n = XMLUtils.getIntAttribute(string, xMLNode, "", "height", 0);
                int n2 = XMLUtils.getIntAttribute(string, xMLNode, "", "width", 0);
                int n3 = XMLUtils.getIntAttribute(string, xMLNode, "", "depth", 0);
                int n4 = 0;
                if (string3.equals("selected")) {
                    n4 = 1;
                } else if (string3.equals("disabled")) {
                    n4 = 2;
                } else if (string3.equals("rollover")) {
                    n4 = 3;
                } else if (string3.equals("splash")) {
                    n4 = 4;
                } else if (string3.equals("shortcut")) {
                    n4 = 5;
                }
                arrayList.add(new IconDesc(uRL2, string2, n, n2, n3, n4));
            }
        });
        return arrayList.toArray(new IconDesc[arrayList.size()]);
    }

    private static ShortcutDesc getShortcutDesc(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<shortcut>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string = XMLUtils.getAttribute(xMLNode, "", "online", "true");
                boolean bl = string.equalsIgnoreCase("true");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "install", "false");
                boolean bl2 = string2.equalsIgnoreCase("true");
                boolean bl3 = XMLUtils.isElementPath(xMLNode, "<desktop>");
                boolean bl4 = XMLUtils.isElementPath(xMLNode, "<menu>");
                String string3 = XMLUtils.getAttribute(xMLNode, "<menu>", "submenu");
                arrayList.add(new ShortcutDesc(bl, bl2, bl3, bl4, string3));
            }
        });
        if (arrayList.size() > 0) {
            return (ShortcutDesc)arrayList.get(0);
        }
        return null;
    }

    private static CachedCertificatesHelper[] buildCachedCertificates(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<security><details>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string;
                String string2 = XMLUtils.getAttribute(xMLNode, "", "signedjnlp");
                boolean bl = "true".equalsIgnoreCase(string2);
                String string3 = XMLUtils.getAttribute(xMLNode, "<certificate-path>", "timestamp");
                Date date = string3 == null ? null : new Date(Long.parseLong(string3));
                CachedCertificatesHelper cachedCertificatesHelper = CachedCertificatesHelper.create((Date)date, (String)(string = XMLUtils.getElementContents(xMLNode, "<certificate-path>")), (boolean)bl);
                if (cachedCertificatesHelper != null) {
                    arrayList.add(cachedCertificatesHelper);
                }
            }
        });
        if (arrayList.size() > 0) {
            return arrayList.toArray(new CachedCertificatesHelper[0]);
        }
        return null;
    }

    private static UpdateDesc getUpdateDesc(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<update>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string = XMLUtils.getAttribute(xMLNode, "", "check", "timeout");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "policy", "always");
                arrayList.add(new UpdateDesc(string, string2));
            }
        });
        if (arrayList.size() > 0) {
            return (UpdateDesc)arrayList.get(0);
        }
        return new UpdateDesc("timeout", "always");
    }

    private static AssociationDesc[] getAssociationDesc(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<association>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string4 = XMLUtils.getAttribute(xMLNode, "", "extensions");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "mime-type");
                String string3 = XMLUtils.getElementContents(xMLNode, "<description>");
                URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<icon>", "href");
                if (string4 == null && string2 == null) {
                    throw new MissingFieldException(string, "<association>(<extensions><mime-type>)");
                }
                if (string4 == null) {
                    throw new MissingFieldException(string, "<association><extensions>");
                }
                if (string2 == null) {
                    throw new MissingFieldException(string, "<association><mime-type>");
                }
                if ("gnome".equals(System.getProperty("sun.desktop"))) {
                    string4 = string4.toLowerCase();
                    string2 = string2.toLowerCase();
                }
                arrayList.add(new AssociationDesc(string4, string2, string3, uRL2));
            }
        });
        return arrayList.toArray(new AssociationDesc[arrayList.size()]);
    }

    private static RContentDesc[] getRContentDescs(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<related-content>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                URL uRL3 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
                String string3 = XMLUtils.getElementContents(xMLNode, "<title>");
                String string2 = XMLUtils.getElementContents(xMLNode, "<description>");
                URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<icon>", "href");
                arrayList.add(new RContentDesc(uRL3, string3, string2, uRL2));
            }
        });
        return arrayList.toArray(new RContentDesc[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleResourceElement(String string, URL uRL, XMLNode xMLNode, ResourcesDesc resourcesDesc, boolean bl, String string2) throws MissingFieldException, BadFieldException {
        String string3 = xMLNode.getName();
        boolean bl2 = GeneralUtil.prefixMatchArch((String[])GeneralUtil.getStringList((String)string2));
        if (bl2 && (string3.equals("jar") || string3.equals("nativelib"))) {
            URL uRL2 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
            String string4 = XMLUtils.getAttribute(xMLNode, "", "version", null);
            String string5 = XMLUtils.getAttribute(xMLNode, "", "download");
            String string6 = XMLUtils.getAttribute(xMLNode, "", "main");
            String string7 = XMLUtils.getAttribute(xMLNode, "", "part");
            int n = XMLUtils.getIntAttribute(string, xMLNode, "", "size", 0);
            boolean bl3 = string3.equals("nativelib");
            if (!Cache.isCacheEnabled() && bl3) {
                throw new BadFieldException(string, "nativelib", uRL2.toString());
            }
            boolean bl4 = "lazy".equalsIgnoreCase(string5);
            boolean bl5 = "progress".equalsIgnoreCase(string5);
            boolean bl6 = "true".equalsIgnoreCase(string6);
            JARDesc jARDesc = null;
            if (Environment.isImportMode() && Environment.getImportModeCodebaseOverride() != null) {
                String string8 = XMLUtils.getAttribute(xMLNode, "", "href");
                if (uRL2.toString().endsWith("/")) {
                    File file = null;
                    try {
                        URI uRI = new URI(Environment.getImportModeCodebaseOverride().replace("\\", "/") + string8);
                        file = new File(uRI);
                        if (file == null || !file.isDirectory()) return;
                        File[] fileArray = file.listFiles();
                        for (int i = 0; i < fileArray.length; ++i) {
                            try {
                                URL uRL3 = new URL(uRL2.toString() + fileArray[i].getName());
                                jARDesc = new JARDesc(uRL3, string4, bl4, bl6, bl3, string7, n, resourcesDesc, bl5);
                                resourcesDesc.addResource(jARDesc);
                                continue;
                            }
                            catch (MalformedURLException malformedURLException) {
                                Trace.ignoredException((Exception)malformedURLException);
                            }
                        }
                        return;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Trace.ignoredException((Exception)uRISyntaxException);
                        return;
                    }
                } else {
                    try {
                        URL uRL4 = new URL(Environment.getImportModeCodebaseOverride());
                        URL uRL5 = new URL(uRL4, string8);
                        jARDesc = new JARDesc(uRL5, string4, bl4, bl6, bl3, string7, n, resourcesDesc, bl5);
                        resourcesDesc.addResource(jARDesc);
                        return;
                    }
                    catch (MalformedURLException malformedURLException) {
                        Trace.ignoredException((Exception)malformedURLException);
                    }
                }
                return;
            } else {
                jARDesc = new JARDesc(uRL2, string4, bl4, bl6, bl3, string7, n, resourcesDesc, bl5);
                resourcesDesc.addResource(jARDesc);
            }
            return;
        }
        if (bl2 && string3.equals("property")) {
            String string9 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
            String string10 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
            if (string9.equals("jnlp.versionEnabled") && string10.equalsIgnoreCase("true")) {
                resourcesDesc.setVersionEnabled();
                return;
            }
            if (string9.equals("jnlp.packEnabled") && string10.equalsIgnoreCase("true")) {
                resourcesDesc.setPack200Enabled();
                return;
            }
            if (string9.equals("jnlp.concurrentDownloads")) {
                if (string10 == null) return;
                int n = 0;
                try {
                    n = Integer.parseInt(string10.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                resourcesDesc.setConcurrentDownloads(n);
                return;
            }
            resourcesDesc.addResource(new PropertyDesc(string9, string10));
            return;
        }
        if (bl2 && string3.equals("package")) {
            String string11 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
            String string12 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "part");
            String string13 = XMLUtils.getAttribute(xMLNode, "", "recursive", "false");
            boolean bl7 = "true".equals(string13);
            resourcesDesc.addResource(new PackageDesc(string11, string12, bl7));
            return;
        } else if (bl2 && string3.equals("extension")) {
            String string14 = XMLUtils.getAttribute(xMLNode, "", "name");
            URL uRL6 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
            String string15 = XMLUtils.getAttribute(xMLNode, "", "version", null);
            ExtDownloadDesc[] extDownloadDescArray = XMLFormat.getExtDownloadDescs(string, xMLNode);
            resourcesDesc.addResource(new ExtensionDesc(string14, uRL6, string15, extDownloadDescArray));
            return;
        } else if ((string3.equals("java") || string3.equals("j2se")) && !bl && JREInfo.archMatchStringList((String[])GeneralUtil.getStringList((String)string2))) {
            String string16 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "version");
            URL uRL7 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "", "href");
            String string17 = XMLUtils.getAttribute(xMLNode, "", "initial-heap-size");
            String string18 = XMLUtils.getAttribute(xMLNode, "", "max-heap-size");
            String string19 = XMLUtils.getAttribute(xMLNode, "", "java-vm-args");
            long l = -1L;
            long l2 = -1L;
            l = GeneralUtil.heapValToLong((String)string17);
            l2 = GeneralUtil.heapValToLong((String)string18);
            ResourcesDesc resourcesDesc2 = XMLFormat.buildResourcesDesc(string, uRL, xMLNode, true);
            JREDesc jREDesc = new JREDesc(string16, l, l2, string19, uRL7, resourcesDesc2, string2);
            resourcesDesc.addResource(jREDesc);
            return;
        } else {
            if (!string3.equals("javafx-runtime")) return;
            String string20 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "version");
            URL uRL8 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "", "href");
            resourcesDesc.addResource(new JavaFXRuntimeDesc(string20, uRL8));
        }
    }

    private static ExtDownloadDesc[] getExtDownloadDescs(final String string, XMLNode xMLNode) throws BadFieldException, MissingFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<ext-download>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string4 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "ext-part");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "part");
                String string3 = XMLUtils.getAttribute(xMLNode, "", "download", "eager");
                boolean bl = "lazy".equals(string3);
                arrayList.add(new ExtDownloadDesc(string4, string2, bl));
            }
        });
        ExtDownloadDesc[] extDownloadDescArray = new ExtDownloadDesc[arrayList.size()];
        return arrayList.toArray(extDownloadDescArray);
    }

    private static ApplicationDesc buildApplicationDesc(final String string, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getClassName(string, xMLNode, "<application-desc>", "main-class", false);
        String string3 = XMLUtils.getClassName(string, xMLNode, "<application-desc>", "progress-class", false);
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<application-desc><argument>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string2 = XMLUtils.getElementContents(xMLNode, "", null);
                if (string2 == null) {
                    throw new BadFieldException(string, XMLUtils.getPathString(xMLNode), "");
                }
                arrayList.add(string2);
            }
        });
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return new ApplicationDesc(string2, string3, stringArray);
    }

    private static JavaFXAppDesc buildFXAppDesc(final String string, XMLNode xMLNode, String string2) throws MissingFieldException, BadFieldException {
        String string3 = XMLUtils.getClassName(string, xMLNode, string2, "main-class", true);
        String string4 = XMLUtils.getClassName(string, xMLNode, string2, "preloader-class", false);
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<javafx-desc><argument>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string2 = XMLUtils.getElementContents(xMLNode, "", null);
                if (string2 == null) {
                    throw new BadFieldException(string, XMLUtils.getPathString(xMLNode), "");
                }
                arrayList.add(string2);
            }
        });
        String[] stringArray = null;
        if (!arrayList.isEmpty()) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        final Properties properties = new Properties();
        XMLUtils.visitElements(xMLNode, "<javafx-desc><param>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
                String string2 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
                properties.setProperty(string3, string2);
            }
        });
        return new JavaFXAppDesc(string3, string4, stringArray, properties);
    }

    private static LibraryDesc buildLibraryDesc(String string, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getClassName(string, xMLNode, "<component-desc>", "progress-class", false);
        return new LibraryDesc(string2);
    }

    private static InstallerDesc buildInstallerDesc(String string, URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getClassName(string, xMLNode, "<installer-desc>", "main-class", false);
        return new InstallerDesc(string2);
    }

    private static AppletDesc buildAppletDesc(final String string, URL uRL, URL uRL2, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getClassName(string, xMLNode, "<applet-desc>", "main-class", true);
        String string3 = XMLUtils.getClassName(string, xMLNode, "<applet-desc>", "progress-class", false);
        String string4 = XMLUtils.getRequiredAttribute(string, xMLNode, "<applet-desc>", "name");
        Rectangle rectangle = UIFactory.getMouseScreenBounds();
        int n = XMLUtils.getRequiredWHAttribute(string, xMLNode, "<applet-desc>", "width", (int)rectangle.getWidth());
        int n2 = XMLUtils.getRequiredWHAttribute(string, xMLNode, "<applet-desc>", "height", (int)rectangle.getHeight());
        if (n <= 0) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + "<applet-desc>width", new Integer(n).toString());
        }
        if (n2 <= 0) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + "<applet-desc>height", new Integer(n2).toString());
        }
        final Properties properties = new Properties();
        XMLUtils.visitElements(xMLNode, "<applet-desc><param>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
                String string2 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
                properties.setProperty(string3, string2);
            }
        });
        return new AppletDesc(string4, string2, uRL2, n, n2, properties, string3);
    }

    public static boolean isBlacklisted(XMLNode xMLNode) {
        if (xMLNode == null) {
            return false;
        }
        if (xMLNode.getName() != null) {
            if (xMLNode.getName().equals("java") || xMLNode.getName().equals("j2se")) {
                for (XMLAttribute xMLAttribute = xMLNode.getAttributes(); xMLAttribute != null; xMLAttribute = xMLAttribute.getNext()) {
                    String string;
                    if (!xMLAttribute.getName().equals("java-vm-args") || (string = xMLAttribute.getValue()) == null || string.indexOf("*") < 0) continue;
                    Trace.println((String)("Blacklisted - a = " + xMLAttribute), (TraceLevel)TraceLevel.SECURITY);
                    return true;
                }
            } else if (xMLNode.getName().equals("property")) {
                for (XMLAttribute xMLAttribute = xMLNode.getAttributes(); xMLAttribute != null; xMLAttribute = xMLAttribute.getNext()) {
                    String string = xMLAttribute.getValue();
                    if (string == null || string.indexOf("*") < 0) continue;
                    Trace.println((String)("Blacklisted - a = " + xMLAttribute), (TraceLevel)TraceLevel.SECURITY);
                    return true;
                }
            }
        }
        if (XMLFormat.isBlacklisted(xMLNode.getNested())) {
            return true;
        }
        return XMLFormat.isBlacklisted(xMLNode.getNext());
    }

    private static void setSourceURL(LaunchDesc launchDesc, URL uRL) {
        URL uRL2;
        File file = null;
        if (uRL != null) {
            if (!launchDesc.isApplicationDescriptor()) {
                launchDesc.setSourceURL(uRL);
            } else if ("file".equalsIgnoreCase(uRL.getProtocol())) {
                try {
                    file = new File(uRL.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(uRL.getPath());
                }
            } else {
                launchDesc.setSourceURL(uRL);
            }
        }
        if (file != null && !Cache.isFileWithinCache(file) && (uRL2 = launchDesc.getCodebase()) != null && "file".equals(uRL2.getProtocol())) {
            launchDesc.setSourceURL(uRL);
        }
    }
}

