/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSACore;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPadding;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;

public abstract class RSASignature
extends SignatureSpi {
    private static final int a = 8;
    private final ObjectIdentifier b;
    private final int c;
    private final MessageDigest d;
    private boolean e;
    private RSAPrivateKey f;
    private RSAPublicKey g;
    private RSAPadding h;
    private static final String[] z;

    RSASignature(String string, ObjectIdentifier objectIdentifier, int n2) {
        this.b = objectIdentifier;
        try {
            this.d = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.e = true;
        this.c = 8 + n2 + this.d.getDigestLength();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.f = null;
        this.g = rSAPublicKey;
        this.a(rSAPublicKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey;
        this.f = rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.g = null;
        this.a(rSAPrivateKey, secureRandom);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.a();
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            this.h = RSAPadding.getInstance(1, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        int n3 = this.h.getMaxDataSize();
        if (this.c > n3) {
            throw new InvalidKeyException(z[4]);
        }
    }

    private void a() {
        if (!this.e) {
            this.d.reset();
            this.e = true;
        }
    }

    private byte[] b() {
        this.e = true;
        return this.d.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.d.update(by);
        this.e = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.d.update(byArray, n2, n3);
        this.e = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.d.update(byteBuffer);
        this.e = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = RSASignature.encodeSignature(this.b, byArray);
            byte[] byArray3 = this.h.pad(byArray2);
            byte[] byArray4 = RSACore.rsa(byArray3, this.f, true);
            return byArray4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(z[10], generalSecurityException);
        }
        catch (IOException iOException) {
            throw new SignatureException(z[9], iOException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (byArray.length != RSACore.getByteLength(this.g)) {
            throw new SignatureException(z[6] + byArray.length + z[7] + RSACore.getByteLength(this.g));
        }
        byte[] byArray2 = this.b();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.g);
            byte[] byArray4 = this.h.unpad(byArray3);
            byte[] byArray5 = RSASignature.decodeSignature(this.b, byArray4);
            return MessageDigest.isEqual(byArray2, byArray5);
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (IOException iOException) {
            throw new SignatureException(z[8], iOException);
        }
    }

    public static byte[] encodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        new AlgorithmId(objectIdentifier).encode(derOutputStream);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray, 0, byArray.length, false);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) throw new IOException(z[1]);
        if (derInputStream.available() != 0) {
            throw new IOException(z[1]);
        }
        AlgorithmId algorithmId = AlgorithmId.parse((DerValue)derValueArray[0]);
        if (!algorithmId.getOID().equals((Object)objectIdentifier)) {
            throw new IOException(z[3] + algorithmId.getOID());
        }
        if (algorithmId.getEncodedParams() == null) return derValueArray[1].getOctetString();
        throw new IOException(z[2]);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[0]);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[5]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[11];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "f\u001b=\u0015`g\u001f$ up\fal!{\u0011=er`\u000e9*sa\u001b-";
        int n3 = -1;
        block18: while (true) {
            char[] cArray;
            block22: {
                int n4;
                int n5;
                block21: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block21;
                    n5 = n5;
                    if (n5 <= n4) break block22;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 21;
                            break;
                        }
                        case 1: {
                            n6 = 126;
                            break;
                        }
                        case 2: {
                            n6 = 73;
                            break;
                        }
                        case 3: {
                            n6 = 69;
                            break;
                        }
                        default: {
                            n6 = 1;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "F;\u0018\u0010D[=\femp\u0010.1i5\u001b;7ng";
                    n3 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "@\u0010,=qp\u001d= e5?%\"ng\u0017=-l\\\u001ai5`g\u001f$ up\f:";
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "Z\u001c# ba7- oa\u0017/,dg^$,rx\u001f=&i/^";
                    n3 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "^\u001b0ehf^=*n5\r!*sa^/*s5\n!,r5\r \"ot\n<7d5\u001f%\"ng\u0017=-l";
                    n3 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "r\u001b=\u0015`g\u001f$ up\fal!{\u0011=er`\u000e9*sa\u001b-";
                    n3 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "F\u0017.+`a\u000b; !y\u001b'\"u}^'*u5\u001d&7sp\u001d=\u007f!r\u0011=e";
                    n3 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "5\u001c<1!b\u001f:edm\u000e,&u|\u0010.e";
                    n3 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "F\u0017.+`a\u000b; !p\u0010**e|\u0010.edg\f&7";
                    n3 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "V\u0011<)e5\u0010&1!p\u0010**ep^-$ut";
                    n3 = 8;
                    continue block18;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "V\u0011<)e5\u0010&1!f\u0017.+!q\u001f=$";
                    n3 = 9;
                    continue block18;
                }
                case 9: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

