/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Serializable {
    static final long serialVersionUID = -6195576206650062694L;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private static final String[] z;

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        RSAKeyFactory.b(this.modulus.bitLength(), this.publicExponent);
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            byte[] byArray = derOutputStream.toByteArray();
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0] + iOException.getMessage());
        }
    }

    public RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        RSAKeyFactory.b(this.modulus.bitLength(), this.publicExponent);
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String toString() {
        return z[5] + this.modulus.toString() + z[4] + this.publicExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.getKey().toByteArray());
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                throw new IOException(z[2]);
            }
            DerInputStream derInputStream2 = derValue.getData();
            this.modulus = derInputStream2.getPositiveBigInteger();
            this.publicExponent = derInputStream2.getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[3]);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[1] + exception.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "/|C|\u0011l}YdU\bVd0\u0010\"pYt\u0010v3";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                block16: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block16;
                    n5 = n5;
                    if (n5 <= n4) break block17;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 76;
                            break;
                        }
                        case 1: {
                            n6 = 19;
                            break;
                        }
                        case 2: {
                            n6 = 54;
                            break;
                        }
                        case 3: {
                            n6 = 16;
                            break;
                        }
                        default: {
                            n6 = 117;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0005}@q\u0019%w\u0016{\u001053@q\u00199v\u0016\u001a";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0002|B0\u0014l@sA \t]uU";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\tkBb\u0014lwWd\u0014lr@q\u001c rT|\u0010";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "FcCr\u0019%p\u0016u\r<|Xu\u001b8)<";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0005Q{Z6\t3dC4lCCr\u0019%p\u0016[\u00105)<}\u001a(fZe\u0006v\u0019";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

