/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.JCAUtil;
import com.ibm.crypto.provider.RSACore;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPadding;
import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;

public class RSAPSSSignature
extends SignatureSpi {
    protected SecureRandom a;
    private static final Hashtable<String, Integer> b;
    double c = 0.0;
    private int d;
    private double e;
    private MessageDigest f;
    private MessageDigest g;
    private boolean h;
    private RSAPadding i;
    private RSAPrivateKey j;
    private java.security.interfaces.RSAPublicKey k;
    PSSParameterSpec l = PSSParameterSpec.DEFAULT;
    private static final String[] z;

    RSAPSSSignature(PSSParameterSpec pSSParameterSpec) {
        try {
            this.engineSetParameter(pSSParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public RSAPSSSignature() {
        this(new PSSParameterSpec(z[1], z[2], MGF1ParameterSpec.SHA1, 20, 1));
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        Serializable serializable;
        if (this.l != null) {
            serializable = b.get(this.l.getDigestAlgorithm());
            if (serializable == null) {
                throw new ProviderException(z[27] + this.l.getDigestAlgorithm());
            }
            RSAPSSSignature.a((RSAPublicKey)publicKey, (Integer)serializable, this.l.getSaltLength());
        }
        serializable = (java.security.interfaces.RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.j = null;
        this.k = serializable;
        this.a = JCAUtil.getSecureRandom();
        this.c = serializable.getModulus().bitLength();
        this.e = this.c - 1.0;
        this.d = (int)Math.ceil(this.e / 8.0);
        this.a((RSAKey)((Object)serializable), this.a);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.a = JCAUtil.getSecureRandom();
        this.engineInitSign(privateKey, this.a);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        Serializable serializable;
        if (this.l != null) {
            serializable = b.get(this.l.getDigestAlgorithm());
            if (serializable == null) {
                throw new ProviderException(z[20] + this.l.getDigestAlgorithm());
            }
            RSAPSSSignature.a((RSAPrivateCrtKey)privateKey, (Integer)serializable, this.l.getSaltLength());
        }
        serializable = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.c = serializable.getModulus().bitLength();
        this.e = this.c - 1.0;
        this.d = (int)Math.ceil(this.e / 8.0);
        this.j = serializable;
        this.k = null;
        this.a((RSAKey)((Object)serializable), secureRandom);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            this.i = RSAPadding.getInstance(5, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        this.a();
    }

    private void a() {
        this.f.reset();
        this.h = true;
    }

    private byte[] b() {
        this.h = true;
        return this.f.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.f.update(by);
        this.h = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.f.update(byArray, n2, n3);
        this.h = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.f.update(byteBuffer);
        this.h = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = this.encodeSignature(byArray);
            byte[] byArray3 = RSACore.rsa(byArray2, this.j);
            int n2 = ((int)this.c + 7) / 8;
            return byArray3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(z[17], generalSecurityException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (byArray.length != RSACore.getByteLength(this.k)) {
            throw new SignatureException(z[5] + byArray.length + z[7] + RSACore.getByteLength(this.k));
        }
        int n2 = ((int)this.c + 7) / 8;
        if (byArray.length != n2) {
            throw new SignatureException(z[3] + byArray.length + z[6] + RSACore.getByteLength(this.k));
        }
        byte[] byArray2 = this.b();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.k);
            byte[] byArray4 = this.i.unpad(byArray3);
            if (byArray4.length > this.d) {
                return false;
            }
            if (byArray4.length < this.d) {
                byte[] byArray5 = new byte[this.d];
                System.arraycopy(byArray4, 0, byArray5, this.d - byArray4.length, byArray4.length);
                byArray4 = byArray5;
            }
            boolean bl2 = this.decodeSignature(byArray4, byArray2);
            return bl2;
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return false;
        }
        catch (IOException iOException) {
            throw new SignatureException(z[4], iOException);
        }
    }

    public byte[] encodeSignature(byte[] byArray) throws InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        if (this.d < byArray.length + this.l.getSaltLength() + 2) {
            throw new SecurityException(z[18]);
        }
        byte[] byArray2 = new byte[this.l.getSaltLength()];
        this.a.nextBytes(byArray2);
        byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray4 = new byte[8 + byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length + byArray.length, byArray2.length);
        this.f.reset();
        this.f.update(byArray4);
        byte[] byArray5 = this.f.digest();
        int n3 = this.d - byArray5.length - byArray2.length - 2;
        byte[] byArray6 = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray6[n2] = 0;
        }
        byte[] byArray7 = new byte[this.d - byArray5.length - 1];
        if (n3 > 0) {
            System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
        }
        byArray7[n2++] = 1;
        System.arraycopy(byArray2, 0, byArray7, n2, byArray2.length);
        byte[] byArray8 = new byte[n3 + 1 + byArray2.length];
        byArray8 = this.a(byArray5, byArray8.length);
        byte[] byArray9 = new byte[n3 + 1 + byArray2.length];
        int n4 = 0;
        for (byte by : byArray8) {
            byArray9[n4] = (byte)(by ^ byArray7[n4++]);
        }
        int n5 = 8 * this.d - (int)this.e;
        if (n5 > 0) {
            int n6 = (byte)(255 >>> n5);
            byArray9[0] = (byte)(byArray9[0] & n6);
        }
        byte[] byArray10 = new byte[this.d];
        System.arraycopy(byArray9, 0, byArray10, 0, byArray9.length);
        System.arraycopy(byArray5, 0, byArray10, byArray9.length, byArray5.length);
        byArray10[byArray9.length + byArray5.length] = -68;
        return byArray10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decodeSignature(byte[] byArray, byte[] byArray2) throws IOException, SignatureException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        byte by2;
        if (this.d < byArray2.length + 2 + this.l.getSaltLength()) {
            throw new SecurityException(z[15]);
        }
        byte by = byArray[this.d - 1];
        if ((by ^ 0xBC) == 0) {
            throw new SecurityException(z[13]);
        }
        byte[] byArray5 = Arrays.copyOfRange(byArray, 0, this.d - byArray2.length - 1);
        byte[] byArray4 = Arrays.copyOfRange(byArray, byArray5.length, this.d - 1);
        int n3 = 8 * this.d - (int)this.e;
        int n4 = 8 - n3;
        if (n4 > 0 && (byArray5[0] & (by2 = (byte)(255 << n4))) != 0) {
            throw new SignatureException(z[12]);
        }
        byte[] byArray6 = new byte[this.d - byArray4.length - 1];
        byArray6 = this.a(byArray4, byArray6.length);
        byte[] byArray3 = new byte[byArray6.length];
        int n5 = 0;
        byte[] byArray7 = byArray6;
        int n6 = byArray7.length;
        for (int i2 = 0; i2 < n6; ++n5, ++i2) {
            byte by3 = byArray7[i2];
            byArray3[n5] = (byte)(by3 ^ byArray5[n5]);
        }
        n3 = 8 * this.d - (int)this.e;
        if (n3 > 0) {
            byte by4 = (byte)(255 >>> n3);
            byArray3[0] = (byte)(byArray3[0] & by4);
        }
        if ((n2 = this.d - byArray4.length - this.l.getSaltLength() - 2) > 0) {
            for (n6 = 0; n6 < n2; ++n6) {
                if (byArray3[n6] == 0) continue;
                throw new SecurityException(z[16]);
            }
        }
        if (byArray3[n2] != 1) {
            throw new SecurityException(z[14]);
        }
        byte[] byArray72 = Arrays.copyOfRange(byArray3, n2 + 1, byArray3.length);
        byte[] byArray8 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray9 = new byte[8 + byArray2.length + byArray72.length];
        System.arraycopy(byArray8, 0, byArray9, 0, byArray8.length);
        System.arraycopy(byArray2, 0, byArray9, byArray8.length, byArray2.length);
        System.arraycopy(byArray72, 0, byArray9, byArray8.length + byArray2.length, byArray72.length);
        this.f.reset();
        this.f.update(byArray9);
        byte[] byArray10 = this.f.digest();
        return MessageDigest.isEqual(byArray4, byArray10);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[21]);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[0]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        block56: {
            boolean bl2;
            block60: {
                block70: {
                    String string;
                    block69: {
                        String string2;
                        block67: {
                            block68: {
                                block66: {
                                    block64: {
                                        block65: {
                                            block63: {
                                                block61: {
                                                    block62: {
                                                        block58: {
                                                            block59: {
                                                                block57: {
                                                                    if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
                                                                        throw new InvalidAlgorithmParameterException();
                                                                    }
                                                                    this.l = (PSSParameterSpec)algorithmParameterSpec;
                                                                    string2 = this.l.getDigestAlgorithm();
                                                                    AlgorithmParameterSpec algorithmParameterSpec2 = this.l.getMGFParameters();
                                                                    if (string2 == null || algorithmParameterSpec2 == null) break block56;
                                                                    if (!(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) break block56;
                                                                    string = ((MGF1ParameterSpec)algorithmParameterSpec2).getDigestAlgorithm();
                                                                    if (string == null) break block56;
                                                                    bl2 = true;
                                                                    if (string2.equalsIgnoreCase(z[31]) || string2.equalsIgnoreCase(z[38])) break block57;
                                                                    if (!string2.equalsIgnoreCase(z[40])) break block58;
                                                                }
                                                                if (string.equalsIgnoreCase(z[46])) break block59;
                                                                if (string.equalsIgnoreCase(z[45])) break block59;
                                                                if (!string.equalsIgnoreCase(z[42])) break block60;
                                                            }
                                                            bl2 = false;
                                                            break block60;
                                                        }
                                                        if (!string2.equalsIgnoreCase(z[37]) && !string2.equalsIgnoreCase(z[29])) break block61;
                                                        if (string.equalsIgnoreCase(z[41])) break block62;
                                                        if (!string.equalsIgnoreCase(z[47])) break block60;
                                                    }
                                                    bl2 = false;
                                                    break block60;
                                                }
                                                if (string2.equalsIgnoreCase(z[36]) || string2.equalsIgnoreCase(z[51])) break block63;
                                                if (!string2.equalsIgnoreCase(z[56])) break block64;
                                            }
                                            if (string.equalsIgnoreCase(z[32])) break block65;
                                            if (string.equalsIgnoreCase(z[52])) break block65;
                                            if (!string.equalsIgnoreCase(z[30])) break block60;
                                        }
                                        bl2 = false;
                                        break block60;
                                    }
                                    if (string2.equalsIgnoreCase(z[50]) || string2.equalsIgnoreCase(z[54])) break block66;
                                    if (!string2.equalsIgnoreCase(z[48])) break block67;
                                }
                                if (string.equalsIgnoreCase(z[28])) break block68;
                                if (string.equalsIgnoreCase(z[53])) break block68;
                                if (!string.equalsIgnoreCase(z[55])) break block60;
                            }
                            bl2 = false;
                            break block60;
                        }
                        if (string2.equalsIgnoreCase(z[34]) || string2.equalsIgnoreCase(z[43])) break block69;
                        if (!string2.equalsIgnoreCase(z[33])) break block60;
                    }
                    if (string.equalsIgnoreCase(z[49])) break block70;
                    if (string.equalsIgnoreCase(z[39])) break block70;
                    if (!string.equalsIgnoreCase(z[44])) break block60;
                }
                bl2 = false;
            }
            if (bl2) {
                InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException(z[35]);
                throw invalidAlgorithmParameterException;
            }
        }
        try {
            this.f = MessageDigest.getInstance(this.l.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidAlgorithmParameterException(noSuchAlgorithmException);
        }
        this.h = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray, int n2) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException {
        String string = this.l.getDigestAlgorithm();
        String string2 = this.l.getMGFAlgorithm();
        if (!string2.equalsIgnoreCase(z[8])) {
            throw new InvalidAlgorithmParameterException(z[10] + string2);
        }
        String string3 = null;
        string3 = this.l.getMGFParameters() == null ? string : ((MGF1ParameterSpec)this.l.getMGFParameters()).getDigestAlgorithm();
        try {
            this.g = MessageDigest.getInstance(string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(z[11] + string + z[9], noSuchAlgorithmException);
        }
        byte[] byArray2 = new byte[n2];
        int n3 = this.g.getDigestLength();
        int n4 = n2 / n3;
        if (n2 % n3 > 0) {
            ++n4;
        }
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[n3];
        int n5 = 0;
        while (n5 < n4) {
            byArray3[0] = (byte)(n5 >>> 24);
            byArray3[1] = (byte)(n5 >>> 16);
            byArray3[2] = (byte)(n5 >>> 8);
            byArray3[3] = (byte)n5;
            this.g.update(byArray, 0, byArray.length);
            this.g.update(byArray3);
            try {
                this.g.digest(byArray4, 0, byArray4.length);
            }
            catch (DigestException digestException) {
                throw new BadPaddingException(digestException.toString());
            }
            for (int i2 = 0; i2 < byArray4.length && n5 * n3 + i2 < n2; ++i2) {
                byArray2[n5 * n3 + i2] = byArray4[i2];
            }
            ++n5;
        }
        return byArray2;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() throws InvalidParameterException {
        AlgorithmParameters algorithmParameters = null;
        if (this.l == null) {
            return null;
        }
        try {
            algorithmParameters = AlgorithmParameters.getInstance(z[23], z[22]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new RuntimeException(z[26] + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(z[24]);
        }
        try {
            algorithmParameters.init(this.l);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            invalidParameterSpecException.printStackTrace();
            throw new RuntimeException(z[25] + invalidParameterSpecException.getMessage());
        }
        return algorithmParameters;
    }

    String a(byte[] byArray) {
        String string = z[57];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            stringBuffer.append(string.charAt(n2 >> 4));
            stringBuffer.append(string.charAt(n2 & 0xF));
        }
        return stringBuffer.toString();
    }

    private static void a(RSAKey rSAKey, int n2, int n3) throws InvalidKeyException {
        if (rSAKey != null) {
            int n4 = RSAPSSSignature.a(rSAKey) >> 3;
            int n5 = Math.addExact(Math.addExact(n2, n3), 2);
            if (n4 < n5) {
                throw new InvalidKeyException(z[19] + n5);
            }
        }
    }

    private static int a(RSAKey rSAKey) {
        if (rSAKey != null) {
            return rSAKey.getModulus().bitLength();
        }
        return -1;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n2;
        String[] stringArray = new String[58];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string3 = "n2lFE{6usPl%0?\u0004g8l6W|'hyV}2|";
        int n4 = -1;
        block88: while (true) {
            char[] cArray;
            block95: {
                int n5;
                block94: {
                    char[] cArray2 = string3.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n2 = 0;
                    if (!true) break block94;
                    n5 = n5;
                    if (n5 <= n2) break block95;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n2;
                    char c2 = cArray[n7];
                    switch (n2 % 5) {
                        case 0: {
                            n6 = 9;
                            break;
                        }
                        case 1: {
                            n6 = 87;
                            break;
                        }
                        case 2: {
                            n6 = 24;
                            break;
                        }
                        case 3: {
                            n6 = 22;
                            break;
                        }
                        default: {
                            n6 = 36;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n2;
                    n5 = n5;
                } while (n5 > n2);
            }
            string2 = new String(cArray);
            switch (n4) {
                default: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string3 = "Z\u001fY;\u0015";
                    n4 = 0;
                    continue block88;
                }
                case 0: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string3 = "D\u0010^'";
                    n4 = 1;
                    continue block88;
                }
                case 1: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string3 = ")\u0004qqJh#mdA);}xC}?8xK}w{yV{2{b\u001e)0wb\u0004";
                    n4 = 2;
                    continue block88;
                }
                case 2: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 4;
                    string3 = "Z>\u007fxE}\"js\u0004l9{y@`9\u007f6A{%wd";
                    n4 = 3;
                    continue block88;
                }
                case 3: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 5;
                    string3 = ")\u0004qqJh#mdA);}xC}?8xK}w{yV{2{b\u001e)0wb\u0004";
                    n4 = 4;
                    continue block88;
                }
                case 4: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 6;
                    string3 = ")5mb\u0004~6k6Aq'}uP`9\u007f6";
                    n4 = 5;
                    continue block88;
                }
                case 5: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 7;
                    string3 = ")5mb\u0004~6k6Aq'}uP`9\u007f6";
                    n4 = 6;
                    continue block88;
                }
                case 6: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 8;
                    string3 = "D\u0010^'";
                    n4 = 7;
                    continue block88;
                }
                case 7: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 9;
                    string3 = ")9wb\u0004h!y\u007fHh5ts";
                    n4 = 8;
                    continue block88;
                }
                case 8: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 10;
                    string3 = "\\9kcTy8jbAmwUQb)6tqK3w";
                    n4 = 9;
                    continue block88;
                }
                case 9: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 11;
                    string3 = "M>\u007fsW}w";
                    n4 = 10;
                    continue block88;
                }
                case 10: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 12;
                    string3 = "M2{y@`9\u007f6A{%wd";
                    n4 = 11;
                    continue block88;
                }
                case 11: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 13;
                    string3 = "`9{yJz>kbAg#8eMn9ybQ{2";
                    n4 = 12;
                    continue block88;
                }
                case 12: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 14;
                    string3 = "M2{y@`9\u007f6A{%wd";
                    n4 = 13;
                    continue block88;
                }
                case 13: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 15;
                    string3 = "`9{yJz>kbAg#8eMn9ybQ{2";
                    n4 = 14;
                    continue block88;
                }
                case 14: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 16;
                    string3 = "M2{y@`9\u007f6A{%wd";
                    n4 = 15;
                    continue block88;
                }
                case 15: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 17;
                    string3 = "J8mz@)9wb\u0004z>\u007fx\u0004m6lw";
                    n4 = 16;
                    continue block88;
                }
                case 16: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 18;
                    string3 = "l9{y@`9\u007f6A{%wd";
                    n4 = 17;
                    continue block88;
                }
                case 17: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 19;
                    string3 = "B2a6MzwlyK)$pyV}{8xAl38{Mgw";
                    n4 = 18;
                    continue block88;
                }
                case 18: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 20;
                    string3 = "\\9kcTy8jbAmw|\u007fCl$l6Ee0wdM}?u,\u0004";
                    n4 = 19;
                    continue block88;
                }
                case 19: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 21;
                    string3 = "z2lFE{6usPl%0?\u0004g8l6W|'hyV}2|";
                    n4 = 20;
                    continue block88;
                }
                case 20: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 22;
                    string3 = "@\u0015U\\gL";
                    n4 = 21;
                    continue block88;
                }
                case 21: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 23;
                    string3 = "[\u0004YFwZ";
                    n4 = 22;
                    continue block88;
                }
                case 22: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 24;
                    string3 = "@\u0015U\\gLw{wHe2|:\u0004k\"l6Jf#8uKg1qqQ{2|";
                    n4 = 23;
                    continue block88;
                }
                case 23: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 25;
                    string3 = "Y\u0004KFE{6usPl%KfAjwvyP)$mfTf%ls@)";
                    n4 = 24;
                    continue block88;
                }
                case 24: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 26;
                    string3 = "G88eQj?8wHn8j\u007fPa:8";
                    n4 = 25;
                    continue block88;
                }
                case 25: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 27;
                    string3 = "\\9kcTy8jbAmw|\u007fCl$l6Ee0wdM}?u,\u0004";
                    n4 = 26;
                    continue block88;
                }
                case 26: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 28;
                    string3 = "Z\u001fY%\u001c=";
                    n4 = 27;
                    continue block88;
                }
                case 27: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 29;
                    string3 = "Z\u001fY;\u0016;c";
                    n4 = 28;
                    continue block88;
                }
                case 28: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 30;
                    string3 = "Z\u001fY$";
                    n4 = 29;
                    continue block88;
                }
                case 29: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 31;
                    string3 = "Z\u001fY'";
                    n4 = 30;
                    continue block88;
                }
                case 30: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 32;
                    string3 = "Z\u001fY$\u0011?";
                    n4 = 31;
                    continue block88;
                }
                case 31: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 33;
                    string3 = "Z\u001fY#";
                    n4 = 32;
                    continue block88;
                }
                case 32: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 34;
                    string3 = "Z\u001fY#\u0015;";
                    n4 = 33;
                    continue block88;
                }
                case 33: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 35;
                    string3 = "]?}6Il$kwClw|\u007fCl$l6S`#p\u007fJ)#ps\u0004Y\u0004KFE{6usPl%KfAjw|yAzwvyP):ybGawl~A)\u001a_P\u0004d2keEn28rMn2kb\n";
                    n4 = 34;
                    continue block88;
                }
                case 34: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 36;
                    string3 = "Z\u001fY$\u0011?";
                    n4 = 35;
                    continue block88;
                }
                case 35: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 37;
                    string3 = "Z\u001fY$\u0016=";
                    n4 = 36;
                    continue block88;
                }
                case 36: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 38;
                    string3 = "Z\u001fY;\u0015";
                    n4 = 37;
                    continue block88;
                }
                case 37: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 39;
                    string3 = "Z\u001fY;\u00118e";
                    n4 = 38;
                    continue block88;
                }
                case 38: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 40;
                    string3 = "Z\u001fY";
                    n4 = 39;
                    continue block88;
                }
                case 39: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 41;
                    string3 = "Z\u001fY$\u0016=";
                    n4 = 40;
                    continue block88;
                }
                case 40: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 42;
                    string3 = "Z\u001fY";
                    n4 = 41;
                    continue block88;
                }
                case 41: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 43;
                    string3 = "Z\u001fY;\u00118e";
                    n4 = 42;
                    continue block88;
                }
                case 42: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 44;
                    string3 = "Z\u001fY#";
                    n4 = 43;
                    continue block88;
                }
                case 43: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 45;
                    string3 = "Z\u001fY;\u0015";
                    n4 = 44;
                    continue block88;
                }
                case 44: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 46;
                    string3 = "Z\u001fY'";
                    n4 = 45;
                    continue block88;
                }
                case 45: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 47;
                    string3 = "Z\u001fY;\u0016;c";
                    n4 = 46;
                    continue block88;
                }
                case 46: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 48;
                    string3 = "Z\u001fY%";
                    n4 = 47;
                    continue block88;
                }
                case 47: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 49;
                    string3 = "Z\u001fY#\u0015;";
                    n4 = 48;
                    continue block88;
                }
                case 48: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 50;
                    string3 = "Z\u001fY%\u001c=";
                    n4 = 49;
                    continue block88;
                }
                case 49: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 51;
                    string3 = "Z\u001fY;\u0016<a";
                    n4 = 50;
                    continue block88;
                }
                case 50: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 52;
                    string3 = "Z\u001fY;\u0016<a";
                    n4 = 51;
                    continue block88;
                }
                case 51: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 53;
                    string3 = "Z\u001fY;\u00171c";
                    n4 = 52;
                    continue block88;
                }
                case 52: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 54;
                    string3 = "Z\u001fY;\u00171c";
                    n4 = 53;
                    continue block88;
                }
                case 53: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 55;
                    string3 = "Z\u001fY%";
                    n4 = 54;
                    continue block88;
                }
                case 54: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 56;
                    string3 = "Z\u001fY$";
                    n4 = 55;
                    continue block88;
                }
                case 55: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 57;
                    string3 = "9f*%\u0010<a/.\u001dh5{rAo";
                    n4 = 56;
                    continue block88;
                }
                case 56: 
            }
            break;
        }
        stringArray2[n3] = string2.intern();
        z = stringArray3;
        Hashtable<String, Integer> hashtable = b = new Hashtable();
        String string4 = "Z\u001fY;\u0015";
        int n8 = -1;
        block90: while (true) {
            char[] cArray;
            block97: {
                int n9;
                block96: {
                    char[] cArray3 = string4.toCharArray();
                    cArray = cArray3;
                    n9 = cArray3.length;
                    n2 = 0;
                    if (!true) break block96;
                    n9 = n9;
                    if (n9 <= n2) break block97;
                }
                do {
                    int n10;
                    cArray = cArray;
                    int n11 = n2;
                    char c3 = cArray[n11];
                    switch (n2 % 5) {
                        case 0: {
                            n10 = 9;
                            break;
                        }
                        case 1: {
                            n10 = 87;
                            break;
                        }
                        case 2: {
                            n10 = 24;
                            break;
                        }
                        case 3: {
                            n10 = 22;
                            break;
                        }
                        default: {
                            n10 = 36;
                        }
                    }
                    cArray[n11] = (char)(c3 ^ n10);
                    ++n2;
                    n9 = n9;
                } while (n9 > n2);
            }
            string = new String(cArray).intern();
            switch (n8) {
                default: {
                    hashtable.put(string, 20);
                    hashtable = b;
                    string4 = "Z\u001fY";
                    n8 = 0;
                    continue block90;
                }
                case 0: {
                    hashtable.put(string, 20);
                    hashtable = b;
                    string4 = "Z\u001fY'";
                    n8 = 1;
                    continue block90;
                }
                case 1: {
                    hashtable.put(string, 20);
                    hashtable = b;
                    string4 = "Z\u001fY;\u0016;c";
                    n8 = 2;
                    continue block90;
                }
                case 2: {
                    hashtable.put(string, 28);
                    hashtable = b;
                    string4 = "Z\u001fY$\u0016=";
                    n8 = 3;
                    continue block90;
                }
                case 3: {
                    hashtable.put(string, 28);
                    hashtable = b;
                    string4 = "Z\u001fY;\u0016<a";
                    n8 = 4;
                    continue block90;
                }
                case 4: {
                    hashtable.put(string, 32);
                    hashtable = b;
                    string4 = "Z\u001fY$\u0011?";
                    n8 = 5;
                    continue block90;
                }
                case 5: {
                    hashtable.put(string, 32);
                    hashtable = b;
                    string4 = "Z\u001fY;\u00171c";
                    n8 = 6;
                    continue block90;
                }
                case 6: {
                    hashtable.put(string, 48);
                    hashtable = b;
                    string4 = "Z\u001fY%\u001c=";
                    n8 = 7;
                    continue block90;
                }
                case 7: {
                    hashtable.put(string, 48);
                    hashtable = b;
                    string4 = "Z\u001fY;\u00118e";
                    n8 = 8;
                    continue block90;
                }
                case 8: {
                    hashtable.put(string, 64);
                    hashtable = b;
                    string4 = "Z\u001fY#\u0015;";
                    n8 = 9;
                    continue block90;
                }
                case 9: {
                    hashtable.put(string, 64);
                    hashtable = b;
                    string4 = "D\u0013-";
                    n8 = 10;
                    continue block90;
                }
                case 10: {
                    hashtable.put(string, 16);
                    hashtable = b;
                    string4 = "Z\u001fY;\u00118e7$\u0016=";
                    n8 = 11;
                    continue block90;
                }
                case 11: {
                    hashtable.put(string, 28);
                    hashtable = b;
                    string4 = "Z\u001fY#\u0015;x*$\u0010";
                    n8 = 12;
                    continue block90;
                }
                case 12: {
                    hashtable.put(string, 28);
                    hashtable = b;
                    string4 = "Z\u001fY;\u00118e7$\u0011?";
                    n8 = 13;
                    continue block90;
                }
                case 13: {
                    hashtable.put(string, 32);
                    hashtable = b;
                    string4 = "Z\u001fY#\u0015;x*#\u0012";
                    n8 = 14;
                    continue block90;
                }
                case 14: 
            }
            break;
        }
        hashtable.put(string, 32);
    }
}

