/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger a;
    private int b = 2048;
    SecureRandom c = null;
    private static final String[] z;

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        block17: {
            int n2;
            block16: {
                if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                    throw new InvalidAlgorithmParameterException(z[3]);
                }
                RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
                n2 = rSAKeyGenParameterSpec.getKeysize();
                this.a = rSAKeyGenParameterSpec.getPublicExponent();
                this.c = secureRandom;
                if (n2 % 8 != 0) {
                    throw new InvalidAlgorithmParameterException(z[1]);
                }
                try {
                    RSAKeyFactory.checkKeyLengths(n2, this.a, 512, 65536);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidAlgorithmParameterException(z[5], invalidKeyException);
                }
                this.b = n2;
                if (this.a != null) break block16;
                this.a = RSAKeyGenParameterSpec.F4;
                break block17;
            }
            if (this.a.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException(z[2]);
            }
            if (this.a.bitLength() > n2) {
                throw new InvalidAlgorithmParameterException(z[4]);
            }
        }
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[9]);
        }
        try {
            RSAKeyFactory.checkKeyLengths(n2, RSAKeyGenParameterSpec.F4, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(invalidKeyException.getMessage());
        }
        this.b = n2;
        this.c = secureRandom;
        this.a = RSAKeyGenParameterSpec.F4;
    }

    public void initialize(int n2) {
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[7]);
        }
        this.b = n2;
        try {
            this.c = SecureRandom.getInstance(z[6]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.c = new SecureRandom();
        }
        this.a = RSAKeyGenParameterSpec.F4;
        try {
            RSAKeyFactory.checkKeyLengths(this.b, this.a, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(z[8]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        BigInteger bigInteger4;
        int n2;
        if (this.c == null) {
            this.c = null;
            try {
                this.c = SecureRandom.getInstance(z[0]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.c = new SecureRandom();
            }
        }
        BigInteger bigInteger7 = this.a != null ? this.a : RSAKeyGenParameterSpec.F4;
        while ((n2 = (bigInteger4 = (bigInteger6 = new BigInteger(this.b / 2, 10, this.c)).multiply(bigInteger5 = new BigInteger(this.b / 2, 10, this.c))).bitLength()) != this.b || !bigInteger7.gcd(bigInteger = (bigInteger3 = bigInteger6.subtract(BigInteger.ONE)).multiply(bigInteger2 = bigInteger5.subtract(BigInteger.ONE))).equals(BigInteger.ONE)) {
        }
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger2);
        BigInteger bigInteger11 = bigInteger5.modInverse(bigInteger6);
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger4, bigInteger7);
            RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(bigInteger4, bigInteger8, bigInteger7, bigInteger6, bigInteger5, bigInteger9, bigInteger10, bigInteger11);
            return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "U\u001c\u0007NS\u007f+8xd}0.r[";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                block20: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block20;
                    n5 = n5;
                    if (n5 <= n4) break block21;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 28;
                            break;
                        }
                        case 1: {
                            n6 = 94;
                            break;
                        }
                        case 2: {
                            n6 = 74;
                            break;
                        }
                        case 3: {
                            n6 = 29;
                            break;
                        }
                        default: {
                            n6 = 54;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Q1.hZi-jn_f;jpCo*j\u007fS<3?qBu.&x\u0016s8j%";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "L+(q_\u007f~/eFs0/sB<3?nB<</=\u0005<18=Z},-xD";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "L?8|[o~'hEh~(x\u0016u09iWr=/=Yz~\u0018NwW;3ZSr\u000e+oWq;>xDO./~";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "L+(q_\u007f~/eFs0/sB<3?nB<</=Eq?&qSn~>uWr~!xO<-#gS";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "U0<|Zu:jvSe~9tLy-";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "U\u001c\u0007NS\u007f+8xd}0.r[";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "Q1.hZi-jn_f;jpCo*j\u007fS<3?qBu.&x\u0016s8j%";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "U0<|Zu:jvSe~9tLy-";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "Q1.hZi-jn_f;jpCo*j\u007fS<3?qBu.&x\u0016s8j%";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

