/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.EllipticPoint;
import com.ibm.crypto.provider.PrimeField;
import com.ibm.crypto.provider.bd;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.util.Arrays;

public class P256PrimeField
extends ECFieldFp
implements PrimeField {
    private static final int[] a = new int[]{0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, -1, -1, -1};
    private static final int[] b = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] c = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static final int d = 16;

    public P256PrimeField() {
        super(bd.m);
    }

    protected int[] a(int[] nArray) {
        int[] nArray2 = new int[16];
        this.mod(nArray2, nArray);
        while (nArray2[7] < 0) {
            this.addNoMod(nArray2, nArray2, a);
        }
        while (this.greater(nArray2, a)) {
            this.subNoMod(nArray2, nArray2, a);
        }
        return nArray2;
    }

    public int[] multiply(Object object, Object object2) {
        int[] nArray = (int[])object;
        int[] nArray2 = (int[])object2;
        int[] nArray3 = new int[16];
        this.multiply(nArray3, nArray, nArray2);
        return this.a(nArray3);
    }

    public int[] divide(Object object, Object object2) {
        int[] nArray = (int[])object;
        int[] nArray2 = (int[])object2;
        int[] nArray3 = new int[16];
        System.arraycopy(nArray2, 0, nArray3, 0, 16);
        int[] nArray4 = new int[16];
        System.arraycopy(a, 0, nArray4, 0, 16);
        int[] nArray5 = new int[16];
        System.arraycopy(nArray, 0, nArray5, 0, 16);
        int[] nArray6 = new int[16];
        while (!this.isInternalZero(nArray3)) {
            this.divideHelper(nArray3, nArray5);
            this.divideHelper(nArray4, nArray6);
            if (this.greater(nArray4, nArray3)) {
                this.subNoMod(nArray4, nArray4, nArray3);
                nArray6 = this.subtract(nArray6, nArray5);
                continue;
            }
            this.subNoMod(nArray3, nArray3, nArray4);
            nArray5 = this.subtract(nArray5, nArray6);
        }
        return this.a(nArray6);
    }

    public int[] add(Object object, Object object2) {
        int[] nArray = new int[16];
        int[] nArray2 = (int[])object;
        int[] nArray3 = (int[])object2;
        boolean bl2 = this.addNoMod(nArray, nArray2, nArray3);
        if (bl2) {
            this.subNoMod(nArray, nArray, a);
        }
        if (this.greater(a, nArray)) {
            return nArray;
        }
        this.subNoMod(nArray, nArray, a);
        return nArray;
    }

    public int[] subtract(Object object, Object object2) {
        boolean bl2;
        int[] nArray = (int[])object;
        int[] nArray2 = (int[])object2;
        int[] nArray3 = new int[16];
        if (this.greater(nArray2, nArray)) {
            this.addNoMod(nArray3, nArray, a);
            nArray = nArray3;
        }
        if (bl2 = this.subNoMod(nArray3, nArray, nArray2)) {
            this.addNoMod(nArray3, nArray3, a);
        }
        return nArray3;
    }

    public int[] shiftLeft(Object object, int n2) {
        int n3;
        int[] nArray = (int[])object;
        int[] nArray2 = new int[16];
        for (n3 = 8; n3 < 16; ++n3) {
            nArray2[n3] = nArray[n3] << n2;
        }
        for (n3 = 8; n3 < 16; ++n3) {
            int n4 = n3 - 1;
            nArray2[n4] = nArray2[n4] | nArray[n3] >>> 32 - n2;
        }
        if (this.greater(a, nArray2)) {
            return nArray2;
        }
        if (n2 != 1) {
            nArray2 = this.a(nArray2);
            return nArray2;
        }
        this.subNoMod(nArray2, nArray2, a);
        return nArray2;
    }

    public int[] shiftRight(Object object, int n2) {
        int[] nArray = (int[])object;
        int[] nArray2 = new int[16];
        this.shiftRight(nArray2, nArray, n2);
        return nArray2;
    }

    @Override
    public boolean isInternalZero(Object object) {
        return Arrays.equals(b, (int[])object);
    }

    @Override
    public boolean isInternalOne(Object object) {
        return Arrays.equals(c, (int[])object);
    }

    @Override
    public boolean isInternalEqual(Object object, Object object2) {
        return Arrays.equals((int[])object, (int[])object2);
    }

    public int[] internalZero() {
        return b;
    }

    public int[] internalOne() {
        return c;
    }

    public boolean greater(Object object, Object object2) {
        int[] nArray = (int[])object;
        int[] nArray2 = (int[])object2;
        boolean bl2 = false;
        long l2 = nArray[7] - nArray2[7];
        if (l2 < 0L) {
            return false;
        }
        if (l2 > 0L) {
            return true;
        }
        for (int i2 = 8; i2 < 16 && (l2 = ((long)nArray[i2] & 0xFFFFFFFFL) - ((long)nArray2[i2] & 0xFFFFFFFFL)) >= 0L; ++i2) {
            if (l2 <= 0L) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public BigInteger internalToBigInteger(Object object) {
        int[] nArray = (int[])object;
        byte[] byArray = new byte[64];
        int n2 = 0;
        int n3 = 0;
        while (n2 < 16) {
            int n4 = nArray[n2];
            byArray[n3 + 3] = (byte)n4;
            byArray[n3 + 2] = (byte)(n4 >> 8);
            byArray[n3 + 1] = (byte)(n4 >> 16);
            byArray[n3] = (byte)(n4 >> 24);
            ++n2;
            n3 += 4;
        }
        return new BigInteger(1, byArray);
    }

    public int[] bigIntegerTointernal(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int[] nArray = new int[16];
        int n2 = 15;
        int n3 = 0;
        while (n2 >= 0) {
            int n4 = 0;
            int n5 = byArray.length - 1 - n3;
            for (int i2 = 0; n5 >= 0 && i2 < 32; --n5, i2 += 8) {
                n4 |= (byArray[n5] & 0xFF) << i2;
            }
            nArray[n2] = n4;
            --n2;
            n3 += 4;
        }
        return nArray;
    }

    @Override
    public EllipticPoint internalMontgomeryLadderMultiply(Object object, EllipticPoint ellipticPoint) {
        EllipticPoint ellipticPoint2 = ellipticPoint;
        EllipticPoint ellipticPoint3 = ellipticPoint.infinity();
        int[] nArray = (int[])object;
        block0: for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            int n2 = nArray[i2];
            boolean bl2 = i2 == 0;
            int n3 = 0;
            while (n3 < 32) {
                if ((n2 & 1) == 1) {
                    ellipticPoint3.add(ellipticPoint2);
                }
                if (bl2 && n2 == 1) continue block0;
                ellipticPoint2.doublee();
                ++n3;
                n2 >>= 1;
            }
        }
        return ellipticPoint3;
    }

    private void mod(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, nArray2[8], nArray2[9], nArray2[10], nArray2[11], nArray2[12], nArray2[13], nArray2[14], nArray2[15]};
        int[] nArray4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray2[4], 0, 0, 0};
        int[] nArray5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, nArray2[0], nArray2[1], nArray2[2], nArray2[3], 0, 0, 0};
        int[] nArray6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, nArray2[0], nArray2[1], 0, 0, 0, nArray2[5], nArray2[6], nArray2[7]};
        int[] nArray7 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, nArray2[7], nArray2[2], nArray2[0], nArray2[1], nArray2[2], nArray2[4], nArray2[5], nArray2[6]};
        int[] nArray8 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, nArray2[5], nArray2[7], 0, 0, 0, nArray2[2], nArray2[3], nArray2[4]};
        int[] nArray9 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, nArray2[4], nArray2[6], 0, 0, nArray2[0], nArray2[1], nArray2[2], nArray2[3]};
        int[] nArray10 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, nArray2[3], 0, nArray2[5], nArray2[6], nArray2[7], nArray2[0], nArray2[1], nArray2[2]};
        int[] nArray11 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, nArray2[2], 0, nArray2[4], nArray2[5], nArray2[6], 0, nArray2[0], nArray2[1]};
        this.addNoMod(nArray, nArray3, nArray4);
        this.addNoMod(nArray, nArray, nArray4);
        this.addNoMod(nArray, nArray, nArray5);
        this.addNoMod(nArray, nArray, nArray5);
        this.addNoMod(nArray, nArray, nArray6);
        this.addNoMod(nArray, nArray, nArray7);
        this.subNoMod(nArray, nArray, nArray8);
        this.subNoMod(nArray, nArray, nArray9);
        this.subNoMod(nArray, nArray, nArray10);
        this.subNoMod(nArray, nArray, nArray11);
    }

    private boolean addNoMod(int[] nArray, int[] nArray2, int[] nArray3) {
        long l2 = 0L;
        nArray[15] = (int)(l2 += ((long)nArray2[15] & 0xFFFFFFFFL) + ((long)nArray3[15] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[14] = (int)(l2 += ((long)nArray2[14] & 0xFFFFFFFFL) + ((long)nArray3[14] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[13] = (int)(l2 += ((long)nArray2[13] & 0xFFFFFFFFL) + ((long)nArray3[13] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[12] = (int)(l2 += ((long)nArray2[12] & 0xFFFFFFFFL) + ((long)nArray3[12] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[11] = (int)(l2 += ((long)nArray2[11] & 0xFFFFFFFFL) + ((long)nArray3[11] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[10] = (int)(l2 += ((long)nArray2[10] & 0xFFFFFFFFL) + ((long)nArray3[10] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[9] = (int)(l2 += ((long)nArray2[9] & 0xFFFFFFFFL) + ((long)nArray3[9] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[8] = (int)(l2 += ((long)nArray2[8] & 0xFFFFFFFFL) + ((long)nArray3[8] & 0xFFFFFFFFL));
        boolean bl2 = (l2 >>= 32) != 0L;
        nArray[7] = (int)(l2 += ((long)nArray2[7] & 0xFFFFFFFFL) + ((long)nArray3[7] & 0xFFFFFFFFL));
        return bl2;
    }

    private boolean subNoMod(int[] nArray, int[] nArray2, int[] nArray3) {
        long l2 = 0L;
        nArray[15] = (int)(l2 += ((long)nArray2[15] & 0xFFFFFFFFL) - ((long)nArray3[15] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[14] = (int)(l2 += ((long)nArray2[14] & 0xFFFFFFFFL) - ((long)nArray3[14] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[13] = (int)(l2 += ((long)nArray2[13] & 0xFFFFFFFFL) - ((long)nArray3[13] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[12] = (int)(l2 += ((long)nArray2[12] & 0xFFFFFFFFL) - ((long)nArray3[12] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[11] = (int)(l2 += ((long)nArray2[11] & 0xFFFFFFFFL) - ((long)nArray3[11] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[10] = (int)(l2 += ((long)nArray2[10] & 0xFFFFFFFFL) - ((long)nArray3[10] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[9] = (int)(l2 += ((long)nArray2[9] & 0xFFFFFFFFL) - ((long)nArray3[9] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[8] = (int)(l2 += ((long)nArray2[8] & 0xFFFFFFFFL) - ((long)nArray3[8] & 0xFFFFFFFFL));
        l2 >>= 32;
        nArray[7] = (int)(l2 += ((long)nArray2[7] & 0xFFFFFFFFL) - ((long)nArray3[7] & 0xFFFFFFFFL));
        return (l2 >>= 32) != 0L;
    }

    private void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        long l2;
        int n2;
        int n3;
        long l3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n6 = 15; n6 >= 8; --n6) {
            n5 = 15;
            for (n4 = n6; n4 < 16; ++n4) {
                l3 = ((long)nArray2[n4] & 0xFFFFFFFFL) * ((long)nArray3[n5] & 0xFFFFFFFFL);
                n3 = (int)l3;
                n2 = (int)(l3 >> 32);
                l2 = ((long)n7 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL);
                n7 = (int)l2;
                l2 >>= 32;
                n8 = (int)(l2 += ((long)n8 & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL));
                n9 = (int)((long)n9 + (l2 >>= 32));
                --n5;
            }
            nArray[n6] = n7;
            n7 = n8;
            n8 = n9;
            n9 = 0;
        }
        for (n6 = 7; n6 >= 0; --n6) {
            n4 = 7;
            n5 = n6 + 8;
            while (n5 >= 8) {
                l3 = ((long)nArray2[n4] & 0xFFFFFFFFL) * ((long)nArray3[n5] & 0xFFFFFFFFL);
                n3 = (int)l3;
                n2 = (int)(l3 >> 32);
                l2 = ((long)n7 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL);
                n7 = (int)l2;
                l2 >>= 32;
                n8 = (int)(l2 += ((long)n8 & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL));
                n9 = (int)((long)n9 + (l2 >>= 32));
                --n5;
                ++n4;
            }
            nArray[n6] = n7;
            n7 = n8;
            n8 = n9;
            n9 = 0;
        }
    }

    private void divideHelper(int[] nArray, int[] nArray2) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        for (n3 = 15; n3 > 7; --n3) {
            int n5 = nArray[n3];
            for (n4 = 0; n4 < 32; ++n4) {
                if ((n5 & 1) != 0) {
                    bl2 = true;
                    break;
                }
                n5 >>= 1;
                if ((nArray2[15] & 1) != 0) {
                    this.addNoMod(nArray2, nArray2, a);
                }
                this.shiftRight(nArray2, nArray2, 1);
            }
            if (bl2) break;
        }
        if ((n2 = (15 - n3 << 5) + (n4 & 0x1F)) > 0) {
            this.shiftRight(nArray, nArray, n2);
        }
    }

    private void shiftRight(int[] nArray, int[] nArray2, int n2) {
        int n3 = n2 / 32;
        int n4 = n2 & 0x1F;
        for (int i2 = 15; i2 >= 7 && i2 - n3 - 1 > 0; --i2) {
            int n5 = nArray2[i2 - n3] >>> n4;
            nArray[i2] = n5 |= nArray2[i2 - n3 - 1] << 32 - n4;
        }
    }
}

