/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.PrimeCurve;
import com.ibm.crypto.provider.PrimeField;
import com.ibm.crypto.provider.bd;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int a = 256;
    SecureRandom b = null;
    ECParameterSpec c;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 192 || n2 > 521 || n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new InvalidParameterException(z[3]);
        }
        this.a = n2;
        this.b = secureRandom;
        this.c = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.c = ECUtils.getPrimeParameterSpec((ECParameterSpec)algorithmParameterSpec);
            this.b = secureRandom;
            this.a = this.c.getCurve().getField().getFieldSize();
            return;
        }
        if (!(algorithmParameterSpec instanceof ECGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[1]);
        }
        this.c = ECNamedCurve.getECParameterSpec(((ECGenParameterSpec)algorithmParameterSpec).getName());
        if (this.c == null) {
            throw new InvalidAlgorithmParameterException(z[0]);
        }
        this.b = secureRandom;
        this.a = this.c.getCurve().getField().getFieldSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        if (this.b == null) {
            this.b = null;
            try {
                this.b = SecureRandom.getInstance(z[2]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = new SecureRandom();
            }
        }
        if (this.c == null) {
            this.a();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        BigInteger bigInteger = new BigInteger(n2, this.b);
        bigInteger = bigInteger.abs();
        while (bigInteger.compareTo(this.c.getOrder()) != -1) {
            bigInteger = new BigInteger(n2, this.b);
            bigInteger = bigInteger.abs();
        }
        try {
            PrimeCurve primeCurve = ECUtils.getPrimeCurve(this.c.getCurve());
            ECPoint eCPoint = primeCurve.multiply(((PrimeField)primeCurve.getField()).bigIntegerTointernal(bigInteger), primeCurve.toEllipticPoint(this.c.getGenerator())).getAffine();
            ECPublicKey eCPublicKey = new ECPublicKey(eCPoint, this.c);
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger, this.c, eCPublicKey);
            return new KeyPair(eCPublicKey, eCPrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void a() {
        switch (this.a) {
            case 192: {
                PrimeField primeField = ECUtils.getField(192, bd.a, true);
                Object var2_6 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bd.E.mod(bd.a), bd.c, 1);
                this.c = new ECParameterSpec(primeCurve, bd.f, bd.b, 1);
                break;
            }
            case 224: {
                PrimeField primeField = ECUtils.getField(224, bd.g, true);
                Object var2_7 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bd.E.mod(bd.g), bd.i, 1);
                this.c = new ECParameterSpec(primeCurve, bd.l, bd.h, 1);
                break;
            }
            case 256: {
                PrimeField primeField = ECUtils.getField(256, bd.m, true);
                Object var2_8 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bd.E.mod(bd.m), bd.o, 1);
                this.c = new ECParameterSpec(primeCurve, bd.r, bd.n, 1);
                break;
            }
            case 384: {
                PrimeField primeField = ECUtils.getField(384, bd.s, true);
                Object var2_9 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bd.E.mod(bd.s), bd.u, 1);
                this.c = new ECParameterSpec(primeCurve, bd.x, bd.t, 1);
                break;
            }
            case 521: {
                PrimeField primeField = ECUtils.getField(521, bd.y, true);
                Object var2_10 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bd.E.mod(bd.y), bd.A, 1);
                this.c = new ECParameterSpec(primeCurve, bd.D, bd.z, 1);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u001b\rLU*x\u0016_N*x\u0016QWo*\u001d]L(6\u0011DF+x\u0017L\u0003!7\f\u001eP:(\bQQ;=\u001c";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                block14: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block14;
                    n5 = n5;
                    if (n5 <= n4) break block15;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 88;
                            break;
                        }
                        case 1: {
                            n6 = 120;
                            break;
                        }
                        case 2: {
                            n6 = 62;
                            break;
                        }
                        case 3: {
                            n6 = 35;
                            break;
                        }
                        default: {
                            n6 = 79;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\b\u0019LB\"+XSV<,X\\Fo1\u0016MW.6\u001b[\u0003 >X{`\u001f9\n_N*,\u001dLp?=\u001b\u001eL=x=}d*6(_Q.5\u001dJF=\u000b\b[@";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0011:sp*;\rLF\u001d9\u0016ZL\"";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\b\nWN*x\u000bWY*x\u0015KP;x\u001a[\u0003 6\u001d\u001eL)bX\u000f\u001a}tX\f\u0011{tX\f\u0016ytX\r\u001b{tX\u000b\u0011~";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

