/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

class Elementary {
    private Elementary() {
    }

    static int compareArrays(int[] nArray, int[] nArray2, int n) {
        int n2;
        for (n2 = n - 1; n2 >= 0 && nArray[n2] == nArray2[n2]; --n2) {
        }
        return n2 < 0 ? 0 : (((long)nArray[n2] & 0xFFFFFFFFL) < ((long)nArray2[n2] & 0xFFFFFFFFL) ? -1 : 1);
    }

    static BigInteger add(BigInteger bigInteger, BigInteger bigInteger2) {
        int[] nArray;
        int n;
        int n2 = bigInteger.sign;
        int n3 = bigInteger2.sign;
        if (n2 == 0) {
            return bigInteger2;
        }
        if (n3 == 0) {
            return bigInteger;
        }
        int n4 = bigInteger.numberLength;
        int n5 = bigInteger2.numberLength;
        if (n4 + n5 == 2) {
            long l = (long)bigInteger.digits[0] & 0xFFFFFFFFL;
            long l2 = (long)bigInteger2.digits[0] & 0xFFFFFFFFL;
            if (n2 == n3) {
                long l3 = l + l2;
                int n6 = (int)l3;
                int n7 = (int)(l3 >>> 32);
                return n7 == 0 ? new BigInteger(n2, n6) : new BigInteger(n2, 2, new int[]{n6, n7});
            }
            return BigInteger.valueOf(n2 < 0 ? l2 - l : l - l2);
        }
        if (n2 == n3) {
            n = n2;
            nArray = n4 >= n5 ? Elementary.add(bigInteger.digits, n4, bigInteger2.digits, n5) : Elementary.add(bigInteger2.digits, n5, bigInteger.digits, n4);
        } else {
            int n8;
            int n9 = n4 != n5 ? (n4 > n5 ? 1 : -1) : (n8 = Elementary.compareArrays(bigInteger.digits, bigInteger2.digits, n4));
            if (n8 == 0) {
                return BigInteger.ZERO;
            }
            if (n8 == 1) {
                n = n2;
                nArray = Elementary.subtract(bigInteger.digits, n4, bigInteger2.digits, n5);
            } else {
                n = n3;
                nArray = Elementary.subtract(bigInteger2.digits, n5, bigInteger.digits, n4);
            }
        }
        BigInteger bigInteger3 = new BigInteger(n, nArray.length, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    private static void add(int[] nArray, int[] nArray2, int n, int[] nArray3, int n2) {
        int n3;
        long l = ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray3[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        l >>= 32;
        if (n >= n2) {
            for (n3 = 1; n3 < n2; ++n3) {
                nArray[n3] = (int)(l += ((long)nArray2[n3] & 0xFFFFFFFFL) + ((long)nArray3[n3] & 0xFFFFFFFFL));
                l >>= 32;
            }
            while (n3 < n) {
                nArray[n3] = (int)(l += (long)nArray2[n3] & 0xFFFFFFFFL);
                l >>= 32;
                ++n3;
            }
        } else {
            for (n3 = 1; n3 < n; ++n3) {
                nArray[n3] = (int)(l += ((long)nArray2[n3] & 0xFFFFFFFFL) + ((long)nArray3[n3] & 0xFFFFFFFFL));
                l >>= 32;
            }
            while (n3 < n2) {
                nArray[n3] = (int)(l += (long)nArray3[n3] & 0xFFFFFFFFL);
                l >>= 32;
                ++n3;
            }
        }
        if (l != 0L) {
            nArray[n3] = (int)l;
        }
    }

    static BigInteger subtract(BigInteger bigInteger, BigInteger bigInteger2) {
        int[] nArray;
        int n;
        int n2;
        int n3 = bigInteger.sign;
        int n4 = bigInteger2.sign;
        if (n4 == 0) {
            return bigInteger;
        }
        if (n3 == 0) {
            return bigInteger2.negate();
        }
        int n5 = bigInteger.numberLength;
        int n6 = bigInteger2.numberLength;
        if (n5 + n6 == 2) {
            long l = (long)bigInteger.digits[0] & 0xFFFFFFFFL;
            long l2 = (long)bigInteger2.digits[0] & 0xFFFFFFFFL;
            if (n3 < 0) {
                l = -l;
            }
            if (n4 < 0) {
                l2 = -l2;
            }
            return BigInteger.valueOf(l - l2);
        }
        int n7 = n5 != n6 ? (n5 > n6 ? 1 : -1) : (n2 = Elementary.compareArrays(bigInteger.digits, bigInteger2.digits, n5));
        if (n2 == -1) {
            n = -n4;
            nArray = n3 == n4 ? Elementary.subtract(bigInteger2.digits, n6, bigInteger.digits, n5) : Elementary.add(bigInteger2.digits, n6, bigInteger.digits, n5);
        } else {
            n = n3;
            if (n3 == n4) {
                if (n2 == 0) {
                    return BigInteger.ZERO;
                }
                nArray = Elementary.subtract(bigInteger.digits, n5, bigInteger2.digits, n6);
            } else {
                nArray = Elementary.add(bigInteger.digits, n5, bigInteger2.digits, n6);
            }
        }
        BigInteger bigInteger3 = new BigInteger(n, nArray.length, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    private static void subtract(int[] nArray, int[] nArray2, int n, int[] nArray3, int n2) {
        int n3;
        long l = 0L;
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = (int)(l += ((long)nArray2[n3] & 0xFFFFFFFFL) - ((long)nArray3[n3] & 0xFFFFFFFFL));
            l >>= 32;
        }
        while (n3 < n) {
            nArray[n3] = (int)(l += (long)nArray2[n3] & 0xFFFFFFFFL);
            l >>= 32;
            ++n3;
        }
    }

    private static int[] add(int[] nArray, int n, int[] nArray2, int n2) {
        int[] nArray3 = new int[n + 1];
        Elementary.add(nArray3, nArray, n, nArray2, n2);
        return nArray3;
    }

    static void inplaceAdd(BigInteger bigInteger, BigInteger bigInteger2) {
        Elementary.add(bigInteger.digits, bigInteger.digits, bigInteger.numberLength, bigInteger2.digits, bigInteger2.numberLength);
        bigInteger.numberLength = Math.min(Math.max(bigInteger.numberLength, bigInteger2.numberLength) + 1, bigInteger.digits.length);
        bigInteger.cutOffLeadingZeroes();
        bigInteger.unCache();
    }

    static int inplaceAdd(int[] nArray, int n, int n2) {
        long l = (long)n2 & 0xFFFFFFFFL;
        for (int i = 0; l != 0L && i < n; l >>= 32, ++i) {
            nArray[i] = (int)(l += (long)nArray[i] & 0xFFFFFFFFL);
        }
        return (int)l;
    }

    static void inplaceAdd(BigInteger bigInteger, int n) {
        int n2 = Elementary.inplaceAdd(bigInteger.digits, bigInteger.numberLength, n);
        if (n2 == 1) {
            bigInteger.digits[bigInteger.numberLength] = 1;
            ++bigInteger.numberLength;
        }
        bigInteger.unCache();
    }

    static void inplaceSubtract(BigInteger bigInteger, BigInteger bigInteger2) {
        Elementary.subtract(bigInteger.digits, bigInteger.digits, bigInteger.numberLength, bigInteger2.digits, bigInteger2.numberLength);
        bigInteger.cutOffLeadingZeroes();
        bigInteger.unCache();
    }

    private static void inverseSubtract(int[] nArray, int[] nArray2, int n, int[] nArray3, int n2) {
        long l = 0L;
        if (n < n2) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                nArray[n3] = (int)(l += ((long)nArray3[n3] & 0xFFFFFFFFL) - ((long)nArray2[n3] & 0xFFFFFFFFL));
                l >>= 32;
            }
            while (n3 < n2) {
                nArray[n3] = (int)(l += (long)nArray3[n3] & 0xFFFFFFFFL);
                l >>= 32;
                ++n3;
            }
        } else {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                nArray[n4] = (int)(l += ((long)nArray3[n4] & 0xFFFFFFFFL) - ((long)nArray2[n4] & 0xFFFFFFFFL));
                l >>= 32;
            }
            while (n4 < n) {
                nArray[n4] = (int)(l -= (long)nArray2[n4] & 0xFFFFFFFFL);
                l >>= 32;
                ++n4;
            }
        }
    }

    private static int[] subtract(int[] nArray, int n, int[] nArray2, int n2) {
        int[] nArray3 = new int[n];
        Elementary.subtract(nArray3, nArray, n, nArray2, n2);
        return nArray3;
    }

    static void completeInPlaceSubtract(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = bigInteger.compareTo(bigInteger2);
        if (bigInteger.sign == 0) {
            System.arraycopy(bigInteger2.digits, 0, bigInteger.digits, 0, bigInteger2.numberLength);
            bigInteger.sign = -bigInteger2.sign;
        } else if (bigInteger.sign != bigInteger2.sign) {
            Elementary.add(bigInteger.digits, bigInteger.digits, bigInteger.numberLength, bigInteger2.digits, bigInteger2.numberLength);
            bigInteger.sign = n;
        } else {
            int n2 = Elementary.unsignedArraysCompare(bigInteger.digits, bigInteger2.digits, bigInteger.numberLength, bigInteger2.numberLength);
            if (n2 > 0) {
                Elementary.subtract(bigInteger.digits, bigInteger.digits, bigInteger.numberLength, bigInteger2.digits, bigInteger2.numberLength);
            } else {
                Elementary.inverseSubtract(bigInteger.digits, bigInteger.digits, bigInteger.numberLength, bigInteger2.digits, bigInteger2.numberLength);
                bigInteger.sign = -bigInteger.sign;
            }
        }
        bigInteger.numberLength = Math.max(bigInteger.numberLength, bigInteger2.numberLength) + 1;
        bigInteger.cutOffLeadingZeroes();
        bigInteger.unCache();
    }

    static void completeInPlaceAdd(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.sign == 0) {
            System.arraycopy(bigInteger2.digits, 0, bigInteger.digits, 0, bigInteger2.numberLength);
        } else {
            if (bigInteger2.sign == 0) {
                return;
            }
            if (bigInteger.sign == bigInteger2.sign) {
                Elementary.add(bigInteger.digits, bigInteger.digits, bigInteger.numberLength, bigInteger2.digits, bigInteger2.numberLength);
            } else {
                int n = Elementary.unsignedArraysCompare(bigInteger.digits, bigInteger2.digits, bigInteger.numberLength, bigInteger2.numberLength);
                if (n > 0) {
                    Elementary.subtract(bigInteger.digits, bigInteger.digits, bigInteger.numberLength, bigInteger2.digits, bigInteger2.numberLength);
                } else {
                    Elementary.inverseSubtract(bigInteger.digits, bigInteger.digits, bigInteger.numberLength, bigInteger2.digits, bigInteger2.numberLength);
                    bigInteger.sign = -bigInteger.sign;
                }
            }
        }
        bigInteger.numberLength = Math.max(bigInteger.numberLength, bigInteger2.numberLength) + 1;
        bigInteger.cutOffLeadingZeroes();
        bigInteger.unCache();
    }

    private static int unsignedArraysCompare(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        for (n3 = n - 1; n3 >= 0 && nArray[n3] == nArray2[n3]; --n3) {
        }
        return n3 < 0 ? 0 : (((long)nArray[n3] & 0xFFFFFFFFL) < ((long)nArray2[n3] & 0xFFFFFFFFL) ? -1 : 1);
    }
}

