/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import com.ibm.Compiler.Internal.Quad;
import java.math.BigInteger;
import java.math.BitLevel;
import java.math.DivisionLong;
import java.math.Elementary;
import java.math.Multiplication;
import org.apache.harmony.math.internal.nls.Messages;

class Division {
    Division() {
    }

    static int[] divide(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3) {
        int[] nArray4 = new int[n2 + 1];
        int[] nArray5 = new int[n3 + 1];
        int n4 = n3;
        int n5 = Integer.numberOfLeadingZeros(nArray3[n3 - 1]);
        if (n5 != 0) {
            BitLevel.shiftLeft(nArray5, nArray3, 0, n5);
            BitLevel.shiftLeft(nArray4, nArray2, 0, n5);
        } else {
            System.arraycopy(nArray2, 0, nArray4, 0, n2);
            System.arraycopy(nArray3, 0, nArray5, 0, n3);
        }
        int n6 = nArray5[n4 - 1];
        int n7 = n2;
        for (int i = n - 1; i >= 0; --i) {
            int n8;
            int n9 = 0;
            if (nArray4[n7] == n6) {
                n9 = -1;
            } else {
                long l = (((long)nArray4[n7] & 0xFFFFFFFFL) << 32) + ((long)nArray4[n7 - 1] & 0xFFFFFFFFL);
                long l2 = Division.divideLongByInt(l, n6);
                n9 = (int)l2;
                int n10 = (int)(l2 >> 32);
                if (n9 != 0) {
                    long l3 = 0L;
                    long l4 = 0L;
                    boolean bl = false;
                    ++n9;
                    do {
                        --n9;
                        if (bl) break;
                        l3 = ((long)n9 & 0xFFFFFFFFL) * ((long)nArray5[n4 - 2] & 0xFFFFFFFFL);
                        l4 = ((long)n10 << 32) + ((long)nArray4[n7 - 2] & 0xFFFFFFFFL);
                        long l5 = ((long)n10 & 0xFFFFFFFFL) + ((long)n6 & 0xFFFFFFFFL);
                        if (Integer.numberOfLeadingZeros((int)(l5 >>> 32)) < 32) {
                            bl = true;
                            continue;
                        }
                        n10 = (int)l5;
                    } while ((l3 ^ Long.MIN_VALUE) > (l4 ^ Long.MIN_VALUE));
                }
            }
            if (n9 != 0 && (n8 = Division.multiplyAndSubtract(nArray4, n7 - n4, nArray5, n4, n9)) != 0) {
                --n9;
                long l = 0L;
                for (int j = 0; j < n4; ++j) {
                    nArray4[n7 - n4 + j] = (int)(l += ((long)nArray4[n7 - n4 + j] & 0xFFFFFFFFL) + ((long)nArray5[j] & 0xFFFFFFFFL));
                    l >>>= 32;
                }
            }
            if (nArray != null) {
                nArray[i] = n9;
            }
            --n7;
        }
        if (n5 != 0) {
            BitLevel.shiftRight(nArray5, n4, nArray4, 0, n5);
            return nArray5;
        }
        System.arraycopy(nArray4, 0, nArray5, 0, n3);
        return nArray4;
    }

    static int divideArrayByInt(int[] nArray, int[] nArray2, int n, int n2) {
        long l = 0L;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        for (int i = n - 1; i >= 0; --i) {
            long l3;
            long l4 = l << 32 | (long)nArray2[i] & 0xFFFFFFFFL;
            if (l4 >= 0L) {
                l3 = l4 / l2;
                l = l4 % l2;
            } else {
                long l5 = l4 >>> 1;
                long l6 = n2 >>> 1;
                l3 = l5 / l6;
                l = l5 % l6;
                l = (l << 1) + (l4 & 1L);
                if ((n2 & 1) != 0) {
                    if (l3 <= l) {
                        l -= l3;
                    } else if (l3 - l <= l2) {
                        l += l2 - l3;
                        --l3;
                    } else {
                        l += (l2 << 1) - l3;
                        l3 -= 2L;
                    }
                }
            }
            nArray[i] = (int)(l3 & 0xFFFFFFFFL);
        }
        return (int)l;
    }

    static int remainderArrayByInt(int[] nArray, int n, int n2) {
        long l = 0L;
        for (int i = n - 1; i >= 0; --i) {
            long l2 = (l << 32) + ((long)nArray[i] & 0xFFFFFFFFL);
            long l3 = Division.divideLongByInt(l2, n2);
            l = (int)(l3 >> 32);
        }
        return (int)l;
    }

    static int remainder(BigInteger bigInteger, int n) {
        return Division.remainderArrayByInt(bigInteger.digits, bigInteger.numberLength, n);
    }

    static long divideLongByInt(long l, int n) {
        long l2;
        long l3;
        long l4 = (long)n & 0xFFFFFFFFL;
        if (l >= 0L) {
            l3 = l / l4;
            l2 = l % l4;
        } else {
            long l5 = l >>> 1;
            long l6 = n >>> 1;
            l3 = l5 / l6;
            l2 = l5 % l6;
            l2 = (l2 << 1) + (l & 1L);
            if ((n & 1) != 0) {
                if (l3 <= l2) {
                    l2 -= l3;
                } else if (l3 - l2 <= l4) {
                    l2 += l4 - l3;
                    --l3;
                } else {
                    l2 += (l4 << 1) - l3;
                    l3 -= 2L;
                }
            }
        }
        return l2 << 32 | l3 & 0xFFFFFFFFL;
    }

    static BigInteger[] divideAndRemainderByInteger(BigInteger bigInteger, int n, int n2) {
        int[] nArray = bigInteger.digits;
        int n3 = bigInteger.numberLength;
        int n4 = bigInteger.sign;
        if (n3 == 1) {
            long l = (long)nArray[0] & 0xFFFFFFFFL;
            long l2 = (long)n & 0xFFFFFFFFL;
            long l3 = l / l2;
            long l4 = l % l2;
            if (n4 != n2) {
                l3 = -l3;
            }
            if (n4 < 0) {
                l4 = -l4;
            }
            return new BigInteger[]{BigInteger.valueOf(l3), BigInteger.valueOf(l4)};
        }
        int n5 = n3;
        int n6 = n4 == n2 ? 1 : -1;
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[]{Division.divideArrayByInt(nArray2, nArray, n3, n)};
        BigInteger bigInteger2 = new BigInteger(n6, n5, nArray2);
        BigInteger bigInteger3 = new BigInteger(n4, 1, nArray3);
        bigInteger2.cutOffLeadingZeroes();
        bigInteger3.cutOffLeadingZeroes();
        return new BigInteger[]{bigInteger2, bigInteger3};
    }

    static int multiplyAndSubtract(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < n2; ++i) {
            l = Multiplication.unsignedMultAddAdd(nArray2[i], n3, (int)l, 0);
            l2 = ((long)nArray[n + i] & 0xFFFFFFFFL) - (l & 0xFFFFFFFFL) + l2;
            nArray[n + i] = (int)l2;
            l2 >>= 32;
            l >>>= 32;
        }
        l2 = ((long)nArray[n + n2] & 0xFFFFFFFFL) - l + l2;
        nArray[n + n2] = (int)l2;
        return (int)(l2 >> 32);
    }

    static BigInteger gcdBinary(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        int n = bigInteger.getLowestSetBit();
        int n2 = bigInteger2.getLowestSetBit();
        int n3 = Math.min(n, n2);
        BitLevel.inplaceShiftRight(bigInteger, n);
        BitLevel.inplaceShiftRight(bigInteger2, n2);
        if (bigInteger.compareTo(bigInteger2) == 1) {
            bigInteger3 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger3;
        }
        do {
            if (bigInteger2.numberLength == 1 || bigInteger2.numberLength == 2 && bigInteger2.digits[1] > 0) {
                bigInteger2 = BigInteger.valueOf(Division.gcdBinary(bigInteger.longValue(), bigInteger2.longValue()));
                break;
            }
            if ((double)bigInteger2.numberLength > (double)bigInteger.numberLength * 1.2) {
                if ((bigInteger2 = bigInteger2.remainder(bigInteger)).signum() != 0) {
                    BitLevel.inplaceShiftRight(bigInteger2, bigInteger2.getLowestSetBit());
                }
            } else {
                do {
                    Elementary.inplaceSubtract(bigInteger2, bigInteger);
                    BitLevel.inplaceShiftRight(bigInteger2, bigInteger2.getLowestSetBit());
                } while (bigInteger2.compareTo(bigInteger) >= 0);
            }
            bigInteger3 = bigInteger2;
            bigInteger2 = bigInteger;
            bigInteger = bigInteger3;
        } while (bigInteger.sign != 0);
        return bigInteger2.shiftLeft(n3);
    }

    static long gcdBinary(long l, long l2) {
        int n = Long.numberOfTrailingZeros(l);
        int n2 = Long.numberOfTrailingZeros(l2);
        int n3 = Math.min(n, n2);
        if (n != 0) {
            l >>>= n;
        }
        if (n2 != 0) {
            l2 >>>= n2;
        }
        do {
            if (l >= l2) {
                l -= l2;
                l >>>= Long.numberOfTrailingZeros(l);
                continue;
            }
            l2 -= l;
            l2 >>>= Long.numberOfTrailingZeros(l2);
        } while (l != 0L);
        return l2 << n3;
    }

    static BigInteger modInverseMontgomery(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        if (bigInteger.sign == 0) {
            throw new ArithmeticException(Messages.getString("math.19"));
        }
        if (!bigInteger2.testBit(0)) {
            return Division.modInverseHars(bigInteger, bigInteger2);
        }
        int n2 = bigInteger2.numberLength * 32;
        BigInteger bigInteger3 = bigInteger2.copy();
        BigInteger bigInteger4 = bigInteger.copy();
        int n3 = Math.max(bigInteger4.numberLength, bigInteger3.numberLength);
        BigInteger bigInteger5 = new BigInteger(1, 1, new int[n3 + 1]);
        BigInteger bigInteger6 = new BigInteger(1, 1, new int[n3 + 1]);
        bigInteger6.digits[0] = 1;
        int n4 = 0;
        int n5 = bigInteger3.getLowestSetBit();
        if (n5 > (n = bigInteger4.getLowestSetBit())) {
            BitLevel.inplaceShiftRight(bigInteger3, n5);
            BitLevel.inplaceShiftRight(bigInteger4, n);
            BitLevel.inplaceShiftLeft(bigInteger5, n);
            n4 += n5 - n;
        } else {
            BitLevel.inplaceShiftRight(bigInteger3, n5);
            BitLevel.inplaceShiftRight(bigInteger4, n);
            BitLevel.inplaceShiftLeft(bigInteger6, n5);
            n4 += n - n5;
        }
        bigInteger5.sign = 1;
        block0: while (bigInteger4.signum() > 0) {
            int n6;
            while (bigInteger3.compareTo(bigInteger4) > 0) {
                Elementary.inplaceSubtract(bigInteger3, bigInteger4);
                n6 = bigInteger3.getLowestSetBit();
                BitLevel.inplaceShiftRight(bigInteger3, n6);
                Elementary.inplaceAdd(bigInteger5, bigInteger6);
                BitLevel.inplaceShiftLeft(bigInteger6, n6);
                n4 += n6;
            }
            while (bigInteger3.compareTo(bigInteger4) <= 0) {
                Elementary.inplaceSubtract(bigInteger4, bigInteger3);
                if (bigInteger4.signum() == 0) continue block0;
                n6 = bigInteger4.getLowestSetBit();
                BitLevel.inplaceShiftRight(bigInteger4, n6);
                Elementary.inplaceAdd(bigInteger6, bigInteger5);
                BitLevel.inplaceShiftLeft(bigInteger5, n6);
                n4 += n6;
            }
        }
        if (!bigInteger3.isOne()) {
            throw new ArithmeticException(Messages.getString("math.19"));
        }
        if (bigInteger5.compareTo(bigInteger2) >= 0) {
            Elementary.inplaceSubtract(bigInteger5, bigInteger2);
        }
        bigInteger5 = bigInteger2.subtract(bigInteger5);
        int n7 = Division.calcN(bigInteger2);
        if (n4 > n2) {
            bigInteger5 = Division.monPro(bigInteger5, BigInteger.ONE, bigInteger2, n7);
            n4 -= n2;
        }
        bigInteger5 = Division.monPro(bigInteger5, BigInteger.getPowerOfTwo(n2 - n4), bigInteger2, n7);
        return bigInteger5;
    }

    private static int calcN(BigInteger bigInteger) {
        long l = (long)bigInteger.digits[0] & 0xFFFFFFFFL;
        long l2 = 1L;
        long l3 = 2L;
        do {
            if ((l * l2 & l3) == 0L) continue;
            l2 |= l3;
        } while ((l3 <<= 1) < 0x100000000L);
        l2 = -l2;
        return (int)(l2 & 0xFFFFFFFFL);
    }

    static BigInteger squareAndMultiply(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, int n) {
        BigInteger bigInteger5 = bigInteger;
        for (int i = bigInteger3.bitLength() - 1; i >= 0; --i) {
            bigInteger5 = Division.monPro(bigInteger5, bigInteger5, bigInteger4, n);
            if (!BitLevel.testBit(bigInteger3, i)) continue;
            bigInteger5 = Division.monPro(bigInteger5, bigInteger2, bigInteger4, n);
        }
        return bigInteger5;
    }

    static BigInteger modInverseHars(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        if (bigInteger.compareTo(bigInteger2) == -1) {
            bigInteger6 = bigInteger2;
            bigInteger5 = bigInteger;
            bigInteger4 = BigInteger.ZERO;
            bigInteger3 = BigInteger.ONE;
        } else {
            bigInteger5 = bigInteger2;
            bigInteger6 = bigInteger;
            bigInteger3 = BigInteger.ZERO;
            bigInteger4 = BigInteger.ONE;
        }
        int n = bigInteger6.bitLength();
        int n2 = bigInteger5.bitLength();
        int n3 = n - n2;
        while (n2 > 1) {
            if (bigInteger6.sign == bigInteger5.sign) {
                bigInteger6 = bigInteger6.subtract(bigInteger5.shiftLeft(n3));
                bigInteger4 = bigInteger4.subtract(bigInteger3.shiftLeft(n3));
            } else {
                bigInteger6 = bigInteger6.add(bigInteger5.shiftLeft(n3));
                bigInteger4 = bigInteger4.add(bigInteger3.shiftLeft(n3));
            }
            if ((n3 = (n = bigInteger6.abs().bitLength()) - (n2 = bigInteger5.abs().bitLength())) >= 0) continue;
            BigInteger bigInteger7 = bigInteger6;
            bigInteger6 = bigInteger5;
            bigInteger5 = bigInteger7;
            bigInteger7 = bigInteger4;
            bigInteger4 = bigInteger3;
            bigInteger3 = bigInteger7;
            n3 = -n3;
            n2 = n;
        }
        if (bigInteger5.sign == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger5.sign < 0) {
            bigInteger3 = bigInteger3.negate();
        }
        if (bigInteger3.compareTo(bigInteger2) == 1) {
            return bigInteger3.subtract(bigInteger2);
        }
        if (bigInteger3.sign < 0) {
            return bigInteger3.add(bigInteger2);
        }
        return bigInteger3;
    }

    static BigInteger slidingWindow(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, int n) {
        int n2;
        BigInteger[] bigIntegerArray = new BigInteger[8];
        BigInteger bigInteger5 = bigInteger;
        bigIntegerArray[0] = bigInteger2;
        BigInteger bigInteger6 = Division.monPro(bigInteger2, bigInteger2, bigInteger4, n);
        for (n2 = 1; n2 <= 7; ++n2) {
            bigIntegerArray[n2] = Division.monPro(bigIntegerArray[n2 - 1], bigInteger6, bigInteger4, n);
        }
        for (n2 = bigInteger3.bitLength() - 1; n2 >= 0; --n2) {
            if (BitLevel.testBit(bigInteger3, n2)) {
                int n3;
                int n4 = 1;
                int n5 = n2;
                for (n3 = Math.max(n2 - 3, 0); n3 <= n2 - 1; ++n3) {
                    if (!BitLevel.testBit(bigInteger3, n3)) continue;
                    if (n3 < n5) {
                        n5 = n3;
                        n4 = n4 << n2 - n3 ^ 1;
                        continue;
                    }
                    n4 ^= 1 << n3 - n5;
                }
                for (n3 = n5; n3 <= n2; ++n3) {
                    bigInteger5 = Division.monPro(bigInteger5, bigInteger5, bigInteger4, n);
                }
                bigInteger5 = Division.monPro(bigIntegerArray[n4 - 1 >> 1], bigInteger5, bigInteger4, n);
                n2 = n5;
                continue;
            }
            bigInteger5 = Division.monPro(bigInteger5, bigInteger5, bigInteger4, n);
        }
        return bigInteger5;
    }

    static BigInteger oddModPow(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        if (!Quad.enableQuadOptimization()) {
            return Division.oddModPow32Bit(bigInteger, bigInteger2, bigInteger3);
        }
        return DivisionLong.oddModPow(bigInteger, bigInteger2, bigInteger3);
    }

    static BigInteger oddModPow32Bit(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n = bigInteger3.numberLength << 5;
        BigInteger bigInteger4 = bigInteger.shiftLeft(n).mod(bigInteger3);
        BigInteger bigInteger5 = BigInteger.getPowerOfTwo(n).mod(bigInteger3);
        int n2 = Division.calcN(bigInteger3);
        BigInteger bigInteger6 = bigInteger3.numberLength == 1 ? Division.squareAndMultiply(bigInteger5, bigInteger4, bigInteger2, bigInteger3, n2) : Division.slidingWindow(bigInteger5, bigInteger4, bigInteger2, bigInteger3, n2);
        return Division.monPro(bigInteger6, BigInteger.ONE, bigInteger3, n2);
    }

    static BigInteger evenModPow(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n = bigInteger3.getLowestSetBit();
        BigInteger bigInteger4 = bigInteger3.shiftRight(n);
        BigInteger bigInteger5 = Division.oddModPow(bigInteger, bigInteger2, bigInteger4);
        BigInteger bigInteger6 = Division.pow2ModPow(bigInteger, bigInteger2, n);
        BigInteger bigInteger7 = Division.modPow2Inverse(bigInteger4, n);
        BigInteger bigInteger8 = bigInteger6.subtract(bigInteger5).multiply(bigInteger7);
        Division.inplaceModPow2(bigInteger8, n);
        if (bigInteger8.sign < 0) {
            bigInteger8 = bigInteger8.add(BigInteger.getPowerOfTwo(n));
        }
        return bigInteger5.add(bigInteger4.multiply(bigInteger8));
    }

    static BigInteger pow2ModPow(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        BigInteger bigInteger3 = BigInteger.ONE;
        BigInteger bigInteger4 = bigInteger2.copy();
        BigInteger bigInteger5 = bigInteger.copy();
        if (bigInteger.testBit(0)) {
            Division.inplaceModPow2(bigInteger4, n - 1);
        }
        Division.inplaceModPow2(bigInteger5, n);
        for (int i = bigInteger4.bitLength() - 1; i >= 0; --i) {
            BigInteger bigInteger6 = bigInteger3.copy();
            Division.inplaceModPow2(bigInteger6, n);
            bigInteger3 = bigInteger3.multiply(bigInteger6);
            if (!BitLevel.testBit(bigInteger4, i)) continue;
            bigInteger3 = bigInteger3.multiply(bigInteger5);
            Division.inplaceModPow2(bigInteger3, n);
        }
        Division.inplaceModPow2(bigInteger3, n);
        return bigInteger3;
    }

    private static void monReduction(int[] nArray, BigInteger bigInteger, int n) {
        int n2;
        int[] nArray2 = bigInteger.digits;
        int n3 = bigInteger.numberLength;
        long l = 0L;
        for (n2 = 0; n2 < n3; ++n2) {
            long l2 = 0L;
            int n4 = (int)Multiplication.unsignedMultAddAdd(nArray[n2], n, 0, 0);
            for (int i = 0; i < n3; ++i) {
                l2 = Multiplication.unsignedMultAddAdd(n4, nArray2[i], nArray[n2 + i], (int)l2);
                nArray[n2 + i] = (int)l2;
                l2 >>>= 32;
            }
            nArray[n2 + n3] = (int)(l += ((long)nArray[n2 + n3] & 0xFFFFFFFFL) + l2);
            l >>>= 32;
        }
        nArray[n3 << 1] = (int)l;
        for (n2 = 0; n2 < n3 + 1; ++n2) {
            nArray[n2] = nArray[n2 + n3];
        }
    }

    static BigInteger monPro(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
        int n2 = bigInteger3.numberLength;
        int[] nArray = new int[(n2 << 1) + 1];
        Multiplication.multArraysPAP(bigInteger.digits, Math.min(n2, bigInteger.numberLength), bigInteger2.digits, Math.min(n2, bigInteger2.numberLength), nArray);
        Division.monReduction(nArray, bigInteger3, n);
        return Division.finalSubtraction(nArray, bigInteger3);
    }

    static BigInteger finalSubtraction(int[] nArray, BigInteger bigInteger) {
        Object object;
        boolean bl;
        int n = bigInteger.numberLength;
        boolean bl2 = bl = nArray[n] != 0;
        if (!bl) {
            object = bigInteger.digits;
            bl = true;
            for (int i = n - 1; i >= 0; --i) {
                if (nArray[i] == object[i]) continue;
                bl = nArray[i] != 0 && ((long)nArray[i] & 0xFFFFFFFFL) > ((long)object[i] & 0xFFFFFFFFL);
                break;
            }
        }
        object = new BigInteger(1, n + 1, nArray);
        if (bl) {
            Elementary.inplaceSubtract((BigInteger)object, bigInteger);
        }
        ((BigInteger)object).cutOffLeadingZeroes();
        return object;
    }

    static BigInteger modPow2Inverse(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = new BigInteger(1, new int[1 << n]);
        bigInteger2.numberLength = 1;
        bigInteger2.digits[0] = 1;
        bigInteger2.sign = 1;
        for (int i = 1; i < n; ++i) {
            if (!BitLevel.testBit(bigInteger.multiply(bigInteger2), i)) continue;
            int n2 = i >> 5;
            bigInteger2.digits[n2] = bigInteger2.digits[n2] | 1 << (i & 0x1F);
        }
        return bigInteger2;
    }

    static void inplaceModPow2(BigInteger bigInteger, int n) {
        int n2 = n >> 5;
        if (bigInteger.numberLength < n2 || bigInteger.bitLength() <= n) {
            return;
        }
        int n3 = 32 - (n & 0x1F);
        bigInteger.numberLength = n2 + 1;
        int n4 = n2;
        bigInteger.digits[n4] = bigInteger.digits[n4] & (n3 < 32 ? -1 >>> n3 : 0);
        bigInteger.cutOffLeadingZeroes();
    }
}

