/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sequence.bytes;

import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory$ArrayByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory$ConstantByteSequence;

public final class ByteSequenceFactory {
    private static final char ZERO_PAD = '0';
    private static final int HEXADECIMAL_LENGTH = 2;
    private static final int OCTAL_LENGTH = 3;
    private static final int BINARY_LENGTH = 8;

    private ByteSequenceFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static ByteSequence newByteSequence(byte[] byArray) throws NullPointerException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        return new ByteSequenceFactory$ArrayByteSequence(byArray);
    }

    public static ByteSequence newConstantByteSequence(byte by, int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        return new ByteSequenceFactory$ConstantByteSequence(by, n);
    }
}

