/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BadRecordFlagException;
import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.DatabaseHashGeneratorFactory;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderHashGeneratorFactory;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.QueryableKeyDatabase;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordDataHashGeneratorFactory;
import com.ibm.security.cmskeystore.RecordFlag;
import com.ibm.security.sequence.Sequence;
import com.ibm.security.sequence.SequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;

final class QueryableKeyDatabaseFactory$QueryableKeyDatabaseImpl
implements QueryableKeyDatabase {
    private KeyDatabase keydatabase;
    private int nextRecordID;

    private static ByteSequence char2UTF8ByteSequence(char[] cArray) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        byte[] byArray = new byte[byteBuffer.limit()];
        System.arraycopy(byteBuffer.array(), 0, byArray, 0, byteBuffer.limit());
        return ByteSequenceFactory.newByteSequence(byArray);
    }

    QueryableKeyDatabaseFactory$QueryableKeyDatabaseImpl(KeyDatabase keyDatabase) {
        if (keyDatabase == null) {
            throw new NullPointerException();
        }
        this.keydatabase = keyDatabase;
    }

    public Record getRecordByLabel(String string) {
        ByteSequence byteSequence;
        try {
            byteSequence = ByteSequenceFactory.newByteSequence(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        for (Record record : this.keydatabase.getRecords()) {
            if (record.getRecordFlag() == RecordFlag.DELETED || !record.getLabel().getContent().equals(byteSequence)) continue;
            return record;
        }
        return null;
    }

    public Record getRecordByPublicKeyInfo(Certificate certificate) {
        Buffer buffer;
        try {
            buffer = RecordDataHashGeneratorFactory.newRecordDataHashGenerator().generateSubjectPublicKeyInfoHash((X509Certificate)certificate);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        for (Record record : this.keydatabase.getRecords()) {
            if (record.getRecordFlag() == RecordFlag.DELETED || !record.getSubjectPublicKeyInfoHash().equals(buffer)) continue;
            return record;
        }
        return null;
    }

    public Record getRecordByCert(Certificate certificate) {
        Buffer buffer;
        try {
            buffer = RecordDataHashGeneratorFactory.newRecordDataHashGenerator().generateCertificateSignatureHash((X509Certificate)certificate);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        for (Record record : this.keydatabase.getRecords()) {
            if (record.getRecordFlag() == RecordFlag.DELETED || !record.getSignatureHash().equals(buffer)) continue;
            return record;
        }
        return null;
    }

    public Record getIssuerRecord(Record record) {
        Buffer buffer;
        try {
            X509Certificate x509Certificate = (X509Certificate)record.getEncoding().getCertificate();
            Object object = new X500Name(x509Certificate.getIssuerDN().getName());
            buffer = RecordDataHashGeneratorFactory.newRecordDataHashGenerator().generateHash(ByteSequenceFactory.newByteSequence(object.getEncoded()));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        for (Object object : this.keydatabase.getRecords()) {
            if (object.getRecordFlag() == RecordFlag.DELETED || !object.getSubjectNameHash().equals(buffer)) continue;
            return object;
        }
        return null;
    }

    public boolean checkKeyStoreIntegrity(char[] cArray) {
        ByteSequence byteSequence;
        if (cArray == null) {
            throw new NullPointerException();
        }
        try {
            byteSequence = DatabaseHashGeneratorFactory.newDatabaseHashGenerator(this.keydatabase.getHeader()).generateHash(this.keydatabase, new String(cArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        ByteSequence byteSequence2 = this.keydatabase.getHeader().getPasswordDatabaseHash();
        return byteSequence2.equals(byteSequence);
    }

    public FileHeader getHeader() {
        return this.keydatabase.getHeader();
    }

    public Sequence getRecords() {
        return this.keydatabase.getRecords();
    }

    public byte get(int n) throws IndexOutOfBoundsException {
        return this.keydatabase.get(n);
    }

    public int length() {
        return this.keydatabase.length();
    }

    public ByteSequence append(ByteSequence byteSequence) throws NullPointerException {
        return this.keydatabase.append(byteSequence);
    }

    public ByteSequence getSubSequence(int n, int n2) throws IndexOutOfBoundsException {
        return this.keydatabase.getSubSequence(n, n2);
    }

    public int indexOf(byte by) {
        return this.keydatabase.indexOf(by);
    }

    public int indexOf(int n, byte by) throws IndexOutOfBoundsException {
        return this.keydatabase.indexOf(n, by);
    }

    public int lastIndexOf(byte by) {
        return this.keydatabase.lastIndexOf(by);
    }

    public int lastIndexOf(int n, byte by) throws IndexOutOfBoundsException {
        return this.keydatabase.lastIndexOf(n, by);
    }

    public boolean isEmpty() {
        return this.keydatabase.isEmpty();
    }

    public InputStream getInputStream() {
        return this.keydatabase.getInputStream();
    }

    public ByteSequenceIterator getIterator() {
        return this.keydatabase.getIterator();
    }

    public ByteSequenceIterator getIterator(int n) throws IndexOutOfBoundsException {
        return this.keydatabase.getIterator(n);
    }

    public String toBinaryString() {
        return this.keydatabase.toBinaryString();
    }

    public String toOctalString() {
        return this.keydatabase.toOctalString();
    }

    public String toHexString() {
        return this.keydatabase.toHexString();
    }

    public int getNextRecordID() {
        return this.nextRecordID++;
    }

    private void setNextRecordID() {
        int n = this.keydatabase.getRecords().length();
        if (n > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            for (Record record : this.keydatabase.getRecords()) {
                arrayList.add(record.getRecordId().toInt());
            }
            this.nextRecordID = (Integer)Collections.max(arrayList) + 1;
        } else {
            this.nextRecordID = 1;
        }
    }

    public boolean checkPassword(char[] cArray) throws NullPointerException, NoSuchAlgorithmException, UnsupportedEncodingException {
        if (cArray == null) {
            throw new NullPointerException();
        }
        ByteSequence byteSequence = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(this.keydatabase.getHeader()).generateHash(this.keydatabase.getHeader(), new String(cArray));
        ByteSequence byteSequence2 = this.keydatabase.getHeader().getPasswordHeaderHash();
        return byteSequence.equals(byteSequence2);
    }

    public Sequence getKeyRecords() {
        ArrayList<Record> arrayList = new ArrayList<Record>();
        for (Record record : this.keydatabase.getRecords()) {
            if (record.getRecordFlag() == RecordFlag.DELETED || !record.getEncoding().isPrivateKeyPresent()) continue;
            arrayList.add(record);
        }
        return SequenceFactory.newSequence(arrayList);
    }

    public boolean equals(Object object) {
        return this.keydatabase.equals(object);
    }

    public int hashCode() {
        return this.keydatabase.hashCode();
    }

    public String toString() {
        return this.keydatabase.toString();
    }

    public void decodeRawRecords() throws BadRecordFlagException, NullPointerException, IllegalArgumentException, IndexOutOfBoundsException, IOException {
        this.keydatabase.decodeRawRecords();
        this.setNextRecordID();
    }
}

