/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.InputStream;

final class IntableByteSequenceFactory$IntableByteSequenceImpl
implements IntableByteSequence {
    private final ByteSequence sequence;
    private int value;
    private boolean valueCalculated;

    IntableByteSequenceFactory$IntableByteSequenceImpl(ByteSequence byteSequence) {
        this.sequence = byteSequence;
    }

    public int toInt() {
        if (!this.valueCalculated) {
            ByteSequenceIterator byteSequenceIterator = this.sequence.getIterator();
            while (byteSequenceIterator.hasNextByte()) {
                int n = byteSequenceIterator.getNextByte();
                if (n < 0) {
                    n += 256;
                }
                this.value <<= 8;
                this.value |= n;
            }
            this.valueCalculated = true;
        }
        return this.value;
    }

    public byte get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.sequence.get(n);
    }

    public int length() {
        return this.sequence.length();
    }

    public ByteSequence append(ByteSequence byteSequence) throws NullPointerException {
        if (byteSequence == null) {
            throw new NullPointerException();
        }
        return this.sequence.append(byteSequence);
    }

    public ByteSequence getSubSequence(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 > this.sequence.length() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.sequence.getSubSequence(n, n2);
    }

    public int indexOf(byte by) {
        return this.sequence.indexOf(by);
    }

    public int indexOf(int n, byte by) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.sequence.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.sequence.indexOf(n, by);
    }

    public int lastIndexOf(byte by) {
        return this.sequence.lastIndexOf(by);
    }

    public int lastIndexOf(int n, byte by) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.sequence.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.sequence.lastIndexOf(n, by);
    }

    public boolean isEmpty() {
        return this.sequence.isEmpty();
    }

    public InputStream getInputStream() {
        return this.sequence.getInputStream();
    }

    public ByteSequenceIterator getIterator() {
        return this.sequence.getIterator();
    }

    public ByteSequenceIterator getIterator(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.sequence.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.sequence.getIterator(n);
    }

    public String toBinaryString() {
        return this.sequence.toBinaryString();
    }

    public String toOctalString() {
        return this.sequence.toOctalString();
    }

    public String toHexString() {
        return this.sequence.toHexString();
    }

    public String toString() {
        return this.sequence.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ByteSequence)) {
            return false;
        }
        ByteSequence byteSequence = (ByteSequence)object;
        if (this.sequence.length() != byteSequence.length()) {
            return false;
        }
        ByteSequenceIterator byteSequenceIterator = this.getIterator();
        ByteSequenceIterator byteSequenceIterator2 = byteSequence.getIterator();
        while (byteSequenceIterator.hasNextByte() && byteSequenceIterator2.hasNextByte()) {
            byte by;
            byte by2 = byteSequenceIterator.getNextByte();
            if (by2 == (by = byteSequenceIterator2.getNextByte())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.sequence.hashCode();
    }
}

