/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.tools;

import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.shared.custom_gui.ui_builder.tools.ToolType;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ToolItem
extends JLabel {
    private ToolType mToolType;

    public ToolItem(ToolType toolType) {
        this.mToolType = toolType;
        this.setFont(new Font("SansSerif", 0, 12));
        String string = this.getBaseId();
        this.setText(BuilderResUtil.getString(string));
        this.setToolTipText(BuilderResUtil.getString(string + "_TIP"));
        this.setIcon(new ImageIcon(BuilderResUtil.getImageResource(this.getToolIconFileName())));
    }

    public ToolType getToolType() {
        return this.mToolType;
    }

    private String getBaseId() {
        if (this.mToolType == ToolType.CHECKBOX_CONTROL) {
            return "IDS_CHECKBOX_TOOL";
        }
        if (this.mToolType == ToolType.CHECKBOX_GROUP_CONTROL) {
            return "IDS_CHECKBOX_GROUP_TOOL";
        }
        if (this.mToolType == ToolType.FIELD_CHOOSER_CONTROL) {
            return "IDS_FIELD_CHOOSER_TOOL";
        }
        if (this.mToolType == ToolType.COMBO_BOX_CONTROL) {
            return "IDS_COMBOBOX_TOOL";
        }
        if (this.mToolType == ToolType.DIALOG_TAB_CONTROL) {
            return "IDS_DLG_TAB_TOOL";
        }
        if (this.mToolType == ToolType.EDIT_TEXT_CONTROL) {
            return "IDS_EDIT_TEXT_TOOL";
        }
        if (this.mToolType == ToolType.NUMBER_EDIT_CONTROL) {
            return "IDS_NUMBER_EDIT_TOOL";
        }
        if (this.mToolType == ToolType.SPINNER_CONTROL) {
            return "IDS_SPINNER_TOOL";
        }
        if (this.mToolType == ToolType.PASSWORD_CONTROL) {
            return "IDS_PASSWORD_TOOL";
        }
        if (this.mToolType == ToolType.COLOR_PICKER_CONTROL) {
            return "IDS_COLOR_PICKER_TOOL";
        }
        if (this.mToolType == ToolType.TABLE_CONTROL) {
            return "IDS_TABLE_TOOL";
        }
        if (this.mToolType == ToolType.STATIC_IMAGE) {
            return "IDS_STATIC_IMAGE_TOOL";
        }
        if (this.mToolType == ToolType.LISTBOX_CONTROL) {
            return "IDS_LISTBOX_TOOL";
        }
        if (this.mToolType == ToolType.RADIO_GROUP) {
            return "IDS_RADIO_GROUP_TOOL";
        }
        if (this.mToolType == ToolType.SOURCE_VAR_LIST) {
            return "IDS_SRC_LIST_TOOL";
        }
        if (this.mToolType == ToolType.STATIC_TEXT_CONTROL) {
            return "IDS_STATIC_TEXT_TOOL";
        }
        if (this.mToolType == ToolType.SUB_DIALOG_BUTTON) {
            return "IDS_SUB_DLG_TOOL";
        }
        if (this.mToolType == ToolType.TARGET_VAR_LIST) {
            return "IDS_TARGET_LIST_TOOL";
        }
        if (this.mToolType == ToolType.FILE_SYSTEM_BROWSER) {
            return "IDS_FILE_SYSTEM_BROWSER_TOOL";
        }
        if (this.mToolType == ToolType.ITEM_GROUP_CONTROL) {
            return "IDS_ITEM_GROUP_TOOL";
        }
        if (this.mToolType == ToolType.DATASET_SELECTOR) {
            return "IDS_DATASET_SELECTOR_TOOL";
        }
        assert (false);
        return null;
    }

    private String getToolIconFileName() {
        if (this.mToolType == ToolType.CHECKBOX_CONTROL) {
            return "check_box.png";
        }
        if (this.mToolType == ToolType.CHECKBOX_GROUP_CONTROL) {
            return "checkbox_group.png";
        }
        if (this.mToolType == ToolType.FIELD_CHOOSER_CONTROL) {
            return "combo_box.png";
        }
        if (this.mToolType == ToolType.COMBO_BOX_CONTROL) {
            return "combo_box.png";
        }
        if (this.mToolType == ToolType.DIALOG_TAB_CONTROL) {
            return "tab_ctrl.png";
        }
        if (this.mToolType == ToolType.EDIT_TEXT_CONTROL) {
            return "edit_ctrl.png";
        }
        if (this.mToolType == ToolType.NUMBER_EDIT_CONTROL) {
            return "number_edit_ctrl.png";
        }
        if (this.mToolType == ToolType.SPINNER_CONTROL) {
            return "spinner_tool.png";
        }
        if (this.mToolType == ToolType.TABLE_CONTROL) {
            return "table_tool.png";
        }
        if (this.mToolType == ToolType.COLOR_PICKER_CONTROL) {
            return "colorpicker_tool.png";
        }
        if (this.mToolType == ToolType.PASSWORD_CONTROL) {
            return "password_tool.png";
        }
        if (this.mToolType == ToolType.STATIC_IMAGE) {
            return "image.png";
        }
        if (this.mToolType == ToolType.LISTBOX_CONTROL) {
            return "list_box.png";
        }
        if (this.mToolType == ToolType.RADIO_GROUP) {
            return "radio_group.png";
        }
        if (this.mToolType == ToolType.SOURCE_VAR_LIST) {
            return "src_list.png";
        }
        if (this.mToolType == ToolType.STATIC_TEXT_CONTROL) {
            return "static_text.png";
        }
        if (this.mToolType == ToolType.SUB_DIALOG_BUTTON) {
            return "dlg_button.png";
        }
        if (this.mToolType == ToolType.TARGET_VAR_LIST) {
            return "target_list.png";
        }
        if (this.mToolType == ToolType.FILE_SYSTEM_BROWSER) {
            return "file_browser.png";
        }
        if (this.mToolType == ToolType.ITEM_GROUP_CONTROL) {
            return "item_group.png";
        }
        if (this.mToolType == ToolType.DATASET_SELECTOR) {
            return "dataset_selector_tool.png";
        }
        assert (false);
        return null;
    }
}

