/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.pyspark;

import com.pasw.framework.common.core.CFEnum;
import com.pasw.framework.common.core.EnumerationValueDescriptor;
import com.pasw.framework.ui.swing.SwingResourceProvider;
import java.awt.Dimension;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class UIUtilities {
    public static JButton createButton(SwingResourceProvider swingResourceProvider, String string) {
        JButton jButton = new JButton();
        jButton.setFocusable(true);
        jButton.setText(swingResourceProvider.getLabel(string));
        jButton.setActionCommand(string);
        UIUtilities.addAccessKey(jButton, swingResourceProvider, string);
        UIUtilities.addTooltip(jButton, swingResourceProvider, string);
        return (JButton)UIUtilities.addDescription(jButton, swingResourceProvider, string);
    }

    public static JComboBox createComBox(SwingResourceProvider swingResourceProvider, String string, int n, DefaultComboBoxModel defaultComboBoxModel) {
        JComboBox jComboBox = new JComboBox(defaultComboBoxModel);
        jComboBox.setSize(n, 5);
        jComboBox = (JComboBox)UIUtilities.addTooltip(jComboBox, swingResourceProvider, string);
        jComboBox = (JComboBox)UIUtilities.addDescription(jComboBox, swingResourceProvider, string);
        return jComboBox;
    }

    public static DefaultComboBoxModel createEnumComboBoxModel(EnumerationValueDescriptor enumerationValueDescriptor) {
        DefaultComboBoxModel<CFEnum> defaultComboBoxModel = new DefaultComboBoxModel<CFEnum>();
        List list = enumerationValueDescriptor.getEnumValues();
        for (CFEnum cFEnum : list) {
            defaultComboBoxModel.addElement(cFEnum);
        }
        return defaultComboBoxModel;
    }

    public static AbstractButton addAccessKey(AbstractButton abstractButton, SwingResourceProvider swingResourceProvider, String string) {
        Integer n = swingResourceProvider.getAccessKey(string);
        if (n != null) {
            abstractButton.setMnemonic(n);
        }
        return abstractButton;
    }

    public static JTextComponent createTextFiled(SwingResourceProvider swingResourceProvider, String string, int n) {
        JTextComponent jTextComponent = new JTextField(n);
        jTextComponent = (JTextComponent)UIUtilities.addTooltip(jTextComponent, swingResourceProvider, string);
        jTextComponent = (JTextComponent)UIUtilities.addDescription(jTextComponent, swingResourceProvider, string);
        return jTextComponent;
    }

    public static JComponent addTooltip(JComponent jComponent, SwingResourceProvider swingResourceProvider, String string) {
        String string2 = swingResourceProvider.getTooltip(string);
        if (string2 != null) {
            jComponent.setToolTipText(string2);
        }
        return jComponent;
    }

    public static JComponent addDescription(JComponent jComponent, SwingResourceProvider swingResourceProvider, String string) {
        String string2 = swingResourceProvider.getDescription(string);
        if (string2 != null) {
            jComponent.getAccessibleContext().setAccessibleName(string2);
        }
        return jComponent;
    }

    public static void fitAllComponents(JComponent ... jComponentArray) {
        UIUtilities.setPreferSizeOfAllComponents(UIUtilities.getMaxPreferSizeOfAllComponents(jComponentArray), jComponentArray);
        UIUtilities.setMaxSizeOfAllComponents(UIUtilities.getMaxMaxSizeOfAllComponents(jComponentArray), jComponentArray);
        UIUtilities.setMinSizeOfAllComponents(UIUtilities.getMaxMinSizeOfAllComponents(jComponentArray), jComponentArray);
    }

    public static Dimension getMaxPreferSizeOfAllComponents(JComponent ... jComponentArray) {
        int n = 0;
        int n2 = 0;
        for (JComponent jComponent : jComponentArray) {
            Dimension dimension = jComponent.getPreferredSize();
            if ((double)n < dimension.getWidth()) {
                n = (int)dimension.getWidth();
            }
            if (!((double)n2 < dimension.getHeight())) continue;
            n2 = (int)dimension.getHeight();
        }
        return new Dimension(n, n2);
    }

    public static void setPreferSizeOfAllComponents(Dimension dimension, JComponent ... jComponentArray) {
        for (JComponent jComponent : jComponentArray) {
            jComponent.setPreferredSize(dimension);
        }
    }

    public static Dimension getMaxMaxSizeOfAllComponents(JComponent ... jComponentArray) {
        int n = 0;
        int n2 = 0;
        for (JComponent jComponent : jComponentArray) {
            Dimension dimension = jComponent.getMaximumSize();
            if ((double)n < dimension.getWidth()) {
                n = (int)dimension.getWidth();
            }
            if (!((double)n2 < dimension.getHeight())) continue;
            n2 = (int)dimension.getHeight();
        }
        return new Dimension(n, n2);
    }

    public static void setMaxSizeOfAllComponents(Dimension dimension, JComponent ... jComponentArray) {
        for (JComponent jComponent : jComponentArray) {
            jComponent.setMaximumSize(dimension);
        }
    }

    public static Dimension getMaxMinSizeOfAllComponents(JComponent ... jComponentArray) {
        int n = 0;
        int n2 = 0;
        for (JComponent jComponent : jComponentArray) {
            Dimension dimension = jComponent.getMinimumSize();
            if ((double)n < dimension.getWidth()) {
                n = (int)dimension.getWidth();
            }
            if (!((double)n2 < dimension.getHeight())) continue;
            n2 = (int)dimension.getHeight();
        }
        return new Dimension(n, n2);
    }

    public static void setMinSizeOfAllComponents(Dimension dimension, JComponent ... jComponentArray) {
        for (JComponent jComponent : jComponentArray) {
            jComponent.setMinimumSize(dimension);
        }
    }
}

