/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.pyspark;

import com.pasw.framework.common.container.Container;
import com.pasw.framework.common.core.Properties;
import com.pasw.framework.common.extension.interaction.InteractorEvent;
import com.pasw.framework.common.extension.spi.InteractorListener;
import com.pasw.framework.ui.swing.ManagedPanelContext;
import com.pasw.framework.ui.swing.spi.ManagedPanel;
import com.pasw.framework.ui.swing.spi.ManagedUIElement;
import com.spss.shared.custom_gui.ui_builder.pyspark.Copyright;
import com.spss.shared.custom_gui.ui_builder.pyspark.ManagedTextOutputArea;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComponent;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM SPSS Products: Modeler Common\r\n\r\n\u00a9 Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP\r\nSchedule Contract with IBM Corp.\r\n\r\n")
public class ManagedModelOutputPanel
implements ManagedPanel,
InteractorListener {
    public static final String OUT_CONSOLE_OUTPUT_ELEMENT_ID = "outConsoleOutputDisplay";
    public static final String ERR_CONSOLE_OUTPUT_ELEMENT_ID = "errConsoleOutputDisplay";
    public static final String OUT_CONSOLE_CONTAINER_NAME = "out";
    public static final String ERR_CONSOLE_CONTAINER_NAME = "err";
    private ManagedTextOutputArea consoleOutput;
    private HashMap<String, JComponent> componentMap = new HashMap();
    private ManagedPanelContext managedPanelContext = null;

    public void initManagedPanel(String string, Properties properties, ManagedPanelContext managedPanelContext) {
        this.managedPanelContext = managedPanelContext;
    }

    public ManagedUIElement createManagedUIElement(String string) {
        ManagedUIElement managedUIElement = null;
        if (OUT_CONSOLE_OUTPUT_ELEMENT_ID.equals(string) || ERR_CONSOLE_OUTPUT_ELEMENT_ID.equals(string)) {
            managedUIElement = this.setupConsoleOutputControl(string);
        }
        return managedUIElement;
    }

    public void disposeManagedPanel() {
        this.componentMap.clear();
    }

    public void onInteractorEvent(InteractorEvent interactorEvent) {
    }

    private ManagedUIElement setupConsoleOutputControl(String string) {
        this.consoleOutput = new ManagedTextOutputArea();
        this.consoleOutput.setVisible(true);
        String string2 = null;
        if (OUT_CONSOLE_OUTPUT_ELEMENT_ID.equals(string)) {
            this.consoleOutput.setName(OUT_CONSOLE_OUTPUT_ELEMENT_ID);
            this.componentMap.put(this.consoleOutput.getName(), this.consoleOutput);
            string2 = this.getTextContainerData(OUT_CONSOLE_CONTAINER_NAME);
        } else if (ERR_CONSOLE_OUTPUT_ELEMENT_ID.equals(string)) {
            this.consoleOutput.setName(ERR_CONSOLE_OUTPUT_ELEMENT_ID);
            this.componentMap.put(this.consoleOutput.getName(), this.consoleOutput);
            string2 = this.getTextContainerData(ERR_CONSOLE_CONTAINER_NAME);
        }
        if (string2 != null) {
            this.consoleOutput.setData(string2);
            this.consoleOutput.setCaretPosition(0);
        } else {
            this.consoleOutput.setVisible(false);
        }
        return this.consoleOutput;
    }

    public void updateConsoleOutputControl(String string) {
        String string2 = this.getTextContainerData(string);
        if (string2 != null) {
            this.consoleOutput.setData(string2);
            this.consoleOutput.setCaretPosition(0);
            this.consoleOutput.setVisible(true);
        } else {
            this.consoleOutput.setVisible(false);
        }
    }

    public String getTextContainerData(String string) {
        String string2 = null;
        Container container = this.managedPanelContext.getExtensionObjectUI().getExtensionObject().getContainer(string);
        if (container != null && !container.isEmpty()) {
            try {
                int n;
                InputStream inputStream = container.getContentFromInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[4096];
                while ((n = inputStreamReader.read(cArray)) != -1) {
                    stringBuffer.append(new String(cArray, 0, n));
                }
                ((Reader)inputStreamReader).close();
                string2 = stringBuffer.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZip(String string, String string2, boolean bl) throws IOException {
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        try {
            while (enumeration.hasMoreElements()) {
                Object object;
                Object object2;
                Object object3;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                ArrayList<File> arrayList = new ArrayList<File>();
                for (object3 = new File(zipEntry.getName()); object3 != null; object3 = ((File)object3).getParentFile()) {
                    arrayList.add((File)object3);
                    if (!bl) continue;
                    ((File)object3).deleteOnExit();
                }
                Collections.reverse(arrayList);
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object2 = (File)object3.next();
                    if (!object3.hasNext()) break;
                    object = new File(string2 + ((File)object2).getPath());
                    if (bl) {
                        ((File)object).deleteOnExit();
                    }
                    ((File)object).mkdir();
                }
                object3 = new byte[1024];
                object2 = zipFile.getInputStream(zipEntry);
                object = new FileOutputStream(string2 + zipEntry.getName());
                File file = new File(string2 + zipEntry.getName());
                if (bl) {
                    file.deleteOnExit();
                }
                int n = ((InputStream)object2).read((byte[])object3);
                while (n >= 0) {
                    ((OutputStream)object).write((byte[])object3, 0, n);
                    n = ((InputStream)object2).read((byte[])object3);
                }
                ((InputStream)object2).close();
                ((OutputStream)object).close();
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

