/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.pyspark;

import com.pasw.framework.common.data.Field;
import com.pasw.framework.common.data.Geo;
import com.pasw.framework.common.data.GeometryType;
import com.pasw.framework.common.data.MeasurementType;
import com.pasw.framework.common.data.MissingValueDescriptor;
import com.pasw.framework.common.data.ModelOutputDescriptor;
import com.pasw.framework.common.data.ModelOutputRole;
import com.pasw.framework.common.data.RoleType;
import com.pasw.framework.common.data.RuleFeatureType;
import com.pasw.framework.common.data.StorageType;
import com.pasw.framework.common.data.StructureType;
import com.pasw.framework.common.data.format.FieldFormat;
import com.pasw.framework.common.data.format.FieldFormats;
import com.pasw.framework.common.data.format.FormattedField;
import com.pasw.framework.common.data.format.TimeFieldFormat;
import com.pasw.framework.common.extension.data.GeoBase;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFDataModel;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFDateFieldFormat;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFDecoratedFieldFormat;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFExtendableAdaptor;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFField;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFFieldFormats;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFFormattedField;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFFormattedFieldFormat;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFNumberFieldFormat;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFStringFieldFormat;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFTimeFieldFormat;
import com.spss.shared.custom_gui.ui_builder.pyspark.CFXMLFormatConstants;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CFDataModelParser {
    private static final String kXML_NUMBERFORMAT_ELMT = "NumberFormat";
    private static final String kXML_DECORATEDFORMAT_ELMT = "DecoratedFormat";
    private static final String kXML_STRINGFORMAT_ELMT = "StringFormat";
    private static final String kXML_TIMEFORMAT_ELMT = "TimeFormat";
    private static final String kXML_DATEFORMAT_ELMT = "DateFormat";
    private static final String kXML_GEO_ELEMT = "Geo";
    private static final String kXML_GEO_HEADER_ELEMT = "GeoHeader";
    private static final String kXML_FIELDGROUPS_ELMT = "FieldGroups";
    private static final String kXML_FIELDS_ELMT = "Fields";
    private static final String kXML_VALUE_LABELS_ELMT = "ValueLabels";
    private static final String kXML_VALUES_ELMT = "Values";
    private static final String kXML_FIELDFORMATS_ELEMT = "FieldFormats";
    private static final String kXML_FIELDFORMAT_ELEMT = "FieldFormat";
    private static final String kXML_MODELFIELD_ELMT = "ModelField";
    private static final String kXML_MISSING_VALUES_ELMT = "MissingValues";
    private static final String kXML_RANGE_ELMT = "Range";
    private static final String kXML_TREAT_NULL_AS_MISSING_ATTR = "treatNullAsMissing";
    private static final String kXML_TREAT_WHITESPACE_AS_MISSING_ATTR = "treatWhitespaceAsMissing";
    private static final String kXML_MAX_VALUE_ATTR = "maxValue";
    private static final String kXML_MIN_VALUE_ATTR = "minValue";
    private static final String kXML_DISPLAYLABEL_ATTR = "displayLabel";
    private static final String kXML_NAME_ATTR = "name";
    private static final String kXML_ROLE_ATTR = "role";
    private static final String kXML_STORAGE_ATTR = "storage";
    private static final String kXML_STRUCTURE_ATTR = "structure";
    private static final String kXML_ELEMENT_COUNT_ATTR = "elementCount";
    private static final String kXML_DEPTH_ATTR = "depth";
    private static final String kXML_MEASURE_ATTR = "measure";
    private static final String kXML_GEO_TYPE_ATTR = "type";
    private static final String kXML_COORDINATES_ATTR = "coordinates";
    private static final String kXML_WKID_ATTR = "wkid";
    private static final String kXML_CSNAME_ATTR = "csname";
    private static final String kXML_IS_PROJECTED_ATTR = "isProjected";
    private static final String kXML_WKT_ATTR = "wkt";
    private static final String kXML_GEO_HEADER_ATTR = "header";
    private static final String kXML_VALUE_ATTR = "value";
    private static final String kXML_USENAMEDFORMAT_ATTR = "useNamedFormat";
    private static final String kXML_MODEL_FIELD_TARGET_ATTR = "targetField";
    private static final String kXML_MODEL_FIELD_ROLE_ATTR = "role";
    private static final String kXML_MODEL_FIELD_VALUE = "value";
    private static final String kXML_MODEL_FIELD_GROUPID = "group";
    private static final String kXML_MODEL_FIELD_TAG = "tag";
    private static final String kXML_RULE_TAG_ATTR = "ruleFeature";
    private static final String kXML_BOTH_VAL = "both";
    private static final String kXML_INPUT_VAL = "input";
    private static final String kXML_TARGET_VAL = "target";
    private static final String kXML_SPLIT_VAL = "split";
    private static final String kXML_NONE_VAL = "none";
    private static final String kXML_FREQWEIGHT_VAL = "freqWeight";
    private static final String kXML_PARTITION_VAL = "partition";
    private static final String kXML_RECORDID_VAL = "recordId";
    private static final String kXML_ANTECEDENT = "antecedent";
    private static final String kXML_CONSEQUENT = "consequent";
    private static final String kXML_RULE = "rule";
    private static final String kXML_RULEID = "ruleId";
    private static final String kXML_RULE_FEATURE_CONFIDENCE = "confidence";
    private static final String kXML_SUPPORT = "support";
    private static final String kXML_LIFT = "lift";
    private static final String kXML_UNKNOWN = "unknown";
    private static final String kXML_PRED_VAL = "predictedValue";
    private static final String kXML_PROBABILITY = "probability";
    private static final String kXML_CONFIDENCE = "confidence";
    private static final String kXML_RESIDUAL = "residual";
    private static final String kXML_STD_ERROR = "standardError";
    private static final String kXML_CLUSTER_ID = "clusterId";
    private static final String kXML_CLUSTER_AFFINITY = "clusterAffinity";
    private static final String kXML_ENTITY_ID = "entityId";
    private static final String kXML_ENTITNY_AFFINITY = "entityAffinity";
    private static final String kXML_UPPER_CONF = "upperConfidenceLimit";
    private static final String kXML_LOWER_CONF = "lowerConfidenceLimit";
    private static final String kXML_PROPENSITY = "propensity";
    private static final String kXML_RECORD_ID = "recordId";
    private static final String kXML_CUM_HAZARD = "cumulativeHazard";
    private static final String kXML_WARNING = "warning";
    private static final String kXML_RULE_VALUE = "ruleValue";
    private static final String kXML_ENTENDED = "extended";
    private static final String kXML_STRING_VAL = "string";
    private static final String kXML_REAL_VAL = "real";
    private static final String kXML_INTERGER_VAL = "integer";
    private static final String kXML_DATE_VAL = "date";
    private static final String kXML_UNKNOWN_VAL = "unknown";
    private static final String kXML_TIME_VAL = "time";
    private static final String kXML_TIMESTAMP_VAL = "timestamp";
    private static final String kXML_LIST_VAL = "list";
    private static final String kXML_NOMINAL_VAL = "nominal";
    private static final String kXML_CONTINUOUS_VAL = "continuous";
    private static final String kXML_ORDINAL_VAL = "ordinal";
    private static final String kXML_FLAG_VAL = "flag";
    private static final String kXML_DISCRETE_VAL = "discrete";
    private static final String kXML_TYPELESS_VAL = "typeless";

    CFDataModelParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parseDataModelXml(CFDataModel cFDataModel, String string) {
        Vector<Field> vector = new Vector<Field>();
        FieldFormats fieldFormats = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node == null || node.getNodeType() != 1) continue;
                if (node.getNodeName().equals(kXML_FIELDS_ELMT)) {
                    NodeList nodeList2 = node.getChildNodes();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Node node2 = nodeList2.item(j);
                        if (node2 == null || node2.getNodeType() != 1) continue;
                        CFDataModelParser.parseField(node2, vector);
                    }
                    continue;
                }
                if (node.getNodeName().equals(kXML_FIELDGROUPS_ELMT) || fieldFormats != null || !node.getNodeName().equals(kXML_FIELDFORMATS_ELEMT)) continue;
                fieldFormats = CFDataModelParser.parseSharedFieldFormat(node);
            }
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            cFDataModel.setFields(vector);
            cFDataModel.setToolFieldFormats(fieldFormats);
        }
        return true;
    }

    private static void parseField(Node node, Vector<Field> vector) {
        String string;
        Object object;
        TreeMap<Object, String> treeMap;
        int n;
        String string2;
        String string3 = node.getAttributes().getNamedItem(kXML_NAME_ATTR).getNodeValue();
        String string4 = "";
        Node node2 = node.getAttributes().getNamedItem(kXML_DISPLAYLABEL_ATTR);
        if (node2 != null) {
            string4 = node2.getNodeValue();
        }
        RoleType roleType = CFDataModelParser.parseRoleAtt(node);
        StorageType storageType = CFDataModelParser.parseStorageAtt(node, kXML_STORAGE_ATTR);
        StructureType structureType = CFDataModelParser.parseStructureAtt(node, kXML_STRUCTURE_ATTR);
        int n2 = 0;
        int n3 = 0;
        if (structureType == StructureType.list) {
            n2 = CFDataModelParser.parseIntAtt(node, kXML_ELEMENT_COUNT_ATTR);
            n3 = CFDataModelParser.parseIntAtt(node, kXML_DEPTH_ATTR);
        }
        GeoBase geoBase = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() > 0) {
            string2 = null;
            int n4 = 0;
            n = 0;
            treeMap = "";
            boolean bl = false;
            object = "";
            string = "";
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (kXML_GEO_ELEMT.equals(node3.getNodeName())) {
                    string2 = CFDataModelParser.parseGeometryTypeAtt(node3, kXML_GEO_TYPE_ATTR);
                    n4 = CFDataModelParser.parseIntAtt(node3, kXML_COORDINATES_ATTR);
                    n = CFDataModelParser.parseIntAtt(node3, kXML_WKID_ATTR);
                    treeMap = CFDataModelParser.parseStringAtt(node3, kXML_CSNAME_ATTR);
                    bl = CFDataModelParser.parseBooleanAtt(node3, kXML_IS_PROJECTED_ATTR);
                    object = CFDataModelParser.parseStringAtt(node3, kXML_WKT_ATTR);
                } else if (kXML_GEO_HEADER_ELEMT.equals(node3.getNodeName())) {
                    string = CFDataModelParser.parseStringAtt(node3, kXML_GEO_HEADER_ATTR);
                }
                geoBase = new GeoBase();
                geoBase.setGeometryType((GeometryType)string2);
                geoBase.setCoordinates(Integer.valueOf(n4));
                geoBase.setWkid(Integer.valueOf(n));
                geoBase.setCsname((String)((Object)treeMap));
                geoBase.setIsProjected(Boolean.valueOf(bl));
                geoBase.setWkt((String)object);
                geoBase.setHeader(string);
            }
        }
        string2 = node.getAttributes().getNamedItem(kXML_MEASURE_ATTR) != null ? node.getAttributes().getNamedItem(kXML_MEASURE_ATTR).getNodeValue() : "unknown";
        MeasurementType measurementType = MeasurementType.unknown;
        if (string2.equals(kXML_NOMINAL_VAL)) {
            measurementType = MeasurementType.nominal;
        } else if (string2.equals(kXML_CONTINUOUS_VAL)) {
            measurementType = MeasurementType.continuous;
        } else if (string2.equals(kXML_ORDINAL_VAL)) {
            measurementType = MeasurementType.ordinal;
        } else if (string2.equals(kXML_FLAG_VAL)) {
            measurementType = MeasurementType.flag;
        } else if (string2.equals(kXML_DISCRETE_VAL)) {
            measurementType = MeasurementType.discrete;
        } else if (string2.equals("unknown")) {
            measurementType = MeasurementType.unknown;
        } else if (string2.equals(kXML_TYPELESS_VAL)) {
            measurementType = MeasurementType.typeless;
        }
        n = node.getChildNodes().getLength();
        treeMap = null;
        FormattedField formattedField = null;
        object = null;
        string = null;
        if (n != 0) {
            treeMap = new TreeMap();
            NodeList nodeList2 = node.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Object object2;
                NodeList nodeList3;
                Node node4 = nodeList2.item(i);
                if (node4 == null || node4.getNodeType() != 1) continue;
                if (node4.getNodeName().equals(kXML_VALUE_LABELS_ELMT)) {
                    nodeList3 = node4.getChildNodes();
                    for (int j = 0; j < nodeList3.getLength(); ++j) {
                        object2 = nodeList3.item(j);
                        if (object2 == null || object2.getNodeType() != 1 || !object2.getNodeName().equals(kXML_VALUES_ELMT)) continue;
                        treeMap = CFDataModelParser.parseValues((Node)object2, treeMap, storageType, measurementType);
                    }
                    continue;
                }
                if (node4.getNodeName().equals(kXML_VALUES_ELMT)) {
                    treeMap = CFDataModelParser.parseValues(node4, treeMap, storageType, measurementType);
                    continue;
                }
                if (node4.getNodeName().equals(kXML_FIELDFORMAT_ELEMT)) {
                    formattedField = CFDataModelParser.parseFieldInlineFormat(node4);
                    continue;
                }
                if (node4.getNodeName().equals(kXML_MISSING_VALUES_ELMT)) {
                    string = CFDataModelParser.parseMissingValues(node4, storageType, measurementType);
                    continue;
                }
                if (!node4.getNodeName().equals(kXML_MODELFIELD_ELMT)) continue;
                nodeList3 = CFDataModelParser.parseModelFieldRoleAtt(node4);
                Node node5 = node4.getAttributes().getNamedItem(kXML_MODEL_FIELD_TARGET_ATTR);
                object2 = node5 != null ? node5.getNodeValue() : null;
                RuleFeatureType ruleFeatureType = CFDataModelParser.parseRuleFeatureType(node4);
                Node node6 = node4.getAttributes().getNamedItem("value");
                String string5 = node6 != null ? node6.getNodeValue() : null;
                Node node7 = node4.getAttributes().getNamedItem(kXML_MODEL_FIELD_GROUPID);
                String string6 = node7 != null ? node7.getNodeValue() : null;
                Node node8 = node4.getAttributes().getNamedItem(kXML_MODEL_FIELD_TAG);
                String string7 = node8 != null ? node8.getNodeValue() : null;
                object = new ToolModelOutputDescriptor((ModelOutputRole)nodeList3, ruleFeatureType, (String)object2, string5, string6, string7);
            }
        }
        if (formattedField != null) {
            CFFormattedField cFFormattedField = new CFFormattedField(string3, string4, measurementType, storageType, treeMap, roleType, (ModelOutputDescriptor)object, (MissingValueDescriptor)string, structureType, n2, n3, (Geo)geoBase);
            cFFormattedField.setFormattedField(formattedField);
            vector.add((Field)cFFormattedField);
        } else {
            CFField cFField = new CFField(string3, string4, measurementType, storageType, treeMap, roleType, (ModelOutputDescriptor)object, (MissingValueDescriptor)string, structureType, n2, n3, (Geo)geoBase);
            vector.add((Field)cFField);
        }
    }

    private static RoleType parseRoleAtt(Node node) {
        String string = node.getAttributes().getNamedItem("role").getNodeValue();
        RoleType roleType = RoleType.none;
        if (string.equals(kXML_BOTH_VAL)) {
            roleType = RoleType.both;
        } else if (string.equals(kXML_INPUT_VAL)) {
            roleType = RoleType.input;
        } else if (string.equals(kXML_TARGET_VAL)) {
            roleType = RoleType.target;
        } else if (string.equals(kXML_SPLIT_VAL)) {
            roleType = RoleType.split;
        } else if (string.equals(kXML_NONE_VAL)) {
            roleType = RoleType.none;
        } else if (string.equals(kXML_FREQWEIGHT_VAL)) {
            roleType = RoleType.freqWeight;
        } else if (string.equals(kXML_PARTITION_VAL)) {
            roleType = RoleType.partition;
        } else if (string.equals("recordId")) {
            roleType = RoleType.recordId;
        }
        return roleType;
    }

    private static RuleFeatureType parseRuleFeatureType(Node node) {
        String string;
        RuleFeatureType ruleFeatureType = null;
        Node node2 = node.getAttributes().getNamedItem(kXML_RULE_TAG_ATTR);
        String string2 = string = node2 != null ? node2.getNodeValue() : null;
        if (string != null) {
            if (string.equals(kXML_ANTECEDENT)) {
                ruleFeatureType = RuleFeatureType.antecedent;
            } else if (string.equals(kXML_CONSEQUENT)) {
                ruleFeatureType = RuleFeatureType.consequent;
            } else if (string.equals(kXML_RULE)) {
                ruleFeatureType = RuleFeatureType.rule;
            } else if (string.equals(kXML_RULEID)) {
                ruleFeatureType = RuleFeatureType.ruleId;
            } else if (string.equals("confidence")) {
                ruleFeatureType = RuleFeatureType.confidence;
            } else if (string.equals(kXML_SUPPORT)) {
                ruleFeatureType = RuleFeatureType.support;
            } else if (string.equals(kXML_LIFT)) {
                ruleFeatureType = RuleFeatureType.lift;
            }
        }
        return ruleFeatureType;
    }

    private static ModelOutputRole parseModelFieldRoleAtt(Node node) {
        String string = node.getAttributes().getNamedItem("role").getNodeValue();
        ModelOutputRole modelOutputRole = ModelOutputRole.unknown;
        if (string.equals("unknown")) {
            modelOutputRole = ModelOutputRole.unknown;
        } else if (string.equals(kXML_PRED_VAL)) {
            modelOutputRole = ModelOutputRole.predictedValue;
        } else if (string.equals(kXML_PROBABILITY)) {
            modelOutputRole = ModelOutputRole.probability;
        } else if (!string.equals("confidence")) {
            if (string.equals(kXML_RESIDUAL)) {
                modelOutputRole = ModelOutputRole.residual;
            } else if (string.equals(kXML_STD_ERROR)) {
                modelOutputRole = ModelOutputRole.standardError;
            } else if (string.equals(kXML_CLUSTER_ID)) {
                modelOutputRole = ModelOutputRole.clusterId;
            } else if (string.equals(kXML_CLUSTER_AFFINITY)) {
                modelOutputRole = ModelOutputRole.clusterAffinity;
            } else if (string.equals(kXML_ENTITY_ID)) {
                modelOutputRole = ModelOutputRole.entityId;
            } else if (string.equals(kXML_ENTITNY_AFFINITY)) {
                modelOutputRole = ModelOutputRole.entityAffinity;
            } else if (string.equals(kXML_UPPER_CONF)) {
                modelOutputRole = ModelOutputRole.upperConfidenceLimit;
            } else if (string.equals(kXML_LOWER_CONF)) {
                modelOutputRole = ModelOutputRole.lowerConfidenceLimit;
            } else if (string.equals(kXML_PROPENSITY)) {
                modelOutputRole = ModelOutputRole.propensity;
            } else if (!string.equals("recordId") && !string.equals(kXML_CUM_HAZARD)) {
                if (string.equals(kXML_WARNING)) {
                    modelOutputRole = ModelOutputRole.warning;
                } else if (string.equals(kXML_RULE_VALUE)) {
                    modelOutputRole = ModelOutputRole.ruleValue;
                } else if (string.equals(kXML_ENTENDED)) {
                    // empty if block
                }
            }
        }
        return modelOutputRole;
    }

    private static StorageType parseStorageAtt(Node node, String string) {
        String string2 = node.getAttributes().getNamedItem(string).getNodeValue();
        StorageType storageType = StorageType.unknown;
        if (string2.equals(kXML_STRING_VAL)) {
            storageType = StorageType.string;
        } else if (string2.equals(kXML_REAL_VAL)) {
            storageType = StorageType.real;
        } else if (string2.equals(kXML_INTERGER_VAL)) {
            storageType = StorageType.integer;
        } else if (string2.equals(kXML_DATE_VAL)) {
            storageType = StorageType.date;
        } else if (string2.equals("unknown")) {
            storageType = StorageType.unknown;
        } else if (string2.equals(kXML_TIME_VAL)) {
            storageType = StorageType.time;
        } else if (string2.equals(kXML_TIMESTAMP_VAL)) {
            storageType = StorageType.timestamp;
        }
        return storageType;
    }

    private static StructureType parseStructureAtt(Node node, String string) {
        String string2;
        StructureType structureType = StructureType.primitive;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null && (string2 = node2.getNodeValue()).equals(kXML_LIST_VAL)) {
            structureType = StructureType.list;
        }
        return structureType;
    }

    private static int parseIntAtt(Node node, String string) {
        int n = 0;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            String string2 = node2.getNodeValue();
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private static String parseStringAtt(Node node, String string) {
        String string2 = "";
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            string2 = node2.getNodeValue();
        }
        return string2;
    }

    private static boolean parseBooleanAtt(Node node, String string) {
        boolean bl = false;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            String string2 = node2.getNodeValue();
            bl = "true".equals(string2);
        }
        return bl;
    }

    private static GeometryType parseGeometryTypeAtt(Node node, String string) {
        GeometryType geometryType = GeometryType.Point;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            String string2 = node2.getNodeValue();
            if ("Point".equals(string2)) {
                geometryType = GeometryType.Point;
            } else if ("MultiPoint".equals(string2)) {
                geometryType = GeometryType.MultiPoint;
            } else if ("LineString".equals(string2)) {
                geometryType = GeometryType.LineString;
            } else if ("MultiLineString".equals(string2)) {
                geometryType = GeometryType.MultiLineString;
            } else if ("Polygon".equals(string2)) {
                geometryType = GeometryType.Polygon;
            } else if ("MultiPolygon".equals(string2)) {
                geometryType = GeometryType.MultiPolygon;
            }
        }
        return geometryType;
    }

    private static List<Object> parseValues(Node node, StorageType storageType, MeasurementType measurementType) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (node.getNodeName().equals(kXML_VALUES_ELMT)) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2 == null || node2.getNodeType() != 1) continue;
                String string = node2.getAttributes().getNamedItem("value").getNodeValue();
                if (measurementType == MeasurementType.ordinal || measurementType == MeasurementType.nominal || measurementType == MeasurementType.continuous) {
                    try {
                        if (storageType == StorageType.real) {
                            double d = Double.parseDouble(string);
                            arrayList.add(d);
                            continue;
                        }
                        if (storageType == StorageType.integer) {
                            int n = Integer.parseInt(string);
                            arrayList.add(n);
                            continue;
                        }
                        arrayList.add(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        arrayList.add(string);
                    }
                    continue;
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private static TreeMap<Object, String> parseValues(Node node, TreeMap<Object, String> treeMap, StorageType storageType, MeasurementType measurementType) {
        if (node.getNodeName().equals(kXML_VALUES_ELMT)) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2 == null || node2.getNodeType() != 1) continue;
                String string = node2.getAttributes().getNamedItem("value").getNodeValue();
                String string2 = "";
                try {
                    Node node3 = node2.getAttributes().getNamedItem(kXML_DISPLAYLABEL_ATTR);
                    string2 = node3 != null ? node3.getNodeValue() : null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (measurementType == MeasurementType.ordinal || measurementType == MeasurementType.nominal || measurementType == MeasurementType.continuous) {
                    try {
                        if (storageType == StorageType.real) {
                            double d = Double.parseDouble(string);
                            treeMap.put(d, string2);
                            continue;
                        }
                        if (storageType == StorageType.integer) {
                            int n = Integer.parseInt(string);
                            treeMap.put(n, string2);
                            continue;
                        }
                        treeMap.put(string, string2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (measurementType == MeasurementType.flag) continue;
                treeMap.put(string, string2);
            }
        }
        return treeMap;
    }

    public static FieldFormats parseSharedFieldFormat(Node node) {
        if (node == null) {
            return new CFFieldFormats();
        }
        CFFieldFormats cFFieldFormats = CFDataModelParser.createFieldFormats(node.getAttributes());
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return cFFieldFormats;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            FieldFormat fieldFormat = CFDataModelParser.fieldFormatFactory(node2);
            if (fieldFormat == null) continue;
            cFFieldFormats.setSharedFieldFormat(fieldFormat.getName(), fieldFormat);
        }
        return cFFieldFormats;
    }

    public static FieldFormat fieldFormatFactory(Node node) {
        FieldFormat fieldFormat = null;
        if (node == null || node.getNodeType() != 1) {
            return fieldFormat;
        }
        if (node.getNodeName().equals(kXML_NUMBERFORMAT_ELMT)) {
            fieldFormat = CFDataModelParser.createNumberFieldFormat(node);
        } else if (node.getNodeName().equals(kXML_DATEFORMAT_ELMT)) {
            fieldFormat = CFDataModelParser.createDateFieldFormat(node);
        } else if (node.getNodeName().equals(kXML_STRINGFORMAT_ELMT)) {
            fieldFormat = CFDataModelParser.createStringFieldFormat(node);
        } else if (node.getNodeName().equals(kXML_TIMEFORMAT_ELMT)) {
            fieldFormat = CFDataModelParser.createTimeFieldFormat(node);
        } else if (node.getNodeName().equals(kXML_DECORATEDFORMAT_ELMT)) {
            fieldFormat = CFDataModelParser.createDecoratedFieldFormat(node);
        }
        return fieldFormat;
    }

    private static FieldFormat createDateFieldFormat(Node node) {
        CFDateFieldFormat cFDateFieldFormat = new CFDateFieldFormat();
        if (node == null) {
            return cFDateFieldFormat;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return cFDateFieldFormat;
        }
        CFXMLFormatConstants.DATE_FORMAT_ATT[] dATE_FORMAT_ATTArray = CFXMLFormatConstants.DATE_FORMAT_ATT.values();
        for (CFXMLFormatConstants.DATE_FORMAT_ATT dATE_FORMAT_ATT : dATE_FORMAT_ATTArray) {
            if (namedNodeMap.getNamedItem(dATE_FORMAT_ATT.name()) == null) continue;
            String string = namedNodeMap.getNamedItem(dATE_FORMAT_ATT.name()).getNodeValue();
            cFDateFieldFormat.setAttribute(dATE_FORMAT_ATT, string);
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return cFDateFieldFormat;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            CFXMLFormatConstants.DATE_FORMAT_ATT dATE_FORMAT_ATT;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(kXML_TIMEFORMAT_ELMT)) continue;
            dATE_FORMAT_ATT = (TimeFieldFormat)CFDataModelParser.createTimeFieldFormat(node2);
            cFDateFieldFormat.setTimeFieldFormat((TimeFieldFormat)dATE_FORMAT_ATT);
        }
        return cFDateFieldFormat;
    }

    private static FieldFormat createStringFieldFormat(Node node) {
        CFXMLFormatConstants.STRING_FORMAT_ATT[] sTRING_FORMAT_ATTArray;
        CFStringFieldFormat cFStringFieldFormat = new CFStringFieldFormat();
        if (node == null) {
            return cFStringFieldFormat;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return cFStringFieldFormat;
        }
        for (CFXMLFormatConstants.STRING_FORMAT_ATT sTRING_FORMAT_ATT : sTRING_FORMAT_ATTArray = CFXMLFormatConstants.STRING_FORMAT_ATT.values()) {
            Node node2 = namedNodeMap.getNamedItem(sTRING_FORMAT_ATT.name());
            if (node2 == null) continue;
            String string = node2.getNodeValue();
            cFStringFieldFormat.setAttribute(sTRING_FORMAT_ATT, string);
        }
        return cFStringFieldFormat;
    }

    private static FieldFormat createNumberFieldFormat(Node node) {
        CFXMLFormatConstants.NUMBER_FORMAT_ATT[] nUMBER_FORMAT_ATTArray;
        CFNumberFieldFormat cFNumberFieldFormat = new CFNumberFieldFormat();
        if (node == null) {
            return cFNumberFieldFormat;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return cFNumberFieldFormat;
        }
        for (CFXMLFormatConstants.NUMBER_FORMAT_ATT nUMBER_FORMAT_ATT : nUMBER_FORMAT_ATTArray = CFXMLFormatConstants.NUMBER_FORMAT_ATT.values()) {
            if (namedNodeMap.getNamedItem(nUMBER_FORMAT_ATT.name()) == null) continue;
            String string = namedNodeMap.getNamedItem(nUMBER_FORMAT_ATT.name()).getNodeValue();
            cFNumberFieldFormat.setAttribute(nUMBER_FORMAT_ATT, string);
        }
        return cFNumberFieldFormat;
    }

    private static FieldFormat createTimeFieldFormat(Node node) {
        CFXMLFormatConstants.TIME_FORMAT_ATT[] tIME_FORMAT_ATTArray;
        CFTimeFieldFormat cFTimeFieldFormat = new CFTimeFieldFormat();
        if (node == null) {
            return cFTimeFieldFormat;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return cFTimeFieldFormat;
        }
        for (CFXMLFormatConstants.TIME_FORMAT_ATT tIME_FORMAT_ATT : tIME_FORMAT_ATTArray = CFXMLFormatConstants.TIME_FORMAT_ATT.values()) {
            Node node2 = namedNodeMap.getNamedItem(tIME_FORMAT_ATT.name());
            if (node2 == null) continue;
            String string = node2.getNodeValue();
            cFTimeFieldFormat.setAttribute(tIME_FORMAT_ATT, string);
        }
        return cFTimeFieldFormat;
    }

    private static FieldFormat createDecoratedFieldFormat(Node node) {
        CFXMLFormatConstants.DECORATED_FORMAT_ATT[] dECORATED_FORMAT_ATTArray;
        CFDecoratedFieldFormat cFDecoratedFieldFormat = new CFDecoratedFieldFormat();
        if (node == null) {
            return cFDecoratedFieldFormat;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return cFDecoratedFieldFormat;
        }
        for (CFXMLFormatConstants.DECORATED_FORMAT_ATT dECORATED_FORMAT_ATT : dECORATED_FORMAT_ATTArray = CFXMLFormatConstants.DECORATED_FORMAT_ATT.values()) {
            Node node2 = namedNodeMap.getNamedItem(dECORATED_FORMAT_ATT.name());
            if (node2 == null) continue;
            String string = node2.getNodeValue();
            cFDecoratedFieldFormat.setAttribute(dECORATED_FORMAT_ATT, string);
        }
        return cFDecoratedFieldFormat;
    }

    private static CFFieldFormats createFieldFormats(NamedNodeMap namedNodeMap) {
        CFXMLFormatConstants.FIELD_FORMATS_ATT[] fIELD_FORMATS_ATTArray;
        CFFieldFormats cFFieldFormats = new CFFieldFormats();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return cFFieldFormats;
        }
        for (CFXMLFormatConstants.FIELD_FORMATS_ATT fIELD_FORMATS_ATT : fIELD_FORMATS_ATTArray = CFXMLFormatConstants.FIELD_FORMATS_ATT.values()) {
            Node node = namedNodeMap.getNamedItem(fIELD_FORMATS_ATT.name());
            if (node == null) continue;
            String string = node.getNodeValue();
            cFFieldFormats.setDefaultFormatName(fIELD_FORMATS_ATT, string);
        }
        return cFFieldFormats;
    }

    private static MissingValueDescriptor parseMissingValues(Node node, StorageType storageType, MeasurementType measurementType) {
        List<Object> list = null;
        Object object = null;
        Object object2 = null;
        boolean bl = true;
        boolean bl2 = false;
        Node node2 = node.getAttributes().getNamedItem(kXML_TREAT_NULL_AS_MISSING_ATTR);
        if (node2 != null) {
            boolean bl3 = bl = node2.getNodeValue() == null || node2.getNodeValue().compareToIgnoreCase(Boolean.FALSE.toString()) != 0;
        }
        if ((node2 = node.getAttributes().getNamedItem(kXML_TREAT_WHITESPACE_AS_MISSING_ATTR)) != null) {
            bl2 = node2.getNodeValue() != null && node2.getNodeValue().compareToIgnoreCase(Boolean.TRUE.toString()) == 0;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (node3 == null || node3.getNodeType() != 1) continue;
            if (node3.getNodeName().equals(kXML_VALUES_ELMT)) {
                list = CFDataModelParser.parseValues(node3, storageType, measurementType);
            }
            if (!node3.getNodeName().equals(kXML_RANGE_ELMT)) continue;
            node2 = node3.getAttributes().getNamedItem(kXML_MIN_VALUE_ATTR);
            if (node2 != null) {
                object = CFDataModelParser.parseAttributeValue(storageType, node2.getNodeValue());
            }
            if ((node2 = node3.getAttributes().getNamedItem(kXML_MAX_VALUE_ATTR)) == null) continue;
            object2 = CFDataModelParser.parseAttributeValue(storageType, node2.getNodeValue());
        }
        return new ToolMissingValueDescriptor(list, object, object2, bl, bl2);
    }

    private static Object parseAttributeValue(StorageType storageType, String string) {
        Object object = null;
        if (string != null) {
            try {
                object = storageType == StorageType.real ? Double.valueOf(Double.parseDouble(string)) : (storageType == StorageType.integer ? Integer.valueOf(Integer.parseInt(string)) : string);
            }
            catch (NumberFormatException numberFormatException) {
                object = string;
            }
        }
        return object;
    }

    private static FormattedField parseFieldInlineFormat(Node node) {
        CFFormattedFieldFormat cFFormattedFieldFormat = new CFFormattedFieldFormat();
        Node node2 = node.getAttributes().getNamedItem(kXML_USENAMEDFORMAT_ATTR);
        if (node2 != null) {
            cFFormattedFieldFormat.setSharedFormatName(node2.getNodeValue());
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            FieldFormat fieldFormat = CFDataModelParser.fieldFormatFactory(node3);
            if (fieldFormat == null) continue;
            cFFormattedFieldFormat.setFieldFormat(fieldFormat);
            break;
        }
        return cFFormattedFieldFormat;
    }

    static class ToolModelOutputDescriptor
    extends CFExtendableAdaptor
    implements ModelOutputDescriptor {
        ModelOutputRole modelOutputRole;
        RuleFeatureType ruleFeatureType;
        String targetField;
        String value;
        String groupID;
        String tag;

        public ToolModelOutputDescriptor(ModelOutputRole modelOutputRole, RuleFeatureType ruleFeatureType, String string, String string2, String string3, String string4) {
            this.modelOutputRole = modelOutputRole;
            this.ruleFeatureType = ruleFeatureType;
            this.targetField = string;
            this.value = string2;
            this.groupID = string3;
            this.tag = string4;
        }

        public ModelOutputRole getModelOutputRole() {
            return this.modelOutputRole;
        }

        public RuleFeatureType getRuleFeatureType() {
            return this.ruleFeatureType;
        }

        public String getTargetField() {
            return this.targetField;
        }

        public Object getValue() {
            return this.value;
        }

        public String getGroupID() {
            return this.groupID;
        }

        public String getTag() {
            return this.tag;
        }
    }

    static class ToolMissingValueDescriptor
    implements MissingValueDescriptor {
        List<Object> values;
        Object rangeLowerBound;
        Object rangeUpperBound;
        boolean isNullIncluded;
        boolean isWhitespaceIncluded;

        public ToolMissingValueDescriptor(List<Object> list, Object object, Object object2, boolean bl, boolean bl2) {
            this.values = list;
            this.rangeLowerBound = object;
            this.rangeUpperBound = object2;
            this.isNullIncluded = bl;
            this.isWhitespaceIncluded = bl2;
        }

        public int getValueCount() {
            return this.values == null ? 0 : this.values.size();
        }

        public List<Object> getValues() {
            return this.values;
        }

        public boolean hasRange() {
            return this.rangeLowerBound != null;
        }

        public Object getRangeLowerBound() {
            return this.rangeLowerBound;
        }

        public Object getRangeUpperBound() {
            return this.rangeUpperBound;
        }

        public boolean isNullIncluded() {
            return this.isNullIncluded;
        }

        public boolean isWhitespaceIncluded() {
            return this.isWhitespaceIncluded;
        }
    }
}

