/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.pyspark;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.pasw.aeintegration.core.AslGeneratorException;
import com.pasw.aeintegration.framework.ASPathRelative;
import com.pasw.aeintegration.framework.AslExecutionContext;
import com.pasw.aeintegration.framework.AslGenerationContext;
import com.pasw.aeintegration.framework.ContainerDownload;
import com.pasw.framework.common.container.Container;
import com.pasw.framework.common.extension.ExtensionObject;
import com.pasw.framework.common.extension.Feature;
import com.spss.ae.aslhelpers.AslContainer;
import com.spss.ae.aslhelpers.AslFunction;
import com.spss.ae.aslhelpers.AslProgram;
import com.spss.analyticframework.api.exceptions.AFException;
import com.spss.utilities.container.exceptions.ContainerException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AslFactory {
    private static String KYE_SCRIPT = "script";
    private static String KEY_DATAMODEL_ONLY = "computeDataModelOnly";
    private static String KEY_STDOUT_DEST = "stdoutDestinations";
    private static String KEY_STDERR_DEST = "stderrDestinations";
    private static String KEY_MESSAGE = "messages";
    public static String MODEL_CONTAINER = "model";
    public static String CONTAINER_COLON = "container:";
    public static String OUT_CONTAINER = "out";
    public static String ERROR_CONTAINER = "err";

    private static Container downloadContainer(AslExecutionContext aslExecutionContext, ASPathRelative aSPathRelative, boolean bl) {
        try {
            if (null == aSPathRelative) {
                return null;
            }
            ContainerDownload containerDownload = aslExecutionContext.downloadContainer(aSPathRelative, bl);
            if (null == containerDownload) {
                return null;
            }
            return containerDownload.getDownloadedContainer();
        }
        catch (AFException aFException) {
            if (!(aFException.getCause() instanceof ContainerException)) {
                throw aFException;
            }
            return null;
        }
    }

    public static void saveContainer2GeneratedFeatures(String string, ExtensionObject extensionObject, AslExecutionContext aslExecutionContext, ASPathRelative aSPathRelative, boolean bl, boolean bl2, boolean bl3, List<Feature> list) {
        Container container = AslFactory.downloadContainer(aslExecutionContext, aSPathRelative, bl3);
        if (null != container) {
            if (bl) {
                for (Feature feature : list) {
                    feature.setContainer(string, container);
                }
            }
            if (bl2) {
                extensionObject.setContainer(string, container);
            }
        }
    }

    public static void saveOutputContainer(Feature feature, AslExecutionContext aslExecutionContext, ASPathRelative aSPathRelative, ASPathRelative aSPathRelative2) {
        AslFactory.saveContainer(feature, aslExecutionContext, aSPathRelative, OUT_CONTAINER);
        AslFactory.saveContainer(feature, aslExecutionContext, aSPathRelative2, ERROR_CONTAINER);
    }

    private static void saveContainer(Feature feature, AslExecutionContext aslExecutionContext, ASPathRelative aSPathRelative, String string) {
        Container container = AslFactory.downloadContainer(aslExecutionContext, aSPathRelative, false);
        if (null != container) {
            feature.setContainer(string, container);
        }
    }

    public static AslFunction generateBuildModelFunction(AslProgram aslProgram, AslFunction aslFunction, String string, ASPathRelative aSPathRelative, ASPathRelative aSPathRelative2, ASPathRelative aSPathRelative3) {
        JSONObject jSONObject = new JSONObject();
        AslFactory.addCommonConfig(jSONObject, string, false);
        ArrayList<AslContainer> arrayList = new ArrayList<AslContainer>();
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.message, aSPathRelative);
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.error, aSPathRelative2);
        AslFactory.addOutputContainer(aslProgram, arrayList, MODEL_CONTAINER, aSPathRelative3);
        return aslProgram.createAslFunction(ModuleType.build.getName(), jSONObject, null, arrayList, aslFunction);
    }

    public static AslFunction generateApplyModelFunction(AslProgram aslProgram, AslGenerationContext aslGenerationContext, ExtensionObject extensionObject, AslFunction aslFunction, String string, boolean bl, ASPathRelative aSPathRelative, ASPathRelative aSPathRelative2, ASPathRelative aSPathRelative3) throws AslGeneratorException {
        JSONObject jSONObject = new JSONObject();
        AslFactory.addCommonConfig(jSONObject, string, bl);
        ArrayList<AslContainer> arrayList = new ArrayList<AslContainer>();
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.message, aSPathRelative);
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.error, aSPathRelative2);
        ArrayList<AslContainer> arrayList2 = new ArrayList<AslContainer>();
        if (!bl) {
            AslFactory.addInputContainer(aslProgram, aslGenerationContext, extensionObject, arrayList2, MODEL_CONTAINER, aSPathRelative3);
        }
        return aslProgram.createAslFunction(ModuleType.apply.getName(), jSONObject, arrayList2, arrayList, aslFunction);
    }

    public static AslFunction generateReadFunction(AslProgram aslProgram, String string, boolean bl, ASPathRelative aSPathRelative, ASPathRelative aSPathRelative2) {
        JSONObject jSONObject = new JSONObject();
        AslFactory.addCommonConfig(jSONObject, string, bl);
        ArrayList<AslContainer> arrayList = new ArrayList<AslContainer>();
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.message, aSPathRelative);
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.error, aSPathRelative2);
        return aslProgram.createAslFunction(ModuleType.read.getName(), jSONObject, null, arrayList, null);
    }

    public static AslFunction generateExportFunction(AslProgram aslProgram, AslGenerationContext aslGenerationContext, AslFunction aslFunction, String string, ASPathRelative aSPathRelative, ASPathRelative aSPathRelative2) throws AslGeneratorException {
        JSONObject jSONObject = new JSONObject();
        AslFactory.addCommonConfig(jSONObject, string, false);
        ArrayList<AslContainer> arrayList = new ArrayList<AslContainer>();
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.message, aSPathRelative);
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.error, aSPathRelative2);
        return aslProgram.createAslFunction(ModuleType.export.getName(), jSONObject, null, arrayList, aslFunction);
    }

    public static ASPathRelative genTempRelativePath() {
        return new ASPathRelative("/tempRelativePath/" + UUID.randomUUID().toString());
    }

    public static AslFunction generateProcessFunction(AslProgram aslProgram, AslFunction aslFunction, String string, boolean bl, ASPathRelative aSPathRelative, ASPathRelative aSPathRelative2) {
        JSONObject jSONObject = new JSONObject();
        AslFactory.addCommonConfig(jSONObject, string, bl);
        ArrayList<AslContainer> arrayList = new ArrayList<AslContainer>();
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.message, aSPathRelative);
        AslFactory.addMessageDest(aslProgram, jSONObject, arrayList, OutputType.error, aSPathRelative2);
        return aslProgram.createAslFunction(ModuleType.process.getName(), jSONObject, null, arrayList, aslFunction);
    }

    private static void addCommonConfig(JSONObject jSONObject, String string, boolean bl) {
        jSONObject.put((Object)KYE_SCRIPT, (Object)string);
        jSONObject.put((Object)KEY_DATAMODEL_ONLY, (Object)bl);
    }

    private static void addMessageDest(AslProgram aslProgram, JSONObject jSONObject, List<AslContainer> list, OutputType outputType, ASPathRelative aSPathRelative) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)KEY_MESSAGE);
        String string = "";
        if (outputType.equals((Object)OutputType.message)) {
            jSONArray.add((Object)(CONTAINER_COLON + OUT_CONTAINER));
            jSONObject.put((Object)KEY_STDOUT_DEST, (Object)jSONArray);
            string = OUT_CONTAINER;
        } else {
            jSONArray.add((Object)(CONTAINER_COLON + ERROR_CONTAINER));
            jSONObject.put((Object)KEY_STDERR_DEST, (Object)jSONArray);
            string = ERROR_CONTAINER;
        }
        list.add(aslProgram.createContainer(string, aSPathRelative.asString(), true));
    }

    private static void addInputContainer(AslProgram aslProgram, AslGenerationContext aslGenerationContext, ExtensionObject extensionObject, List<AslContainer> list, String string, ASPathRelative aSPathRelative) throws AslGeneratorException {
        aslGenerationContext.uploadContainer(extensionObject.getContainer(string), aSPathRelative);
        list.add(aslProgram.createContainer(string, aSPathRelative.asString(), true));
    }

    private static void addOutputContainer(AslProgram aslProgram, List<AslContainer> list, String string, ASPathRelative aSPathRelative) {
        list.add(aslProgram.createContainer(string, aSPathRelative.asString(), true));
    }

    public static enum OutputType {
        message,
        error;

    }

    public static enum ModuleType {
        read("pyspark:read"),
        build("pyspark:buildmodel"),
        apply("pyspark:applymodel"),
        process("pyspark:process"),
        export("pyspark:buildmodel");

        private String name;

        private ModuleType(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }
}

