/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.pyspark;

import com.pasw.aeintegration.core.AslGeneratorException;
import com.pasw.aeintegration.framework.ASPathRelative;
import com.pasw.core.application.callback.GetAttributeCallbackRequest;
import com.pasw.core.application.callback.GetAttributeCallbackResponse;
import com.pasw.core.property.DefaultProperties;
import com.pasw.framework.common.PaswException;
import com.pasw.framework.common.core.Structure;
import com.pasw.framework.common.extension.ExtensionObject;
import com.pasw.framework.common.extension.Feature;
import com.pasw.framework.common.extension.interaction.Interactor;
import com.pasw.framework.common.extension.interaction.InteractorEvent;
import com.pasw.framework.common.extension.spi.InteractorListener;
import com.pasw.framework.common.extension.spi.PaswDataModelException;
import com.pasw.framework.common.session.SessionCallbackRequest;
import com.pasw.framework.common.session.SessionCallbackResponse;
import com.spss.ae.aslhelpers.AslFragment;
import com.spss.ae.aslhelpers.AslProgram;
import com.spss.ae.client.DataSourceApi;
import com.spss.ae.client.ProjectApi;
import com.spss.ae.client.exception.ApiException;
import com.spss.ae.client.meta.ExecutionInfo;
import com.spss.ae.client.meta.ExecutionListener;
import com.spss.ae.client.meta.ExecutionResults;
import com.spss.ae.client.meta.Progress;
import com.spss.ae.client.meta.ProjectInfo;
import com.spss.ae.client.meta.RealTimeExecutionInfo;
import com.spss.ae.client.meta.records.RecordChannelSpec;
import com.spss.ae.client.remote.ApiContext;
import com.spss.ae.client.remote.RemoteClient;
import com.spss.datamodel.DataModel;
import com.spss.datarecord.DataVal;
import com.spss.datarecord.Record;
import com.spss.shared.custom_gui.ui_builder.pyspark.ASConnectionHelper;
import com.spss.shared.custom_gui.ui_builder.pyspark.AslFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;

public class AnalyticServerAPIHelper {
    public static final String ANALYTIC_SERVER_EXCEPTION_THROWS_ERROR = "Errors.AnalyticServerExceptionThrows";
    private static final String SESSION_PREFIX = "session.";
    private static final String INTERACTOR_PREFIX = "pyspark_interactor";
    private static final String ASL_TAG = "asl";
    private static String g_connection_context = null;

    private static RemoteClient connect(Structure structure) throws ApiException {
        String string;
        Properties properties = new Properties();
        properties.setProperty("secure.connection", ASConnectionHelper.getSecureConnect(structure));
        properties.setProperty("server", ASConnectionHelper.getServerURL(structure));
        properties.setProperty("port", ASConnectionHelper.getServerPort(structure));
        properties.setProperty("root.context", ASConnectionHelper.getContextRoot(structure));
        properties.setProperty("consumer", ASConnectionHelper.getConsumer(structure));
        String string2 = ASConnectionHelper.getUseKerberosAuth(structure);
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            String string3;
            String string4;
            String string5;
            properties.setProperty("use-kerberos-auth", string2);
            string = ASConnectionHelper.getKrb5ConfigFile(structure);
            if (string != null && string.length() > 0) {
                properties.setProperty("kerberos-krb5-conf", string);
            }
            if ((string5 = ASConnectionHelper.getJaasConfigFile(structure)) != null && string5.length() > 0) {
                properties.setProperty("kerberos-jaas-conf", string5);
            }
            if ((string4 = ASConnectionHelper.getKrb5ServicePrincipalName(structure)) != null && string4.length() > 0) {
                properties.setProperty("kerberos-krb5-spn", string4);
            }
            if ((string3 = ASConnectionHelper.getKerberosDebugSelection(structure)) != null && string3.length() > 0) {
                properties.setProperty("enable-kerberos-debug", string3);
            }
        } else {
            properties.setProperty("user.name", ASConnectionHelper.getUserName(structure));
            properties.setProperty("password", ASConnectionHelper.getPassword(structure));
        }
        if (g_connection_context != null) {
            properties.setProperty("context", g_connection_context);
        }
        string = new RemoteClient(new ApiContext(properties, Locale.getDefault()));
        string.login();
        g_connection_context = string.getContext();
        return string;
    }

    public static void disconnect(RemoteClient remoteClient) {
        remoteClient.logout();
    }

    private static Object getAttribute(Feature feature, String string) throws Exception {
        GetAttributeCallbackRequest getAttributeCallbackRequest = new GetAttributeCallbackRequest(string);
        GetAttributeCallbackResponse getAttributeCallbackResponse = new GetAttributeCallbackResponse();
        if (feature.getSession().handleCallback((SessionCallbackRequest)getAttributeCallbackRequest, (SessionCallbackResponse)getAttributeCallbackResponse)) {
            return getAttributeCallbackResponse.getAtrribute();
        }
        throw new Exception(getAttributeCallbackResponse.getErrorMessage());
    }

    private static Object getSessionAttriute(Feature feature, String string) throws Exception {
        return AnalyticServerAPIHelper.getAttribute(feature, SESSION_PREFIX + string);
    }

    private static Structure getAnalyticServerConnDescriptor(Feature feature) throws Exception {
        Properties properties = (Properties)AnalyticServerAPIHelper.getSessionAttriute(feature, "ASConnection");
        return ASConnectionHelper.getASCredential(properties);
    }

    public static RemoteClient genRemoteClient(Feature feature) throws Exception {
        Structure structure = AnalyticServerAPIHelper.getAnalyticServerConnDescriptor(feature);
        return AnalyticServerAPIHelper.connect(structure);
    }

    public static String genAslString(AslFactory.ModuleType moduleType, String string) throws AslGeneratorException {
        Object object;
        AslProgram aslProgram = new AslProgram();
        ASPathRelative aSPathRelative = AslFactory.genTempRelativePath();
        ASPathRelative aSPathRelative2 = AslFactory.genTempRelativePath();
        switch (moduleType) {
            case read: {
                AslFactory.generateReadFunction(aslProgram, string, true, aSPathRelative, aSPathRelative2);
                break;
            }
            case apply: {
                object = AslFactory.genTempRelativePath();
                AslFactory.generateApplyModelFunction(aslProgram, null, null, null, string, true, aSPathRelative, aSPathRelative2, (ASPathRelative)object);
                break;
            }
            case process: {
                AslFactory.generateProcessFunction(aslProgram, null, string, true, aSPathRelative, aSPathRelative2);
                break;
            }
        }
        object = "";
        for (AslFragment aslFragment : aslProgram.getFragments()) {
            object = aslFragment.toASLText();
        }
        if (((String)object).length() == 0) {
            throw new AslGeneratorException();
        }
        return object;
    }

    private static String createProject(RemoteClient remoteClient, boolean bl, final String string) {
        final String string2 = UUID.randomUUID().toString();
        try {
            ProjectApi projectApi = remoteClient.getProjectApi();
            ProjectInfo projectInfo = new ProjectInfo(){
                {
                    this.name = string2;
                    this.description = string;
                }
            };
            if (bl) {
                projectInfo.setTemp();
            }
            projectApi.createProject(projectInfo);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string2;
    }

    private static String createTemporaryProject(RemoteClient remoteClient) {
        String string = AnalyticServerAPIHelper.createProject(remoteClient, true, "Temporary project used for IBM SPSS Modeler stream execution");
        try {
            ProjectApi projectApi = remoteClient.getProjectApi();
            projectApi.lockProject(string, null);
        }
        catch (ApiException apiException) {
            // empty catch block
        }
        return string;
    }

    private static void cleanTempProject(RemoteClient remoteClient, String string) {
        ProjectApi projectApi = remoteClient.getProjectApi();
        projectApi.unlockProject(string);
        projectApi.deleteProject(string);
    }

    public static String submitExecutionOnAS(RemoteClient remoteClient, ExtensionObject extensionObject, final String string, String string2, String string3) throws PaswDataModelException {
        String string4 = "";
        final boolean[] blArray = new boolean[1];
        final String[] stringArray = new String[1];
        final String[] stringArray2 = new String[1];
        final DataModel dataModel = new DataModel();
        dataModel.fromXMLString(string2);
        final String string5 = AnalyticServerAPIHelper.createTemporaryProject(remoteClient);
        try {
            remoteClient.getAnalyticApi().submitExecution((ExecutionInfo)new RealTimeExecutionInfo(){

                public String getProgram() {
                    return string;
                }

                public String getProject() {
                    return string5;
                }

                public String getDescription() {
                    return "RealTimeExecutionInfo submit execution";
                }

                public Locale getLocale() {
                    return Locale.getDefault();
                }

                public boolean isAsynchronous() {
                    return false;
                }

                public boolean coreDump() {
                    return false;
                }

                public DataModel getInputDataModel() {
                    return dataModel;
                }
            }, new ExecutionListener(){

                public void onCancel() {
                    blArray[0] = true;
                }

                public void onError(String string, String string2, String string3) {
                    stringArray[0] = string + ":" + string2 + ". " + string3;
                }

                public void onInit(String string) {
                    stringArray2[0] = string;
                }

                public void onMessage(String string) {
                }

                public void onProgress(Progress progress) {
                }

                public void onSuccess(ExecutionResults executionResults) {
                }
            });
            ArrayList<4> arrayList = new ArrayList<4>();
            arrayList.add(new Record(){

                public DataVal getField(int n) {
                    return null;
                }

                public int getNumFields() {
                    return dataModel.getFields().getNumberOfFields();
                }
            });
            RecordChannelSpec recordChannelSpec = remoteClient.getAnalyticApi().feedRealTimeData(stringArray2[0], arrayList.iterator());
            string4 = recordChannelSpec.getDataModel().toXmlString();
        }
        catch (ApiException apiException) {
            String string6 = null;
            if (stringArray[0] != null && stringArray[0].length() > 0) {
                string6 = stringArray[0];
            }
            if (apiException.getLocalizedMessage() != null) {
                string6 = string6 + " \n " + apiException.getLocalizedMessage();
            }
            throw new PaswDataModelException(string6, (Throwable)apiException);
        }
        catch (Exception exception) {
            throw new PaswDataModelException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            AnalyticServerAPIHelper.cleanTempProject(remoteClient, string5);
        }
        if (blArray[0]) {
            throw new PaswDataModelException(extensionObject.getLocalizedMessage(string3, new Object[0]));
        }
        if (stringArray[0] != null && stringArray[0].length() > 0) {
            throw new PaswDataModelException(stringArray[0]);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String submitExecutionOnEAS(ExtensionObject extensionObject, String string, String string2) throws PaswDataModelException {
        class InteractorListenerImp
        implements InteractorListener {
            String errorMsg = null;

            InteractorListenerImp() {
            }

            public void onInteractorEvent(InteractorEvent interactorEvent) {
                try {
                    this.errorMsg = new String(interactorEvent.getMessage(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.errorMsg = "Error Code: " + Integer.toString(interactorEvent.getErrorCode());
                }
            }
        }
        InteractorListenerImp interactorListenerImp = new InteractorListenerImp();
        Interactor interactor = ((Feature)extensionObject).newInteractor(INTERACTOR_PREFIX, (InteractorListener)interactorListenerImp);
        try {
            if (interactor == null) throw new PaswDataModelException("Failed to init datamodel provider");
            interactor.initInteractor();
            DefaultProperties defaultProperties = new DefaultProperties();
            defaultProperties.addProperty(ASL_TAG, (Object)string);
            byte[] byArray = interactor.request("getDataModel", (com.pasw.framework.common.core.Properties)defaultProperties, string2.getBytes("UTF-8"));
            if (byArray != null && byArray.length != 0) {
                String string3;
                String string4 = string3 = new String(byArray, "UTF-8");
                return string4;
            }
            try {
                InteractorListenerImp interactorListenerImp2 = interactorListenerImp;
                synchronized (interactorListenerImp2) {
                    int n = 0;
                    while (interactorListenerImp.errorMsg == null && n++ < 5) {
                        interactorListenerImp.wait(500L);
                    }
                }
                if (interactorListenerImp.errorMsg == null) throw new PaswDataModelException("Unknow error during calculate datamodel");
                throw new PaswDataModelException(interactorListenerImp.errorMsg);
            }
            catch (PaswDataModelException paswDataModelException) {
                throw paswDataModelException;
            }
            catch (Exception exception) {
                throw new PaswDataModelException((Throwable)exception);
            }
        }
        finally {
            try {
                interactor.disposeInteractor();
            }
            catch (PaswException paswException) {
            }
            catch (IOException iOException) {}
            interactor = null;
        }
    }

    public static String getDataModelString(RemoteClient remoteClient, String string) throws ApiException {
        DataSourceApi dataSourceApi = remoteClient.getDataSourceApi();
        return dataSourceApi.getDataModelXml(string);
    }
}

