/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ComponentsArrowButton;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.PlainList;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssArrowButton;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.ui_builder.definition.FieldChooserDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.TableColItem;
import com.spss.uitools.ui_builder.definition.TableDefinition;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class TableActionButtonDlg
extends BaseDialog
implements ActionListener {
    private BuilderFrame mFrame;
    private TableDefinition mTableDef;
    private Vector<String> mChooserControlIDs;
    private JLabel mChooserListLabel;
    private PlainList mFieldChooserList;
    private DefaultListModel mFieldChooserListModel;
    private JLabel mTargetListLabel;
    private PlainList mTargetList;
    private DefaultListModel mTargetListModel;
    private TableLinkArrowButton mArrowButton;
    private JLabel mLinkedColLabel;
    private JComboBox mLinkedColumn;
    private DefaultComboBoxModel mLinkedColModel;
    private JButton mOkButton;

    public TableActionButtonDlg(BuilderFrame builderFrame, TableDefinition tableDefinition) throws HeadlessException {
        super((JFrame)builderFrame, BuilderResUtil.getString("IDS_TABLE_ACTION_BUTTON_DLG_TITLE"), true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.mFrame = builderFrame;
        this.mTableDef = tableDefinition;
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
    }

    public void doHelp() {
        BuilderUtil.getInstance().showHelp("spss/base/idh_idd_uibuilder_linkto");
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 23;
        int n2 = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.mChooserListLabel = DialogUtil.createLabel(this, "IDS_FIELD_CHOOSER_LIST");
        insets.set(1, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mChooserListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mFieldChooserList = new PlainList("IDS_FIELD_CHOOSER_LIST");
        this.mChooserListLabel.setLabelFor(this.mFieldChooserList);
        this.mFieldChooserListModel = new DefaultListModel();
        this.mFieldChooserList.setModel(this.mFieldChooserListModel);
        this.mFieldChooserList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.mFieldChooserList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(new Dimension(150, this.mFieldChooserList.getFixedCellHeight() * 6));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 2, 10, 2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n, insets);
        this.mTargetListLabel = DialogUtil.createLabel(this, "IDS_SELECTED_LIST");
        this.mTargetList = new PlainList("IDS_SELECTED_LIST");
        this.mTargetListLabel.setLabelFor(this.mTargetList);
        this.mTargetListModel = new DefaultListModel();
        this.mTargetList.setModel(this.mTargetListModel);
        this.mTargetList.setSelectionMode(0);
        Dimension dimension = new Dimension(150, this.mTargetList.getFixedCellHeight() + 6);
        this.mTargetList.setMaximumSize(dimension);
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetList);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setPreferredSize(dimension);
        this.mArrowButton = new TableLinkArrowButton();
        this.mArrowButton.registerComponents(this.mFieldChooserList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 8, 8, 8);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 4, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mTargetListLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 2, 8, 2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, insets);
        this.mLinkedColLabel = DialogUtil.createLabel(this, "IDS_LINKED_COLUMN");
        this.mLinkedColumn = new JComboBox();
        this.mLinkedColLabel.setLabelFor(this.mLinkedColumn);
        this.mLinkedColModel = new DefaultComboBoxModel();
        this.mLinkedColumn.setModel(this.mLinkedColModel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(4, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mLinkedColLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, 2, 10, 2);
        DialogUtil.addUsingGBL(jPanel, this.mLinkedColumn, gridBagConstraints, 2, 3, 1, 1, n, insets);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        return jPanel;
    }

    private void loadData() {
        this.mFieldChooserListModel.removeAllElements();
        this.getComboItems();
        for (String string : this.mChooserControlIDs) {
            this.mFieldChooserListModel.addElement(string);
        }
        String string = this.mTableDef.getKeyProviderName();
        if (this.mChooserControlIDs.size() > 0 && string.length() > 0) {
            int n = this.findIndex(string);
            if (n >= 0) {
                this.mTargetListModel.addElement(string);
                this.mFieldChooserListModel.remove(n);
                this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                this.enableLinkDropdown();
            } else {
                this.mTableDef.setKeyProviderName("");
            }
        }
        this.mLinkedColModel.removeAllElements();
        Vector vector = this.mTableDef.getColumns();
        for (int i = 0; i < vector.size(); ++i) {
            TableColItem tableColItem = (TableColItem)vector.get(i);
            if (tableColItem.getContentType() != TableColItem.ColContentType.VarName) continue;
            this.mLinkedColModel.addElement(tableColItem.getColId());
        }
        if (this.mLinkedColModel.getSize() == 0) {
            this.mLinkedColumn.setEnabled(false);
        } else {
            int n;
            String string2 = this.mTableDef.getKeyAttribute();
            if (string2.length() > 0 && (n = this.mLinkedColModel.getIndexOf(string2)) >= 0) {
                this.mLinkedColModel.setSelectedItem(string2);
            }
        }
        this.enableLinkDropdown();
    }

    private void getComboItems() {
        this.mChooserControlIDs = new Vector();
        this.loadFieldChooserIds((PanelElementDefinition)this.mFrame.getCanvas().getDialogDefinition().getCurrentPanel(), this.mChooserControlIDs);
    }

    private int findIndex(String string) {
        int n = -1;
        for (String string2 : this.mChooserControlIDs) {
            ++n;
            if (!string.equals(string2)) continue;
            return n;
        }
        return n;
    }

    private void loadFieldChooserIds(PanelElementDefinition panelElementDefinition, Vector<String> vector) {
        int n;
        if (panelElementDefinition instanceof PanelDefinition) {
            n = ((PanelDefinition)panelElementDefinition).getElementCount();
        } else if (panelElementDefinition instanceof RadioItemDefinition) {
            n = ((RadioItemDefinition)panelElementDefinition).getElementCount();
        } else {
            return;
        }
        for (int i = 0; i < n; ++i) {
            PanelElementDefinition panelElementDefinition2 = panelElementDefinition instanceof PanelDefinition ? ((PanelDefinition)panelElementDefinition).getPanelElement(i) : ((RadioItemDefinition)panelElementDefinition).getPanelElement(i);
            if (panelElementDefinition2 instanceof FieldChooserDefinition && ((FieldChooserDefinition)panelElementDefinition2).getChooserType() == FieldChooserDefinition.ChooserType.multiple) {
                vector.add(panelElementDefinition2.getControlId());
            }
            if (panelElementDefinition2 instanceof PanelDefinition) {
                this.loadFieldChooserIds(panelElementDefinition2, vector);
                continue;
            }
            if (!(panelElementDefinition2 instanceof RadioGroupDefinition)) continue;
            RadioGroupDefinition radioGroupDefinition = (RadioGroupDefinition)panelElementDefinition2;
            for (int j = 0; j < radioGroupDefinition.radioItemCount(); ++j) {
                this.loadFieldChooserIds((PanelElementDefinition)radioGroupDefinition.getRadioItem(j), vector);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof ComponentsArrowButton) {
            if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                int n = this.mFieldChooserList.getSelectedIndex();
                if (n >= 0 && this.mTargetList.getModel().getSize() == 0) {
                    this.mTargetListModel.addElement(this.mFieldChooserListModel.getElementAt(n));
                    this.mFieldChooserListModel.remove(n);
                    this.enableLinkDropdown();
                }
                this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            } else {
                int n = this.mTargetList.getSelectedIndex();
                if (n >= 0) {
                    String string = this.mTargetListModel.getElementAt(n).toString();
                    int n2 = this.findIndex(string);
                    this.mFieldChooserListModel.insertElementAt(string, n2);
                    this.mTargetListModel.remove(n);
                    this.enableLinkDropdown();
                }
                this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            }
        }
    }

    private void enableLinkDropdown() {
        boolean bl = false;
        if (this.mTargetListModel.getSize() > 0 && this.mLinkedColModel.getSize() > 0) {
            bl = true;
        }
        this.mLinkedColLabel.setEnabled(bl);
        this.mLinkedColumn.setEnabled(bl);
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TableActionButtonDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TableActionButtonDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TableActionButtonDlg.this.mTargetListModel.getSize() > 0) {
                TableActionButtonDlg.this.mTableDef.setKeyProviderName(TableActionButtonDlg.this.mTargetListModel.getElementAt(0).toString());
                if (TableActionButtonDlg.this.mLinkedColModel.getSize() > 0 && TableActionButtonDlg.this.mLinkedColModel.getSelectedItem() != null) {
                    TableActionButtonDlg.this.mTableDef.setKeyAttribute(TableActionButtonDlg.this.mLinkedColModel.getSelectedItem().toString());
                } else {
                    TableActionButtonDlg.this.mTableDef.setKeyAttribute("");
                }
                TableActionButtonDlg.this.mFrame.setModified(true);
            } else {
                TableActionButtonDlg.this.mTableDef.setKeyProviderName("");
                TableActionButtonDlg.this.mTableDef.setKeyAttribute("");
            }
            TableActionButtonDlg.this.dispose();
        }
    }

    class TableLinkArrowButton
    extends ComponentsArrowButton {
        TableLinkArrowButton() {
        }

        @Override
        protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
            if (srcDestHolder == null) {
                return;
            }
            this.setEnabled(true);
            if (this.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right && TableActionButtonDlg.this.mTargetListModel.getSize() == 1) {
                this.setEnabled(false);
            }
        }
    }
}

