/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.props_ui.ItemListTable;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RadioListDlg
extends JDialog {
    private ItemListTable mTable;
    private BuilderFrame mFrame;

    public RadioListDlg(BuilderFrame builderFrame, String string, CanvasObject canvasObject) throws HeadlessException {
        super(builderFrame, string, true);
        this.mFrame = builderFrame;
        this.init(canvasObject);
        this.pack();
        this.setSize(new Dimension(1000, 225));
        this.setLocationRelativeTo(builderFrame);
    }

    private void init(CanvasObject canvasObject) {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 24;
        this.mTable = new ItemListTable(this.mFrame, canvasObject);
        this.mTable.setBorder(BorderFactory.createEtchedBorder());
        this.mTable.getColumnModel().setColumnMargin(1);
        JScrollPane jScrollPane = new JScrollPane(this.mTable);
        jScrollPane.setPreferredSize(new Dimension(700, 200));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mTable.getUpButton(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mTable.getDownButton(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1, 5, 5));
        jPanel3.add(new JButton(new OKAction()));
        jPanel3.add(new JButton(new CancelAction()));
        jPanel3.add(new JButton(new HelpAction()));
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel3);
        this.add(jPanel3);
        this.setPreferredSize(new Dimension(700, 200));
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderUtil.getInstance().showHelp("spss/base/idh_idd_uibuilder_radioprops");
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RadioListDlg.this.mTable.clearTempRB();
            RadioListDlg.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RadioListDlg.this.mTable.isEditing()) {
                RadioListDlg.this.mTable.getCellEditor().stopCellEditing();
            }
            RadioListDlg.this.mTable.makeTempRBPermanent();
            RadioListDlg.this.mTable.saveData();
            RadioListDlg.this.mFrame.setModified(true);
            RadioListDlg.this.dispose();
        }
    }
}

