/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.SyntaxDiagramDlg;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ButtonEditCtrl;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.IButtonEditListener;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RefFileFilter;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RemoteFileChooser;
import com.spss.shared.custom_gui.ui_builder.canvas.BuilderCanvas;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.canvas.CheckBoxGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.CheckBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ColorPickerCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ComboBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.DatasetSelectorObject;
import com.spss.shared.custom_gui.ui_builder.canvas.EditCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.FieldChooserObject;
import com.spss.shared.custom_gui.ui_builder.canvas.FileSystemBrowserObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ISelectionListener;
import com.spss.shared.custom_gui.ui_builder.canvas.ItemGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ListBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.RadioGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.SpinnerCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.SrcListObject;
import com.spss.shared.custom_gui.ui_builder.canvas.StaticCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.StaticImageObject;
import com.spss.shared.custom_gui.ui_builder.canvas.SubDlgButtonObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TabObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TableCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TargetListObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TextAreaCtrlObject;
import com.spss.shared.custom_gui.ui_builder.props_ui.AttrType;
import com.spss.shared.custom_gui.ui_builder.props_ui.ControlTitleDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.CurrentDateDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.EnablingRuleDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.FieldSourceSelectDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.FileFilterDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.ITabOrderListener;
import com.spss.shared.custom_gui.ui_builder.props_ui.ItemListDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.RadioListDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.RequiredAddOnsDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.TableActionButtonDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.TableColumnDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.VariableFilterDlg;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.CheckBoxDefinition;
import com.spss.uitools.ui_builder.definition.CheckBoxGroupDefinition;
import com.spss.uitools.ui_builder.definition.ColorPickerDefinition;
import com.spss.uitools.ui_builder.definition.ComboBoxDefinition;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.ControlDefinition;
import com.spss.uitools.ui_builder.definition.DatasetSelectorDefinition;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.EditCtrlDefinition;
import com.spss.uitools.ui_builder.definition.FieldChooserDefinition;
import com.spss.uitools.ui_builder.definition.FileSystemBrowserDefinition;
import com.spss.uitools.ui_builder.definition.ListBoxDefinition;
import com.spss.uitools.ui_builder.definition.ListDefinition;
import com.spss.uitools.ui_builder.definition.NodeType;
import com.spss.uitools.ui_builder.definition.PaletteType;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.ScriptType;
import com.spss.uitools.ui_builder.definition.SpinnerDefinition;
import com.spss.uitools.ui_builder.definition.SrcListDefinition;
import com.spss.uitools.ui_builder.definition.StaticImageDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import com.spss.uitools.ui_builder.definition.TableDefinition;
import com.spss.uitools.ui_builder.definition.TargetListDefinition;
import com.spss.uitools.ui_builder.definition.VarListDefinition;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PropertiesPanel
extends JPanel
implements ISelectionListener,
CommandLocation.ResLoader {
    private static Font sItalicFont = null;
    private static Font sBoldFont = null;
    private JLabel mLabel;
    private PropsTable mPropTable;
    private PropsModel mModel;
    private Vector<AttrType> mRowTypes;
    private Vector<Integer> mDisabledRows;
    private DialogDefinition mDlgDef;
    private BuilderFrame mFrame;
    BaseDialog mSyntaxDiagramDlg;

    public PropertiesPanel(DialogDefinition dialogDefinition, BuilderFrame builderFrame) {
        this.mDlgDef = dialogDefinition;
        this.mRowTypes = new Vector();
        this.mDisabledRows = new Vector();
        this.mFrame = builderFrame;
        this.setLayout(new GridBagLayout());
        this.init();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertiesPanel.this.mPropTable.buildModel(null);
                if (PropertiesPanel.this.mFrame.getCanvas().getCanvasType() == BuilderCanvas.CanvasType.Normal && PropertiesPanel.this.mFrame.getCanvas().getComponentCount() == 0) {
                    PropertiesPanel.this.mFrame.getCanvas().createTextAreaObject();
                }
            }
        });
    }

    public JTable getPropTable() {
        return this.mPropTable;
    }

    public DialogDefinition getDlgDef() {
        return this.mDlgDef;
    }

    public void setDlgDef(DialogDefinition dialogDefinition) {
        this.mDlgDef = dialogDefinition;
    }

    public void focusTable() {
        this.mPropTable.requestFocus();
    }

    public CanvasObject getSelectedObject() {
        return this.mModel.mCanvasObject;
    }

    public void launchControlEditor(PanelElementDefinition panelElementDefinition) {
        if (panelElementDefinition instanceof SubDlgButtonDefinition) {
            this.launchSubDlgEditor((SubDlgButtonDefinition)panelElementDefinition);
        } else if (panelElementDefinition instanceof VarListDefinition) {
            VariableFilterDlg variableFilterDlg = new VariableFilterDlg(this.getBuilderFrame(), (VarListDefinition)panelElementDefinition);
            variableFilterDlg.setVisible(true);
        } else if (panelElementDefinition instanceof RadioGroupDefinition) {
            RadioListDlg radioListDlg = new RadioListDlg(this.getBuilderFrame(), BuilderResUtil.getString("IDS_RADIO_DLG_TITLE"), this.mModel.mCanvasObject);
            radioListDlg.setVisible(true);
            this.refreshCanvas();
        } else if (panelElementDefinition instanceof ListDefinition) {
            if (!(this.mModel.mCanvasObject instanceof ComboBoxObject) && !(this.mModel.mCanvasObject instanceof ListBoxObject)) {
                return;
            }
            ItemListDlg itemListDlg = new ItemListDlg(this.getBuilderFrame(), BuilderResUtil.getString("IDS_LIST_DLG_TITLE"), this.mModel.mCanvasObject);
            itemListDlg.setVisible(true);
            this.refreshCanvas();
        } else if (panelElementDefinition instanceof FileSystemBrowserDefinition) {
            FileFilterDlg fileFilterDlg = new FileFilterDlg(this.getBuilderFrame(), (FileSystemBrowserObject)this.mModel.mCanvasObject);
            fileFilterDlg.setVisible(true);
        }
    }

    public BuilderFrame launchSubDlgEditor(SubDlgButtonDefinition subDlgButtonDefinition) {
        DialogDefinition dialogDefinition = subDlgButtonDefinition.getDialogDefinition();
        final BuilderFrame builderFrame = new BuilderFrame(null, dialogDefinition);
        builderFrame.editCFDialogDefinition(dialogDefinition);
        builderFrame.showEditor(this.getBuilderFrame());
        if (builderFrame.getTabbedPane() != null) {
            builderFrame.getTabbedPane().setSelectedIndex(0);
        }
        this.getBuilderFrame().setEnabled(false);
        builderFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (builderFrame.isModified()) {
                    PropertiesPanel.this.getBuilderFrame().setModified(true);
                }
                PropertiesPanel.this.getBuilderFrame().setEnabled(true);
            }
        });
        return builderFrame;
    }

    public void commitEdits() {
        if (this.mPropTable.isEditing() && !this.mPropTable.getCellEditor().stopCellEditing()) {
            this.mPropTable.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public void selectionChanged(CanvasObject canvasObject) {
        if (!(canvasObject instanceof TextAreaCtrlObject)) {
            this.mPropTable.buildModel(canvasObject);
            this.refreshLabel();
        }
    }

    private String getFieldSourceString(String string, boolean bl, boolean bl2) {
        String string2 = string;
        String string3 = BuilderResUtil.getString("IDS_FIELD_SOURCE_IN");
        String string4 = BuilderResUtil.getString("IDS_FIELD_SOURCE_NOT_IN");
        if (bl) {
            if (bl2) {
                return string3 + string2;
            }
            return string4 + string2;
        }
        int n = string2.indexOf(string3);
        int n2 = string2.indexOf(string4);
        if (n >= 0) {
            string2 = string2.substring(string3.length());
        } else if (n2 >= 0) {
            string2 = string2.substring(string4.length());
        }
        return string2;
    }

    private String getDlgFieldSourceString(String string, boolean bl) {
        String string2 = string;
        String string3 = BuilderResUtil.getString("IDS_DIALOG_FIELD_SOURCE");
        if (bl) {
            return string3 + string2;
        }
        int n = string2.indexOf(string3);
        if (n >= 0) {
            string2 = string2.substring(string3.length());
        }
        return string2;
    }

    public String getString(String string) {
        BuilderFrame builderFrame = this.getBuilderFrame();
        if (builderFrame != null) {
            return builderFrame.getMenuName(string);
        }
        return "";
    }

    private BuilderFrame getBuilderFrame() throws NullPointerException {
        Container container = this.getTopLevelAncestor();
        if (container instanceof BuilderFrame) {
            return (BuilderFrame)container;
        }
        throw new NullPointerException();
    }

    private void refreshCanvas() {
        this.getBuilderFrame().getCanvas().revalidate();
        this.getBuilderFrame().getCanvas().repaint();
    }

    private void refreshLabel() {
        CanvasObject canvasObject = this.mModel.mCanvasObject;
        String string = "";
        if (canvasObject == null) {
            string = BuilderResUtil.getString("IDS_DLG_PROPS");
        } else if (canvasObject instanceof FieldChooserObject) {
            string = BuilderResUtil.getString("IDS_FIELD_CHOOSER_PROPS");
        } else if (canvasObject instanceof CheckBoxObject) {
            string = BuilderResUtil.getString("IDS_CHECKBOX_PROPS");
        } else if (canvasObject instanceof CheckBoxGroupObject) {
            string = BuilderResUtil.getString("IDS_CHECKBOX_GROUP_PROPS");
        } else if (canvasObject instanceof ItemGroupObject) {
            string = BuilderResUtil.getString("IDS_ITEM_GROUP_PROPS");
        } else if (canvasObject instanceof ComboBoxObject) {
            string = BuilderResUtil.getString("IDS_COMBO_PROPS");
        } else if (canvasObject instanceof ListBoxObject) {
            string = BuilderResUtil.getString("IDS_LIST_PROPS");
        } else if (canvasObject instanceof SpinnerCtrlObject) {
            string = BuilderResUtil.getString("IDS_SPINNER_PROPS");
        } else if (canvasObject instanceof EditCtrlObject) {
            boolean bl;
            EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)canvasObject.getCtrlDef();
            EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
            boolean bl2 = bl = parseType == EditCtrlDefinition.ParseType.integer || parseType == EditCtrlDefinition.ParseType.number;
            string = bl ? BuilderResUtil.getString("IDS_NUMERIC_EDIT_PROPS") : (editCtrlDefinition.isPasswordField() ? BuilderResUtil.getString("IDS_EDIT_SECURED_PROPS") : BuilderResUtil.getString("IDS_EDIT_PROPS"));
        } else if (canvasObject instanceof StaticCtrlObject) {
            string = BuilderResUtil.getString("IDS_STATIC_PROPS");
        } else if (canvasObject instanceof RadioGroupObject) {
            string = BuilderResUtil.getString("IDS_RADIO_GROUP_PROPS");
        } else if (canvasObject instanceof SrcListObject) {
            string = BuilderResUtil.getString("IDS_SRC_LIST_PROPS");
        } else if (canvasObject instanceof TargetListObject) {
            string = BuilderResUtil.getString("IDS_TGT_LIST_PROPS");
        } else if (canvasObject instanceof SubDlgButtonObject) {
            string = BuilderResUtil.getString("IDS_SUB_DLG_PROPS");
        } else if (canvasObject instanceof FileSystemBrowserObject) {
            string = BuilderResUtil.getString("IDS_FSB_PROPS");
        } else if (canvasObject instanceof TabObject) {
            string = BuilderResUtil.getString("IDS_TAB_PROPS");
        } else if (canvasObject instanceof TableCtrlObject) {
            string = BuilderResUtil.getString("IDS_TABLE_PROPS");
        } else if (canvasObject instanceof ColorPickerCtrlObject) {
            string = BuilderResUtil.getString("IDS_COLOR_PICKER_PROPS");
        } else if (canvasObject instanceof DatasetSelectorObject) {
            string = BuilderResUtil.getString("IDS_DATASET_SELECTOR_PROPS");
        }
        this.mLabel.setText(string);
    }

    private Font getItalicFont() {
        if (sItalicFont == null) {
            String string = BuilderResUtil.getString("IDS_ITALIC_VALUE");
            Font font = this.mModel == null || this.mModel.mCanvasObject == null ? new Font("SansSerif", 0, 12) : this.mModel.mCanvasObject.getFont();
            sItalicFont = string != null && string.equals("2") ? font.deriveFont(2) : font.deriveFont(0);
        }
        return sItalicFont;
    }

    private Font getBoldFont() {
        if (sBoldFont == null) {
            Font font = this.mModel == null || this.mModel.mCanvasObject == null ? new Font("SansSerif", 0, 12) : this.mModel.mCanvasObject.getFont();
            sBoldFont = font.deriveFont(1);
        }
        return sBoldFont;
    }

    private void adjustFont(int n, JComponent jComponent) {
        SubDlgButtonDefinition subDlgButtonDefinition;
        String string;
        AttrType attrType = this.mRowTypes.get(n);
        boolean bl = false;
        if (attrType == AttrType.launches && ((string = (subDlgButtonDefinition = (SubDlgButtonDefinition)this.mModel.mCanvasObject.getCtrlDef()).getDialogDefinition().getDialogTitle()) == null || string.length() == 0)) {
            bl = true;
        }
        if (attrType == AttrType.radioItems || attrType == AttrType.itemList || bl || attrType == AttrType.varFilters || attrType == AttrType.fileFilters || attrType == AttrType.requiredAddOns || attrType == AttrType.currentDate || attrType == AttrType.fieldSource || attrType == AttrType.enablingRule || attrType == AttrType.tableCol) {
            jComponent.setFont(this.getItalicFont());
            jComponent.setForeground(Color.gray);
        } else if (attrType == AttrType.propHeader) {
            jComponent.setFont(this.getBoldFont());
        } else {
            jComponent.setFont(this.getBuilderFrame().getCanvas().getFont());
            jComponent.setForeground(Color.black);
        }
    }

    private void runMenuLocationDialog() {
        BuilderFrame builderFrame = this.getBuilderFrame();
        builderFrame.runMenuLocationDlg();
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(4, 2, 2, 2), 0, 0);
        this.mLabel = new JLabel(BuilderResUtil.getString("IDS_DLG_PROPS"));
        this.mLabel.setHorizontalAlignment(10);
        this.mLabel.setFont(new Font("SansSerif", 1, 12));
        this.mLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_PROPERTIES"));
        this.add((Component)this.mLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 2, 2, 2), 0, 0);
        this.mModel = new PropsModel();
        this.mPropTable = new PropsTable(this.mModel);
        this.add((Component)new JScrollPane(this.mPropTable), gridBagConstraints);
        this.mLabel.setLabelFor(this.mPropTable);
        this.mPropTable.setBorder(BorderFactory.createEtchedBorder());
        this.mPropTable.setBackground(new Color(221, 221, 221));
        this.mPropTable.setFont(new Font("SansSerif", 0, 12));
        this.mPropTable.getColumnModel().setColumnMargin(1);
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = BuilderResUtil.getShortcut("IDK_CANVAS");
        inputMap.put(keyStroke, "FocusCanvas");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesPanel.this.getBuilderFrame().getCanvas().requestFocus();
            }
        };
        this.getActionMap().put("FocusCanvas", abstractAction);
        keyStroke = BuilderResUtil.getShortcut("IDK_TOOLS");
        inputMap.put(keyStroke, "FocusPalette");
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesPanel.this.getBuilderFrame().focusToolPalette();
            }
        };
        this.getActionMap().put("FocusPalette", abstractAction2);
    }

    class ComboItem<T> {
        private T mData;
        private String mLabel;

        public ComboItem(String string, T t) {
            this.mLabel = string;
            this.mData = t;
        }

        public T getData() {
            return this.mData;
        }

        public void setData(T t) {
            this.mData = t;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public void setLabel(String string) {
            this.mLabel = string;
        }

        public String toString() {
            return this.mLabel;
        }
    }

    static class LimitedPlainDocument
    extends PlainDocument {
        private int mMaxCharacters;

        public LimitedPlainDocument(int n) {
            this.mMaxCharacters = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            try {
                String string2 = string.substring(0, this.mMaxCharacters).toUpperCase(BuilderUtil.getInstance().getAppLocale());
                if (this.getLength() > 0) {
                    this.replace(0, this.mMaxCharacters, string2, attributeSet);
                } else {
                    super.insertString(0, string2, attributeSet);
                }
                if (n >= this.mMaxCharacters) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class GIFFilter
    extends RefFileFilter {
        GIFFilter() {
            super(BuilderResUtil.getString("IDS_GIF_FILTER_TYPE"), "gif", ";");
        }

        @Override
        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName().toUpperCase();
                if (string.endsWith(".GIF")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString("IDS_GIF_FILTER_TYPE");
        }
    }

    class HtmFilter
    extends RefFileFilter {
        HtmFilter() {
            super(BuilderResUtil.getString("IDS_HTM_FILTER_TYPE"), "htm;html", ";");
        }

        @Override
        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName().toUpperCase();
                if (string.endsWith(".HTM") || string.endsWith(".HTML")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString("IDS_HTM_FILTER_TYPE");
        }
    }

    class StepSizeValueEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private JTextField mTextField;

        public StepSizeValueEditor(JTextField jTextField) {
            super(jTextField);
            this.mTextField = jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mTextField.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n2 != 1 || !(PropertiesPanel.this.getSelectedObject() instanceof EditCtrlObject)) {
                return this.mTextField;
            }
            EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)PropertiesPanel.this.getSelectedObject().getCtrlDef();
            if (editCtrlDefinition.getDisplayType() != EditCtrlDefinition.DisplayType.Spinner) {
                return this.mTextField;
            }
            EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
            if (parseType == EditCtrlDefinition.ParseType.integer) {
                this.mTextField = new IntTextField(true);
            } else if (parseType == EditCtrlDefinition.ParseType.number) {
                this.mTextField = new FloatTextField(true);
            } else {
                return this.mTextField;
            }
            this.setEditCtrl(this.mTextField);
            this.mTextField.setText(object != null ? object.toString() : "");
            return this.mTextField;
        }

        public void setEditCtrl(JTextField jTextField) {
            this.mTextField = jTextField;
            this.editorComponent = jTextField;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object object) {
                    StepSizeValueEditor.this.mTextField.setText(object != null ? object.toString() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    return StepSizeValueEditor.this.mTextField.getText();
                }
            };
            this.mTextField.addActionListener(this.delegate);
        }
    }

    class DefCellRenderer
    extends DefaultTableCellRenderer {
        private Border mCellBorder = null;

        DefCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl && !bl2) {
                this.setBackground(Color.lightGray);
                this.setForeground(Color.black);
            }
            if (component instanceof JComponent) {
                if (n2 == 0 && PropertiesPanel.this.mRowTypes.get(n) == AttrType.propHeader) {
                    PropertiesPanel.this.adjustFont(n, (JComponent)component);
                } else if (n2 == 1) {
                    PropertiesPanel.this.adjustFont(n, (JComponent)component);
                }
            }
            if (component instanceof JComponent) {
                if (this.mCellBorder == null) {
                    this.mCellBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
                }
                ((JComponent)component).setBorder(this.mCellBorder);
            }
            return component;
        }
    }

    class CheckBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JCheckBox mCheckBox;
        private CanvasObject mCanvasObject;
        private AttrType mAttrType;

        public CheckBoxEditor(CanvasObject canvasObject, AttrType attrType, String string) {
            this.mCanvasObject = canvasObject;
            this.mAttrType = attrType;
            this.mCheckBox = new JCheckBox(string);
            this.mCheckBox.setFont(this.mCanvasObject.getFont());
            this.mCheckBox.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.mCheckBox.isSelected() ? BuilderResUtil.getString("IDS_MULTI_ITEM") : BuilderResUtil.getString("IDS_SINGLE_ITEM");
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.mCheckBox;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mAttrType == AttrType.targetListType) {
                TargetListObject targetListObject = (TargetListObject)this.mCanvasObject;
                targetListObject.setIsMultiItemList(this.mCheckBox.isSelected());
                PropertiesPanel.this.refreshCanvas();
            }
        }
    }

    class ComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox mComboBox;
        private ITabOrderListener listener;

        public ComboEditor(Object[] objectArray) {
            this.mComboBox = new JComboBox<Object>(objectArray);
            this.mComboBox.setEditable(false);
            this.mComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (ComboEditor.this.listener != null) {
                        ComboEditor.this.listener.tabOrderChanged(-1, ComboEditor.this.mComboBox.getSelectedIndex(), false);
                    }
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.mComboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.mComboBox;
        }

        public void setTabOrderListener(ITabOrderListener iTabOrderListener) {
            this.listener = iTabOrderListener;
        }
    }

    class NumberEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private SPSSTextField mTextField;

        public NumberEditor(SPSSTextField sPSSTextField) {
            super((JTextField)sPSSTextField);
            this.mTextField = sPSSTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mTextField.getUnformattedText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.mTextField.setText(object != null ? object.toString() : "");
            return this.mTextField;
        }
    }

    static class MnemonicEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private JTextField mTextField;

        public MnemonicEditor(JTextField jTextField) {
            super(jTextField);
            this.mTextField = jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mTextField.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.mTextField.setText(object != null ? object.toString() : "");
            return this.mTextField;
        }
    }

    class PropsModel
    extends DefaultTableModel {
        private CanvasObject mCanvasObject = null;

        public void setCanvasObject(CanvasObject canvasObject) {
            this.mCanvasObject = canvasObject;
        }

        @Override
        public int getColumnCount() {
            return super.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return super.getRowCount();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (PropertiesPanel.this.mRowTypes.get(n) == AttrType.propHeader) {
                return false;
            }
            if (PropertiesPanel.this.mRowTypes.get(n) == AttrType.scoringScript) {
                Object object = this.getValueAt(n - 1, n2);
                return object.toString().equals(BuilderResUtil.getString("IDS_TRUE"));
            }
            if (PropertiesPanel.this.mRowTypes.get(n) == AttrType.nodeType) {
                return !PropertiesPanel.this.mDlgDef.canScore();
            }
            if (PropertiesPanel.this.mDisabledRows.contains(n)) {
                return false;
            }
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getValueAt(n, n2);
            if (object2 != null && object2.equals(object)) {
                return;
            }
            boolean bl = true;
            if (n2 == 1) {
                bl = this.dispatchProperty(n, object);
            }
            if (bl) {
                super.setValueAt(object, n, n2);
                if (this.mCanvasObject != null && n2 == 1) {
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    if (n == 0 || n == 1) {
                        if (n == 0) {
                            string2 = object.toString();
                        } else {
                            string = object.toString();
                        }
                    } else if (n == 5 && this.mCanvasObject instanceof CheckBoxObject) {
                        string3 = object.toString();
                    } else if (n == 6 && this.mCanvasObject instanceof CheckBoxGroupObject) {
                        string3 = object.toString();
                    } else if (n == this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_SYNTAX"))) {
                        string3 = object.toString();
                    }
                    if (string3 != null || string2 != null || string != null) {
                        PropertiesPanel.this.mFrame.updateCanvasObject(this.mCanvasObject, string2, string, string3);
                    }
                }
            }
        }

        private boolean dispatchProperty(int n, Object object) {
            AttrType attrType = (AttrType)((Object)PropertiesPanel.this.mRowTypes.get(n));
            if (this.mCanvasObject != null ? !this.dispatchControlProperties(object, attrType) : !this.dispatchDialogProperties(object, attrType)) {
                return false;
            }
            PropertiesPanel.this.getBuilderFrame().setModified(true);
            PropertiesPanel.this.refreshCanvas();
            return true;
        }

        private boolean dispatchControlProperties(Object object, AttrType attrType) {
            if (attrType == AttrType.elementId) {
                if (!this.setControlId(object.toString())) {
                    return false;
                }
            } else if (attrType == AttrType.title || attrType == AttrType.ellipTitle) {
                this.mCanvasObject.setControlTitle(object.toString());
            } else if (attrType == AttrType.tip) {
                this.setCtrlTip(object);
            } else if (attrType == AttrType.syntax) {
                if (!this.setControlSyntax(object, true)) {
                    return false;
                }
            } else if (attrType == AttrType.syntaxOff) {
                this.setControlSyntax(object, false);
            } else if (attrType == AttrType.subTitle) {
                if (!this.setPanelSubTitle(object)) {
                    return false;
                }
            } else if (attrType == AttrType.defaultValue) {
                this.setCtrlDefaultValue(object);
            } else if (attrType == AttrType.textBoxCols) {
                this.setTextColsValue(object);
            } else if (attrType == AttrType.mnemonic) {
                if (!this.setCtrlMnemonic(object)) {
                    return false;
                }
            } else if (attrType == AttrType.copyMove) {
                if (!this.setSrcListCopyMoveState(object)) {
                    return false;
                }
            } else if (attrType == AttrType.isMultiItem) {
                this.setTargetMulti(object);
            } else if (attrType == AttrType.editType) {
                if (!this.setEditType(object)) {
                    return false;
                }
            } else if (attrType == AttrType.contentType) {
                this.setContentType(object);
            } else if (attrType == AttrType.displayType) {
                this.setDisplayType(object);
            } else if (attrType == AttrType.comboEditable) {
                this.setComboboxEditable(object);
            } else if (attrType == AttrType.titlePos) {
                this.setTitlePosition(object);
            } else if (attrType == AttrType.selectionType) {
                this.setLBSelectionType(object);
            } else if (attrType == AttrType.minValue || attrType == AttrType.maxValue) {
                if (!this.setMinMaxValue(attrType, object)) {
                    return false;
                }
            } else if (attrType == AttrType.stepSizeValue) {
                if (!this.setStepSizeValue(attrType, object)) {
                    return false;
                }
            } else if (attrType == AttrType.browserSystem) {
                this.setBrowserSystem(object);
            } else if (attrType == AttrType.browserType) {
                this.setBrowserType(object);
            } else if (attrType == AttrType.browserOp) {
                this.setBrowserOp(object);
            } else if (attrType == AttrType.required) {
                this.setIsRequired(object);
            } else if (attrType == AttrType.secureText) {
                this.setSecuretextValue(object);
            } else if (attrType == AttrType.tableAction) {
                this.setTableReorder(object);
            } else if (attrType == AttrType.chooserType) {
                this.setFieldChooserType(object);
            } else if (attrType == AttrType.separator) {
                this.setSeparatorType(object);
            } else if (attrType == AttrType.quotation) {
                this.setQuotationMarkType(object);
            } else if (attrType == AttrType.nodeImage) {
                this.setStaticImageName(object);
            } else if (attrType == AttrType.quoteHandleType) {
                this.setQuoteHandlingType(object);
            } else if (attrType == AttrType.currentDate) {
                this.setDateDefault(object);
            } else if (attrType == AttrType.fieldSource) {
                String string = object.toString();
                string = PropertiesPanel.this.getFieldSourceString(string, false, false);
                ((FieldChooserDefinition)((PropertiesPanel)PropertiesPanel.this).mModel.mCanvasObject.getCtrlDef()).setFieldSourceID(string);
            } else if (attrType == AttrType.tableLinking || attrType == AttrType.tableCol) {
                ((PropertiesPanel)PropertiesPanel.this).mModel.mCanvasObject.getCtrlDef();
            } else {
                return attrType == AttrType.visibleItems && this.setVisibleItemValue(object);
            }
            return true;
        }

        private void setLBSelectionType(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                ((ListBoxObject)this.mCanvasObject).getListDef().setSelectionType((ListBoxDefinition.SelectionType)comboItem.getData());
            }
        }

        private void setFieldChooserType(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                ((FieldChooserObject)this.mCanvasObject).getChooserDef().setChooserType((FieldChooserDefinition.ChooserType)comboItem.getData());
            }
        }

        private void setSeparatorType(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                if (this.mCanvasObject instanceof FieldChooserObject) {
                    ((FieldChooserObject)this.mCanvasObject).getChooserDef().setSeparatorType((FieldChooserDefinition.SeparatorType)comboItem.getData());
                } else if (this.mCanvasObject instanceof TargetListObject) {
                    ((TargetListDefinition)this.mCanvasObject.getCtrlDef()).setSeparatorType((FieldChooserDefinition.SeparatorType)comboItem.getData());
                } else if (this.mCanvasObject instanceof ListBoxObject) {
                    ((ListBoxObject)this.mCanvasObject).getListDef().setSeparatorType((FieldChooserDefinition.SeparatorType)comboItem.getData());
                }
            }
        }

        private void setQuoteHandlingType(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                if (this.mCanvasObject instanceof ComboBoxObject) {
                    ((ComboBoxObject)this.mCanvasObject).getComboDef().setQuoteHandleType((ControlDefinition.QuoteHandlingType)comboItem.getData());
                } else if (this.mCanvasObject instanceof EditCtrlObject) {
                    ((ControlDefinition)this.mCanvasObject.getCtrlDef()).setQuoteHandleType((ControlDefinition.QuoteHandlingType)comboItem.getData());
                } else if (this.mCanvasObject instanceof ListBoxObject) {
                    ((ListBoxObject)this.mCanvasObject).getListDef().setQuoteHandleType((ControlDefinition.QuoteHandlingType)comboItem.getData());
                } else if (this.mCanvasObject instanceof TableCtrlObject) {
                    ((ControlDefinition)this.mCanvasObject.getCtrlDef()).setQuoteHandleType((ControlDefinition.QuoteHandlingType)comboItem.getData());
                }
            }
        }

        private void setDateDefault(Object object) {
            ((SpinnerDefinition)((PropertiesPanel)PropertiesPanel.this).mModel.mCanvasObject.getCtrlDef()).setDefaultValue(object.toString());
        }

        private void setQuotationMarkType(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                ((FieldChooserObject)this.mCanvasObject).getChooserDef().setQuotationMarkType((FieldChooserDefinition.QuotationMarkType)comboItem.getData());
            }
        }

        private void setIsModeless(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.FALSE.equals(comboItem.getData());
                PropertiesPanel.this.mDlgDef.setIsModal(bl);
            }
        }

        private void setScriptType(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                PropertiesPanel.this.mDlgDef.setScriptType((ScriptType)comboItem.getData());
            }
        }

        private void setNodeType(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                PropertiesPanel.this.mDlgDef.setNodeType((NodeType)comboItem.getData());
            }
        }

        private void setNodePalette(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                PropertiesPanel.this.mDlgDef.setNodePalette((PaletteType)comboItem.getData());
            }
        }

        private void setCanScore(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                PropertiesPanel.this.mDlgDef.setCanScore(bl);
            }
        }

        private void setIsRequired(Object object) {
            PanelElementDefinition panelElementDefinition;
            Object object2;
            boolean bl = false;
            if (object instanceof ComboItem) {
                object2 = (ComboItem)object;
                bl = Boolean.TRUE.equals(((ComboItem)object2).getData());
                this.mCanvasObject.getCtrlDef().setRequired(bl);
            }
            if (bl && this.mCanvasObject instanceof TableCtrlObject && ((String)(object2 = ((TableDefinition)this.mCanvasObject.getCtrlDef()).getKeyProviderName())).length() > 0 && (panelElementDefinition = PropertiesPanel.this.mFrame.getCanvas().findCanvasObject((String)object2)) instanceof FieldChooserDefinition && !panelElementDefinition.isRequired()) {
                panelElementDefinition.setRequired(true);
            }
        }

        private void setSecuretextValue(Object object) {
            if (this.mCanvasObject instanceof EditCtrlObject && object instanceof ComboItem && ((EditCtrlDefinition)this.mCanvasObject.getCtrlDef()).isPasswordField()) {
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                ((EditCtrlDefinition)this.mCanvasObject.getCtrlDef()).setEncryptSyntax(bl);
            }
        }

        private void setTableReorder(Object object) {
            if (this.mCanvasObject instanceof TableCtrlObject && object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                ((TableDefinition)this.mCanvasObject.getCtrlDef()).setAllowReorderRows(bl);
            }
        }

        private boolean setControlSyntax(Object object, boolean bl) {
            boolean bl2 = true;
            String string = object.toString();
            if (!this.checkRecursiveReference(object.toString(), this.mCanvasObject.getControlId())) {
                BuilderAlertPane.showWarningMessageDialog(PropertiesPanel.this, BuilderResUtil.getString("IDS_REFERENCE_SELF"), BuilderUtil.getInstance().getAppVersionString());
                if (this.mCanvasObject != null) {
                    string = this.mCanvasObject.getControlSyntax();
                }
                bl2 = false;
            }
            if (this.mCanvasObject instanceof CheckBoxObject) {
                CheckBoxDefinition checkBoxDefinition = (CheckBoxDefinition)this.mCanvasObject.getCtrlDef();
                if (bl) {
                    checkBoxDefinition.setCheckedSyntax(string);
                } else {
                    checkBoxDefinition.setUncheckedSyntax(string);
                }
            } else if (this.mCanvasObject instanceof CheckBoxGroupObject) {
                CheckBoxDefinition checkBoxDefinition = ((CheckBoxGroupDefinition)this.mCanvasObject.getCtrlDef()).getControllerCheckBox();
                if (bl) {
                    checkBoxDefinition.setCheckedSyntax(string);
                } else {
                    checkBoxDefinition.setUncheckedSyntax(string);
                }
            } else if (this.mCanvasObject != null) {
                this.mCanvasObject.setControlSyntax(string);
            }
            return bl2;
        }

        private void setBrowserOp(Object object) {
            if (this.mCanvasObject instanceof FileSystemBrowserObject && object instanceof ComboItem) {
                FileSystemBrowserObject fileSystemBrowserObject = (FileSystemBrowserObject)this.mCanvasObject;
                FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)fileSystemBrowserObject.getCtrlDef();
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                fileSystemBrowserDefinition.setOpenDialog(bl);
            }
        }

        private void setBrowserType(Object object) {
            if (this.mCanvasObject instanceof FileSystemBrowserObject && object instanceof ComboItem) {
                FileSystemBrowserObject fileSystemBrowserObject = (FileSystemBrowserObject)this.mCanvasObject;
                FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)fileSystemBrowserObject.getCtrlDef();
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                fileSystemBrowserDefinition.setDirectoryBrowser(bl);
            }
        }

        private void setBrowserSystem(Object object) {
            if (this.mCanvasObject instanceof FileSystemBrowserObject && object instanceof ComboItem) {
                FileSystemBrowserObject fileSystemBrowserObject = (FileSystemBrowserObject)this.mCanvasObject;
                FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)fileSystemBrowserObject.getCtrlDef();
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.FALSE.equals(comboItem.getData());
                fileSystemBrowserDefinition.setServerFileSystem(bl);
            }
        }

        private boolean setMinMaxValue(AttrType attrType, Object object) {
            if (this.mCanvasObject instanceof EditCtrlObject) {
                EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
                if (!"".equals(object)) {
                    Double d = this.string2Value(object.toString(), parseType);
                    Double d2 = attrType == AttrType.minValue ? Double.valueOf(editCtrlDefinition.getMaxValue()) : Double.valueOf(editCtrlDefinition.getMinValue());
                    if (!Double.isNaN(d) && !this.validateMinMax(attrType, d, d2)) {
                        return false;
                    }
                    if (attrType == AttrType.minValue) {
                        editCtrlDefinition.setMinValue(d.doubleValue());
                    } else {
                        editCtrlDefinition.setMaxValue(d.doubleValue());
                    }
                    this.validateEditDefault(parseType, editCtrlDefinition.getMinValue(), editCtrlDefinition.getMaxValue(), editCtrlDefinition.getDefaultValue());
                } else if (attrType == AttrType.minValue) {
                    editCtrlDefinition.setMinValue(Double.NaN);
                } else {
                    editCtrlDefinition.setMaxValue(Double.NaN);
                }
            } else if (this.mCanvasObject instanceof SpinnerCtrlObject) {
                SpinnerDefinition spinnerDefinition = (SpinnerDefinition)this.mCanvasObject.getCtrlDef();
                EditCtrlDefinition.ParseType parseType = spinnerDefinition.getSpinnerType();
                if (!"".equals(object)) {
                    Double d = this.string2Value(object.toString(), parseType);
                    Double d3 = attrType == AttrType.minValue ? Double.valueOf(spinnerDefinition.getMaxValue()) : Double.valueOf(spinnerDefinition.getMinValue());
                    if (!Double.isNaN(d) && !this.validateMinMax(attrType, d, d3)) {
                        return false;
                    }
                    if (attrType == AttrType.minValue) {
                        spinnerDefinition.setMinValue(d.doubleValue());
                    } else {
                        spinnerDefinition.setMaxValue(d.doubleValue());
                    }
                    this.validateEditDefault(parseType, spinnerDefinition.getMinValue(), spinnerDefinition.getMaxValue(), spinnerDefinition.getDefaultValue());
                } else if (attrType == AttrType.minValue) {
                    spinnerDefinition.setMinValue(Double.NaN);
                } else {
                    spinnerDefinition.setMaxValue(Double.NaN);
                }
            } else {
                if (this.mCanvasObject instanceof TargetListObject || this.mCanvasObject instanceof FieldChooserObject || this.mCanvasObject instanceof ListBoxObject) {
                    return this.setMultiItemMinMax(attrType, object);
                }
                if (this.mCanvasObject instanceof TableCtrlObject) {
                    TableDefinition tableDefinition = (TableDefinition)this.mCanvasObject.getCtrlDef();
                    if (!"".equals(object)) {
                        int n = this.string2Int(object.toString(), false);
                        int n2 = attrType == AttrType.minValue ? tableDefinition.getMaxRowNum() : tableDefinition.getMinRowNum();
                        if (n2 != Integer.MAX_VALUE && n2 != Integer.MIN_VALUE && !this.validateMinMax(attrType, Double.valueOf(n), Double.valueOf(n2))) {
                            return false;
                        }
                        if (attrType == AttrType.minValue) {
                            tableDefinition.setMinRowNum(n);
                        } else {
                            tableDefinition.setMaxRowNum(n);
                        }
                    } else if (attrType == AttrType.minValue) {
                        tableDefinition.setMinRowNum(Integer.MIN_VALUE);
                    } else {
                        tableDefinition.setMaxRowNum(Integer.MAX_VALUE);
                    }
                } else {
                    return false;
                }
            }
            return true;
        }

        private boolean setMultiItemMinMax(AttrType attrType, Object object) {
            int n;
            TargetListDefinition targetListDefinition = null;
            FieldChooserDefinition fieldChooserDefinition = null;
            ListBoxDefinition listBoxDefinition = null;
            if (this.mCanvasObject instanceof TargetListObject) {
                targetListDefinition = (TargetListDefinition)this.mCanvasObject.getCtrlDef();
                n = attrType == AttrType.minValue ? targetListDefinition.getMaxFields() : targetListDefinition.getMinFields();
            } else if (this.mCanvasObject instanceof FieldChooserObject) {
                fieldChooserDefinition = (FieldChooserDefinition)this.mCanvasObject.getCtrlDef();
                n = attrType == AttrType.minValue ? fieldChooserDefinition.getMaxFields() : fieldChooserDefinition.getMinFields();
            } else {
                listBoxDefinition = (ListBoxDefinition)this.mCanvasObject.getCtrlDef();
                n = attrType == AttrType.minValue ? listBoxDefinition.getMaxFields() : listBoxDefinition.getMinFields();
            }
            int n2 = attrType == AttrType.minValue ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            if (!"".equals(object)) {
                n2 = Integer.parseInt(object.toString());
                if (n != Integer.MAX_VALUE && n != Integer.MIN_VALUE && !this.validateMinMax(attrType, Double.valueOf(n2), Double.valueOf(n))) {
                    return false;
                }
            }
            if (attrType == AttrType.minValue) {
                if (fieldChooserDefinition != null) {
                    fieldChooserDefinition.setMinFields(n2);
                } else if (targetListDefinition != null) {
                    targetListDefinition.setMinFields(n2);
                } else if (listBoxDefinition != null) {
                    listBoxDefinition.setMinFields(n2);
                }
            } else if (fieldChooserDefinition != null) {
                fieldChooserDefinition.setMaxFields(n2);
            } else if (targetListDefinition != null) {
                targetListDefinition.setMaxFields(n2);
            } else if (listBoxDefinition != null) {
                listBoxDefinition.setMaxFields(n2);
            }
            return true;
        }

        private boolean validateMinMax(AttrType attrType, Double d, Double d2) {
            boolean bl;
            boolean bl2 = bl = attrType == AttrType.minValue;
            if (bl && d > d2 || !bl && d < d2) {
                BuilderAlertPane.showWarningMessageDialog(PropertiesPanel.this, BuilderResUtil.getString("IDS_INVALID_MIN_MAX"), BuilderUtil.getInstance().getAppVersionString());
                return false;
            }
            return true;
        }

        private boolean setStepSizeValue(AttrType attrType, Object object) {
            EditCtrlDefinition editCtrlDefinition;
            if (this.mCanvasObject instanceof SpinnerCtrlObject) {
                SpinnerDefinition spinnerDefinition = (SpinnerDefinition)this.mCanvasObject.getCtrlDef();
                EditCtrlDefinition.ParseType parseType = spinnerDefinition.getSpinnerType();
                if (!"".equals(object)) {
                    Double d = this.string2Value(object.toString(), parseType);
                    spinnerDefinition.setStepSize(d.doubleValue());
                }
            } else if (this.mCanvasObject instanceof EditCtrlObject && (editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef()).getDisplayType() == EditCtrlDefinition.DisplayType.Spinner) {
                EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
                if (!"".equals(object)) {
                    Double d = this.string2Value(object.toString(), parseType);
                    editCtrlDefinition.setStepSize(d.doubleValue());
                }
            }
            return true;
        }

        private void setTargetMulti(Object object) {
            if (object instanceof ComboItem && this.mCanvasObject instanceof TargetListObject) {
                TargetListObject targetListObject = (TargetListObject)this.mCanvasObject;
                ComboItem comboItem = (ComboItem)object;
                targetListObject.setIsMultiItemList((Boolean)comboItem.getData());
                PropertiesPanel.this.refreshCanvas();
            }
        }

        private boolean setVisibleItemValue(Object object) {
            if (this.mCanvasObject instanceof TargetListObject) {
                if (object != null && object.toString().length() > 0) {
                    int n = this.string2Int(object.toString(), false);
                    int n2 = 1;
                    int n3 = 10;
                    if (n > n3 || n < n2) {
                        BuilderAlertPane.showWarningMessageDialog(PropertiesPanel.this, String.format(BuilderResUtil.getString("IDS_OUT_OF_RANGE_VALUE"), n2, n3), BuilderUtil.getInstance().getAppVersionString());
                        return false;
                    }
                    ((TargetListDefinition)this.mCanvasObject.getCtrlDef()).setDefaultVisibleItem(n);
                    return true;
                }
                return false;
            }
            return false;
        }

        private boolean setEditType(Object object) {
            if (object instanceof ComboItem) {
                if (this.mCanvasObject instanceof EditCtrlObject) {
                    EditCtrlDefinition.ParseType parseType;
                    EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                    EditCtrlDefinition.ParseType parseType2 = editCtrlDefinition.getParseType();
                    boolean bl = parseType2 == EditCtrlDefinition.ParseType.integer || parseType2 == EditCtrlDefinition.ParseType.number;
                    ComboItem comboItem = (ComboItem)object;
                    if (bl) {
                        Long l;
                        String string;
                        boolean bl2 = Boolean.TRUE.equals(comboItem.getData());
                        parseType = bl2 ? EditCtrlDefinition.ParseType.integer : EditCtrlDefinition.ParseType.number;
                        Object object2 = bl2 ? new IntTextField() : new FloatTextField();
                        int n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_MIN_VALUE"));
                        if (n > -1) {
                            if (bl2 && (string = this.getValueAt(n, 1).toString()).length() > 0) {
                                l = Math.round(this.string2Value(string, EditCtrlDefinition.ParseType.integer));
                                this.setValueAt(l.toString(), n, 1);
                            }
                            PropertiesPanel.this.mPropTable.mEditors.set(n, new NumberEditor((SPSSTextField)object2));
                        }
                        object2 = bl2 ? new IntTextField() : new FloatTextField();
                        n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_MAX_VALUE"));
                        if (n > -1) {
                            if (bl2 && (string = this.getValueAt(n, 1).toString()).length() > 0) {
                                l = Math.round(this.string2Value(string, EditCtrlDefinition.ParseType.integer));
                                this.setValueAt(l.toString(), n, 1);
                            }
                            PropertiesPanel.this.mPropTable.mEditors.set(n, new NumberEditor((SPSSTextField)object2));
                        }
                    } else {
                        parseType = Boolean.TRUE.equals(comboItem.getData()) ? EditCtrlDefinition.ParseType.variableName : EditCtrlDefinition.ParseType.string;
                    }
                    editCtrlDefinition.setParseType(parseType);
                    if (parseType == EditCtrlDefinition.ParseType.variableName) {
                        this.validateEditDefault(parseType, editCtrlDefinition.getMinValue(), editCtrlDefinition.getMaxValue(), editCtrlDefinition.getDefaultValue());
                    }
                } else if (this.mCanvasObject instanceof SpinnerCtrlObject) {
                    SpinnerDefinition spinnerDefinition = (SpinnerDefinition)this.mCanvasObject.getCtrlDef();
                    ComboItem comboItem = (ComboItem)object;
                    boolean bl = EditCtrlDefinition.ParseType.integer.equals(comboItem.getData());
                    boolean bl3 = EditCtrlDefinition.ParseType.number.equals(comboItem.getData());
                    if (bl || bl3) {
                        Long l;
                        String string;
                        EditCtrlDefinition.ParseType parseType = bl ? EditCtrlDefinition.ParseType.integer : EditCtrlDefinition.ParseType.number;
                        Object object3 = bl ? new IntTextField() : new FloatTextField();
                        int n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_MIN_VALUE"));
                        if (n > -1) {
                            if (bl && (string = this.getValueAt(n, 1).toString()).length() > 0) {
                                l = Math.round(this.string2Value(string, EditCtrlDefinition.ParseType.integer));
                                this.setValueAt(l.toString(), n, 1);
                            }
                            PropertiesPanel.this.mPropTable.mEditors.set(n, new NumberEditor((SPSSTextField)object3));
                        }
                        object3 = bl ? new IntTextField() : new FloatTextField();
                        n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_MAX_VALUE"));
                        if (n > -1) {
                            if (bl && (string = this.getValueAt(n, 1).toString()).length() > 0) {
                                l = Math.round(this.string2Value(string, EditCtrlDefinition.ParseType.integer));
                                this.setValueAt(l.toString(), n, 1);
                            }
                            PropertiesPanel.this.mPropTable.mEditors.set(n, new NumberEditor((SPSSTextField)object3));
                        }
                        spinnerDefinition.setSpinnerType(parseType);
                    } else {
                        int n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_SPINNER_TYPE_FIELD"));
                        spinnerDefinition.setSpinnerType((EditCtrlDefinition.ParseType)comboItem.getData());
                        this.setValueAt(comboItem.getLabel(), n, 1);
                    }
                }
            } else {
                return false;
            }
            return true;
        }

        private void setContentType(Object object) {
            if (object instanceof ComboItem) {
                EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                ComboItem comboItem = (ComboItem)object;
                int n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_TEXT_CONTENT_FIELD"));
                editCtrlDefinition.setParseType((EditCtrlDefinition.ParseType)comboItem.getData());
                this.setValueAt(comboItem.getLabel(), n, 1);
            }
        }

        private void setTitlePosition(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                this.mCanvasObject.getCtrlDef().setIsLabelAbove(bl);
            }
        }

        private void setComboboxEditable(Object object) {
            if (object instanceof ComboItem && this.mCanvasObject instanceof ComboBoxObject) {
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                ((ComboBoxObject)this.mCanvasObject).getComboDef().setEditable(bl);
            }
        }

        private void setDisplayType(Object object) {
            if (object instanceof ComboItem) {
                if (this.mCanvasObject instanceof EditCtrlObject) {
                    EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                    EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
                    boolean bl = parseType == EditCtrlDefinition.ParseType.integer || parseType == EditCtrlDefinition.ParseType.number;
                    ComboItem comboItem = (ComboItem)object;
                    if (bl) {
                        boolean bl2 = Boolean.FALSE.equals(comboItem.getData());
                        EditCtrlDefinition.DisplayType displayType = bl2 ? EditCtrlDefinition.DisplayType.textBox : EditCtrlDefinition.DisplayType.Spinner;
                        editCtrlDefinition.setDisplayType(displayType);
                        int n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_STEP_SIZE_VALUE"));
                        if (bl2) {
                            PropertiesPanel.this.mDisabledRows.add(n);
                        } else {
                            PropertiesPanel.this.mDisabledRows.removeElement(n);
                        }
                    }
                } else if (this.mCanvasObject instanceof DatasetSelectorObject) {
                    DatasetSelectorDefinition datasetSelectorDefinition = (DatasetSelectorDefinition)this.mCanvasObject.getCtrlDef();
                    ComboItem comboItem = (ComboItem)object;
                    datasetSelectorDefinition.setIncludeActiveDataset(((Boolean)comboItem.getData()).booleanValue());
                }
            }
        }

        private void setStaticImageName(Object object) {
            if (object instanceof String && this.mCanvasObject instanceof StaticImageObject) {
                ((StaticImageDefinition)this.mCanvasObject.getCtrlDef()).setImageName(object.toString());
            }
        }

        public int getRowForFirstColumnValue(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.getValueAt(i, 0);
                if (!object.toString().equals(string)) continue;
                return i;
            }
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean dispatchDialogProperties(Object object, AttrType attrType) {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            if (attrType == AttrType.elementId) {
                String string = object.toString();
                String string2 = dialogDefinition.getDialogId();
                dialogDefinition.setDialogId("");
                if (string.length() > 0 && PropertiesPanel.this.getBuilderFrame().getCanvas().findCanvasObject(string) == null && !string.contains(" ") && !PropertiesPanel.this.mFrame.isDlgIdExist(string)) {
                    dialogDefinition.setDialogId(string);
                    PropertiesPanel.this.mFrame.updateDlgMenu(string, string2, dialogDefinition.getCommandLocation());
                    return true;
                }
                dialogDefinition.setDialogId(string2);
                if (string.contains(" ")) {
                    BuilderAlertPane.showWarningMessageDialog(PropertiesPanel.this, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), BuilderUtil.getInstance().getAppVersionString());
                    return false;
                }
                BuilderAlertPane.showWarningMessageDialog(PropertiesPanel.this, string.length() == 0 ? BuilderResUtil.getString("IDS_MISSING_ID_WARNING") : BuilderResUtil.getString("IDS_DUPLICATE_DLG_ID_WARNING"), BuilderUtil.getInstance().getAppVersionString());
                return false;
            }
            if (attrType == AttrType.title) {
                String string = object.toString();
                dialogDefinition.setDialogTitle(string);
                String string3 = BuilderResUtil.getString("IDS_UIBUILDER_TITLE");
                if (string != null && string.length() > 0) {
                    string3 = string3 + " - " + dialogDefinition.getDialogTitle();
                }
                PropertiesPanel.this.getBuilderFrame().setTitle(string3);
                return true;
            }
            if (attrType == AttrType.helpFile) {
                dialogDefinition.setHelpFileName(object.toString());
                return true;
            }
            if (attrType == AttrType.customPath) {
                dialogDefinition.setCustomPropertiesFile(object.toString());
                return true;
            }
            if (attrType == AttrType.menuItem) {
                PropertiesPanel.this.runMenuLocationDialog();
                TraceSettings.trace1((String)("AttrType.menuItem: " + object.toString()), (int)15);
                return true;
            }
            if (attrType == AttrType.modal) {
                this.setIsModeless(object);
                return true;
            }
            if (attrType == AttrType.canScore) {
                this.setCanScore(object);
                PropertiesPanel.this.mDlgDef.setNodeType(NodeType.MODEL);
                PropertiesPanel.this.mFrame.updateScoreTabStatus();
                return true;
            }
            if (attrType != AttrType.scriptType) {
                if (attrType == AttrType.scoringScript) {
                    dialogDefinition.setRScoringScript(object.toString());
                    return true;
                }
                if (attrType == AttrType.nodeType) {
                    this.setNodeType(object);
                    return true;
                }
                if (attrType == AttrType.palette) {
                    this.setNodePalette(object);
                    return true;
                }
                if (attrType == AttrType.nodeImage) {
                    dialogDefinition.setNodeIconFile(object.toString());
                    return true;
                }
                if (attrType != AttrType.fieldSource) return false;
                String string = PropertiesPanel.this.getDlgFieldSourceString(object.toString(), false);
                dialogDefinition.setDatasetSeletorId(string);
                return true;
            }
            this.setScriptType(object);
            int n = 0;
            while (n < PropertiesPanel.this.mRowTypes.size()) {
                AttrType attrType2 = (AttrType)((Object)PropertiesPanel.this.mRowTypes.get(n));
                if (attrType2 == AttrType.syntax) {
                    String string;
                    if (PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.SYNTAX) {
                        string = BuilderResUtil.getString("IDS_SYNTAX");
                        ComboItem<Boolean> comboItem = new ComboItem<Boolean>(BuilderResUtil.getString("IDS_TRUE"), Boolean.FALSE);
                        this.setCanScore(comboItem);
                        this.setDisabledItems();
                        PropertiesPanel.this.mDlgDef.clearRequiredAddOns();
                    } else if (PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.R) {
                        string = BuilderResUtil.getString("IDS_SYNTAX_R_PYTHON");
                        this.resetDisabledItems();
                        PropertiesPanel.this.mDlgDef.getRequiredAddOns().add(AddOnType.R);
                        if (PropertiesPanel.this.mDlgDef.getAppType() == AppType.MODELER) {
                            PropertiesPanel.this.mDlgDef.getRequiredAddOns().remove(AddOnType.Python);
                        }
                    } else if (PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.PYTHON) {
                        string = BuilderResUtil.getString("IDS_SYNTAX_R_PYTHON");
                        this.resetDisabledItems();
                        PropertiesPanel.this.mDlgDef.getRequiredAddOns().add(AddOnType.Python);
                        if (PropertiesPanel.this.mDlgDef.getAppType() == AppType.MODELER) {
                            PropertiesPanel.this.mDlgDef.getRequiredAddOns().remove(AddOnType.R);
                        }
                    } else {
                        string = BuilderResUtil.getString("IDS_SYNTAX_UNDEFINED");
                    }
                    this.setValueAt(string, n, 0);
                }
                ++n;
            }
            return true;
        }

        private void setDisabledItems() {
            for (int i = 0; i < PropertiesPanel.this.mRowTypes.size(); ++i) {
                AttrType attrType = (AttrType)((Object)PropertiesPanel.this.mRowTypes.get(i));
                if (attrType != AttrType.canScore && attrType != AttrType.nodeType && attrType != AttrType.palette && attrType != AttrType.nodeImage) continue;
                PropertiesPanel.this.mDisabledRows.add(i);
            }
        }

        private void resetDisabledItems() {
            PropertiesPanel.this.mDisabledRows.clear();
        }

        private boolean setSrcListCopyMoveState(Object object) {
            if (!(this.mCanvasObject instanceof SrcListObject) || !(object instanceof ComboItem)) {
                return false;
            }
            ComboItem comboItem = (ComboItem)object;
            SrcListDefinition.TransferOp transferOp = Boolean.FALSE.equals(comboItem.getData()) ? SrcListDefinition.TransferOp.move : SrcListDefinition.TransferOp.copy;
            ((SrcListDefinition)this.mCanvasObject.getCtrlDef()).setTransferOp(transferOp);
            return true;
        }

        private boolean setCtrlMnemonic(Object object) {
            CanvasObject canvasObject = this.mCanvasObject;
            if (this.mCanvasObject instanceof CheckBoxGroupObject) {
                canvasObject = (CheckBoxObject)this.mCanvasObject.getComponent(0);
            }
            if (canvasObject == null) {
                return false;
            }
            String string = object.toString();
            if (string.length() > 0) {
                Integer n = string.toUpperCase().charAt(0);
                canvasObject.getCtrlDef().setMnemonicKey(n);
            } else {
                canvasObject.getCtrlDef().setMnemonicKey(null);
            }
            return true;
        }

        private void setCtrlDefaultValue(Object object) {
            Serializable serializable;
            Object object2;
            Object object3;
            if (this.mCanvasObject instanceof EditCtrlObject) {
                object3 = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                if (!this.validateEditDefault(object3.getParseType(), object3.getMinValue(), object3.getMaxValue(), object.toString())) {
                    return;
                }
                object2 = object3.getParseType();
                if (object.toString().length() > 0 && object2 == EditCtrlDefinition.ParseType.integer) {
                    serializable = this.string2Value(object.toString(), object3.getParseType());
                    object = ((Double)serializable).intValue();
                }
                object3.setDefaultValue(object.toString());
            }
            if (this.mCanvasObject instanceof SpinnerCtrlObject) {
                object3 = (SpinnerDefinition)this.mCanvasObject.getCtrlDef();
                object2 = object3.getSpinnerType();
                if (!this.validateEditDefault((EditCtrlDefinition.ParseType)object2, object3.getMinValue(), object3.getMaxValue(), object.toString())) {
                    return;
                }
                if (object.toString().length() > 0 && object2 == EditCtrlDefinition.ParseType.integer) {
                    serializable = this.string2Value(object.toString(), object3.getSpinnerType());
                    object = ((Double)serializable).intValue();
                }
                object3.setDefaultValue(object.toString());
            } else if (this.mCanvasObject instanceof FileSystemBrowserObject) {
                object3 = (FileSystemBrowserDefinition)((PropertiesPanel)PropertiesPanel.this).mModel.mCanvasObject.getCtrlDef();
                object3.setDefaultValue((String)object);
            } else if (object instanceof ComboItem) {
                object3 = (ComboItem)object;
                if (this.mCanvasObject instanceof CheckBoxObject) {
                    ((CheckBoxDefinition)this.mCanvasObject.getCtrlDef()).setDefaultState(((Boolean)((ComboItem)object3).getData()).booleanValue());
                } else if (this.mCanvasObject instanceof CheckBoxGroupObject) {
                    object2 = (CheckBoxGroupObject)this.mCanvasObject;
                    serializable = (CheckBoxObject)((Container)object2).getComponent(0);
                    ((CheckBoxDefinition)((CanvasObject)serializable).getCtrlDef()).setDefaultState(((Boolean)((ComboItem)object3).getData()).booleanValue());
                }
            }
        }

        private void setTextColsValue(Object object) {
            if (!PropertiesPanel.this.mDlgDef.IsCompatMode() && this.mCanvasObject instanceof EditCtrlObject) {
                EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                if (object.toString().length() > 0) {
                    Double d = this.string2Value(object.toString(), EditCtrlDefinition.ParseType.integer);
                    int n = d.intValue();
                    editCtrlDefinition.setNumCols(n);
                } else {
                    editCtrlDefinition.setNumCols(Integer.MAX_VALUE);
                    int n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_WIDTH"));
                    PropertiesPanel.this.mPropTable.getModel().setValueAt(BuilderResUtil.getString("IDS_WIDTH_DEAULT"), n, 1);
                }
            }
        }

        private boolean validateEditDefault(EditCtrlDefinition.ParseType parseType, double d, double d2, String string) {
            boolean bl;
            if (string == null || string.length() == 0) {
                return true;
            }
            boolean bl2 = true;
            boolean bl3 = bl = parseType == EditCtrlDefinition.ParseType.integer || parseType == EditCtrlDefinition.ParseType.number;
            if (bl) {
                Double d3 = this.string2Value(string, parseType);
                if (Double.isNaN(d3)) {
                    bl2 = false;
                } else {
                    if (!Double.isNaN(d) && d > d3) {
                        bl2 = false;
                    }
                    if (!Double.isNaN(d2) && d2 < d3) {
                        bl2 = false;
                    }
                }
            }
            if (!bl2) {
                BuilderAlertPane.showWarningMessageDialog(PropertiesPanel.this, BuilderResUtil.getString("IDS_INVALID_DEFAULT"), BuilderUtil.getInstance().getAppVersionString());
                final int n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_DEFAULT_VALUE"));
                if (n > -1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PropertiesPanel.this.mPropTable.setValueAt("", n, 1);
                            PropertiesPanel.this.mPropTable.changeSelection(n, 1, false, false);
                            PropertiesPanel.this.focusTable();
                        }
                    });
                }
            }
            return bl2;
        }

        private int string2Int(String string, boolean bl) {
            int n = -1;
            try {
                if (string.length() > 0 && (Character.isDigit(string.charAt(0)) || bl && string.charAt(0) == '-')) {
                    n = Integer.valueOf(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            return n;
        }

        private Double string2Value(String string, EditCtrlDefinition.ParseType parseType) {
            Double d;
            NumberFormat numberFormat = NumberFormat.getNumberInstance(BuilderUtil.getInstance().getAppLocale());
            try {
                d = string != null && string.length() > 0 ? numberFormat.parse(string).doubleValue() : Double.NaN;
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                d = Double.NaN;
            }
            if (!Double.isNaN(d) && parseType == EditCtrlDefinition.ParseType.integer) {
                d = Math.floor(d);
            }
            return d;
        }

        private boolean setPanelSubTitle(Object object) {
            if (!(this.mCanvasObject instanceof CheckBoxGroupObject)) {
                return false;
            }
            CheckBoxGroupObject checkBoxGroupObject = (CheckBoxGroupObject)this.mCanvasObject;
            CheckBoxObject checkBoxObject = (CheckBoxObject)checkBoxGroupObject.getComponent(0);
            checkBoxObject.setControlTitle(object.toString());
            return true;
        }

        private void setCtrlTip(Object object) {
            if (this.mCanvasObject instanceof CheckBoxGroupObject) {
                CheckBoxGroupObject checkBoxGroupObject = (CheckBoxGroupObject)this.mCanvasObject;
                CheckBoxObject checkBoxObject = (CheckBoxObject)checkBoxGroupObject.getComponent(0);
                checkBoxObject.setControlTip(object.toString());
            } else {
                this.mCanvasObject.setControlTip(object.toString());
            }
        }

        private boolean setControlId(String string) {
            String string2;
            String string3 = string2 = this.mCanvasObject != null ? this.mCanvasObject.getControlId() : PropertiesPanel.this.mDlgDef.getDialogId();
            if (string2.equals(string)) {
                return false;
            }
            if (string != null && string.contains(" ")) {
                BuilderAlertPane.showWarningMessageDialog(PropertiesPanel.this, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), BuilderUtil.getInstance().getAppVersionString());
                return false;
            }
            this.mCanvasObject.setControlId("");
            if (string == null || string.length() <= 0 || PropertiesPanel.this.getBuilderFrame().getCanvas().findCanvasObject(string) != null) {
                this.mCanvasObject.setControlId(string2);
                BuilderAlertPane.showWarningMessageDialog(PropertiesPanel.this, string == null || string.length() == 0 ? BuilderResUtil.getString("IDS_MISSING_EL_ID_WARNING") : BuilderResUtil.getString("IDS_DUPLICATE_ID_WARNING"), BuilderUtil.getInstance().getAppVersionString());
                return false;
            }
            this.mCanvasObject.setControlId(string);
            return true;
        }

        private boolean checkRecursiveReference(String string, String string2) {
            int n;
            String string3 = "%%";
            String string4 = string3 + string2 + string3;
            if (string.contains(string4)) {
                return false;
            }
            Vector<Object> vector = new Vector<Object>();
            int n2 = string.indexOf(string3);
            while (n2 != -1 && (n = string.indexOf(string3, n2 + 2)) != -1) {
                String string5 = string.substring(n2 + 2, n);
                vector.add(string5);
                n2 = string.indexOf(string3, n + 2);
            }
            for (String string6 : vector) {
                PanelElementDefinition panelElementDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().findCanvasObject(string6);
                String string7 = "";
                if (panelElementDefinition == null) continue;
                if (panelElementDefinition instanceof ControlDefinition) {
                    string7 = ((ControlDefinition)panelElementDefinition).getControlSyntax();
                } else if (panelElementDefinition instanceof PanelDefinition) {
                    string7 = ((PanelDefinition)panelElementDefinition).getPanelSyntax();
                }
                return this.checkRecursiveReference(string7, string2);
            }
            return true;
        }
    }

    class PropsTable
    extends JTable
    implements IButtonEditListener {
        private DefCellRenderer mCellRenderer;
        private Vector<TableCellRenderer> mRenderers;
        private Vector<TableCellEditor> mEditors;

        public PropsTable(PropsModel propsModel) {
            super(propsModel);
            this.mRenderers = new Vector();
            this.mEditors = new Vector();
            this.mCellRenderer = new DefCellRenderer();
            this.setAutoResizeMode(3);
            this.setAutoscrolls(true);
            this.getTableHeader().setResizingAllowed(true);
            this.setAutoCreateColumnsFromModel(false);
            this.setSelectionMode(0);
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_PROPERTY"));
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_VALUE"));
            this.addColumn(tableColumn);
            this.handleCellDelete();
            this.setupTableTabPolicy();
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    Serializable serializable;
                    TableCellEditor tableCellEditor;
                    if (PropertiesPanel.this.mRowTypes.elementAt(PropsTable.this.getSelectedRow()) == AttrType.title && (tableCellEditor = PropsTable.this.getCellEditor(PropsTable.this.getSelectedRow(), PropsTable.this.getSelectedColumn())) instanceof DefaultCellEditor && (serializable = ((DefaultCellEditor)tableCellEditor).getComponent()) instanceof JTextField) {
                        ((Component)serializable).addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyTyped(KeyEvent keyEvent) {
                                String string;
                                if (keyEvent.getKeyChar() >= ' ' && keyEvent.getKeyChar() <= '\u007f' && (string = " \"*:/<>?\\|").contains("" + keyEvent.getKeyChar())) {
                                    Toolkit.getDefaultToolkit().beep();
                                    keyEvent.consume();
                                }
                            }
                        });
                        if (keyEvent.getKeyChar() == ' ') {
                            keyEvent.consume();
                        }
                        ((Component)serializable).requestFocusInWindow();
                    }
                    if (keyEvent.getKeyChar() == ' ') {
                        if (PropsTable.this.isAllowedComboEdit()) {
                            tableCellEditor = PropsTable.this.getCellEditor(PropsTable.this.getSelectedRow(), PropsTable.this.getSelectedColumn());
                            if (tableCellEditor instanceof ComboEditor) {
                                serializable = (ComboEditor)tableCellEditor;
                                ((ComboEditor)serializable).mComboBox.requestFocusInWindow();
                            }
                        } else if (PropsTable.this.isAllowedButtonEdit() && (tableCellEditor = PropsTable.this.getCellEditor(PropsTable.this.getSelectedRow(), PropsTable.this.getSelectedColumn())) instanceof ButtonEditCtrl) {
                            serializable = (ButtonEditCtrl)tableCellEditor;
                            ((JComponent)serializable).requestFocusInWindow();
                        }
                    }
                }
            });
        }

        private boolean isAllowedComboEdit() {
            AttrType attrType = (AttrType)((Object)PropertiesPanel.this.mRowTypes.elementAt(this.getSelectedRow()));
            return this.getSelectedColumn() == 1 && (attrType == AttrType.canScore || attrType == AttrType.scriptType || attrType == AttrType.nodeType || attrType == AttrType.palette || attrType == AttrType.selectionType || attrType == AttrType.quoteHandleType || attrType == AttrType.defaultValue);
        }

        private boolean isAllowedButtonEdit() {
            AttrType attrType = (AttrType)((Object)PropertiesPanel.this.mRowTypes.elementAt(this.getSelectedRow()));
            return this.getSelectedColumn() == 1 && (attrType == AttrType.helpFile || attrType == AttrType.nodeImage || attrType == AttrType.enablingRule || attrType == AttrType.ellipTitle || attrType == AttrType.syntax || attrType == AttrType.syntaxOff);
        }

        private boolean canDelete(AttrType attrType) {
            return attrType == AttrType.customPath || attrType == AttrType.defaultValue || attrType == AttrType.elementId || attrType == AttrType.helpFile || attrType == AttrType.maxValue || attrType == AttrType.minValue || attrType == AttrType.mnemonic || attrType == AttrType.subTitle || attrType == AttrType.syntax || attrType == AttrType.syntaxOff || attrType == AttrType.tip || attrType == AttrType.title || attrType == AttrType.nodeImage;
        }

        public void buildModel(CanvasObject canvasObject) {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            this.mRenderers.clear();
            this.mEditors.clear();
            PropertiesPanel.this.mRowTypes.clear();
            Vector<String> vector = new Vector<String>();
            Vector<Vector<Object>> vector2 = new Vector<Vector<Object>>();
            vector.setSize(2);
            vector.set(0, BuilderResUtil.getString("IDS_PROPERTY_LABEL"));
            vector.set(1, BuilderResUtil.getString("IDS_VALUE_LABEL"));
            if (canvasObject != null) {
                this.setupRow(canvasObject.getControlId(), vector2, "IDS_IDENTIFIER", AttrType.elementId);
                if (PropertiesPanel.this.mDlgDef.IsCompatMode() || canvasObject instanceof TabObject) {
                    this.setupRow(canvasObject.getControlTitle(), vector2, "IDS_TITLE", AttrType.title);
                } else {
                    this.addEditableTitleRow(vector2, canvasObject);
                }
                if (!PropertiesPanel.this.mDlgDef.IsCompatMode()) {
                    this.addTitlePosition(vector2, canvasObject);
                }
                if (!(canvasObject instanceof StaticCtrlObject || canvasObject instanceof ItemGroupObject || canvasObject instanceof TabObject || canvasObject instanceof StaticImageObject)) {
                    this.setupRow(canvasObject.getControlTip(), vector2, "IDS_TIP", AttrType.tip);
                }
                this.addControlProperties(vector2, canvasObject);
                this.addSyntaxProperty(canvasObject, vector2);
                if (PropertiesPanel.this.mDlgDef.getAppType() == AppType.STATS && !PropertiesPanel.this.mDlgDef.IsCompatMode()) {
                    this.addQuoteHandleTypeRow(vector2, canvasObject, true);
                } else if (PropertiesPanel.this.mDlgDef.getAppType() == AppType.MODELER) {
                    this.addQuoteHandleTypeRow(vector2, canvasObject, false);
                }
                if (!PropertiesPanel.this.mDlgDef.IsCompatMode()) {
                    Vector vector3 = PropertiesPanel.this.mDlgDef.getAllEnableControls(canvasObject.getCtrlDef());
                    if (vector3.size() > 0) {
                        this.addEnablingRuleRow(vector2, canvasObject);
                    } else if (canvasObject instanceof TabObject && canvasObject.getCtrlDef().getCtrlConditions().size() > 0) {
                        this.addEnablingRuleRow(vector2, canvasObject);
                    } else {
                        canvasObject.getCtrlDef().setControlConditions(new Vector());
                    }
                }
            } else {
                this.buildDialogProperties(vector2);
            }
            PropertiesPanel.this.mModel.setDataVector(vector2, vector);
            PropertiesPanel.this.mModel.setCanvasObject(canvasObject);
            PropertiesPanel.this.mFrame.updateCanvasObject(canvasObject, null, null, null);
            int n = this.getColumnModel().getTotalColumnWidth();
            this.getColumnModel().getColumn(0).setPreferredWidth((int)((double)n * 0.33));
            this.getColumnModel().getColumn(1).setPreferredWidth((int)((double)n * 0.67));
            this.setRowHeight(22);
            this.changeSelection(0, 0, false, false);
        }

        @Override
        public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
            return this.mCellRenderer;
        }

        @Override
        public boolean isCellSelected(int n, int n2) {
            return this.isRowSelected(n) && this.isColumnSelected(n2);
        }

        @Override
        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            Component component;
            boolean bl = super.editCellAt(n, n2, eventObject);
            if (bl && (component = this.getEditorComponent()) instanceof JTextField) {
                MouseEvent mouseEvent;
                final JTextField jTextField = (JTextField)component;
                jTextField.selectAll();
                if (eventObject instanceof MouseEvent && (mouseEvent = (MouseEvent)eventObject).getClickCount() > 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jTextField.selectAll();
                        }
                    });
                }
            }
            return bl;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            TableCellRenderer tableCellRenderer;
            if (n2 == 1) {
                tableCellRenderer = this.mRenderers.get(n);
                if (tableCellRenderer instanceof JComponent) {
                    PropertiesPanel.this.adjustFont(n, (JComponent)((Object)tableCellRenderer));
                }
            } else {
                tableCellRenderer = super.getCellRenderer(n, n2);
                if (tableCellRenderer instanceof JComponent) {
                    ((JComponent)((Object)tableCellRenderer)).setForeground(Color.black);
                }
            }
            if (tableCellRenderer instanceof JComponent) {
                ((JComponent)((Object)tableCellRenderer)).setBackground(Color.white);
            }
            return tableCellRenderer;
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 1) {
                Object object;
                String string;
                TableCellEditor tableCellEditor = this.mEditors.get(n);
                Component component = tableCellEditor.getTableCellEditorComponent(this, string = (object = this.getValueAt(n, n2)) != null ? object.toString() : "", false, n, n2);
                if (component instanceof JComponent) {
                    PropertiesPanel.this.adjustFont(n, (JComponent)component);
                }
                if (component instanceof JComboBox && tableCellEditor instanceof ComboEditor) {
                    JComboBox jComboBox = (JComboBox)component;
                    int n3 = jComboBox.getItemCount();
                    for (int i = 0; i < n3; ++i) {
                        Object e = jComboBox.getItemAt(i);
                        if (!e.toString().equals(string)) continue;
                        jComboBox.setSelectedIndex(i);
                        break;
                    }
                }
                return tableCellEditor;
            }
            return super.getCellEditor(n, n2);
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            super.columnMarginChanged(changeEvent);
        }

        @Override
        public void buttonPressed(long l, int n) {
            FileSystemBrowserDefinition fileSystemBrowserDefinition;
            final int n2 = (int)l;
            AttrType attrType = (AttrType)((Object)PropertiesPanel.this.mRowTypes.get(n2));
            if (attrType == AttrType.launches) {
                if (!(PropertiesPanel.this.mModel.mCanvasObject instanceof SubDlgButtonObject)) {
                    return;
                }
                SubDlgButtonObject subDlgButtonObject = (SubDlgButtonObject)PropertiesPanel.this.mModel.mCanvasObject;
                final BuilderFrame builderFrame = PropertiesPanel.this.launchSubDlgEditor((SubDlgButtonDefinition)subDlgButtonObject.getCtrlDef());
                builderFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        SubDlgButtonObject subDlgButtonObject = (SubDlgButtonObject)PropertiesPanel.this.mModel.mCanvasObject;
                        String string = subDlgButtonObject.getDialogDefinition().getDialogTitle();
                        if (string == null || string.length() == 0) {
                            string = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
                        }
                        ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)PropsTable.this.mEditors.get(n2);
                        buttonEditCtrl.getTextField().setText(string);
                        if (builderFrame.isModified()) {
                            PropertiesPanel.this.getBuilderFrame().setModified(true);
                        }
                        PropertiesPanel.this.adjustFont(n2, buttonEditCtrl);
                    }
                });
            } else if (attrType == AttrType.radioItems) {
                if (!(PropertiesPanel.this.mModel.mCanvasObject instanceof RadioGroupObject)) {
                    return;
                }
                RadioListDlg radioListDlg = new RadioListDlg(PropertiesPanel.this.getBuilderFrame(), BuilderResUtil.getString("IDS_RADIO_DLG_TITLE"), PropertiesPanel.this.mModel.mCanvasObject);
                radioListDlg.setVisible(true);
                PropertiesPanel.this.refreshCanvas();
            } else if (attrType == AttrType.itemList) {
                if (!(PropertiesPanel.this.mModel.mCanvasObject instanceof ComboBoxObject) && !(PropertiesPanel.this.mModel.mCanvasObject instanceof ListBoxObject)) {
                    return;
                }
                ItemListDlg itemListDlg = new ItemListDlg(PropertiesPanel.this.getBuilderFrame(), BuilderResUtil.getString("IDS_LIST_DLG_TITLE"), PropertiesPanel.this.mModel.mCanvasObject);
                itemListDlg.setVisible(true);
                PropertiesPanel.this.refreshCanvas();
            } else if (attrType == AttrType.enablingRule) {
                EnablingRuleDlg enablingRuleDlg = new EnablingRuleDlg(PropertiesPanel.this.getBuilderFrame(), PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef());
                enablingRuleDlg.setVisible(true);
            } else if (attrType == AttrType.helpFile) {
                this.locateHelpFile(n2, n);
            } else if (attrType == AttrType.nodeImage) {
                this.locateIconFile(n2, n);
            } else if (attrType == AttrType.customPath) {
                this.locateCustomPropsFile(n2, n);
            } else if (attrType == AttrType.menuItem) {
                PropertiesPanel.this.runMenuLocationDialog();
            } else if (attrType == AttrType.syntax || attrType == AttrType.syntaxOff) {
                String string = this.getDialogSyntax();
                final BuilderFrame builderFrame = PropertiesPanel.this.getBuilderFrame();
                BuilderFrame.DialogDefinitionHelper dialogDefinitionHelper = new BuilderFrame.DialogDefinitionHelper();
                if (PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.R || PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.PYTHON) {
                    String string2 = this.getSyntax(PropertiesPanel.this.mModel.mCanvasObject, attrType);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("ThisValue");
                    String string3 = "IDS_CONTROL_SCRIPT_DESC";
                    final AttrType attrType2 = attrType;
                    PropertiesPanel.this.mSyntaxDiagramDlg = new SyntaxDiagramDlg(builderFrame, BuilderResUtil.getString("IDS_SCRIPT_DIAGRAM_PROPERTY"), string2, arrayList, null, string3, new SyntaxDiagramDlg.SyntaxDiagramDlgCallback(){

                        @Override
                        public void syntaxModifiedNotification() {
                            String string = ((SyntaxDiagramDlg)PropertiesPanel.this.mSyntaxDiagramDlg).getSyntax();
                            if (PropertiesPanel.this.mModel.mCanvasObject instanceof CheckBoxObject || PropertiesPanel.this.mModel.mCanvasObject instanceof CheckBoxGroupObject) {
                                if (attrType2 == AttrType.syntax) {
                                    if (PropertiesPanel.this.mModel.mCanvasObject instanceof CheckBoxObject) {
                                        ((CheckBoxDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).setCheckedSyntax(string);
                                    } else {
                                        ((CheckBoxGroupDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).getControllerCheckBox().setCheckedSyntax(string);
                                    }
                                } else if (PropertiesPanel.this.mModel.mCanvasObject instanceof CheckBoxObject) {
                                    ((CheckBoxDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).setUncheckedSyntax(string);
                                } else {
                                    ((CheckBoxGroupDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).getControllerCheckBox().setUncheckedSyntax(string);
                                }
                            } else {
                                PropertiesPanel.this.mModel.mCanvasObject.setControlSyntax(string);
                            }
                            builderFrame.setModified(true);
                            PropertiesPanel.this.mFrame.updateCanvasObject(PropertiesPanel.this.mModel.mCanvasObject, null, null, string);
                        }

                        @Override
                        public void showHelp() {
                            BuilderUtil.getInstance().showHelp("clementine/idh_idd_uibuilder_syntemplate");
                        }

                        @Override
                        public boolean showInvalidSyntaxWarning() {
                            int n = BuilderAlertPane.showConfirmDialog((Window)PropertiesPanel.this.mSyntaxDiagramDlg, BuilderResUtil.getString("IDS_INVALID_SCRIPT_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                            return n == 2;
                        }
                    });
                    PropertiesPanel.this.mSyntaxDiagramDlg.setVisible(true);
                    if (((SyntaxDiagramDlg)PropertiesPanel.this.mSyntaxDiagramDlg).getModalResult()) {
                        if (PropertiesPanel.this.mModel.mCanvasObject == null) {
                            builderFrame.getCanvas().fireSelectionChange(null);
                        } else {
                            builderFrame.getCanvas().fireSelectionChange(PropertiesPanel.this.mModel.mCanvasObject);
                        }
                        builderFrame.setModified(true);
                    }
                } else if (PropertiesPanel.this.mModel.mCanvasObject == null) {
                    String string4 = BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM") + "-" + PropertiesPanel.this.mFrame.getDialogTitle();
                    PropertiesPanel.this.mSyntaxDiagramDlg = new SyntaxDiagramDlg(builderFrame, string4, string, dialogDefinitionHelper.getControlIds(this.getMainDialogDefinition()), PropertiesPanel.this.mFrame.getSyntaxCommand(), new SyntaxDiagramDlg.SyntaxDiagramDlgCallback(){

                        @Override
                        public void syntaxModifiedNotification() {
                            String string = ((SyntaxDiagramDlg)PropertiesPanel.this.mSyntaxDiagramDlg).getSyntax();
                            PropsTable.this.getMainDialogDefinition().setDialogSyntax(string);
                            builderFrame.setModified(true);
                        }

                        @Override
                        public void showHelp() {
                            BuilderUtil.getInstance().showHelp("clementine/idh_idd_uibuilder_syntemplate");
                        }

                        @Override
                        public boolean showInvalidSyntaxWarning() {
                            int n = BuilderAlertPane.showConfirmDialog((Window)PropertiesPanel.this.mSyntaxDiagramDlg, BuilderResUtil.getString("IDS_INVALID_SYNTAX_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                            return n == 2;
                        }
                    });
                    PropertiesPanel.this.mSyntaxDiagramDlg.setVisible(true);
                    if (((SyntaxDiagramDlg)PropertiesPanel.this.mSyntaxDiagramDlg).getModalResult()) {
                        builderFrame.getCanvas().fireSelectionChange(null);
                        builderFrame.setModified(true);
                    }
                } else {
                    String string5 = this.getSyntax(PropertiesPanel.this.mModel.mCanvasObject, attrType);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("ThisValue");
                    String string6 = "IDS_CONTROL_SYNTAX_DESC";
                    final AttrType attrType3 = attrType;
                    PropertiesPanel.this.mSyntaxDiagramDlg = new SyntaxDiagramDlg(builderFrame, BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM_PROPERTY"), string5, arrayList, PropertiesPanel.this.mFrame.getSyntaxCommand(), string6, new SyntaxDiagramDlg.SyntaxDiagramDlgCallback(){

                        @Override
                        public void syntaxModifiedNotification() {
                            String string = ((SyntaxDiagramDlg)PropertiesPanel.this.mSyntaxDiagramDlg).getSyntax();
                            if (PropertiesPanel.this.mModel.mCanvasObject instanceof CheckBoxObject || PropertiesPanel.this.mModel.mCanvasObject instanceof CheckBoxGroupObject) {
                                if (attrType3 == AttrType.syntax) {
                                    if (PropertiesPanel.this.mModel.mCanvasObject instanceof CheckBoxObject) {
                                        ((CheckBoxDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).setCheckedSyntax(string);
                                    } else {
                                        ((CheckBoxGroupDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).getControllerCheckBox().setCheckedSyntax(string);
                                    }
                                } else if (PropertiesPanel.this.mModel.mCanvasObject instanceof CheckBoxObject) {
                                    ((CheckBoxDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).setUncheckedSyntax(string);
                                } else {
                                    ((CheckBoxGroupDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).getControllerCheckBox().setUncheckedSyntax(string);
                                }
                            } else {
                                PropertiesPanel.this.mModel.mCanvasObject.setControlSyntax(string);
                            }
                            builderFrame.setModified(true);
                            PropertiesPanel.this.mFrame.updateCanvasObject(PropertiesPanel.this.mModel.mCanvasObject, null, null, string);
                        }

                        @Override
                        public void showHelp() {
                            BuilderUtil.getInstance().showHelp("clementine/idh_idd_uibuilder_syntemplate");
                        }

                        @Override
                        public boolean showInvalidSyntaxWarning() {
                            int n = BuilderAlertPane.showConfirmDialog((Window)PropertiesPanel.this.mSyntaxDiagramDlg, BuilderResUtil.getString("IDS_INVALID_SYNTAX_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                            return n == 2;
                        }
                    });
                    PropertiesPanel.this.mSyntaxDiagramDlg.setVisible(true);
                    if (((SyntaxDiagramDlg)PropertiesPanel.this.mSyntaxDiagramDlg).getModalResult()) {
                        builderFrame.getCanvas().fireSelectionChange(PropertiesPanel.this.mModel.mCanvasObject);
                        builderFrame.setModified(true);
                    }
                }
            } else if (attrType == AttrType.varFilters) {
                VariableFilterDlg variableFilterDlg = new VariableFilterDlg(PropertiesPanel.this.getBuilderFrame(), (VarListDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef());
                variableFilterDlg.setVisible(true);
            } else if (attrType == AttrType.fieldSource) {
                FieldSourceSelectDlg fieldSourceSelectDlg = PropertiesPanel.this.mModel.mCanvasObject == null ? new FieldSourceSelectDlg(PropertiesPanel.this.getBuilderFrame(), PropertiesPanel.this.mDlgDef) : new FieldSourceSelectDlg(PropertiesPanel.this.getBuilderFrame(), (VarListDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef());
                fieldSourceSelectDlg.setVisible(true);
                if (fieldSourceSelectDlg.isOKPressed()) {
                    String string;
                    string = PropertiesPanel.this.mModel.mCanvasObject == null ? ((string = PropertiesPanel.this.mDlgDef.getDatasetSeletorId()).length() == 0 ? BuilderResUtil.getString("IDS_ACTIVE_DATASET_TO_EDIT") : PropertiesPanel.this.getDlgFieldSourceString(string, true)) : ((string = ((VarListDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).getFieldSourceID()).length() == 0 ? BuilderResUtil.getString("IDS_SELECT_TO_EDIT") : (((FieldChooserDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).isFieldSourceInclude() ? PropertiesPanel.this.getFieldSourceString(string, true, true) : PropertiesPanel.this.getFieldSourceString(string, true, false)));
                    ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n2);
                    buttonEditCtrl.getTextField().setText(string);
                }
            } else if (attrType == AttrType.tableLinking) {
                TableActionButtonDlg tableActionButtonDlg = new TableActionButtonDlg(PropertiesPanel.this.getBuilderFrame(), (TableDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef());
                tableActionButtonDlg.setVisible(true);
                TableDefinition tableDefinition = (TableDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef();
                this.getModel().setValueAt(tableDefinition.getLinkString(), n2, 1);
                ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n2);
                buttonEditCtrl.getTextField().setText(tableDefinition.getLinkString());
            } else if (attrType == AttrType.tableCol) {
                TableColumnDlg tableColumnDlg = new TableColumnDlg(PropertiesPanel.this.getBuilderFrame(), BuilderResUtil.getString("IDS_GRID_COL_DLG_TITLE"), PropertiesPanel.this.mModel.mCanvasObject);
                tableColumnDlg.setVisible(true);
                if (tableColumnDlg.isOKButtonPressed()) {
                    this.buildModel(PropertiesPanel.this.mModel.mCanvasObject);
                }
            } else if (attrType == AttrType.currentDate) {
                if (PropertiesPanel.this.mModel.mCanvasObject instanceof SpinnerCtrlObject && ((SpinnerDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()).getSpinnerType() == EditCtrlDefinition.ParseType.date) {
                    CurrentDateDlg currentDateDlg = new CurrentDateDlg(PropertiesPanel.this.getBuilderFrame(), (SpinnerDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef());
                    currentDateDlg.setVisible(true);
                    SpinnerDefinition spinnerDefinition = (SpinnerDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef();
                    String string = spinnerDefinition.getDefaultValue();
                    if (string.length() == 0) {
                        string = BuilderResUtil.getString("IDS_CURRENT_DATE_TIME");
                    }
                    this.getModel().setValueAt(string, n2, 1);
                    ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n2);
                    buttonEditCtrl.getTextField().setText(string);
                }
            } else if (attrType == AttrType.ellipTitle) {
                ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n2);
                ControlTitleDlg controlTitleDlg = new ControlTitleDlg(PropertiesPanel.this.getBuilderFrame(), PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef(), buttonEditCtrl.getTextField().getText());
                controlTitleDlg.setVisible(true);
                if (controlTitleDlg.isOKPressed()) {
                    String string = PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef().getTitle();
                    this.getModel().setValueAt(string, n2, 1);
                    buttonEditCtrl.getTextField().setText(string);
                }
            } else if (attrType == AttrType.fileFilters) {
                FileFilterDlg fileFilterDlg = new FileFilterDlg(PropertiesPanel.this.getBuilderFrame(), (FileSystemBrowserObject)PropertiesPanel.this.mModel.mCanvasObject);
                fileFilterDlg.setVisible(true);
            } else if (attrType == AttrType.requiredAddOns) {
                DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
                RequiredAddOnsDlg requiredAddOnsDlg = new RequiredAddOnsDlg(PropertiesPanel.this.getBuilderFrame(), dialogDefinition);
                requiredAddOnsDlg.setVisible(true);
                String string = this.buildAddOnsValue(dialogDefinition);
                this.getModel().setValueAt(string, n2, 1);
                ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n2);
                buttonEditCtrl.getTextField().setText(string);
                PropertiesPanel.this.adjustFont(n2, buttonEditCtrl);
            } else if (attrType == AttrType.defaultValue && PropertiesPanel.this.mModel.mCanvasObject instanceof FileSystemBrowserObject && (fileSystemBrowserDefinition = (FileSystemBrowserDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef()) != null) {
                this.locateDefaultFileBrowserFile(n2, n, fileSystemBrowserDefinition);
                ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n2);
                fileSystemBrowserDefinition.setDefaultValue(buttonEditCtrl.getTextField().getText());
            }
        }

        private String getSyntax(CanvasObject canvasObject, AttrType attrType) {
            String string = canvasObject instanceof CheckBoxObject || canvasObject instanceof CheckBoxGroupObject ? (attrType == AttrType.syntax ? (canvasObject instanceof CheckBoxObject ? ((CheckBoxDefinition)canvasObject.getCtrlDef()).getCheckedSyntax() : ((CheckBoxGroupDefinition)canvasObject.getCtrlDef()).getControllerCheckBox().getCheckedSyntax()) : (canvasObject instanceof CheckBoxObject ? ((CheckBoxDefinition)canvasObject.getCtrlDef()).getUncheckedSyntax() : ((CheckBoxGroupDefinition)canvasObject.getCtrlDef()).getControllerCheckBox().getUncheckedSyntax())) : canvasObject.getControlSyntax();
            return string;
        }

        private String getDialogSyntax() {
            DialogDefinition dialogDefinition = this.getMainDialogDefinition();
            return dialogDefinition.getDialogSyntax();
        }

        private DialogDefinition getMainDialogDefinition() {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            if (dialogDefinition.isSubDialog()) {
                dialogDefinition = dialogDefinition.getParentDefinition();
            }
            return dialogDefinition;
        }

        private void setupRow(String string, Vector<Vector<Object>> vector, String string2, AttrType attrType) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString(string2));
            vector2.add(string);
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(this.getDefaultEditor(String.class));
            PropertiesPanel.this.mRowTypes.add(attrType);
        }

        private void addEditableTitleRow(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_TITLE"));
            vector2.add(canvasObject.getControlTitle());
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setTestOnly(true);
            buttonEditCtrl.setFont(canvasObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(false);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.ellipTitle);
        }

        private void addControlSyntaxProperty(Vector<Vector<Object>> vector, String string, String string2, AttrType attrType) {
            Vector<String> vector2 = new Vector<String>();
            String string3 = BuilderResUtil.getString(string);
            vector2.add(string3);
            string2 = string2.replace("\n", "\\n");
            vector2.add(string2);
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setTestOnly(true);
            buttonEditCtrl.setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
            buttonEditCtrl.setReadOnlyEdit(false);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(attrType);
        }

        private void addSyntaxProperty(CanvasObject canvasObject, Vector<Vector<Object>> vector) {
            if (canvasObject instanceof CheckBoxObject) {
                CheckBoxDefinition checkBoxDefinition = (CheckBoxDefinition)canvasObject.getCtrlDef();
                if (PropertiesPanel.this.mDlgDef.getAppType() == AppType.STATS && !PropertiesPanel.this.mDlgDef.IsCompatMode() || PropertiesPanel.this.mDlgDef.getAppType() == AppType.MODELER) {
                    this.addControlSyntaxProperty(vector, this.getScriptLabel(1), checkBoxDefinition.getCheckedSyntax(), AttrType.syntax);
                    this.addControlSyntaxProperty(vector, this.getScriptLabel(2), checkBoxDefinition.getUncheckedSyntax(), AttrType.syntaxOff);
                } else {
                    this.setupRow(checkBoxDefinition.getCheckedSyntax(), vector, this.getScriptLabel(1), AttrType.syntax);
                    this.setupRow(checkBoxDefinition.getUncheckedSyntax(), vector, this.getScriptLabel(2), AttrType.syntaxOff);
                }
            } else if (canvasObject instanceof CheckBoxGroupObject) {
                CheckBoxDefinition checkBoxDefinition = ((CheckBoxGroupDefinition)canvasObject.getCtrlDef()).getControllerCheckBox();
                if (PropertiesPanel.this.mDlgDef.getAppType() == AppType.STATS && !PropertiesPanel.this.mDlgDef.IsCompatMode() || PropertiesPanel.this.mDlgDef.getAppType() == AppType.MODELER) {
                    this.addControlSyntaxProperty(vector, this.getScriptLabel(1), checkBoxDefinition.getCheckedSyntax(), AttrType.syntax);
                    this.addControlSyntaxProperty(vector, this.getScriptLabel(2), checkBoxDefinition.getUncheckedSyntax(), AttrType.syntaxOff);
                } else {
                    this.setupRow(checkBoxDefinition.getCheckedSyntax(), vector, this.getScriptLabel(1), AttrType.syntax);
                    this.setupRow(checkBoxDefinition.getUncheckedSyntax(), vector, this.getScriptLabel(2), AttrType.syntaxOff);
                }
            } else if (this.generatesSyntax(canvasObject)) {
                if (PropertiesPanel.this.mDlgDef.getAppType() == AppType.STATS && !PropertiesPanel.this.mDlgDef.IsCompatMode() || PropertiesPanel.this.mDlgDef.getAppType() == AppType.MODELER) {
                    this.addControlSyntaxProperty(vector, this.getScriptLabel(3), canvasObject.getControlSyntax(), AttrType.syntax);
                } else {
                    this.setupRow(canvasObject.getControlSyntax(), vector, this.getScriptLabel(3), AttrType.syntax);
                }
            }
        }

        private String getScriptLabel(int n) {
            if (PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.SYNTAX) {
                switch (n) {
                    case 1: {
                        return "IDS_CHECKED_SYNTAX";
                    }
                    case 2: {
                        return "IDS_UNCHECKED_SYNTAX";
                    }
                    case 3: {
                        return "IDS_SYNTAX";
                    }
                }
            } else {
                switch (n) {
                    case 1: {
                        return "IDS_CHECKED_R";
                    }
                    case 2: {
                        return "IDS_UNCHECKED_R";
                    }
                    case 3: {
                        return "IDS_SYNTAX_R_PYTHON";
                    }
                }
            }
            return "IDS_SYNTAX";
        }

        private void handleCellDelete() {
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCellEditor tableCellEditor;
                    Component component;
                    int n = PropsTable.this.getSelectedRow();
                    int n2 = PropsTable.this.getSelectedColumn();
                    AttrType attrType = (AttrType)((Object)PropertiesPanel.this.mRowTypes.get(n));
                    if (n2 == 1 && PropsTable.this.canDelete(attrType) && PropsTable.this.editCellAt(n, n2) && (component = (tableCellEditor = PropsTable.this.getCellEditor()).getTableCellEditorComponent(PropsTable.this, "", false, n, n2)) instanceof JTextField) {
                        ((JTextField)component).setText("");
                    }
                }
            };
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(127, 0), "DeleteRow");
            this.getActionMap().put("DeleteRow", abstractAction);
        }

        private void setupTableTabPolicy() {
            InputMap inputMap = this.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 1);
            final Action action = this.getActionMap().get(inputMap.get(keyStroke));
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = jTable.getRowCount();
                    int n2 = jTable.getColumnCount();
                    int n3 = jTable.getSelectedRow();
                    int n4 = jTable.getSelectedColumn();
                    if (n4 == n2 - 1 && n3 == n - 1) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    } else if (action != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            };
            this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
            final Action action2 = this.getActionMap().get(inputMap.get(keyStroke2));
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = jTable.getSelectedRow();
                    int n2 = jTable.getSelectedColumn();
                    if (n2 == 0 && n == 0) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    } else if (action2 != null) {
                        action2.actionPerformed(actionEvent);
                    }
                }
            };
            this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
        }

        private void buildDialogProperties(Vector<Vector<Object>> vector) {
            Object object;
            Object object2;
            Object object3;
            String string;
            ButtonEditCtrl buttonEditCtrl;
            Vector<Object> vector2;
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            String string2 = dialogDefinition.isSubDialog() ? "IDS_SUBDLG_ID" : "IDS_EXT_NAME";
            this.setupRow(dialogDefinition.getDialogId(), vector, string2, AttrType.elementId);
            if (!dialogDefinition.isSubDialog() && BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                PropertiesPanel.this.mFrame.isDlgMenuExist(dialogDefinition.getDialogId(), dialogDefinition.getCommandLocation(), false);
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_MENU_LOCATION"));
                vector2.add(dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)PropertiesPanel.this));
                vector.add(vector2);
                buttonEditCtrl = new ButtonEditCtrl(1);
                buttonEditCtrl.setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
                buttonEditCtrl.setReadOnlyEdit(true);
                buttonEditCtrl.addButtonListener(this);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(buttonEditCtrl);
                PropertiesPanel.this.mRowTypes.add(AttrType.menuItem);
            }
            this.setupRow(dialogDefinition.getDialogTitle(), vector, "IDS_TITLE", AttrType.title);
            vector2 = new Vector<Object>();
            vector2.add(BuilderResUtil.getString("IDS_HELPFILE"));
            vector2.add(dialogDefinition.getHelpFileName());
            vector.add(vector2);
            buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
            buttonEditCtrl.setReadOnlyEdit(false);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.helpFile);
            if (!dialogDefinition.isSubDialog()) {
                if (BuilderUtil.getInstance().getAppType() != AppType.STATS) {
                    string = BuilderResUtil.getString("IDS_SCRIPT_SYNTAX");
                    object3 = BuilderResUtil.getString("IDS_SCRIPT_R");
                    object2 = BuilderUtil.getInstance().getAppType() == AppType.MODELER ? BuilderResUtil.getString("IDS_SCRIPT_PYSPARK") : BuilderResUtil.getString("IDS_SCRIPT_PYTHON");
                    vector2 = new Vector();
                    vector2.add(BuilderResUtil.getString("IDS_SCRIPT_TYPE"));
                    object = PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.R ? object3 : (PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.PYTHON ? object2 : string);
                    vector2.add(object);
                    vector.add(vector2);
                    Object[] objectArray = dialogDefinition.getAppType() == AppType.STATS ? new Object[]{new ComboItem<ScriptType>(string, ScriptType.SYNTAX), new ComboItem<ScriptType>((String)object3, ScriptType.R), new ComboItem<ScriptType>((String)object2, ScriptType.PYTHON)} : new Object[]{new ComboItem<ScriptType>((String)object3, ScriptType.R), new ComboItem<ScriptType>((String)object2, ScriptType.PYTHON)};
                    this.mRenderers.add(this.getDefaultRenderer(String.class));
                    final ComboEditor comboEditor = new ComboEditor(objectArray);
                    comboEditor.mComboBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent itemEvent) {
                            int n = comboEditor.mComboBox.getSelectedIndex();
                            if (n == 0) {
                                PropertiesPanel.this.mDlgDef.getRequiredAddOns().add(AddOnType.R);
                                PropertiesPanel.this.mDlgDef.getRequiredAddOns().remove(AddOnType.Python);
                                if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                                    final int n2 = PropertiesPanel.this.mPropTable.getSelectedRow();
                                    final int n3 = PropertiesPanel.this.mPropTable.getSelectedColumn();
                                    Object[] objectArray = PropsTable.this.getNodeTypeList();
                                    ComboItem comboItem = objectArray[1];
                                    final ComboEditor comboEditor2 = new ComboEditor(objectArray);
                                    comboEditor2.mComboBox.addItemListener(new ItemListener(){

                                        @Override
                                        public void itemStateChanged(ItemEvent itemEvent) {
                                            int n = comboEditor2.mComboBox.getSelectedIndex();
                                            if (n >= 0) {
                                                Object[] objectArray = PropsTable.this.getPaletteTypeList(n);
                                                ComboItem comboItem = objectArray[0];
                                                PropsTable.this.mEditors.setElementAt(new ComboEditor(objectArray), n2 + 4);
                                                PropertiesPanel.this.mPropTable.setValueAt(comboItem.getLabel(), n2 + 4, n3);
                                                PropertiesPanel.this.mDlgDef.setNodePalette((PaletteType)comboItem.getData());
                                            }
                                        }
                                    });
                                    PropsTable.this.mEditors.setElementAt(comboEditor2, n2 + 3);
                                    PropertiesPanel.this.mPropTable.setValueAt(comboItem.getLabel(), n2 + 3, n3);
                                    PropertiesPanel.this.mDlgDef.setNodeType((NodeType)comboItem.getData());
                                    Object[] objectArray2 = PropsTable.this.getPaletteTypeList(1);
                                    ComboItem comboItem2 = objectArray2[0];
                                    PropsTable.this.mEditors.setElementAt(new ComboEditor(objectArray2), n2 + 4);
                                    PropertiesPanel.this.mPropTable.setValueAt(comboItem2.getLabel(), n2 + 4, n3);
                                    PropertiesPanel.this.mDlgDef.setNodePalette((PaletteType)comboItem2.getData());
                                }
                            } else if (n == 1) {
                                final int n4 = PropertiesPanel.this.mPropTable.getSelectedRow();
                                final int n5 = PropertiesPanel.this.mPropTable.getSelectedColumn();
                                if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                                    PropertiesPanel.this.mDlgDef.getRequiredAddOns().add(AddOnType.Python);
                                    PropertiesPanel.this.mDlgDef.getRequiredAddOns().remove(AddOnType.R);
                                    PropertiesPanel.this.mPropTable.setValueAt(PropsTable.this.buildAddOnsValue(PropertiesPanel.this.getDlgDef()), n4 + 1, n5);
                                } else {
                                    PropertiesPanel.this.mDlgDef.getRequiredAddOns().add(AddOnType.Python);
                                    PropertiesPanel.this.mDlgDef.getRequiredAddOns().remove(AddOnType.R);
                                    Object[] objectArray = PropsTable.this.getNodeTypeList();
                                    ComboItem comboItem = objectArray[1];
                                    final ComboEditor comboEditor3 = new ComboEditor(objectArray);
                                    comboEditor3.mComboBox.addItemListener(new ItemListener(){

                                        @Override
                                        public void itemStateChanged(ItemEvent itemEvent) {
                                            int n = comboEditor3.mComboBox.getSelectedIndex();
                                            if (n >= 0) {
                                                Object[] objectArray = PropsTable.this.getPaletteTypeList(n);
                                                ComboItem comboItem = objectArray[0];
                                                PropsTable.this.mEditors.setElementAt(new ComboEditor(objectArray), n4 + 4);
                                                PropertiesPanel.this.mPropTable.setValueAt(comboItem.getLabel(), n4 + 4, n5);
                                                PropertiesPanel.this.mDlgDef.setNodePalette((PaletteType)comboItem.getData());
                                            }
                                        }
                                    });
                                    PropsTable.this.mEditors.setElementAt(comboEditor3, n4 + 3);
                                    PropertiesPanel.this.mPropTable.setValueAt(comboItem.getLabel(), n4 + 3, n5);
                                    PropertiesPanel.this.mDlgDef.setNodeType((NodeType)comboItem.getData());
                                    Object[] objectArray3 = PropsTable.this.getPaletteTypeList(1);
                                    ComboItem comboItem3 = objectArray3[0];
                                    PropsTable.this.mEditors.setElementAt(new ComboEditor(objectArray3), n4 + 4);
                                    PropertiesPanel.this.mPropTable.setValueAt(comboItem3.getLabel(), n4 + 4, n5);
                                    PropertiesPanel.this.mDlgDef.setNodePalette((PaletteType)comboItem3.getData());
                                }
                            }
                        }
                    });
                    this.mEditors.add(comboEditor);
                    PropertiesPanel.this.mRowTypes.add(AttrType.scriptType);
                    if (PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.R) {
                        PropertiesPanel.this.mDlgDef.getRequiredAddOns().add(AddOnType.R);
                        PropertiesPanel.this.mDlgDef.getRequiredAddOns().remove(AddOnType.Python);
                    } else if (PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.PYTHON) {
                        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                            PropertiesPanel.this.mDlgDef.getRequiredAddOns().add(AddOnType.Python);
                            PropertiesPanel.this.mDlgDef.getRequiredAddOns().remove(AddOnType.R);
                        } else {
                            PropertiesPanel.this.mDlgDef.getRequiredAddOns().remove(AddOnType.Python);
                            PropertiesPanel.this.mDlgDef.getRequiredAddOns().remove(AddOnType.R);
                        }
                    }
                }
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS && PropertiesPanel.this.mDlgDef.IsCompatMode()) {
                    vector2 = new Vector();
                    vector2.add(BuilderResUtil.getString("IDS_REQUIRED_ADD_ONS"));
                    string = this.buildAddOnsValue(dialogDefinition);
                    vector2.add(string);
                    vector.add(vector2);
                    buttonEditCtrl = new ButtonEditCtrl(1);
                    buttonEditCtrl.setReadOnlyEdit(true);
                    buttonEditCtrl.addButtonListener(this);
                    this.mRenderers.add(this.getDefaultRenderer(String.class));
                    this.mEditors.add(buttonEditCtrl);
                    PropertiesPanel.this.mRowTypes.add(AttrType.requiredAddOns);
                    PropertiesPanel.this.adjustFont(vector.size() - 1, buttonEditCtrl);
                }
            }
            if (!dialogDefinition.isSubDialog() && BuilderUtil.getInstance().getAppType() != AppType.STATS) {
                string = BuilderResUtil.getString("IDS_TRUE");
                object3 = BuilderResUtil.getString("IDS_FALSE");
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_SCORE_FROM_MODEL"));
                vector2.add(PropertiesPanel.this.mDlgDef.canScore() ? string : object3);
                vector.add(vector2);
                object2 = new Object[]{new ComboItem<Boolean>((String)object3, Boolean.FALSE), new ComboItem<Boolean>(string, Boolean.TRUE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                object = new ComboEditor((Object[])object2);
                ((ComboEditor)object).mComboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getItem().toString().equals(string)) {
                            PropertiesPanel.this.mDlgDef.setCanScore(true);
                            PropertiesPanel.this.mDlgDef.setNodeType(NodeType.MODEL);
                            ComboEditor comboEditor = (ComboEditor)PropsTable.this.mEditors.get(6);
                            comboEditor.mComboBox.setSelectedIndex(0);
                            PropertiesPanel.this.mPropTable.setValueAt(BuilderResUtil.getString("IDS_NODE_MODEL"), 6, 1);
                            Object[] objectArray = PropsTable.this.getPaletteTypeList(1);
                            ComboItem comboItem = objectArray[0];
                            PropsTable.this.mEditors.setElementAt(new ComboEditor(objectArray), 7);
                            PropertiesPanel.this.mPropTable.setValueAt(comboItem.getLabel(), 7, 1);
                            PropertiesPanel.this.mDlgDef.setNodePalette((PaletteType)comboItem.getData());
                        } else {
                            PropertiesPanel.this.mDlgDef.setCanScore(false);
                        }
                    }
                });
                this.mEditors.add((TableCellEditor)object);
                PropertiesPanel.this.mRowTypes.add(AttrType.canScore);
            }
            if (!dialogDefinition.isSubDialog() && BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_WEBAPP_PROPERTIES"));
                vector2.add(dialogDefinition.getCustomPropertiesFile());
                vector.add(vector2);
                buttonEditCtrl = new ButtonEditCtrl(1);
                buttonEditCtrl.setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
                buttonEditCtrl.setReadOnlyEdit(true);
                buttonEditCtrl.addButtonListener(this);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(buttonEditCtrl);
                PropertiesPanel.this.mRowTypes.add(AttrType.customPath);
                string = BuilderResUtil.getString("IDS_TRUE");
                object3 = BuilderResUtil.getString("IDS_FALSE");
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_MODELESS"));
                vector2.add(PropertiesPanel.this.mDlgDef.isModal() ? object3 : string);
                vector.add(vector2);
                object2 = new Object[]{new ComboItem<Boolean>((String)object3, Boolean.FALSE), new ComboItem<Boolean>(string, Boolean.TRUE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(new ComboEditor((Object[])object2));
                PropertiesPanel.this.mRowTypes.add(AttrType.modal);
            }
            if (!dialogDefinition.isSubDialog() && BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                int n;
                this.setupRow("", vector, "IDS_PROPERTY_HEADER_M", AttrType.propHeader);
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_NODE_TYPE"));
                if (PropertiesPanel.this.mDlgDef.getNodeType() == NodeType.IMPORT) {
                    vector2.add(this.getNodeTypeLabel(NodeType.IMPORT));
                    n = 0;
                } else if (PropertiesPanel.this.mDlgDef.getNodeType() == NodeType.MODEL) {
                    vector2.add(this.getNodeTypeLabel(NodeType.MODEL));
                    n = 1;
                } else if (PropertiesPanel.this.mDlgDef.getNodeType() == NodeType.PROCESS) {
                    vector2.add(this.getNodeTypeLabel(NodeType.PROCESS));
                    n = 2;
                } else if (PropertiesPanel.this.mDlgDef.getNodeType() == NodeType.OUTPUT) {
                    vector2.add(this.getNodeTypeLabel(NodeType.OUTPUT));
                    n = 3;
                } else {
                    vector2.add(this.getNodeTypeLabel(NodeType.EXPORT));
                    n = 4;
                }
                vector.add(vector2);
                object3 = this.getNodeTypeList();
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                object2 = new ComboEditor((Object[])object3);
                ((ComboEditor)object2).mComboBox.addItemListener(new ItemListener((ComboEditor)object2){
                    final /* synthetic */ ComboEditor val$nodeTypeEditor;
                    {
                        this.val$nodeTypeEditor = comboEditor;
                    }

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        int n = 6;
                        int n2 = PropertiesPanel.this.mPropTable.getSelectedColumn();
                        int n3 = this.val$nodeTypeEditor.mComboBox.getSelectedIndex();
                        if (n3 >= 0) {
                            Object[] objectArray = PropsTable.this.getPaletteTypeList(n3);
                            ComboItem comboItem = objectArray[0];
                            PropsTable.this.mEditors.setElementAt(new ComboEditor(objectArray), n + 1);
                            PropertiesPanel.this.mPropTable.setValueAt(comboItem.getLabel(), n + 1, n2);
                            PropertiesPanel.this.mDlgDef.setNodePalette((PaletteType)comboItem.getData());
                        }
                    }
                });
                this.mEditors.add((TableCellEditor)object2);
                PropertiesPanel.this.mRowTypes.add(AttrType.nodeType);
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_NODE_PALETTE"));
                vector2.add(this.getPaletteLabel(PropertiesPanel.this.mDlgDef.getNodePalette()));
                vector.add(vector2);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(new ComboEditor(this.getPaletteTypeList(n)));
                PropertiesPanel.this.mRowTypes.add(AttrType.palette);
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_NODE_ICON"));
                vector2.add(dialogDefinition.getNodeIconFile());
                vector.add(vector2);
                buttonEditCtrl = new ButtonEditCtrl(1);
                buttonEditCtrl.setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
                buttonEditCtrl.setReadOnlyEdit(false);
                buttonEditCtrl.addButtonListener(this);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(buttonEditCtrl);
                PropertiesPanel.this.mRowTypes.add(AttrType.nodeImage);
            }
            if (!dialogDefinition.isSubDialog() && BuilderUtil.getInstance().getAppType() == AppType.STATS && PropertiesPanel.this.mDlgDef.hasDataselector()) {
                String string3 = BuilderResUtil.getString("IDS_ACTIVE_DATASET_TO_EDIT");
                if (PropertiesPanel.this.mDlgDef.getDatasetSeletorId().length() > 0) {
                    string3 = PropertiesPanel.this.mDlgDef.getDatasetSeletorId();
                    string3 = PropertiesPanel.this.getDlgFieldSourceString(string3, true);
                }
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_DLG_DATA_SOURCE"));
                vector2.add(string3);
                vector.add(vector2);
                object3 = new ButtonEditCtrl(1);
                ((ButtonEditCtrl)object3).setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
                ((ButtonEditCtrl)object3).setReadOnlyEdit(true);
                ((ButtonEditCtrl)object3).addButtonListener(this);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add((TableCellEditor)object3);
                PropertiesPanel.this.mRowTypes.add(AttrType.fieldSource);
            }
        }

        private String getNodeTypeLabel(NodeType nodeType) {
            return BuilderResUtil.getString("IDS_NODE_" + nodeType.name());
        }

        private ComboItem<NodeType>[] getNodeTypeList() {
            return new ComboItem[]{new ComboItem<NodeType>(this.getNodeTypeLabel(NodeType.IMPORT), NodeType.IMPORT), new ComboItem<NodeType>(this.getNodeTypeLabel(NodeType.MODEL), NodeType.MODEL), new ComboItem<NodeType>(this.getNodeTypeLabel(NodeType.PROCESS), NodeType.PROCESS), new ComboItem<NodeType>(this.getNodeTypeLabel(NodeType.OUTPUT), NodeType.OUTPUT), new ComboItem<NodeType>(this.getNodeTypeLabel(NodeType.EXPORT), NodeType.EXPORT)};
        }

        private ComboItem<PaletteType>[] getPaletteTypeList(int n) {
            ComboItem[] comboItemArray = n == 0 ? new ComboItem[]{new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.SOURCES), PaletteType.SOURCES)} : (n == 1 ? new ComboItem[]{new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.MODELING), PaletteType.MODELING), new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.MODELINGANS), PaletteType.MODELINGANS), new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.MODELINGCLA), PaletteType.MODELINGCLA), new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.MODELINGAS), PaletteType.MODELINGAS), new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.MODELINGSE), PaletteType.MODELINGSE)} : (n == 2 ? new ComboItem[]{new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.RECORDOPS), PaletteType.RECORDOPS), new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.FIELDOPS), PaletteType.FIELDOPS)} : (n == 3 ? new ComboItem[]{new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.GRAPHS), PaletteType.GRAPHS), new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.OUTPUT), PaletteType.OUTPUT)} : new ComboItem[]{new ComboItem<PaletteType>(this.getPaletteLabel(PaletteType.EXPORT), PaletteType.EXPORT)})));
            return comboItemArray;
        }

        private String getPaletteLabel(PaletteType paletteType) {
            return BuilderResUtil.getString("IDS_NODE_PALETTE_" + paletteType.name());
        }

        private String buildAddOnsValue(DialogDefinition dialogDefinition) {
            HashMap<AddOnType, String> hashMap = new HashMap<AddOnType, String>();
            hashMap.put(AddOnType.R, BuilderResUtil.getString("IDS_R_PROGRAMMABILITY"));
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                hashMap.put(AddOnType.Python, BuilderResUtil.getString("IDS_PYSPARK_PROGRAMMABILITY"));
            } else {
                hashMap.put(AddOnType.Python, BuilderResUtil.getString("IDS_PYTHON_PROGRAMMABILITY"));
            }
            StringBuilder stringBuilder = new StringBuilder();
            Set set = dialogDefinition.getRequiredAddOns();
            HashSet<AddOnType> hashSet = new HashSet<AddOnType>();
            for (AddOnType addOnType : set) {
                if (PropertiesPanel.this.mDlgDef.getAppType() == AppType.MODELER && PropertiesPanel.this.mDlgDef.getScriptType() == ScriptType.PYTHON) continue;
                hashSet.add(addOnType);
            }
            set.clear();
            set.addAll(hashSet);
            if (set.size() > 0) {
                for (AddOnType addOnType : set) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append((String)hashMap.get(addOnType));
                }
            } else {
                stringBuilder.append(BuilderResUtil.getString("IDS_NONE"));
            }
            return stringBuilder.toString();
        }

        private void addTitlePosition(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            boolean bl;
            PanelElementDefinition panelElementDefinition = canvasObject.getCtrlDef();
            boolean bl2 = bl = panelElementDefinition instanceof EditCtrlDefinition || panelElementDefinition instanceof SpinnerDefinition || panelElementDefinition instanceof ColorPickerDefinition || panelElementDefinition instanceof ComboBoxDefinition || panelElementDefinition instanceof FileSystemBrowserDefinition || panelElementDefinition instanceof FieldChooserDefinition && ((FieldChooserDefinition)panelElementDefinition).getChooserType() == FieldChooserDefinition.ChooserType.single;
            if (bl) {
                boolean bl3 = panelElementDefinition.isLabelAbove();
                String string = BuilderResUtil.getString("IDS_TITLE_POSITION_TOP");
                String string2 = BuilderResUtil.getString("IDS_TITLE_POSITION_LEFT");
                Vector<String> vector2 = new Vector<String>();
                vector2.add(BuilderResUtil.getString("IDS_TITLE_POSITION"));
                vector2.add(bl3 ? string : string2);
                vector.add(vector2);
                Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.TRUE), new ComboItem<Boolean>(string2, Boolean.FALSE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                ComboEditor comboEditor = new ComboEditor(objectArray);
                comboEditor.mComboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (PropsTable.this.isEditing()) {
                            PropsTable.this.getCellEditor().stopCellEditing();
                        }
                        PropertiesPanel.this.refreshCanvas();
                    }
                });
                this.mEditors.add(comboEditor);
                PropertiesPanel.this.mRowTypes.add(AttrType.titlePos);
            }
        }

        private void addControlProperties(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            if (canvasObject instanceof SrcListObject) {
                this.addSrcListProperties(vector, canvasObject);
            } else if (canvasObject instanceof TargetListObject) {
                this.addTargetListProperties(vector, (TargetListObject)canvasObject);
            } else if (canvasObject instanceof FieldChooserObject) {
                this.addFieldChooserProperties(vector, (FieldChooserObject)canvasObject);
            } else if (canvasObject instanceof SubDlgButtonObject) {
                this.addSubDlgButtonProperties(vector, (SubDlgButtonObject)canvasObject);
            } else if (canvasObject instanceof RadioGroupObject) {
                this.addRadioGroupProperties(vector, (RadioGroupObject)canvasObject);
            } else if (canvasObject instanceof ComboBoxObject) {
                this.addComboBoxProperties(vector, (ComboBoxObject)canvasObject);
            } else if (canvasObject instanceof TableCtrlObject) {
                this.addGridCtrlProperties(vector, (TableCtrlObject)canvasObject);
            } else if (canvasObject instanceof ListBoxObject) {
                this.addListBoxProperties(vector, (ListBoxObject)canvasObject);
            } else if (canvasObject instanceof DatasetSelectorObject) {
                this.addDatasetSelectorProperties(vector, (DatasetSelectorObject)canvasObject);
            } else if (canvasObject instanceof EditCtrlObject) {
                this.addEditCtrlProperties(vector, (EditCtrlObject)canvasObject);
            } else if (canvasObject instanceof SpinnerCtrlObject) {
                this.addSpinnerCtrlProperties(vector, (SpinnerCtrlObject)canvasObject);
            } else if (canvasObject instanceof ColorPickerCtrlObject) {
                this.addColorPickerCtrlProperties(vector, (ColorPickerCtrlObject)canvasObject);
            } else if (canvasObject instanceof StaticImageObject) {
                this.addStaticImageProperties(vector, (StaticImageObject)canvasObject);
            } else if (canvasObject instanceof CheckBoxObject) {
                this.addCheckboxProperties(vector, (CheckBoxObject)canvasObject);
            } else if (canvasObject instanceof CheckBoxGroupObject) {
                this.addCheckboxGroupProperties(vector, (CheckBoxGroupObject)canvasObject);
            } else if (canvasObject instanceof ItemGroupObject) {
                this.addItemGroupProperties(vector, (ItemGroupObject)canvasObject);
            } else if (canvasObject instanceof FileSystemBrowserObject) {
                this.addFSBProperties(vector, (FileSystemBrowserObject)canvasObject);
            } else if (canvasObject instanceof TabObject) {
                this.addTabCtrlProperty(vector);
            }
        }

        private void addTabCtrlProperty(Vector<Vector<Object>> vector) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_TAB_POSITION"));
            int n = PropertiesPanel.this.getBuilderFrame().getTabbedPane().getSelectedIndex();
            String string = String.valueOf(n + 1);
            vector2.add(string);
            vector.add(vector2);
            int n2 = PropertiesPanel.this.getBuilderFrame().getTabbedPane().getTabCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = i == n ? new ComboItem<Boolean>(String.valueOf(i + 1), Boolean.TRUE) : new ComboItem<Boolean>(String.valueOf(i + 1), Boolean.FALSE);
            }
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            ComboEditor comboEditor = new ComboEditor(objectArray);
            comboEditor.setTabOrderListener(PropertiesPanel.this.getBuilderFrame());
            this.mEditors.add(comboEditor);
            PropertiesPanel.this.mRowTypes.add(AttrType.position);
        }

        private void addItemGroupProperties(Vector<Vector<Object>> vector, ItemGroupObject itemGroupObject) {
            this.addRequiredProperty(vector, itemGroupObject);
        }

        private void addRequiredProperty(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            String string = BuilderResUtil.getString("IDS_TRUE");
            String string2 = BuilderResUtil.getString("IDS_FALSE");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_IS_REQUIRED"));
            vector2.add(canvasObject.getCtrlDef().isRequired() ? string : string2);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<Boolean>(string2, Boolean.FALSE), new ComboItem<Boolean>(string, Boolean.TRUE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.required);
        }

        private void addSeparatorProperty(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            FieldChooserDefinition.SeparatorType separatorType;
            String string = BuilderResUtil.getString("IDS_SEPARATOR_TYPE_COMMA");
            String string2 = BuilderResUtil.getString("IDS_SEPARATOR_TYPE_BLANK");
            String string3 = BuilderResUtil.getString("IDS_SEPARATOR_TYPE_PLUS");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_SEPARATOR_TYPE"));
            if (canvasObject instanceof FieldChooserObject) {
                separatorType = ((FieldChooserObject)canvasObject).getChooserDef().getSeparatorType();
            } else if (canvasObject instanceof TargetListObject) {
                separatorType = ((TargetListDefinition)canvasObject.getCtrlDef()).getSeparatorType();
            } else if (canvasObject instanceof ListBoxObject) {
                separatorType = ((ListBoxObject)canvasObject).getListDef().getSeparatorType();
            } else {
                return;
            }
            if (separatorType == FieldChooserDefinition.SeparatorType.comma) {
                vector2.add(string);
            } else if (separatorType == FieldChooserDefinition.SeparatorType.blank) {
                vector2.add(string2);
            } else if (separatorType == FieldChooserDefinition.SeparatorType.plus) {
                vector2.add(string3);
            }
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<FieldChooserDefinition.SeparatorType>(string, FieldChooserDefinition.SeparatorType.comma), new ComboItem<FieldChooserDefinition.SeparatorType>(string2, FieldChooserDefinition.SeparatorType.blank), new ComboItem<FieldChooserDefinition.SeparatorType>(string3, FieldChooserDefinition.SeparatorType.plus)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            ComboEditor comboEditor = new ComboEditor(objectArray);
            this.mEditors.add(comboEditor);
            PropertiesPanel.this.mRowTypes.add(AttrType.separator);
        }

        private void addQuotationProperty(Vector<Vector<Object>> vector, FieldChooserObject fieldChooserObject) {
            String string = BuilderResUtil.getString("IDS_QUOTATION_MARK_TYPE_NONE");
            String string2 = BuilderResUtil.getString("IDS_QUOTATION_MARK_TYPE_SINGLE");
            String string3 = BuilderResUtil.getString("IDS_QUOTATION_MARK_TYPE_DOUBLE");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_QUOTATION_MARK_TYPE"));
            if (fieldChooserObject.getChooserDef().getQuotationMarkType() == FieldChooserDefinition.QuotationMarkType.none) {
                vector2.add(string);
            } else if (fieldChooserObject.getChooserDef().getQuotationMarkType() == FieldChooserDefinition.QuotationMarkType.single) {
                vector2.add(string2);
            } else if (fieldChooserObject.getChooserDef().getQuotationMarkType() == FieldChooserDefinition.QuotationMarkType.doubleq) {
                vector2.add(string3);
            }
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<FieldChooserDefinition.QuotationMarkType>(string, FieldChooserDefinition.QuotationMarkType.none), new ComboItem<FieldChooserDefinition.QuotationMarkType>(string2, FieldChooserDefinition.QuotationMarkType.single), new ComboItem<FieldChooserDefinition.QuotationMarkType>(string3, FieldChooserDefinition.QuotationMarkType.doubleq)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            ComboEditor comboEditor = new ComboEditor(objectArray);
            this.mEditors.add(comboEditor);
            PropertiesPanel.this.mRowTypes.add(AttrType.quotation);
        }

        private void addFSBProperties(Vector<Vector<Object>> vector, FileSystemBrowserObject fileSystemBrowserObject) {
            FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)fileSystemBrowserObject.getCtrlDef();
            this.addMnemonicRow(vector, fileSystemBrowserObject);
            String string = BuilderResUtil.getString("IDS_OPEN");
            String string2 = BuilderResUtil.getString("IDS_SAVE");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_FILE_SYSTEM_OP"));
            vector2.add(fileSystemBrowserDefinition.isOpenDialog() ? string : string2);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.TRUE), new ComboItem<Boolean>(string2, Boolean.FALSE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.browserOp);
            String string3 = BuilderResUtil.getString("IDS_LOCATE_FOLDER");
            String string4 = BuilderResUtil.getString("IDS_LOCATE_FILE");
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_BROWSER_TYPE"));
            vector2.add(fileSystemBrowserDefinition.isDirectoryBrowser() ? string3 : string4);
            vector.add(vector2);
            objectArray = new Object[]{new ComboItem<Boolean>(string4, Boolean.FALSE), new ComboItem<Boolean>(string3, Boolean.TRUE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.browserType);
            String string5 = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_FILE_FILTER"));
            vector2.add(string5);
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(fileSystemBrowserObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.fileFilters);
            String string6 = BuilderResUtil.getString("IDS_CLIENT");
            String string7 = BuilderResUtil.getString("IDS_SERVER");
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_FILE_SYSTEM_TYPE"));
            vector2.add(fileSystemBrowserDefinition.isServerFileSystemBrowser() ? string7 : string6);
            vector.add(vector2);
            objectArray = new Object[]{new ComboItem<Boolean>(string6, Boolean.TRUE), new ComboItem<Boolean>(string7, Boolean.FALSE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.browserSystem);
            this.addRequiredProperty(vector, fileSystemBrowserObject);
            string5 = fileSystemBrowserDefinition.getDefaultValue() != null ? fileSystemBrowserDefinition.getDefaultValue() : "";
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_DEFAULT"));
            vector2.add(string5);
            vector.add(vector2);
            buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(fileSystemBrowserObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(false);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.defaultValue);
        }

        private void addCheckboxGroupProperties(Vector<Vector<Object>> vector, CheckBoxGroupObject checkBoxGroupObject) {
            CheckBoxObject checkBoxObject = (CheckBoxObject)checkBoxGroupObject.getComponent(0);
            this.setupRow(checkBoxObject.getControlTitle(), vector, "IDS_CHECKBOX_TITLE", AttrType.subTitle);
            this.setupRow(checkBoxObject.getControlTip(), vector, "IDS_TIP", AttrType.tip);
            this.addMnemonicRow(vector, checkBoxObject);
            this.addDefaultCheckState(vector, checkBoxObject);
        }

        private void addCheckboxProperties(Vector<Vector<Object>> vector, CheckBoxObject checkBoxObject) {
            this.addMnemonicRow(vector, checkBoxObject);
            this.addDefaultCheckState(vector, checkBoxObject);
        }

        private void addSrcListProperties(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            SrcListDefinition srcListDefinition = (SrcListDefinition)canvasObject.getCtrlDef();
            this.addMnemonicRow(vector, canvasObject);
            String string = BuilderResUtil.getString("IDS_MOVE_VARS");
            String string2 = BuilderResUtil.getString("IDS_COPY_VARS");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_TRANSFER_OP"));
            vector2.add(srcListDefinition.getTransferOp() == SrcListDefinition.TransferOp.move ? string : string2);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.FALSE), new ComboItem<Boolean>(string2, Boolean.TRUE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.copyMove);
            this.addVarFilterRow(vector, canvasObject);
        }

        private void addVarFilterRow(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            String string = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_VAR_FILTER"));
            vector2.add(string);
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(canvasObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.varFilters);
        }

        private void addFieldSource(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            String string = ((FieldChooserDefinition)canvasObject.getCtrlDef()).getFieldSourceID();
            if (string.length() == 0 || PropertiesPanel.this.mDlgDef.getPanelElement(string) == null) {
                string = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
                if (PropertiesPanel.this.mDlgDef.getPanelElement(string) == null) {
                    ((FieldChooserDefinition)canvasObject.getCtrlDef()).setFieldSourceID("");
                }
            } else {
                string = PropertiesPanel.this.getFieldSourceString(string, true, ((FieldChooserDefinition)canvasObject.getCtrlDef()).isFieldSourceInclude());
            }
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_FIELD_CHOOSER_SOURCE"));
            vector2.add(string);
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(canvasObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.fieldSource);
        }

        private void addComboBoxProperties(Vector<Vector<Object>> vector, ComboBoxObject comboBoxObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_DEFINE_LIST"));
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TO_EDIT"));
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(comboBoxObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.itemList);
            this.addMnemonicRow(vector, comboBoxObject);
            if (!PropertiesPanel.this.mDlgDef.IsCompatMode()) {
                boolean bl = comboBoxObject.getComboDef().isEditable();
                String string = BuilderResUtil.getString("IDS_TRUE");
                String string2 = BuilderResUtil.getString("IDS_FALSE");
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_COMBOBOX_EDITABLE"));
                vector2.add(bl ? string : string2);
                vector.add(vector2);
                Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.TRUE), new ComboItem<Boolean>(string2, Boolean.FALSE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(new ComboEditor(objectArray));
                PropertiesPanel.this.mRowTypes.add(AttrType.comboEditable);
            }
        }

        private void addGridCtrlProperties(Vector<Vector<Object>> vector, TableCtrlObject tableCtrlObject) {
            this.addMnemonicRow(vector, tableCtrlObject);
            TableDefinition tableDefinition = (TableDefinition)tableCtrlObject.getCtrlDef();
            boolean bl = tableDefinition.isReorderRowAllowed();
            String string = BuilderResUtil.getString("IDS_TRUE");
            String string2 = BuilderResUtil.getString("IDS_FALSE");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_GRID_ACTIONS"));
            vector2.add(bl ? string : string2);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.TRUE), new ComboItem<Boolean>(string2, Boolean.FALSE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.tableAction);
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_GRID_COLUMNS"));
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TO_EDIT"));
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(tableCtrlObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.tableCol);
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_MIN_ROW_VALUE"));
            int n = tableDefinition.getMinRowNum();
            String string3 = n != Integer.MIN_VALUE ? Integer.toString(n) : "";
            vector2.add(UIToolResUtil.addLocale((String)string3));
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            IntTextField intTextField = new IntTextField();
            this.mEditors.add(new NumberEditor((SPSSTextField)intTextField));
            PropertiesPanel.this.mRowTypes.add(AttrType.minValue);
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_MAX_ROW_VALUE"));
            int n2 = tableDefinition.getMaxRowNum();
            string3 = n2 != Integer.MAX_VALUE ? Integer.toString(n2) : "";
            vector2.add(UIToolResUtil.addLocale((String)string3));
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            intTextField = new IntTextField();
            this.mEditors.add(new NumberEditor((SPSSTextField)intTextField));
            PropertiesPanel.this.mRowTypes.add(AttrType.maxValue);
            String string4 = tableDefinition.getKeyProviderName();
            if (PropertiesPanel.this.getBuilderFrame().getCanvas().findCanvasObject(string4) == null) {
                tableDefinition.setKeyProviderName("");
                tableDefinition.setKeyAttribute("");
            }
            this.addRequiredProperty(vector, tableCtrlObject);
        }

        private void addFieldChooserProperties(Vector<Vector<Object>> vector, FieldChooserObject fieldChooserObject) {
            this.addMnemonicRow(vector, fieldChooserObject);
            String string = BuilderResUtil.getString("IDS_CHOOSER_TYPE_SINGLE");
            String string2 = BuilderResUtil.getString("IDS_CHOOSER_TYPE_MULTIP");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_CHOOSER_TYPE"));
            String string3 = fieldChooserObject.getChooserDef().getChooserType() == FieldChooserDefinition.ChooserType.single ? string : string2;
            vector2.add(string3);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<FieldChooserDefinition.ChooserType>(string, FieldChooserDefinition.ChooserType.single), new ComboItem<FieldChooserDefinition.ChooserType>(string2, FieldChooserDefinition.ChooserType.multiple)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            ComboEditor comboEditor = new ComboEditor(objectArray);
            comboEditor.mComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    PropertiesPanel.this.mPropTable.buildModel(PropertiesPanel.this.mModel.mCanvasObject);
                }
            });
            this.mEditors.add(comboEditor);
            PropertiesPanel.this.mRowTypes.add(AttrType.chooserType);
            if (fieldChooserObject.getChooserDef().getChooserType() == FieldChooserDefinition.ChooserType.multiple) {
                this.addSeparatorProperty(vector, fieldChooserObject);
                if (BuilderUtil.getInstance().getAppType() != AppType.STATS) {
                    this.addQuotationProperty(vector, fieldChooserObject);
                }
                this.addMinMaxRow(vector, fieldChooserObject);
            }
            this.addRequiredProperty(vector, fieldChooserObject);
            this.addVarFilterRow(vector, fieldChooserObject);
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                if (!PropertiesPanel.this.mDlgDef.IsCompatMode() && (PropertiesPanel.this.mDlgDef.hasTargetList() || PropertiesPanel.this.mDlgDef.hasFieldChooser(fieldChooserObject.getChooserDef().getControlId()))) {
                    this.addFieldSource(vector, fieldChooserObject);
                }
            } else if (BuilderUtil.getInstance().getAppType() == AppType.MODELER && PropertiesPanel.this.mDlgDef.hasFieldChooser(fieldChooserObject.getChooserDef().getControlId())) {
                this.addFieldSource(vector, fieldChooserObject);
            }
        }

        private void addListBoxProperties(Vector<Vector<Object>> vector, ListBoxObject listBoxObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_DEFINE_LIST"));
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TO_EDIT"));
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(listBoxObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.itemList);
            this.addMnemonicRow(vector, listBoxObject);
            ListBoxDefinition listBoxDefinition = listBoxObject.getListDef();
            String string = BuilderResUtil.getString("IDS_SINGLE_SELECT");
            String string2 = BuilderResUtil.getString("IDS_MULTIPLE_SELECT");
            String string3 = BuilderResUtil.getString("IDS_CHECK_SELECT");
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TYPE"));
            if (listBoxDefinition.getSelectionType() == ListBoxDefinition.SelectionType.single_select) {
                vector2.add(string);
            } else if (listBoxDefinition.getSelectionType() == ListBoxDefinition.SelectionType.multi_select) {
                vector2.add(string2);
            } else if (listBoxDefinition.getSelectionType() == ListBoxDefinition.SelectionType.checkbox_select) {
                vector2.add(string3);
            }
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<ListBoxDefinition.SelectionType>(string, ListBoxDefinition.SelectionType.single_select), new ComboItem<ListBoxDefinition.SelectionType>(string2, ListBoxDefinition.SelectionType.multi_select), new ComboItem<ListBoxDefinition.SelectionType>(string3, ListBoxDefinition.SelectionType.checkbox_select)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            ComboEditor comboEditor = new ComboEditor(objectArray);
            final boolean bl = BuilderUtil.getInstance().getAppType() == AppType.STATS && !PropertiesPanel.this.mDlgDef.IsCompatMode();
            comboEditor.mComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                        PropertiesPanel.this.mPropTable.buildModel(PropertiesPanel.this.mModel.mCanvasObject);
                    } else if (bl) {
                        PropertiesPanel.this.mPropTable.buildModel(PropertiesPanel.this.mModel.mCanvasObject);
                    }
                }
            });
            this.mEditors.add(comboEditor);
            PropertiesPanel.this.mRowTypes.add(AttrType.selectionType);
            if (!(listBoxDefinition.getSelectionType() != ListBoxDefinition.SelectionType.checkbox_select && listBoxDefinition.getSelectionType() != ListBoxDefinition.SelectionType.multi_select || !bl && BuilderUtil.getInstance().getAppType() != AppType.MODELER)) {
                this.addSeparatorProperty(vector, listBoxObject);
                this.addMinMaxRow(vector, listBoxObject);
            }
        }

        private void addDatasetSelectorProperties(Vector<Vector<Object>> vector, DatasetSelectorObject datasetSelectorObject) {
            this.addMnemonicRow(vector, datasetSelectorObject);
            this.addRequiredProperty(vector, datasetSelectorObject);
        }

        private void addRadioGroupProperties(Vector<Vector<Object>> vector, RadioGroupObject radioGroupObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_DEFINE_RADIOS"));
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TO_EDIT"));
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(radioGroupObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.radioItems);
        }

        private void addSubDlgButtonProperties(Vector<Vector<Object>> vector, SubDlgButtonObject subDlgButtonObject) {
            String string = subDlgButtonObject.getDialogDefinition().getDialogTitle();
            boolean bl = string != null && string.length() > 0;
            String string2 = bl ? string : BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_SUB_DIALOG"));
            vector2.add(string2);
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(subDlgButtonObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.getTextField().setText(subDlgButtonObject.getDialogDefinition().getDialogTitle());
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.launches);
            this.addMnemonicRow(vector, subDlgButtonObject);
        }

        private void addEditCtrlProperties(Vector<Vector<Object>> vector, EditCtrlObject editCtrlObject) {
            boolean bl;
            EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)editCtrlObject.getCtrlDef();
            this.addMnemonicRow(vector, editCtrlObject);
            if (editCtrlDefinition.isPasswordField()) {
                this.addPasswordCtrlProperties(vector, editCtrlObject);
                return;
            }
            EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
            boolean bl2 = bl = parseType == EditCtrlDefinition.ParseType.integer || parseType == EditCtrlDefinition.ParseType.number;
            if (bl) {
                Object object;
                String string;
                Double d;
                boolean bl3 = parseType == EditCtrlDefinition.ParseType.integer;
                String string2 = BuilderResUtil.getString("IDS_INTEGER");
                String string3 = BuilderResUtil.getString("IDS_NUMBER");
                Vector<Object> vector2 = new Vector<Object>();
                vector2.add(BuilderResUtil.getString("IDS_NUMBER_TYPE_FIELD"));
                vector2.add(bl3 ? string2 : string3);
                vector.add(vector2);
                Object[] objectArray = new Object[]{new ComboItem<Boolean>(string2, Boolean.TRUE), new ComboItem<Boolean>(string3, Boolean.FALSE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(new ComboEditor(objectArray));
                PropertiesPanel.this.mRowTypes.add(AttrType.editType);
                boolean bl4 = editCtrlDefinition.getDisplayType() == EditCtrlDefinition.DisplayType.textBox;
                String string4 = BuilderResUtil.getString("IDS_TRUE");
                String string5 = BuilderResUtil.getString("IDS_FALSE");
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_DISPLAY_TYPE"));
                vector2.add(bl4 ? string5 : string4);
                vector.add(vector2);
                Object[] objectArray2 = new Object[]{new ComboItem<Boolean>(string4, Boolean.TRUE), new ComboItem<Boolean>(string5, Boolean.FALSE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                ComboEditor comboEditor = new ComboEditor(objectArray2);
                comboEditor.mComboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        PropertiesPanel.this.mPropTable.buildModel(PropertiesPanel.this.mModel.mCanvasObject);
                    }
                });
                this.mEditors.add(comboEditor);
                PropertiesPanel.this.mRowTypes.add(AttrType.displayType);
                if (!bl4) {
                    vector2 = new Vector();
                    vector2.add(BuilderResUtil.getString("IDS_STEP_SIZE_VALUE"));
                    d = editCtrlDefinition.getStepSize();
                    string = !Double.isNaN(d) ? Double.toString(d) : "";
                    vector2.add(UIToolResUtil.addLocale((String)string));
                    vector.add(vector2);
                    this.mRenderers.add(this.getDefaultRenderer(String.class));
                    object = bl3 ? new IntTextField(true) : new FloatTextField(true);
                    this.mEditors.add(new StepSizeValueEditor((JTextField)object));
                    PropertiesPanel.this.mRowTypes.add(AttrType.stepSizeValue);
                }
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_DEFAULT_VALUE"));
                d = PropertiesPanel.this.mModel.string2Value(editCtrlDefinition.getDefaultValue(), parseType);
                vector2.add(!Double.isNaN(d) ? d : "");
                vector.add(vector2);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                object = bl3 ? new IntTextField() : new FloatTextField();
                this.mEditors.add(new NumberEditor((SPSSTextField)object));
                PropertiesPanel.this.mRowTypes.add(AttrType.defaultValue);
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_MIN_VALUE"));
                Double d2 = editCtrlDefinition.getMinValue();
                string = !Double.isNaN(d2) ? Double.toString(d2) : "";
                vector2.add(UIToolResUtil.addLocale((String)string));
                vector.add(vector2);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                object = bl3 ? new IntTextField() : new FloatTextField();
                this.mEditors.add(new NumberEditor((SPSSTextField)object));
                PropertiesPanel.this.mRowTypes.add(AttrType.minValue);
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_MAX_VALUE"));
                Double d3 = editCtrlDefinition.getMaxValue();
                string = !Double.isNaN(d3) ? Double.toString(d3) : "";
                vector2.add(UIToolResUtil.addLocale((String)string));
                vector.add(vector2);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                object = bl3 ? new IntTextField() : new FloatTextField();
                this.mEditors.add(new NumberEditor((SPSSTextField)object));
                PropertiesPanel.this.mRowTypes.add(AttrType.maxValue);
            } else {
                String string = BuilderResUtil.getString("IDS_TEXT_CONTENT_FIELD");
                String string6 = BuilderResUtil.getString("IDS_VARIABLE_NAME");
                String string7 = BuilderResUtil.getString("IDS_ANY");
                Vector<String> vector3 = new Vector<String>();
                vector3.add(string);
                if (PropertiesPanel.this.mDlgDef.IsCompatMode() || PropertiesPanel.this.mDlgDef.getAppType() == AppType.MODELER) {
                    vector3.add(parseType == EditCtrlDefinition.ParseType.variableName ? string6 : string7);
                    vector.add(vector3);
                    Object[] objectArray = new Object[]{new ComboItem<Boolean>(string6, Boolean.TRUE), new ComboItem<Boolean>(string7, Boolean.FALSE)};
                    this.mRenderers.add(this.getDefaultRenderer(String.class));
                    this.mEditors.add(new ComboEditor(objectArray));
                    PropertiesPanel.this.mRowTypes.add(AttrType.editType);
                } else {
                    vector3.add(this.getContentString(parseType));
                    vector.add(vector3);
                    Object[] objectArray = new Object[]{new ComboItem<EditCtrlDefinition.ParseType>(string7, EditCtrlDefinition.ParseType.string), new ComboItem<EditCtrlDefinition.ParseType>(string6, EditCtrlDefinition.ParseType.variableName), new ComboItem<EditCtrlDefinition.ParseType>(this.getContentString(EditCtrlDefinition.ParseType.newDatasetName), EditCtrlDefinition.ParseType.newDatasetName)};
                    this.mRenderers.add(this.getDefaultRenderer(String.class));
                    this.mEditors.add(new ComboEditor(objectArray));
                    PropertiesPanel.this.mRowTypes.add(AttrType.contentType);
                }
                this.setupRow(editCtrlDefinition.getDefaultValue(), vector, "IDS_DEFAULT_VALUE", AttrType.defaultValue);
            }
            if (!PropertiesPanel.this.mDlgDef.IsCompatMode()) {
                this.addTextColRow(vector, editCtrlObject);
            }
            this.addRequiredProperty(vector, editCtrlObject);
        }

        private void addTextColRow(Vector<Vector<Object>> vector, EditCtrlObject editCtrlObject) {
            EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)editCtrlObject.getCtrlDef();
            Vector<String> vector2 = new Vector<String>();
            String string = "";
            int n = editCtrlDefinition.getNumCols();
            if (n != Integer.MAX_VALUE) {
                string = Integer.toString(n);
            }
            vector2.add(BuilderResUtil.getString("IDS_WIDTH"));
            vector2.add(string);
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            IntTextField intTextField = new IntTextField(true);
            if (n == Integer.MAX_VALUE) {
                intTextField.setFont(PropertiesPanel.this.getItalicFont());
                intTextField.setForeground(Color.gray);
            }
            this.mEditors.add(new NumberEditor((SPSSTextField)intTextField));
            PropertiesPanel.this.mRowTypes.add(AttrType.textBoxCols);
        }

        private void addPasswordCtrlProperties(Vector<Vector<Object>> vector, EditCtrlObject editCtrlObject) {
            EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)editCtrlObject.getCtrlDef();
            if (PropertiesPanel.this.mDlgDef.getAppType() == AppType.STATS) {
                boolean bl = editCtrlDefinition.encryptSyntax();
                String string = BuilderResUtil.getString("IDS_TRUE");
                String string2 = BuilderResUtil.getString("IDS_FALSE");
                Vector<String> vector2 = new Vector<String>();
                vector2.add(BuilderResUtil.getString("IDS_IS_ENCRYPT_PASTED"));
                vector2.add(bl ? string : string2);
                vector.add(vector2);
                Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.TRUE), new ComboItem<Boolean>(string2, Boolean.FALSE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(new ComboEditor(objectArray));
                PropertiesPanel.this.mRowTypes.add(AttrType.secureText);
            }
            this.addTextColRow(vector, editCtrlObject);
            this.addRequiredProperty(vector, editCtrlObject);
        }

        private void addSpinnerCtrlProperties(Vector<Vector<Object>> vector, SpinnerCtrlObject spinnerCtrlObject) {
            SpinnerDefinition spinnerDefinition = (SpinnerDefinition)spinnerCtrlObject.getCtrlDef();
            this.addMnemonicRow(vector, spinnerCtrlObject);
            EditCtrlDefinition.ParseType parseType = spinnerDefinition.getSpinnerType();
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_SPINNER_TYPE_FIELD"));
            vector2.add(this.getDateString(parseType));
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<EditCtrlDefinition.ParseType>(this.getDateString(EditCtrlDefinition.ParseType.date), EditCtrlDefinition.ParseType.date), new ComboItem<EditCtrlDefinition.ParseType>(this.getDateString(EditCtrlDefinition.ParseType.time), EditCtrlDefinition.ParseType.time), new ComboItem<EditCtrlDefinition.ParseType>(this.getDateString(EditCtrlDefinition.ParseType.timestamp), EditCtrlDefinition.ParseType.timestamp)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            ComboEditor comboEditor = new ComboEditor(objectArray);
            comboEditor.mComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (PropsTable.this.isEditing()) {
                        PropsTable.this.getCellEditor().stopCellEditing();
                    }
                    PropertiesPanel.this.refreshCanvas();
                    PropertiesPanel.this.mPropTable.buildModel(PropertiesPanel.this.mModel.mCanvasObject);
                }
            });
            this.mEditors.add(comboEditor);
            PropertiesPanel.this.mRowTypes.add(AttrType.editType);
            if (parseType == EditCtrlDefinition.ParseType.date) {
                this.addCurrentDateRow(vector, spinnerCtrlObject);
            }
        }

        private String getDateString(EditCtrlDefinition.ParseType parseType) {
            if (parseType == EditCtrlDefinition.ParseType.date) {
                return BuilderResUtil.getString("IDS_DATE");
            }
            if (parseType == EditCtrlDefinition.ParseType.time) {
                return BuilderResUtil.getString("IDS_TIME");
            }
            return BuilderResUtil.getString("IDS_TIMESTAMP");
        }

        private String getContentString(EditCtrlDefinition.ParseType parseType) {
            if (parseType == EditCtrlDefinition.ParseType.string) {
                return BuilderResUtil.getString("IDS_ANY");
            }
            if (parseType == EditCtrlDefinition.ParseType.variableName) {
                return BuilderResUtil.getString("IDS_VARIABLE_NAME");
            }
            return BuilderResUtil.getString("IDS_NEW_DATASET_NAME");
        }

        private String getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType quoteHandlingType) {
            if (quoteHandlingType == ControlDefinition.QuoteHandlingType.Syntax) {
                return BuilderResUtil.getString("IDS_SYNTAX_QUOTE_HANDLING_SYNTAX");
            }
            if (quoteHandlingType == ControlDefinition.QuoteHandlingType.Python) {
                return BuilderResUtil.getString("IDS_SYNTAX_QUOTE_HANDLING_PYTHON");
            }
            if (quoteHandlingType == ControlDefinition.QuoteHandlingType.R) {
                return BuilderResUtil.getString("IDS_SYNTAX_QUOTE_HANDLING_R");
            }
            return BuilderResUtil.getString("IDS_SYNTAX_QUOTE_HANDLING_NONE");
        }

        private void addCurrentDateRow(Vector<Vector<Object>> vector, SpinnerCtrlObject spinnerCtrlObject) {
            Vector<String> vector2 = new Vector<String>();
            String string = ((SpinnerDefinition)spinnerCtrlObject.getCtrlDef()).getDefaultValue();
            if (string.length() == 0) {
                string = BuilderResUtil.getString("IDS_CURRENT_DATE_TIME");
            }
            vector2.add(BuilderResUtil.getString("IDS_DEFAULT_VALUE"));
            vector2.add(string);
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(spinnerCtrlObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.currentDate);
        }

        private void addColorPickerCtrlProperties(Vector<Vector<Object>> vector, ColorPickerCtrlObject colorPickerCtrlObject) {
            this.addMnemonicRow(vector, colorPickerCtrlObject);
        }

        private void addStaticImageProperties(Vector<Vector<Object>> vector, StaticImageObject staticImageObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_DEFINE_IMAGE_PATH"));
            vector2.add(BuilderResUtil.getString("IDS_DEFINE_IMAGE"));
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(staticImageObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.nodeImage);
        }

        private void addTargetListProperties(Vector<Vector<Object>> vector, TargetListObject targetListObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_LIST_TYPE"));
            String string = BuilderResUtil.getString("IDS_SINGLE_ITEM");
            String string2 = BuilderResUtil.getString("IDS_MULTI_ITEM");
            vector2.add(targetListObject.isMultiItemList() ? string2 : string);
            vector.add(vector2);
            boolean bl = BuilderUtil.getInstance().getAppType() == AppType.STATS && PropertiesPanel.this.mDlgDef.IsCompatMode();
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            if (bl) {
                this.mEditors.add(new CheckBoxEditor(targetListObject, AttrType.targetListType, BuilderResUtil.getString("IDS_MULTI_ITEM_PROMPT")));
                PropertiesPanel.this.mRowTypes.add(AttrType.targetListType);
            } else {
                Object[] objectArray = new Object[]{new ComboItem<Boolean>(string2, Boolean.TRUE), new ComboItem<Boolean>(string, Boolean.FALSE)};
                ComboEditor comboEditor = new ComboEditor(objectArray);
                comboEditor.mComboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        PropertiesPanel.this.mPropTable.buildModel(PropertiesPanel.this.mModel.mCanvasObject);
                    }
                });
                this.mEditors.add(comboEditor);
                PropertiesPanel.this.mRowTypes.add(AttrType.isMultiItem);
            }
            this.addMnemonicRow(vector, targetListObject);
            boolean bl2 = false;
            if (!bl && BuilderUtil.getInstance().getAppType() == AppType.STATS && targetListObject.isMultiItemList()) {
                this.addSeparatorProperty(vector, targetListObject);
                this.addMinMaxRow(vector, targetListObject);
                bl2 = true;
            }
            this.addRequiredProperty(vector, targetListObject);
            this.addVarFilterRow(vector, targetListObject);
            if (bl2) {
                this.addDefaultVisibleItemCount(vector, targetListObject);
            }
        }

        private void addDefaultCheckState(Vector<Vector<Object>> vector, CheckBoxObject checkBoxObject) {
            String string = BuilderResUtil.getString("IDS_CHECKED");
            String string2 = BuilderResUtil.getString("IDS_UNCHECKED");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_DEFAULT_VALUE"));
            vector2.add(((CheckBoxDefinition)checkBoxObject.getCtrlDef()).getDefaultState() ? string : string2);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<Boolean>(string2, Boolean.FALSE), new ComboItem<Boolean>(string, Boolean.TRUE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.defaultValue);
        }

        private void addMnemonicRow(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_MNEMONIC_KEY"));
            Integer n = canvasObject.getCtrlDef().getMnemonicKey();
            if (n != null) {
                vector2.add(new String(new char[]{(char)n.intValue()}));
            }
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new MnemonicEditor(new JTextField(new LimitedPlainDocument(1), "", 2)));
            PropertiesPanel.this.mRowTypes.add(AttrType.mnemonic);
        }

        private void addEnablingRuleRow(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            int n;
            if (canvasObject instanceof SrcListObject) {
                return;
            }
            if (canvasObject instanceof TabObject && (n = PropertiesPanel.this.mDlgDef.getPanels().size()) <= 1) {
                return;
            }
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_ENABLING_RULE_TITLE"));
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TO_EDIT"));
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(canvasObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.enablingRule);
        }

        private void addQuoteHandleTypeRow(Vector<Vector<Object>> vector, CanvasObject canvasObject, boolean bl) {
            EditCtrlDefinition editCtrlDefinition;
            if (canvasObject instanceof EditCtrlObject && (editCtrlDefinition = (EditCtrlDefinition)canvasObject.getCtrlDef()).getParseType() != EditCtrlDefinition.ParseType.string) {
                return;
            }
            if (canvasObject instanceof EditCtrlObject || canvasObject instanceof ComboBoxObject || canvasObject instanceof ListBoxObject) {
                editCtrlDefinition = (ControlDefinition)canvasObject.getCtrlDef();
                ControlDefinition.QuoteHandlingType quoteHandlingType = editCtrlDefinition.getQuoteHandleType();
                String string = BuilderResUtil.getString("IDS_SYNTAX_QUOTE_HANDLING");
                Vector<String> vector2 = new Vector<String>();
                vector2.add(string);
                vector2.add(this.getQuoteHandleTypeString(quoteHandlingType));
                vector.add(vector2);
                Object[] objectArray = bl ? new Object[]{new ComboItem<ControlDefinition.QuoteHandlingType>(this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.Syntax), ControlDefinition.QuoteHandlingType.Syntax), new ComboItem<ControlDefinition.QuoteHandlingType>(this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.Python), ControlDefinition.QuoteHandlingType.Python), new ComboItem<ControlDefinition.QuoteHandlingType>(this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.R), ControlDefinition.QuoteHandlingType.R), new ComboItem<ControlDefinition.QuoteHandlingType>(this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.None), ControlDefinition.QuoteHandlingType.None)} : new Object[]{new ComboItem<ControlDefinition.QuoteHandlingType>(this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.Python), ControlDefinition.QuoteHandlingType.Python), new ComboItem<ControlDefinition.QuoteHandlingType>(this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.R), ControlDefinition.QuoteHandlingType.R), new ComboItem<ControlDefinition.QuoteHandlingType>(this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.None), ControlDefinition.QuoteHandlingType.None)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(new ComboEditor(objectArray));
                PropertiesPanel.this.mRowTypes.add(AttrType.quoteHandleType);
            }
        }

        private void addMinMaxRow(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            String string;
            String string2;
            int n;
            int n2;
            if (canvasObject instanceof TargetListObject) {
                n2 = ((TargetListObject)canvasObject).getDefinition().getMinFields();
                n = ((TargetListObject)canvasObject).getDefinition().getMaxFields();
                string2 = "IDS_MIN_NUM_FIELDS";
                string = "IDS_MAX_NUM_FIELDS";
            } else if (canvasObject instanceof FieldChooserObject) {
                n2 = ((FieldChooserObject)canvasObject).getChooserDef().getMinFields();
                n = ((FieldChooserObject)canvasObject).getChooserDef().getMaxFields();
                string2 = "IDS_MIN_NUM_FIELDS";
                string = "IDS_MAX_NUM_FIELDS";
            } else if (canvasObject instanceof ListBoxObject) {
                n2 = ((ListBoxObject)canvasObject).getListDef().getMinFields();
                n = ((ListBoxObject)canvasObject).getListDef().getMaxFields();
                string2 = "IDS_MIN_LIST_SELECTED";
                string = "IDS_MAX_LIST_SELECTED";
            } else {
                return;
            }
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString(string2));
            String string3 = n2 != Integer.MIN_VALUE ? Integer.toString(n2) : "";
            vector2.add(string3);
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            IntTextField intTextField = new IntTextField(true);
            this.mEditors.add(new NumberEditor((SPSSTextField)intTextField));
            PropertiesPanel.this.mRowTypes.add(AttrType.minValue);
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString(string));
            string3 = n != Integer.MAX_VALUE ? Integer.toString(n) : "";
            vector2.add(UIToolResUtil.addLocale((String)string3));
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            IntTextField intTextField2 = new IntTextField(true);
            this.mEditors.add(new NumberEditor((SPSSTextField)intTextField2));
            PropertiesPanel.this.mRowTypes.add(AttrType.maxValue);
        }

        private void addDefaultVisibleItemCount(Vector<Vector<Object>> vector, TargetListObject targetListObject) {
            int n = targetListObject.getDefinition().getDefaultVisibleItem();
            String string = "IDS_TARGET_DEFAULT_VISIBLE_ITEMS";
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString(string));
            String string2 = n != Integer.MAX_VALUE ? Integer.toString(n) : "";
            vector2.add(string2);
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            IntTextField intTextField = new IntTextField(1, 10);
            intTextField.setSkipValidationOnFocusLost(true);
            this.mEditors.add(new NumberEditor((SPSSTextField)intTextField));
            PropertiesPanel.this.mRowTypes.add(AttrType.visibleItems);
        }

        private boolean generatesSyntax(CanvasObject canvasObject) {
            if (canvasObject instanceof TabObject) {
                return BuilderUtil.getInstance().getAppType() != AppType.STATS;
            }
            return !(canvasObject instanceof SrcListObject) && !(canvasObject instanceof StaticCtrlObject) && !(canvasObject instanceof SubDlgButtonObject) && !(canvasObject instanceof StaticImageObject);
        }

        private void locateCustomPropsFile(int n, int n2) {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            this.getLocalFile(n, n2, BuilderResUtil.getString("IDS_BROWSE_PROP_TITLE"), dialogDefinition.getCustomPropertiesFile(), null);
        }

        private void locateHelpFile(int n, int n2) {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            HtmFilter htmFilter = new HtmFilter();
            this.getLocalFile(n, n2, BuilderResUtil.getString("IDS_BROWSE_HELP_TITLE"), dialogDefinition.getHelpFileName(), htmFilter);
        }

        private void locateIconFile(int n, int n2) {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            GIFFilter gIFFilter = new GIFFilter();
            this.getLocalFile(n, n2, BuilderResUtil.getString("IDS_BROWSE_ICON_TITLE"), dialogDefinition.getNodeIconFile(), gIFFilter);
        }

        private void locateDefaultFileBrowserFile(int n, int n2, FileSystemBrowserDefinition fileSystemBrowserDefinition) {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            RemoteFileChooser.ChooserType chooserType = fileSystemBrowserDefinition.isDirectoryBrowser() ? RemoteFileChooser.ChooserType.OpenFolder : RemoteFileChooser.ChooserType.OpenFile;
            String string = fileSystemBrowserDefinition.isDirectoryBrowser() ? BuilderResUtil.getString("IDS_LOCATE_FOLDER") : BuilderResUtil.getString("IDS_LOCATE_FILE");
            this.getLocalFile(chooserType, n, n2, string, dialogDefinition.getHelpFileName(), null);
        }

        private void getLocalFile(int n, int n2, String string, String string2, FileFilter fileFilter) {
            this.getLocalFile(RemoteFileChooser.ChooserType.OpenFile, n, n2, string, string2, fileFilter);
        }

        private void getLocalFile(RemoteFileChooser.ChooserType chooserType, int n, int n2, String string, String string2, FileFilter fileFilter) {
            int n3;
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(chooserType, RemoteFileChooser.ChooserOption.Generic, BuilderUtil.getInstance().getRecentFilesDirectoryPath(), false, false);
            remoteFileChooser.setDialogTitle(string);
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            remoteFileChooser.setMultiSelectionEnabled(false);
            if (fileFilter != null) {
                remoteFileChooser.setFileFilter(fileFilter);
            }
            String string3 = BuilderUtil.getInstance().getUIExtensionsFolderPath() + File.separator + PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition().getDialogId();
            String string4 = string2;
            if (string4.length() > 0) {
                File file;
                if (!string4.contains(File.separator)) {
                    string4 = string3 + File.separator + string4;
                }
                if ((file = new File(string4)).exists()) {
                    remoteFileChooser.setCurrentDirectory(file.getParentFile());
                    remoteFileChooser.setSelectedFile(file);
                }
            }
            if ((n3 = remoteFileChooser.showOpenDialog(this)) == 0) {
                File file = BuilderFrame.getCanonicalFileIfNotCanonical(remoteFileChooser.getSelectedFile());
                string4 = file != null ? file.getPath() : remoteFileChooser.getSelectedFile().getPath();
                if (string4.startsWith(string3)) {
                    string4 = remoteFileChooser.getSelectedFile().getName();
                }
                this.setValueAt(string4, n, n2);
                ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n);
                if (string4.length() == 0) {
                    string4 = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
                }
                buttonEditCtrl.getTextField().setText(string4);
                PropertiesPanel.this.adjustFont(n, buttonEditCtrl);
            }
        }
    }
}

