/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.SyntaxDiagramDlg;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ButtonEditCtrl;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.IButtonEditListener;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.StringTextField;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ComboBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ItemGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ListBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.RadioGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TableCtrlObject;
import com.spss.shared.custom_gui.ui_builder.props_ui.ComboCellEditor;
import com.spss.shared.custom_gui.ui_builder.props_ui.EnablingRuleDlg;
import com.spss.shared.custom_gui.ui_builder.props_ui.PropertiesPanel;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.ControlCondition;
import com.spss.uitools.ui_builder.definition.ControlDefinition;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.FieldChooserDefinition;
import com.spss.uitools.ui_builder.definition.ListDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.ScriptType;
import com.spss.uitools.ui_builder.definition.TableColItem;
import com.spss.uitools.ui_builder.definition.TableDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ItemListTable
extends JTable
implements IButtonEditListener,
ActionListener {
    private BuilderFrame mOwner;
    private CanvasObject mCanvasObject;
    private Border mCellBorder = null;
    private TableCellRenderer mCellRenderer = new DefCellRenderer();
    private boolean mInLoadData;
    private String[] mContentString;
    private String[] mTypeString;
    private String[] mQuote;
    private String[] mQuoteHandle;
    private JButton mUpButton;
    static ImageIcon sUpImage;
    static ImageIcon sDownImage;
    private JButton mDownButton;
    private SyntaxDiagramDlg mSyntaxDlg;
    private Vector<TableColItem> mOrigColumns;

    public ItemListTable(BuilderFrame builderFrame, CanvasObject canvasObject) {
        this.mOwner = builderFrame;
        this.mCanvasObject = canvasObject;
        this.mInLoadData = false;
        this.init();
        this.saveOrig(canvasObject);
        this.loadData();
        this.enableUpDownButton(-1);
    }

    public CanvasObject getCanvasObject() {
        return this.mCanvasObject;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
        if (tableCellRenderer instanceof JComponent) {
            ((JComponent)((Object)tableCellRenderer)).setBackground(Color.white);
            if (this.mCellBorder == null) {
                this.mCellBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
            }
            ((JComponent)((Object)tableCellRenderer)).setBorder(this.mCellBorder);
        }
        return tableCellRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        int n3;
        TableCellEditor tableCellEditor = super.getCellEditor(n, n2);
        boolean bl = this.mCanvasObject instanceof RadioGroupObject;
        int n4 = n3 = bl ? this.columnIndex(ColType.mnemonic) : -1;
        if (n2 == n3 && tableCellEditor instanceof PropertiesPanel.MnemonicEditor) {
            Object object = this.getValueAt(n, n2);
            String string = object != null ? object.toString() : "";
            tableCellEditor.getTableCellEditorComponent(this, string, false, n, n2);
        }
        return tableCellEditor;
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
        return this.mCellRenderer;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!super.isCellEditable(n, n2)) {
            return false;
        }
        return !(this.mCanvasObject instanceof RadioGroupObject) || n2 != this.columnIndex(ColType.hasSubGroup) || !(this.mCanvasObject.getParent() instanceof ItemGroupObject);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl) {
            Component component = this.getEditorComponent();
            if (component instanceof JTextField) {
                MouseEvent mouseEvent;
                final JTextField jTextField = (JTextField)component;
                jTextField.selectAll();
                if (eventObject instanceof MouseEvent && (mouseEvent = (MouseEvent)eventObject).getClickCount() > 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jTextField.selectAll();
                        }
                    });
                }
            }
        } else {
            this.enableUpDownButton(n);
        }
        return bl;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3;
        int n4;
        Object object2;
        int n5;
        int n6 = this.columnIndex(ColType.identifier);
        if (n6 == n2 && (this.checkForDupId(object.toString(), n, true) || this.checkForInvalidId(object.toString(), true))) {
            return;
        }
        if (this.mCanvasObject instanceof TableCtrlObject && !this.mInLoadData) {
            int n7;
            Object object3;
            n5 = this.columnIndex(ColType.defaultValue);
            if (n5 == n2 && (object2 = this.getTableContentType(this.getStringValue(n, this.columnIndex(ColType.contentType)))) == TableColItem.ColContentType.VarName && this.containInvalidChar(object.toString())) {
                return;
            }
            if (n2 == this.columnIndex(ColType.tableWidth) && ((object3 = this.getValueAt(n, n7 = this.columnIndex(ColType.name))) != null || object3.toString().length() > 0) && this.emptyTableWidth(object.toString())) {
                return;
            }
        }
        super.setValueAt(object, n, n2);
        if (this.mCanvasObject instanceof TableCtrlObject && !this.mInLoadData && n2 == this.columnIndex(ColType.name) && ((object2 = this.getValueAt(n, n5 = this.columnIndex(ColType.tableWidth))) == null || object2.toString().length() == 0) && object.toString().length() > 0) {
            this.setValueAt("" + object.toString().length(), n, n5);
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        int n8 = this.columnIndex(ColType.isDefault);
        int n9 = n4 = this.mCanvasObject instanceof RadioGroupObject ? this.columnIndex(ColType.hasSubGroup) : -1;
        if (object != null && object.toString().length() > 0 && n == this.getRowCount() - 1) {
            n3 = this.getRowCount();
            if (this.mCanvasObject instanceof TableCtrlObject && !this.mInLoadData) {
                this.addOneRowForTableControl(defaultTableModel);
            } else {
                defaultTableModel.setNumRows(n3 + 1);
                if (n2 != n8) {
                    defaultTableModel.setValueAt(Boolean.FALSE, n, n8);
                }
                if (n4 > -1 && n2 != n4) {
                    defaultTableModel.setValueAt(Boolean.FALSE, n, n4);
                }
                this.saveData();
            }
            if (n2 != n6) {
                this.setDefaultIdentifier(n);
            }
        } else if ((object == null || object.toString().length() == 0) && this.rowEmpty(n) && n < this.getRowCount() - 1) {
            defaultTableModel.removeRow(n);
        }
        if (n2 == n8 && Boolean.TRUE.equals(object)) {
            for (n3 = 0; n3 < this.getRowCount() - 1; ++n3) {
                if (n3 == n || !Boolean.TRUE.equals(defaultTableModel.getValueAt(n3, n8))) continue;
                defaultTableModel.setValueAt(Boolean.FALSE, n3, n2);
                break;
            }
        }
        if (!this.mInLoadData && n2 == n4) {
            this.handleRadioItemSyntaxDefaults(n);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mUpButton || actionEvent.getSource() == this.mDownButton) {
            int n = this.getRowCount();
            int n2 = this.getSelectedRow();
            if (n > 1 && n2 >= 0) {
                if (actionEvent.getSource() == this.mUpButton) {
                    this.manipulateUp(n2);
                } else {
                    this.manipulateDown(n2);
                }
            }
        }
    }

    private void manipulateDown(int n) {
        if (n == this.getRowCount() - 1) {
            return;
        }
        int n2 = n + 2;
        int n3 = n;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        Vector vector2 = vector.get(n);
        defaultTableModel.insertRow(n2, vector2);
        defaultTableModel.removeRow(n3);
        this.getSelectionModel().setSelectionInterval(n2 - 1, n2 - 1);
        this.enableUpDownButton(-1);
        this.processMoveNotification(false, n);
    }

    public void enableUpDownButton(int n) {
        int n2 = n;
        if (n2 == -1) {
            n2 = this.getSelectedRow();
        }
        this.mDownButton.setEnabled(true);
        this.mUpButton.setEnabled(true);
        if (n2 == -1 || this.rowEmpty(n2)) {
            this.mDownButton.setEnabled(false);
            this.mUpButton.setEnabled(false);
        } else if (n2 == 0) {
            this.mUpButton.setEnabled(false);
            if (this.getRowCount() > 1 && this.rowEmpty(n2 + 1)) {
                this.mDownButton.setEnabled(false);
            }
        } else if (n2 == this.getRowCount() - 2) {
            this.mDownButton.setEnabled(false);
        }
    }

    private void manipulateUp(int n) {
        if (n == 0) {
            return;
        }
        int n2 = n - 1;
        int n3 = n + 1;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        Vector vector2 = vector.get(n);
        defaultTableModel.insertRow(n2, vector2);
        defaultTableModel.removeRow(n3);
        this.getSelectionModel().setSelectionInterval(n2, n2);
        this.enableUpDownButton(-1);
        this.processMoveNotification(true, n);
    }

    private void processMoveNotification(boolean bl, int n) {
        if (this.mCanvasObject instanceof RadioGroupObject) {
            RadioGroupObject radioGroupObject = (RadioGroupObject)this.mCanvasObject;
            radioGroupObject.processMoveNotification(bl, n);
        }
    }

    public JButton getUpButton() {
        return this.mUpButton;
    }

    public JButton getDownButton() {
        return this.mDownButton;
    }

    @Override
    public void buttonPressed(long l, int n) {
        if (this.mCanvasObject instanceof TableCtrlObject) {
            this.setTableColSyntax(l, n);
        } else {
            RadioGroupObject radioGroupObject = (RadioGroupObject)this.mCanvasObject;
            Vector vector = radioGroupObject.getCtrlDef().getCtrlConditions();
            String string = "";
            if (vector != null && vector.size() > 0) {
                string = ((ControlCondition)vector.get(0)).getControlName();
            }
            EnablingRuleDlg enablingRuleDlg = new EnablingRuleDlg(this.mOwner, (PanelElementDefinition)radioGroupObject.getRadioItem((int)l), string);
            enablingRuleDlg.setVisible(true);
            Vector vector2 = radioGroupObject.getRadioItem((int)l).getCtrlConditions();
        }
    }

    private void setTableColSyntax(long l, int n) {
        int n2 = (int)l;
        int n3 = n;
        TableCtrlObject tableCtrlObject = (TableCtrlObject)this.mCanvasObject;
        TableDefinition tableDefinition = (TableDefinition)tableCtrlObject.getCtrlDef();
        Vector vector = tableDefinition.getColumns();
        if (n2 >= vector.size()) {
            return;
        }
        final TableColItem tableColItem = (TableColItem)vector.get(n2);
        String string = this.getValueAt(n2, n).toString();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ThisValue");
        String string2 = "IDS_CONTROL_SYNTAX_DESC";
        this.mSyntaxDlg = new SyntaxDiagramDlg(this.mOwner, BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM_PROPERTY"), string, arrayList, this.mOwner.getSyntaxCommand(), string2, new SyntaxDiagramDlg.SyntaxDiagramDlgCallback(){

            @Override
            public void syntaxModifiedNotification() {
                String string = ItemListTable.this.mSyntaxDlg.getSyntax();
                tableColItem.setColSyntax(string);
                ItemListTable.this.mOwner.setModified(true);
            }

            @Override
            public void showHelp() {
                BuilderUtil.getInstance().showHelp("clementine/idh_idd_uibuilder_syntemplate");
            }

            @Override
            public boolean showInvalidSyntaxWarning() {
                int n = BuilderAlertPane.showConfirmDialog((Window)((Object)ItemListTable.this.mSyntaxDlg), BuilderResUtil.getString("IDS_INVALID_SYNTAX_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                return n == 2;
            }
        });
        this.mSyntaxDlg.setVisible(true);
        if (this.mSyntaxDlg.getModalResult()) {
            this.mOwner.getCanvas().fireSelectionChange(tableCtrlObject);
            this.mOwner.setModified(true);
            this.refreshTable(n2, this.mSyntaxDlg.getSyntax());
        }
    }

    private void refreshTable(int n, String string) {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.setValueAt(string, n, this.columnIndex(ColType.syntax));
    }

    private String createTableDefaultId(int n) {
        int n2 = this.columnIndex(ColType.identifier);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        String string = this.mCanvasObject.getControlId();
        boolean bl = false;
        String string2 = n + "_" + ((TableDefinition)this.mCanvasObject.getCtrlDef()).getDefaultColumnSuffix();
        String string3 = string + "_" + string2;
        do {
            if (!this.checkForDupId(string3, n, false)) {
                bl = true;
                continue;
            }
            string3 = string3 + "_1";
        } while (!bl);
        return string3;
    }

    private void addOneRowForTableControl(DefaultTableModel defaultTableModel) {
        if (this.hasEmptyRowInTable()) {
            return;
        }
        ControlDefinition.QuoteHandlingType quoteHandlingType = this.mOwner.getDialogDefinition().getAppType() == AppType.STATS ? ControlDefinition.QuoteHandlingType.Syntax : ControlDefinition.QuoteHandlingType.R;
        Vector<String> vector = new Vector<String>();
        TableCtrlObject tableCtrlObject = (TableCtrlObject)this.mCanvasObject;
        TableDefinition tableDefinition = (TableDefinition)tableCtrlObject.getCtrlDef();
        TableColItem tableColItem = new TableColItem("", defaultTableModel.getRowCount(), quoteHandlingType);
        int n = defaultTableModel.getRowCount();
        String string = this.createTableDefaultId(n);
        vector.add(string);
        vector.add("");
        vector.add(this.getContentStrValue(tableColItem.getContentType()));
        vector.add(tableColItem.getDefaultValue());
        vector.add(this.getSeparatorTypeString(tableColItem.getSeparatorType()));
        vector.add(this.getQuoteString(tableColItem.isQuoted()));
        vector.add(this.getQuoteHandleString(tableColItem.getQuoteType()));
        String string2 = "";
        if (tableColItem.getColWidth() != Integer.MAX_VALUE) {
            string2 = Integer.toString(tableColItem.getColWidth());
        }
        vector.add(string2);
        vector.add(tableColItem.getColSyntax());
        Vector vector2 = tableDefinition.getColumns();
        vector2.add(tableColItem);
        tableDefinition.addColumns(vector2);
        defaultTableModel.addRow(vector);
    }

    private boolean hasEmptyRowInTable() {
        boolean bl = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, 0) == null || this.getValueAt(i, 0).toString().length() == 0) {
                bl = true;
                break;
            }
            if (this.getValueAt(i, 1) != null && this.getValueAt(i, 1).toString().length() != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Vector<TableColItem> getTableOrigCols() {
        return this.mOrigColumns;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.getTableHeader().setForeground(bl ? Color.black : Color.darkGray);
        super.setEnabled(bl);
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        super.columnMarginChanged(changeEvent);
    }

    private boolean checkForInvalidId(String string, boolean bl) {
        if (string != null && string.contains(" ")) {
            if (bl) {
                BuilderAlertPane.showWarningMessageDialog(this.mOwner, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), BuilderUtil.getInstance().getAppVersionString());
            }
            return true;
        }
        return false;
    }

    private boolean checkForDupId(String string, int n, boolean bl) {
        if (string.length() == 0 || this.mOwner.getCanvas().findCanvasObject(string) != null || this.hasId(string, n)) {
            if (bl) {
                BuilderAlertPane.showWarningMessageDialog(this.mOwner, string.length() == 0 ? BuilderResUtil.getString("IDS_MISSING_EL_ID_WARNING") : BuilderResUtil.getString("IDS_DUPLICATE_ID_WARNING"), BuilderUtil.getInstance().getAppVersionString());
            }
            return true;
        }
        return false;
    }

    private boolean emptyTableWidth(String string) {
        if (string == null || string.length() == 0) {
            BuilderAlertPane.showWarningMessageDialog(this.mOwner, BuilderResUtil.getString("IDS_TABLE_WIDTH_EMPTY"), BuilderUtil.getInstance().getAppVersionString());
            return true;
        }
        return false;
    }

    private void handleRadioItemSyntaxDefaults(int n) {
        if (this.mCanvasObject instanceof RadioGroupObject && n > -1) {
            boolean bl;
            int n2 = this.columnIndex(ColType.hasSubGroup);
            int n3 = this.columnIndex(ColType.syntax);
            Object object = this.getValueAt(n, n2);
            Object object2 = this.getValueAt(n, n3);
            object2 = object2 == null ? "" : object2;
            boolean bl2 = bl = object != null && object.toString().equals("true");
            if (bl && object2.toString().length() == 0) {
                super.setValueAt(DialogDefinition.getSelfValue(), n, n3);
            } else if (!bl && object2.toString().equals(DialogDefinition.getSelfValue())) {
                super.setValueAt("", n, n3);
            }
        }
    }

    private boolean hasId(String string, int n) {
        int n2 = this.columnIndex(ColType.identifier);
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object;
            if (i == n || (object = this.getValueAt(i, n2)) == null || !object.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void setDefaultIdentifier(int n) {
        String string = this.getUniqueIdentifier(n);
        int n2 = this.columnIndex(ColType.identifier);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        if (string != null) {
            defaultTableModel.setValueAt(string, n, n2);
        }
    }

    private String getUniqueIdentifier(int n) {
        String string = null;
        int n2 = this.columnIndex(ColType.identifier);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        String string2 = this.mCanvasObject.getControlId();
        boolean bl = false;
        do {
            String string3;
            if (this.mCanvasObject instanceof RadioGroupObject) {
                string3 = "" + ((RadioGroupDefinition)this.mCanvasObject.getCtrlDef()).getNextSuffix();
            } else if (this.mCanvasObject instanceof ComboBoxObject || this.mCanvasObject instanceof ListBoxObject) {
                string3 = ((ListDefinition)this.mCanvasObject.getCtrlDef()).getNextSuffix();
            } else if (this.mCanvasObject instanceof TableCtrlObject) {
                string3 = n + "_" + ((TableDefinition)this.mCanvasObject.getCtrlDef()).getDefaultColumnSuffix();
            } else {
                return null;
            }
            String string4 = string2 + "_" + string3;
            if (this.checkForDupId(string4, n, false)) continue;
            string = string4;
            bl = true;
        } while (!bl);
        return string;
    }

    private void loadData() {
        this.mInLoadData = true;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        if (this.mCanvasObject instanceof RadioGroupObject) {
            Serializable serializable;
            RadioGroupObject radioGroupObject = (RadioGroupObject)this.mCanvasObject;
            int n = radioGroupObject.radioItemCount();
            int n2 = 7;
            if (!this.mOwner.IsCompatibleMode()) {
                n2 = 8;
            }
            defaultTableModel.setColumnCount(n2);
            defaultTableModel.setNumRows(n + 1);
            for (int i = 0; i < n; ++i) {
                RadioItemDefinition radioItemDefinition = radioGroupObject.getRadioItem(i);
                this.setValueAt(radioItemDefinition.getControlId(), i, this.columnIndex(ColType.identifier));
                this.setValueAt(radioItemDefinition.getTitle(), i, this.columnIndex(ColType.name));
                this.setValueAt(radioItemDefinition.getTip(), i, this.columnIndex(ColType.tip));
                serializable = radioItemDefinition.getMnemonicKey();
                if (serializable != null) {
                    this.setValueAt(new String(new char[]{(char)((Integer)serializable).intValue()}), i, this.columnIndex(ColType.mnemonic));
                }
                this.setValueAt(radioItemDefinition.getHasSubGroup(), i, this.columnIndex(ColType.hasSubGroup));
                this.setValueAt(radioItemDefinition.getIsDefault(), i, this.columnIndex(ColType.isDefault));
                if (!this.mOwner.IsCompatibleMode()) {
                    this.setValueAt(BuilderResUtil.getString("IDS_SELECT_TO_EDIT"), i, this.columnIndex(ColType.enableRule));
                }
                this.setValueAt(radioItemDefinition.getControlSyntax(), i, this.columnIndex(ColType.syntax));
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.isDefault));
            tableColumn.setCellEditor(new ComboCellEditor());
            tableColumn.setPreferredWidth(40);
            tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.mnemonic));
            tableColumn.setCellEditor(new PropertiesPanel.MnemonicEditor(new JTextField(new PropertiesPanel.LimitedPlainDocument(1), "", 2)));
            tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.hasSubGroup));
            tableColumn.setCellEditor(new ComboCellEditor());
            tableColumn.setPreferredWidth(60);
            if (!this.mOwner.IsCompatibleMode()) {
                tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.enableRule));
                serializable = new ButtonEditCtrl(this.columnIndex(ColType.enableRule));
                ((ButtonEditCtrl)serializable).setFont(this.mCanvasObject.getFont().deriveFont(2));
                ((ButtonEditCtrl)serializable).setReadOnlyEdit(true);
                ((ButtonEditCtrl)serializable).addButtonListener(this);
                tableColumn.setCellEditor((TableCellEditor)((Object)serializable));
                tableColumn.setPreferredWidth(100);
            }
        } else if (this.mCanvasObject instanceof ComboBoxObject || this.mCanvasObject instanceof ListBoxObject) {
            ListDefinition listDefinition = (ListDefinition)this.mCanvasObject.getCtrlDef();
            Vector vector = listDefinition.getListItems();
            int n = vector.size();
            defaultTableModel.setColumnCount(4);
            defaultTableModel.setNumRows(n + 1);
            for (int i = 0; i < n; ++i) {
                ListDefinition.ListItem listItem = (ListDefinition.ListItem)vector.get(i);
                this.setValueAt(listItem.getTitle(), i, this.columnIndex(ColType.name));
                this.setValueAt(listItem.getIdentifier(), i, this.columnIndex(ColType.identifier));
                this.setValueAt(listItem.isDefaultItem(), i, this.columnIndex(ColType.isDefault));
                this.setValueAt(listItem.getSyntax(), i, this.columnIndex(ColType.syntax));
            }
            this.getColumnModel().getColumn(this.columnIndex(ColType.isDefault)).setCellEditor(new ComboCellEditor());
        } else if (this.mCanvasObject instanceof TableCtrlObject) {
            Object object;
            String string;
            Object object2;
            TableCtrlObject tableCtrlObject = (TableCtrlObject)this.mCanvasObject;
            TableDefinition tableDefinition = (TableDefinition)tableCtrlObject.getCtrlDef();
            Vector vector = tableDefinition.getColumns();
            this.mContentString = new String[4];
            this.mContentString[0] = BuilderResUtil.getString("IDS_NUMBER");
            this.mContentString[1] = BuilderResUtil.getString("IDS_INTEGER");
            this.mContentString[2] = BuilderResUtil.getString("IDS_ANY");
            this.mContentString[3] = BuilderResUtil.getString("IDS_VARIABLE_NAME");
            this.mTypeString = new String[3];
            this.mTypeString[0] = BuilderResUtil.getString("IDS_SEPARATOR_TYPE_COMMA");
            this.mTypeString[1] = BuilderResUtil.getString("IDS_SEPARATOR_TYPE_BLANK");
            this.mTypeString[2] = BuilderResUtil.getString("IDS_SEPARATOR_TYPE_PLUS");
            this.mQuote = new String[]{BuilderResUtil.getString("IDS_FALSE"), BuilderResUtil.getString("IDS_TRUE")};
            this.mQuoteHandle = this.mOwner.getDialogDefinition().getAppType() == AppType.STATS ? new String[]{this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.Syntax), this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.Python), this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.R), this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.None)} : new String[]{this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.Python), this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.R), this.getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType.None)};
            int n = vector.size();
            defaultTableModel.setColumnCount(9);
            defaultTableModel.setNumRows(n);
            for (int i = 0; i < n; ++i) {
                object2 = (TableColItem)vector.get(i);
                this.setValueAt(object2.getColId(), i, this.columnIndex(ColType.identifier));
                string = "";
                String string2 = object2.getColName();
                string = object2.getColWidth() != Integer.MAX_VALUE ? Integer.toString(object2.getColWidth()) : "" + string2.length();
                this.setValueAt(string, i, this.columnIndex(ColType.tableWidth));
                this.setValueAt(string2, i, this.columnIndex(ColType.name));
                this.setValueAt(this.getContentStrValue(object2.getContentType()), i, this.columnIndex(ColType.contentType));
                this.setValueAt(object2.getDefaultValue(), i, this.columnIndex(ColType.defaultValue));
                object = object2.getSepTypeCustom();
                if (((String)object).length() == 0) {
                    object = this.getSeparatorTypeString(object2.getSeparatorType());
                }
                this.setValueAt(object, i, this.columnIndex(ColType.separatorType));
                this.setValueAt(this.getQuoteString(object2.isQuoted()), i, this.columnIndex(ColType.quoted));
                this.setValueAt(this.getQuoteHandleString(object2.getQuoteType()), i, this.columnIndex(ColType.quoteHandle));
                this.setValueAt(object2.getColSyntax(), i, this.columnIndex(ColType.syntax));
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.contentType));
            object2 = new ComboCellEditor(this.mContentString);
            object2.mCombo.addItemListener(new ItemListener((ComboCellEditor)object2){
                final /* synthetic */ ComboCellEditor val$chooserEditor;
                {
                    this.val$chooserEditor = comboCellEditor;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ItemListTable.this.updateDefaultValueEditor(this.val$chooserEditor.mCombo.getSelectedIndex());
                }
            });
            tableColumn.setCellEditor((TableCellEditor)object2);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.defaultValue));
            tableColumn.setCellEditor(new TableDefaultValueEditor((JTextField)((Object)new StringTextField())));
            tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.separatorType));
            tableColumn.setCellEditor(new ComboCellEditor(this.mTypeString, true, 1));
            tableColumn.setPreferredWidth(60);
            tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.quoted));
            tableColumn.setCellEditor(new ComboCellEditor(this.mQuote));
            tableColumn.setPreferredWidth(30);
            tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.quoteHandle));
            tableColumn.setCellEditor(new ComboCellEditor(this.mQuoteHandle));
            tableColumn.setPreferredWidth(60);
            tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.tableWidth));
            string = new IntTextField(true);
            tableColumn.setCellEditor(new NumberEditor((SPSSTextField)string));
            tableColumn.setPreferredWidth(80);
            int n3 = this.columnIndex(ColType.syntax);
            tableColumn = this.getColumnModel().getColumn(n3);
            object = new ButtonEditCtrl(n3);
            ((ButtonEditCtrl)object).setFont(this.getFont().deriveFont(2));
            ((ButtonEditCtrl)object).setReadOnlyEdit(false);
            ((ButtonEditCtrl)object).addButtonListener(this);
            tableColumn.setCellEditor((TableCellEditor)object);
            tableColumn.setPreferredWidth(100);
            int n4 = ((DefaultTableModel)this.getModel()).getRowCount();
            if (this.hasEmptyRowInTable() && n4 > 1) {
                ((DefaultTableModel)this.getModel()).removeRow(n4 - 1);
            }
            this.addOneRowForTableControl((DefaultTableModel)this.getModel());
        }
        this.enableUpDownButton(-1);
        this.mInLoadData = false;
    }

    private void updateDefaultValueEditor(int n) {
        String string;
        if (n < 0) {
            return;
        }
        int n2 = this.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        int n3 = this.columnIndex(ColType.defaultValue);
        TableColItem.ColContentType colContentType = n == 0 ? TableColItem.ColContentType.Real : (n == 1 ? TableColItem.ColContentType.Integer : (n == 2 ? TableColItem.ColContentType.String : TableColItem.ColContentType.VarName));
        String string2 = this.getValueAt(n2, n3).toString();
        if (!string2.equals(string = this.getNewValue(string2, colContentType))) {
            this.setValueAt(string, n2, n3);
        }
    }

    private String getNewValue(String string, TableColItem.ColContentType colContentType) {
        String string2 = string;
        if (string2.length() == 0) {
            return string2;
        }
        if (colContentType == TableColItem.ColContentType.Integer) {
            try {
                int n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "";
            }
        } else if (colContentType == TableColItem.ColContentType.Real) {
            try {
                double d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "";
            }
        } else if (colContentType == TableColItem.ColContentType.VarName && this.containInvalidChar(string)) {
            string2 = "";
        }
        return string2;
    }

    private boolean containInvalidChar(String string) {
        boolean bl = false;
        if (string.length() == 0) {
            return bl;
        }
        char[] cArray = string.toCharArray();
        char c = cArray[0];
        if (Character.isDigit(c) || c == '_' || c == '.') {
            return true;
        }
        if (string.indexOf(" ") >= 0) {
            return true;
        }
        for (char c2 : cArray) {
            if (ItemListTable.isValidSpssNameChar(c2)) continue;
            return true;
        }
        return bl;
    }

    private static boolean isValidSpssNameChar(char c) {
        char[] cArray = "@#$_.".toCharArray();
        return Character.isLetterOrDigit(c) || Arrays.binarySearch(cArray, c) > -1;
    }

    private String getQuoteHandleTypeString(ControlDefinition.QuoteHandlingType quoteHandlingType) {
        if (quoteHandlingType == ControlDefinition.QuoteHandlingType.Syntax) {
            return BuilderResUtil.getString("IDS_SYNTAX_QUOTE_HANDLING_SYNTAX");
        }
        if (quoteHandlingType == ControlDefinition.QuoteHandlingType.Python) {
            return BuilderResUtil.getString("IDS_SYNTAX_QUOTE_HANDLING_PYTHON");
        }
        if (quoteHandlingType == ControlDefinition.QuoteHandlingType.R) {
            return BuilderResUtil.getString("IDS_SYNTAX_QUOTE_HANDLING_R");
        }
        return BuilderResUtil.getString("IDS_SYNTAX_QUOTE_HANDLING_NONE");
    }

    private String getContentStrValue(TableColItem.ColContentType colContentType) {
        if (colContentType == TableColItem.ColContentType.Integer) {
            return this.mContentString[1];
        }
        if (colContentType == TableColItem.ColContentType.Real) {
            return this.mContentString[0];
        }
        if (colContentType == TableColItem.ColContentType.VarName) {
            return this.mContentString[3];
        }
        return this.mContentString[2];
    }

    public TableColItem.ColContentType getTableContentType(String string) {
        TableColItem.ColContentType colContentType;
        if (this.mContentString == null) {
            return TableColItem.ColContentType.String;
        }
        int n = 0;
        for (n = 0; n < this.mContentString.length && !string.equals(this.mContentString[n]); ++n) {
        }
        switch (n) {
            case 0: {
                colContentType = TableColItem.ColContentType.Real;
                break;
            }
            case 1: {
                colContentType = TableColItem.ColContentType.Integer;
                break;
            }
            case 2: {
                colContentType = TableColItem.ColContentType.String;
                break;
            }
            case 3: {
                colContentType = TableColItem.ColContentType.VarName;
                break;
            }
            default: {
                colContentType = TableColItem.ColContentType.String;
            }
        }
        return colContentType;
    }

    private String getSeparatorTypeString(FieldChooserDefinition.SeparatorType separatorType) {
        if (separatorType == FieldChooserDefinition.SeparatorType.comma) {
            return ",";
        }
        if (separatorType == FieldChooserDefinition.SeparatorType.plus) {
            return "+";
        }
        return this.mTypeString[1];
    }

    private String getQuoteString(boolean bl) {
        if (bl) {
            return this.mQuote[1];
        }
        return this.mQuote[0];
    }

    private String getQuoteHandleString(ControlDefinition.QuoteHandlingType quoteHandlingType) {
        if (this.mOwner.getDialogDefinition().getAppType() == AppType.STATS) {
            if (quoteHandlingType == ControlDefinition.QuoteHandlingType.Syntax) {
                return this.mQuoteHandle[0];
            }
            if (quoteHandlingType == ControlDefinition.QuoteHandlingType.Python) {
                return this.mQuoteHandle[1];
            }
            if (quoteHandlingType == ControlDefinition.QuoteHandlingType.R) {
                return this.mQuoteHandle[2];
            }
            return this.mQuoteHandle[3];
        }
        if (quoteHandlingType == ControlDefinition.QuoteHandlingType.Python) {
            return this.mQuoteHandle[0];
        }
        if (quoteHandlingType == ControlDefinition.QuoteHandlingType.R) {
            return this.mQuoteHandle[1];
        }
        return this.mQuoteHandle[2];
    }

    protected void makeTempRBPermanent() {
        if (this.mCanvasObject instanceof RadioGroupObject) {
            RadioGroupObject radioGroupObject = (RadioGroupObject)this.mCanvasObject;
            radioGroupObject.makeTempRBPermanent();
        }
    }

    protected void clearTempRB() {
        if (this.mCanvasObject instanceof RadioGroupObject) {
            RadioGroupObject radioGroupObject = (RadioGroupObject)this.mCanvasObject;
            radioGroupObject.clearTempRB();
        }
    }

    protected void saveData() {
        if (this.mCanvasObject instanceof RadioGroupObject) {
            Vector vector;
            int n;
            RadioGroupObject radioGroupObject = (RadioGroupObject)this.mCanvasObject;
            int n2 = radioGroupObject.radioItemCount();
            HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
            Vector<RadioItemDefinition> vector2 = new Vector<RadioItemDefinition>();
            Vector<Vector> vector3 = new Vector<Vector>(n2);
            for (n = 0; n < n2; ++n) {
                vector3.add(radioGroupObject.getRadioItem(n).getCtrlConditions());
            }
            for (n = n2 - 1; n >= 0; --n) {
                RadioItemDefinition radioItemDefinition = radioGroupObject.getRadioItem(n);
                vector = radioGroupObject.getRadioComponents(radioItemDefinition);
                hashMap.put(radioItemDefinition.getControlId(), vector);
                vector2.add(0, radioGroupObject.removeRadioItem(n));
            }
            n = 0;
            for (int i = 0; i < this.getRowCount() - 1; ++i) {
                Iterator iterator;
                Object object;
                RadioItemDefinition radioItemDefinition;
                String string = this.getStringValue(i, this.columnIndex(ColType.name));
                if (string == null || string.length() == 0) {
                    string = BuilderResUtil.getString("IDS_RADIO") + " " + (i + 1);
                    this.setValueAt(string, i, this.columnIndex(ColType.name));
                }
                String string2 = this.getStringValue(i, this.columnIndex(ColType.tip));
                String string3 = this.getStringValue(i, this.columnIndex(ColType.identifier));
                if (string3.trim().length() == 0) {
                    this.setDefaultIdentifier(i);
                }
                String string4 = this.getStringValue(i, this.columnIndex(ColType.syntax));
                if (i < n2) {
                    radioGroupObject.addRadioItem(string, string2, null, -1);
                    radioItemDefinition = radioGroupObject.getRadioItem(n);
                    radioItemDefinition.setControlId(string3);
                    radioItemDefinition.setTemporary(((RadioItemDefinition)vector2.get(i)).isTemporary());
                } else {
                    radioGroupObject.addTempRadioItem(string, string2, null, -1);
                    radioItemDefinition = radioGroupObject.getRadioItem(n);
                }
                radioItemDefinition.setControlSyntax(string4);
                String string5 = this.getStringValue(i, this.columnIndex(ColType.mnemonic));
                if (string5.length() > 0) {
                    object = (int)string5.toUpperCase().charAt(0);
                    radioItemDefinition.setMnemonicKey((Integer)object);
                } else {
                    radioItemDefinition.setMnemonicKey(null);
                }
                if (vector3.size() > 0 && i < vector3.size()) {
                    radioItemDefinition.setControlConditions((Vector)vector3.get(i));
                }
                boolean bl = (object = this.getStringValue(i, this.columnIndex(ColType.hasSubGroup))) != null && ((String)object).equalsIgnoreCase("true");
                radioItemDefinition.setHasSubGroup(bl);
                if (bl) {
                    Object object2;
                    RadioItemDefinition radioItemDefinition2 = null;
                    iterator = vector2.iterator();
                    while (iterator.hasNext()) {
                        object2 = (RadioItemDefinition)iterator.next();
                        if (!object2.getControlId().equals(string3)) continue;
                        radioItemDefinition2 = object2;
                        break;
                    }
                    if (radioItemDefinition2 != null) {
                        for (int j = 0; j < radioItemDefinition2.getElementCount(); ++j) {
                            radioItemDefinition.addPanelElement(radioItemDefinition2.getPanelElement(j));
                        }
                        radioItemDefinition2.removePanelElements();
                        vector = (Vector)hashMap.get(radioItemDefinition.getControlId());
                        iterator = vector.iterator();
                        while (iterator.hasNext()) {
                            object2 = (CanvasObject)iterator.next();
                            radioGroupObject.buildRadioSubItem((CanvasObject)object2, radioItemDefinition);
                        }
                    }
                }
                boolean bl2 = (iterator = this.getStringValue(i, this.columnIndex(ColType.isDefault))) != null && ((String)((Object)iterator)).equalsIgnoreCase("true");
                radioItemDefinition.setIsDefault(bl2);
                ++n;
            }
        } else if (this.mCanvasObject instanceof ComboBoxObject || this.mCanvasObject instanceof ListBoxObject) {
            ListDefinition listDefinition = (ListDefinition)this.mCanvasObject.getCtrlDef();
            Vector vector = listDefinition.getListItems();
            vector.clear();
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string = this.getStringValue(i, this.columnIndex(ColType.name));
                if (string == null || string.length() == 0) continue;
                String string6 = this.getStringValue(i, this.columnIndex(ColType.identifier));
                String string7 = this.getStringValue(i, this.columnIndex(ColType.isDefault));
                String string8 = this.getStringValue(i, this.columnIndex(ColType.syntax));
                boolean bl = string7 != null && string7.equalsIgnoreCase("true");
                ListDefinition.ListItem listItem = new ListDefinition.ListItem(string, "", string6);
                listItem.setIsDefaultItem(bl);
                listItem.setSyntax(string8);
                vector.add(listItem);
            }
        } else if (this.mCanvasObject instanceof TableCtrlObject) {
            TableCtrlObject tableCtrlObject = (TableCtrlObject)this.mCanvasObject;
            TableDefinition tableDefinition = (TableDefinition)tableCtrlObject.getCtrlDef();
            Vector<TableColItem> vector = new Vector<TableColItem>();
            int n = this.getRowCount();
            int n3 = 0;
            String string = BuilderResUtil.getString("IDS_WIDTH_DEAULT");
            String string9 = tableDefinition.getKeyAttribute();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                FieldChooserDefinition.SeparatorType separatorType;
                String string10 = this.getStringValue(i, this.columnIndex(ColType.identifier));
                String string11 = this.getStringValue(i, this.columnIndex(ColType.tableWidth));
                String string12 = this.getStringValue(i, this.columnIndex(ColType.name));
                String string13 = this.getStringValue(i, this.columnIndex(ColType.syntax));
                if (string10.length() == 0 || string12.length() == 0) continue;
                ControlDefinition.QuoteHandlingType quoteHandlingType = this.mOwner.getDialogDefinition().getAppType() == AppType.STATS ? ControlDefinition.QuoteHandlingType.Syntax : ControlDefinition.QuoteHandlingType.R;
                TableColItem tableColItem = new TableColItem(string10, n3++, quoteHandlingType);
                tableColItem.setColName(string12);
                if (string11.length() > 0) {
                    tableColItem.setColWidth(Integer.parseInt(string11));
                }
                tableColItem.setColSyntax(string13);
                String string14 = this.getStringValue(i, this.columnIndex(ColType.contentType));
                TableColItem.ColContentType colContentType = this.getTableContentType(string14);
                tableColItem.setContentType(colContentType);
                if (!bl && colContentType == TableColItem.ColContentType.VarName && string9.equals(string10)) {
                    bl = true;
                }
                String string15 = this.getStringValue(i, this.columnIndex(ColType.defaultValue));
                tableColItem.setDefaultValue(string15);
                String string16 = this.getStringValue(i, this.columnIndex(ColType.separatorType));
                int n4 = 0;
                for (n4 = 0; n4 < this.mTypeString.length && !string16.equals(this.mTypeString[n4]); ++n4) {
                }
                tableColItem.setSepTypeCustom("");
                switch (n4) {
                    case 0: {
                        separatorType = FieldChooserDefinition.SeparatorType.comma;
                        break;
                    }
                    case 1: {
                        separatorType = FieldChooserDefinition.SeparatorType.blank;
                        break;
                    }
                    case 2: {
                        separatorType = FieldChooserDefinition.SeparatorType.plus;
                        break;
                    }
                    default: {
                        if (string16.length() > 0) {
                            tableColItem.setSepTypeCustom(string16);
                        }
                        separatorType = FieldChooserDefinition.SeparatorType.blank;
                    }
                }
                tableColItem.setSeparatorType(separatorType);
                String string17 = this.getStringValue(i, this.columnIndex(ColType.quoted));
                if (string17.equalsIgnoreCase(this.mQuote[0])) {
                    tableColItem.setQuoted(false);
                } else {
                    tableColItem.setQuoted(true);
                }
                if (tableColItem.isQuoted()) {
                    String string18;
                    if (this.mOwner.getDialogDefinition().getAppType() == AppType.STATS) {
                        string18 = this.getStringValue(i, this.columnIndex(ColType.quoteHandle));
                        if (string18.equals(this.mQuoteHandle[0])) {
                            tableColItem.setQuoteType(ControlDefinition.QuoteHandlingType.Syntax);
                        } else if (string18.equals(this.mQuoteHandle[1])) {
                            tableColItem.setQuoteType(ControlDefinition.QuoteHandlingType.Python);
                        } else if (string18.equals(this.mQuoteHandle[2])) {
                            tableColItem.setQuoteType(ControlDefinition.QuoteHandlingType.R);
                        } else {
                            tableColItem.setQuoteType(ControlDefinition.QuoteHandlingType.None);
                        }
                    } else {
                        string18 = this.getStringValue(i, this.columnIndex(ColType.quoteHandle));
                        if (string18.equals(this.mQuoteHandle[0])) {
                            tableColItem.setQuoteType(ControlDefinition.QuoteHandlingType.Python);
                        } else if (string18.equals(this.mQuoteHandle[1])) {
                            tableColItem.setQuoteType(ControlDefinition.QuoteHandlingType.R);
                        } else {
                            tableColItem.setQuoteType(ControlDefinition.QuoteHandlingType.None);
                        }
                    }
                }
                vector.add(tableColItem);
            }
            tableDefinition.addColumns(vector);
            if (!bl && tableDefinition.getKeyProviderName().length() > 0) {
                tableDefinition.setKeyProviderName("");
                tableDefinition.setKeyAttribute("");
            }
        }
    }

    private String createDefaultTitle() {
        int n = this.columnIndex(ColType.identifier);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        String string = "Radio Button 3";
        boolean bl = false;
        String string2 = this.getRowCount() + "_" + ((TableDefinition)this.mCanvasObject.getCtrlDef()).getDefaultColumnSuffix();
        String string3 = string + "_" + string2;
        do {
            if (!this.checkForDupId(string3, this.getRowCount(), false)) {
                bl = true;
                continue;
            }
            string3 = string3 + "_1";
        } while (!bl);
        return string3;
    }

    private int columnIndex(ColType colType) {
        int n = 0;
        if (this.mCanvasObject instanceof RadioGroupObject) {
            if (colType == ColType.identifier) {
                n = 0;
            } else if (colType == ColType.name) {
                n = 1;
            } else if (colType == ColType.tip) {
                n = 2;
            } else if (colType == ColType.mnemonic) {
                n = 3;
            } else if (colType == ColType.hasSubGroup) {
                n = 4;
            } else if (colType == ColType.isDefault) {
                n = 5;
            } else if (colType == ColType.enableRule) {
                n = 6;
            } else if (colType == ColType.syntax) {
                n = this.mOwner.IsCompatibleMode() ? 6 : 7;
            } else assert (false);
        } else if (this.mCanvasObject instanceof ComboBoxObject || this.mCanvasObject instanceof ListBoxObject) {
            if (colType == ColType.identifier) {
                n = 0;
            } else if (colType == ColType.name) {
                n = 1;
            } else if (colType == ColType.isDefault) {
                n = 2;
            } else if (colType == ColType.syntax) {
                n = 3;
            } else assert (false);
        } else if (this.mCanvasObject instanceof TableCtrlObject) {
            if (colType == ColType.identifier) {
                n = 0;
            } else if (colType == ColType.name) {
                n = 1;
            } else if (colType == ColType.contentType) {
                n = 2;
            } else if (colType == ColType.defaultValue) {
                n = 3;
            } else if (colType == ColType.separatorType) {
                n = 4;
            } else if (colType == ColType.quoted) {
                n = 5;
            } else if (colType == ColType.quoteHandle) {
                n = 6;
            } else if (colType == ColType.tableWidth) {
                n = 7;
            } else if (colType == ColType.syntax) {
                n = 8;
            }
        } else assert (false);
        return n;
    }

    private String getStringValue(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        return object != null && object.toString().length() > 0 ? object.toString() : "";
    }

    private boolean rowEmpty(int n) {
        boolean bl = this.mCanvasObject instanceof RadioGroupObject;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        for (int i = 0; i < defaultTableModel.getColumnCount() - 1; ++i) {
            Object object;
            if (i == this.columnIndex(ColType.isDefault) || bl && i == this.columnIndex(ColType.hasSubGroup) || (object = defaultTableModel.getValueAt(n, i)) == null || object.toString().length() <= 0) continue;
            return false;
        }
        return true;
    }

    private void init() {
        if (sUpImage == null) {
            sUpImage = new ImageIcon(BuilderResUtil.getImageResource("moveUp.gif"));
        }
        if (sDownImage == null) {
            sDownImage = new ImageIcon(BuilderResUtil.getImageResource("moveDown.gif"));
        }
        this.mUpButton = new JButton();
        this.mUpButton.setIcon(sUpImage);
        this.mUpButton.addActionListener(this);
        this.mDownButton = new JButton();
        this.mDownButton.setIcon(sDownImage);
        this.mDownButton.addActionListener(this);
        int n = 0;
        this.setAutoscrolls(true);
        this.setBackground(new Color(221, 221, 221));
        this.getTableHeader().setResizingAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setRowHeight(this.getRowHeight() + 2);
        TableColumn tableColumn = new TableColumn(n++);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_IDENTIFIER"));
        this.addColumn(tableColumn);
        tableColumn = new TableColumn(n++);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_COL_NAME"));
        this.addColumn(tableColumn);
        if (this.mCanvasObject instanceof TableCtrlObject) {
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_CONTENTS"));
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_DEFAULT_VALUE"));
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_SEPARATOR_TYPE"));
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_TABLE_COL_QUOTED"));
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_TABLE_COL_QUOTE_HANGDLE"));
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_TABLE_COL_WIDTH"));
            tableColumn.setPreferredWidth(30);
            this.addColumn(tableColumn);
        } else {
            if (this.mCanvasObject instanceof RadioGroupObject) {
                tableColumn = new TableColumn(n++);
                tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_TIP"));
                this.addColumn(tableColumn);
                tableColumn = new TableColumn(n++);
                tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_MNEMONIC_KEY"));
                this.addColumn(tableColumn);
                tableColumn = new TableColumn(n++);
                tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_NESTED_GROUP"));
                this.addColumn(tableColumn);
            }
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_DEFAULT"));
            this.addColumn(tableColumn);
            if (!this.mOwner.IsCompatibleMode() && this.mCanvasObject instanceof RadioGroupObject) {
                tableColumn = new TableColumn(n++);
                tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_ENABLING_RULE_TITLE"));
                this.addColumn(tableColumn);
            }
        }
        tableColumn = new TableColumn(n);
        if (this.mOwner.getDialogDefinition().getAppType() == AppType.STATS) {
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_SYNTAX"));
        } else if (this.mOwner.getDialogDefinition().getScriptType() == ScriptType.SYNTAX) {
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_SYNTAX_SCRIPT"));
        } else {
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_SYNTAX_R_PYTHON"));
        }
        this.addColumn(tableColumn);
        this.setDefaultRenderer(String.class, this.mCellRenderer);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ItemListTable.this.getSelectedRow();
                int n2 = ItemListTable.this.getSelectedColumn();
                if (n > -1 && n2 > -1) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)ItemListTable.this.getModel();
                    if (n2 == ItemListTable.this.columnIndex(ColType.identifier)) {
                        defaultTableModel.removeRow(n);
                    } else {
                        defaultTableModel.setValueAt("", n, n2);
                    }
                }
            }
        };
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "DeleteRow");
        this.getActionMap().put("DeleteRow", abstractAction);
    }

    private void saveOrig(CanvasObject canvasObject) {
        this.mOrigColumns = null;
        if (canvasObject instanceof TableCtrlObject) {
            TableDefinition tableDefinition = (TableDefinition)canvasObject.getCtrlDef();
            this.mOrigColumns = new Vector();
            Vector vector = tableDefinition.getColumns();
            for (TableColItem tableColItem : vector) {
                this.mOrigColumns.add(tableColItem);
            }
        }
    }

    class TableDefaultValueEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private JTextField mTextField;

        public TableDefaultValueEditor(JTextField jTextField) {
            super(jTextField);
            this.mTextField = jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mTextField.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n2 != ItemListTable.this.columnIndex(ColType.defaultValue)) {
                return this.mTextField;
            }
            String string = ItemListTable.this.getStringValue(n, ItemListTable.this.columnIndex(ColType.contentType));
            TableColItem.ColContentType colContentType = ItemListTable.this.getTableContentType(string);
            this.mTextField = colContentType == TableColItem.ColContentType.Integer ? new IntTextField() : (colContentType == TableColItem.ColContentType.Real ? new FloatTextField() : new StringTextField());
            this.setEditCtrl(this.mTextField);
            this.mTextField.setText(object != null ? object.toString() : "");
            return this.mTextField;
        }

        public void setEditCtrl(JTextField jTextField) {
            this.mTextField = jTextField;
            this.editorComponent = jTextField;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object object) {
                    TableDefaultValueEditor.this.mTextField.setText(object != null ? object.toString() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    return TableDefaultValueEditor.this.mTextField.getText();
                }
            };
            this.mTextField.addActionListener(this.delegate);
        }
    }

    class NumberEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private SPSSTextField mTextField;

        public NumberEditor(SPSSTextField sPSSTextField) {
            super((JTextField)sPSSTextField);
            this.mTextField = sPSSTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mTextField.getUnformattedText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.mTextField.setText(object != null ? object.toString() : "");
            return this.mTextField;
        }

        public void setEditCtrl(SPSSTextField sPSSTextField) {
            this.mTextField = sPSSTextField;
            this.editorComponent = sPSSTextField;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object object) {
                    NumberEditor.this.mTextField.setText(object != null ? object.toString() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    return NumberEditor.this.mTextField.getUnformattedText();
                }
            };
            this.mTextField.addActionListener((ActionListener)this.delegate);
        }
    }

    class DefCellRenderer
    extends DefaultTableCellRenderer {
        Border mBorder = null;

        DefCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl4 = bl3 = jTable.isEnabled() && jTable.isCellEditable(n, n2);
            if (bl && !bl2) {
                this.setBackground(Color.lightGray);
            } else if (!bl || !bl2) {
                this.setBackground(jTable.isEnabled() ? Color.white : Color.lightGray);
            }
            this.setForeground(bl3 ? Color.black : Color.darkGray);
            if (component instanceof JComponent) {
                if (this.mBorder == null) {
                    this.mBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
                }
                ((JComponent)component).setBorder(this.mBorder);
            }
            return component;
        }
    }

    static enum ColType {
        identifier,
        name,
        tip,
        mnemonic,
        hasSubGroup,
        isDefault,
        syntax,
        contentType,
        tableWidth,
        defaultValue,
        separatorType,
        quoted,
        quoteHandle,
        enableRule;

    }
}

