/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssButtonGroup;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.StringTextField;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ComboBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ListBoxObject;
import com.spss.shared.custom_gui.ui_builder.props_ui.ItemListTable;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.ui_builder.DefinitionUtil;
import com.spss.uitools.ui_builder.definition.ComboBoxDefinition;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.FieldChooserDefinition;
import com.spss.uitools.ui_builder.definition.ListBoxDefinition;
import com.spss.uitools.ui_builder.definition.ListDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.ScriptType;
import com.spss.uitools.ui_builder.definition.TargetListDefinition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ItemListDlg
extends JDialog
implements DocumentListener {
    private ItemListTable mTable;
    private BuilderFrame mFrame;
    private StringTextField mAttrNameField;
    private JRadioButton mCustomAttrRadio;
    private JRadioButton mValueLabelsRadio;
    private JRadioButton mVarNamesRadio;
    private JLabel mValuesBasedOnLabel;
    private JComboBox mTargetCombo;
    private JLabel mTargetListLabel;
    private JLabel mSyntaxLabel;
    private StringTextField mSyntaxField;
    private JRadioButton mManualRadio;
    private JRadioButton mSrcValuesRadio;
    private JCheckBox mValuesLabelsCheck;
    private OKAction mOKAction;
    private Hashtable<String, PanelElementDefinition> mTargetAndFieldChooser;

    public ItemListDlg(BuilderFrame builderFrame, String string, CanvasObject canvasObject) throws HeadlessException {
        super(builderFrame, string, true);
        this.mFrame = builderFrame;
        this.init(canvasObject);
        this.loadData(canvasObject);
        this.pack();
        if (builderFrame.getCanvas().getDialogDefinition().isSubDialog()) {
            this.mManualRadio.setSelected(true);
            this.mSrcValuesRadio.setEnabled(false);
        }
        this.enableControls(this.mManualRadio.isSelected());
        this.setLocationRelativeTo(builderFrame);
    }

    private void init(CanvasObject canvasObject) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        insets.bottom = 2;
        Insets insets2 = (Insets)insets.clone();
        insets2.top = 2;
        insets2.bottom = 4;
        insets2.left += 20;
        insets2.right += 20;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        this.mManualRadio = new JRadioButton(new ManualRadioAction());
        spssButtonGroup.add(this.mManualRadio);
        DialogUtil.addUsingGBL(this, this.mManualRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.mTable = new ItemListTable(this.mFrame, canvasObject);
        this.mTable.setBorder(BorderFactory.createEtchedBorder());
        this.mTable.getColumnModel().setColumnMargin(1);
        JScrollPane jScrollPane = new JScrollPane(this.mTable);
        Dimension dimension = new Dimension(400, 100);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(1, 1, 1, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 1, 1, 1);
        DialogUtil.addUsingGBL(jPanel2, this.mTable.getUpButton(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mTable.getDownButton(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, 0, 1, 1);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, insets2.left, 4, 0);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        this.mSrcValuesRadio = new JRadioButton(new ListSourceRadioAction());
        spssButtonGroup.add(this.mSrcValuesRadio);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, 10, 1, 1);
        DialogUtil.addUsingGBL(this, this.mSrcValuesRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        JPanel jPanel3 = this.makeListSourcePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, insets2.left, 4, 4);
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        JPanel jPanel4 = new JPanel(null, true);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        if (this.mFrame.getDialogDefinition().getScriptType() == ScriptType.R) {
            this.mSyntaxLabel = new JLabel(BuilderResUtil.getString("IDS_SCRIPT_LABEL"));
            this.mSyntaxLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_SCRIPT_LABEL"));
        } else {
            this.mSyntaxLabel = new JLabel(BuilderResUtil.getString("IDS_SYNTAX_LABEL"));
            this.mSyntaxLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_SYNTAX_LABEL"));
        }
        jPanel4.add(this.mSyntaxLabel);
        jPanel4.add(Box.createRigidArea(new Dimension(4, 0)));
        this.mSyntaxField = new StringTextField(30);
        jPanel4.add((Component)((Object)this.mSyntaxField));
        this.mSyntaxLabel.setLabelFor((Component)((Object)this.mSyntaxField));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 10, 1, 1);
        DialogUtil.addUsingGBL(this, jPanel4, gridBagConstraints, 0, 4, 1, 1, n, insets);
        dimension = this.mSyntaxField.getPreferredSize();
        dimension.height += 3;
        this.mSyntaxField.setMinimumSize(dimension);
        this.mSyntaxField.setPreferredSize(dimension);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 20;
        insets.bottom += 4;
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 5, 5));
        this.mOKAction = new OKAction();
        jPanel5.add(new JButton(this.mOKAction));
        jPanel5.add(new JButton(new CancelAction()));
        jPanel5.add(new JButton(new HelpAction()));
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel5);
        this.add((Component)jPanel5, gridBagConstraints);
        this.mManualRadio.setSelected(true);
        this.setMinimumSize(new Dimension(500, 400));
    }

    private JPanel makeListSourcePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets2.bottom += 12;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets2;
        JPanel jPanel2 = new JPanel(null, true);
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        jPanel2.setLayout(boxLayout);
        this.mTargetListLabel = new JLabel(BuilderResUtil.getString("IDS_TARGET_LIST_LABEL"));
        this.mTargetListLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_TARGET_LIST_LABEL"));
        jPanel2.add(this.mTargetListLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(4, 0)));
        this.mTargetCombo = new JComboBox<String>(this.getComboItems());
        this.mTargetCombo.setEditable(true);
        this.mTargetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ItemListDlg.this.enableRadioControls();
            }
        });
        Dimension dimension = this.mTargetCombo.getPreferredSize();
        dimension.width = 120;
        this.mTargetCombo.setMinimumSize(dimension);
        Dimension dimension2 = this.mTargetCombo.getPreferredSize();
        if (dimension2.width < dimension.width) {
            this.mTargetCombo.setPreferredSize(dimension);
        }
        jPanel2.add(this.mTargetCombo);
        this.mTargetListLabel.setLabelFor(this.mTargetCombo);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        Component component = this.mTargetCombo.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(new ComboDocListener());
        }
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = insets;
        this.mValuesBasedOnLabel = new JLabel(BuilderResUtil.getString("IDS_VALUES_BASED_ON"));
        jPanel3.add((Component)this.mValuesBasedOnLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        this.mVarNamesRadio = new JRadioButton(new ValuesBasedOnAction(ValuesType.var_names));
        spssButtonGroup.add(this.mVarNamesRadio);
        jPanel3.add((Component)this.mVarNamesRadio, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.mValueLabelsRadio = new JRadioButton(new ValuesBasedOnAction(ValuesType.value_labels));
        spssButtonGroup.add(this.mValueLabelsRadio);
        jPanel3.add((Component)this.mValueLabelsRadio, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = (Insets)insets.clone();
        gridBagConstraints.insets.left += 16;
        this.mValuesLabelsCheck = new JCheckBox(BuilderResUtil.getString("IDS_USE_VALUES_IN_SYNTAX"));
        this.mValuesLabelsCheck.setMnemonic(BuilderResUtil.getAccessKey("IDK_USE_VALUES_IN_SYNTAX"));
        jPanel3.add((Component)this.mValuesLabelsCheck, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        jPanel2 = new JPanel(null, true);
        boxLayout = new BoxLayout(jPanel2, 0);
        jPanel2.setLayout(boxLayout);
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        this.mCustomAttrRadio = new JRadioButton(new ValuesBasedOnAction(ValuesType.custom_attr));
        spssButtonGroup.add(this.mCustomAttrRadio);
        jPanel2.add(this.mCustomAttrRadio);
        this.mAttrNameField = new StringTextField(20);
        jPanel2.add((Component)((Object)this.mAttrNameField));
        this.mVarNamesRadio.setSelected(true);
        this.mAttrNameField.setMinimumSize(this.mAttrNameField.getPreferredSize());
        this.mAttrNameField.getDocument().addDocumentListener(this);
        return jPanel;
    }

    private Vector<String> getComboItems() {
        Vector<String> vector = new Vector<String>();
        this.mTargetAndFieldChooser = new Hashtable();
        this.loadTargetListIds((PanelElementDefinition)this.mFrame.getCanvas().getDialogDefinition().getCurrentPanel(), vector);
        return vector;
    }

    private void enableOK() {
        boolean bl = this.mManualRadio.isSelected() || this.mTargetCombo.getEditor().getItem() != null && this.mTargetCombo.getEditor().getItem().toString().length() > 0;
        boolean bl2 = this.mManualRadio.isSelected() || !this.mCustomAttrRadio.isSelected() || this.mCustomAttrRadio.isSelected() && this.mAttrNameField.getText().length() > 0;
        this.mOKAction.setEnabled(bl && bl2);
    }

    private boolean checkForTargetList() {
        String string;
        int n;
        if (this.mManualRadio.isSelected()) {
            return true;
        }
        Object object = this.mTargetCombo.getEditor().getItem();
        if (object == null) {
            object = "";
        }
        return DefinitionUtil.findPanelItem((DialogDefinition)this.mFrame.getCanvas().getDialogDefinition(), (String)object.toString()) != null || 0 == (n = BuilderAlertPane.showConfirmDialog(this.mFrame, string = String.format(BuilderResUtil.getString("IDS_NO_TARGET_WARNING"), object.toString()), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.OK_CANCEL_OPTION));
    }

    private void loadData(CanvasObject canvasObject) {
        if (canvasObject instanceof ComboBoxObject) {
            ComboBoxDefinition comboBoxDefinition = ((ComboBoxObject)canvasObject).getComboDef();
            this.mSyntaxField.setText(comboBoxDefinition.getControlSyntax());
            this.mAttrNameField.setText(comboBoxDefinition.getCustomAttrName());
            this.mValuesLabelsCheck.setSelected(comboBoxDefinition.getUseValues());
            this.mSrcValuesRadio.setSelected(comboBoxDefinition.isDynamicSourceType());
            this.mTargetCombo.setSelectedItem(comboBoxDefinition.getTargetListId());
            ListDefinition.ValueSourceType valueSourceType = comboBoxDefinition.getSourceType();
            if (valueSourceType == ListDefinition.ValueSourceType.variable_names) {
                this.mVarNamesRadio.setSelected(true);
            } else if (valueSourceType == ListDefinition.ValueSourceType.value_labels) {
                this.mValueLabelsRadio.setSelected(true);
            } else if (valueSourceType == ListDefinition.ValueSourceType.custom_attribute) {
                this.mCustomAttrRadio.setSelected(true);
            }
        } else if (canvasObject instanceof ListBoxObject) {
            ListBoxDefinition listBoxDefinition = ((ListBoxObject)canvasObject).getListDef();
            this.mSyntaxField.setText(listBoxDefinition.getControlSyntax());
            this.mAttrNameField.setText(listBoxDefinition.getCustomAttrName());
            this.mValuesLabelsCheck.setSelected(listBoxDefinition.getUseValues());
            this.mSrcValuesRadio.setSelected(listBoxDefinition.isDynamicSourceType());
            this.mTargetCombo.setSelectedItem(listBoxDefinition.getTargetListId());
            ListDefinition.ValueSourceType valueSourceType = listBoxDefinition.getSourceType();
            if (valueSourceType == ListDefinition.ValueSourceType.variable_names) {
                this.mVarNamesRadio.setSelected(true);
            } else if (valueSourceType == ListDefinition.ValueSourceType.value_labels) {
                this.mValueLabelsRadio.setSelected(true);
            } else if (valueSourceType == ListDefinition.ValueSourceType.custom_attribute) {
                this.mCustomAttrRadio.setSelected(true);
            }
        }
    }

    private void loadTargetListIds(PanelElementDefinition panelElementDefinition, Vector<String> vector) {
        int n;
        if (panelElementDefinition instanceof PanelDefinition) {
            n = ((PanelDefinition)panelElementDefinition).getElementCount();
        } else if (panelElementDefinition instanceof RadioItemDefinition) {
            n = ((RadioItemDefinition)panelElementDefinition).getElementCount();
        } else {
            return;
        }
        for (int i = 0; i < n; ++i) {
            PanelElementDefinition panelElementDefinition2 = panelElementDefinition instanceof PanelDefinition ? ((PanelDefinition)panelElementDefinition).getPanelElement(i) : ((RadioItemDefinition)panelElementDefinition).getPanelElement(i);
            if (panelElementDefinition2 instanceof TargetListDefinition || panelElementDefinition2 instanceof FieldChooserDefinition) {
                vector.add(panelElementDefinition2.getControlId());
                this.mTargetAndFieldChooser.put(panelElementDefinition2.getControlId(), panelElementDefinition2);
            }
            if (panelElementDefinition2 instanceof PanelDefinition) {
                this.loadTargetListIds(panelElementDefinition2, vector);
                continue;
            }
            if (!(panelElementDefinition2 instanceof RadioGroupDefinition)) continue;
            RadioGroupDefinition radioGroupDefinition = (RadioGroupDefinition)panelElementDefinition2;
            for (int j = 0; j < radioGroupDefinition.radioItemCount(); ++j) {
                this.loadTargetListIds((PanelElementDefinition)radioGroupDefinition.getRadioItem(j), vector);
            }
        }
    }

    private void enableControls(boolean bl) {
        this.mTable.setEnabled(bl);
        this.mTable.getUpButton().setEnabled(bl);
        this.mTable.getDownButton().setEnabled(bl);
        if (bl) {
            this.mTable.enableUpDownButton(-1);
        }
        this.mTargetListLabel.setEnabled(!bl);
        this.mTargetCombo.setEnabled(!bl);
        this.enableRadioControls();
        this.enableOK();
    }

    private void enableRadioControls() {
        PanelElementDefinition panelElementDefinition;
        Object object;
        boolean bl = this.mTargetCombo.isEnabled();
        boolean bl2 = false;
        if (bl && (object = this.mTargetCombo.getSelectedItem()) != null && object.toString().length() > 0 && (panelElementDefinition = this.mTargetAndFieldChooser.get(object.toString())) instanceof FieldChooserDefinition) {
            bl2 = true;
        }
        this.mValuesBasedOnLabel.setEnabled(bl);
        this.mVarNamesRadio.setEnabled(bl);
        if (bl && bl2) {
            this.mVarNamesRadio.setSelected(true);
        }
        this.mValueLabelsRadio.setEnabled(bl && !bl2);
        this.mCustomAttrRadio.setEnabled(bl && !bl2);
        this.mAttrNameField.setEnabled(bl && !bl2 && this.mCustomAttrRadio.isSelected());
        this.mValuesLabelsCheck.setEnabled(bl && !bl2 && this.mValueLabelsRadio.isSelected());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOK();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOK();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableOK();
    }

    class ComboDocListener
    implements DocumentListener {
        ComboDocListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ItemListDlg.this.enableOK();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ItemListDlg.this.enableOK();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ItemListDlg.this.enableOK();
        }
    }

    static enum ValuesType {
        var_names,
        value_labels,
        custom_attr;

    }

    class ValuesBasedOnAction
    extends AbstractAction {
        private ValuesType mType;

        public ValuesBasedOnAction(ValuesType valuesType) {
            this.mType = valuesType;
            if (this.mType == ValuesType.var_names) {
                this.putValue("Name", BuilderResUtil.getString("IDS_VAR_NAMES"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_VAR_NAMES"));
            } else if (this.mType == ValuesType.value_labels) {
                this.putValue("Name", BuilderResUtil.getString("IDS_VALUE_LABELS"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_VALUE_LABELS"));
            } else if (this.mType == ValuesType.custom_attr) {
                this.putValue("Name", BuilderResUtil.getString("IDS_CUSTOM_ATTR"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_CUSTOM_ATTR"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ItemListDlg.this.mAttrNameField.setEnabled(this.mType == ValuesType.custom_attr);
            ItemListDlg.this.mValuesLabelsCheck.setEnabled(this.mType == ValuesType.value_labels);
            ItemListDlg.this.enableOK();
        }
    }

    class ListSourceRadioAction
    extends AbstractAction {
        ListSourceRadioAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_LIST_SRC_VALUES"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_LIST_SRC_VALUES"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ItemListDlg.this.enableControls(false);
        }
    }

    class ManualRadioAction
    extends AbstractAction {
        ManualRadioAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_MANUAL_VALUES"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_MANUAL_VALUES"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ItemListDlg.this.enableControls(true);
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderUtil.getInstance().showHelp("spss/base/idh_idd_uibuilder_listprops");
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ItemListDlg.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ItemListDlg.this.checkForTargetList()) {
                return;
            }
            if (ItemListDlg.this.mTable.isEditing()) {
                ItemListDlg.this.mTable.getCellEditor().stopCellEditing();
            }
            ItemListDlg.this.mTable.saveData();
            CanvasObject canvasObject = ItemListDlg.this.mTable.getCanvasObject();
            if (canvasObject instanceof ComboBoxObject) {
                ComboBoxDefinition comboBoxDefinition = ((ComboBoxObject)canvasObject).getComboDef();
                comboBoxDefinition.setControlSyntax(ItemListDlg.this.mSyntaxField.getText());
                comboBoxDefinition.setCustomAttrName(ItemListDlg.this.mAttrNameField.getText());
                comboBoxDefinition.setUseValues(ItemListDlg.this.mValuesLabelsCheck.isSelected());
                comboBoxDefinition.setDynamicSourceType(ItemListDlg.this.mSrcValuesRadio.isSelected());
                comboBoxDefinition.setTargetListId(ItemListDlg.this.mTargetCombo.getEditor().getItem().toString());
                if (ItemListDlg.this.mVarNamesRadio.isSelected()) {
                    comboBoxDefinition.setSourceType(ListDefinition.ValueSourceType.variable_names);
                } else if (ItemListDlg.this.mValueLabelsRadio.isSelected()) {
                    comboBoxDefinition.setSourceType(ListDefinition.ValueSourceType.value_labels);
                } else if (ItemListDlg.this.mCustomAttrRadio.isSelected()) {
                    comboBoxDefinition.setSourceType(ListDefinition.ValueSourceType.custom_attribute);
                }
            } else if (canvasObject instanceof ListBoxObject) {
                ListBoxDefinition listBoxDefinition = ((ListBoxObject)canvasObject).getListDef();
                listBoxDefinition.setControlSyntax(ItemListDlg.this.mSyntaxField.getText());
                listBoxDefinition.setCustomAttrName(ItemListDlg.this.mAttrNameField.getText());
                listBoxDefinition.setUseValues(ItemListDlg.this.mValuesLabelsCheck.isSelected());
                listBoxDefinition.setDynamicSourceType(ItemListDlg.this.mSrcValuesRadio.isSelected());
                listBoxDefinition.setTargetListId(ItemListDlg.this.mTargetCombo.getEditor().getItem().toString());
                if (ItemListDlg.this.mVarNamesRadio.isSelected()) {
                    listBoxDefinition.setSourceType(ListDefinition.ValueSourceType.variable_names);
                } else if (ItemListDlg.this.mValueLabelsRadio.isSelected()) {
                    listBoxDefinition.setSourceType(ListDefinition.ValueSourceType.value_labels);
                } else if (ItemListDlg.this.mCustomAttrRadio.isSelected()) {
                    listBoxDefinition.setSourceType(ListDefinition.ValueSourceType.custom_attribute);
                }
            }
            ItemListDlg.this.mFrame.setModified(true);
            ItemListDlg.this.mFrame.getCanvas().fireSelectionChange(canvasObject);
            ItemListDlg.this.dispose();
        }
    }
}

