/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.SyntaxDiagramDlg;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ButtonEditCtrl;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.IButtonEditListener;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.canvas.CheckBoxGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.CheckBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.SubDlgButtonObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.CheckBoxDefinition;
import com.spss.uitools.ui_builder.definition.CheckBoxGroupDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class IdentifierTable
extends JTable
implements IButtonEditListener {
    private BuilderFrame mOwner;
    private Border mCellBorder = null;
    private TableCellRenderer mCellRenderer = new DefCellRenderer();
    private boolean mInLoadData;
    private LinkedList<CanvasObject> mElements;
    private SyntaxDiagramDlg mSyntaxDlg;

    public IdentifierTable(BuilderFrame builderFrame) {
        this.mOwner = builderFrame;
        this.mInLoadData = false;
        this.mElements = new LinkedList();
        this.init();
        this.loadRowData(null, -1);
        this.setupColumnWidths();
    }

    private void refreshTable() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        int n = this.getSelectedRow();
        LinkedList<CanvasObject> linkedList = this.getAllCanvasObjects();
        Vector<CanvasObject> vector = new Vector<CanvasObject>();
        for (CanvasObject canvasObject : linkedList) {
            vector.add(canvasObject);
        }
        this.removeAllObject();
        for (CanvasObject canvasObject : vector) {
            this.addCanvasObject(canvasObject);
        }
        if (n >= 0) {
            this.setRowSelectionInterval(n, n);
        }
    }

    public void addCanvasObject(CanvasObject canvasObject) {
        int n;
        if (canvasObject == null) {
            return;
        }
        for (n = 0; n < this.mElements.size(); ++n) {
            CanvasObject canvasObject2 = this.mElements.get(n);
            if (!canvasObject2.getControlId().equals(canvasObject.getControlId())) continue;
            return;
        }
        n = this.mElements.size();
        this.mElements.add(canvasObject);
        this.loadRowData(canvasObject, n);
    }

    public void removeCanvasObject(CanvasObject canvasObject) {
        for (int i = 0; i < this.mElements.size(); ++i) {
            CanvasObject canvasObject2 = this.mElements.get(i);
            if (!canvasObject2.getControlId().equals(canvasObject.getControlId())) continue;
            this.mElements.remove(canvasObject2);
            ((DefaultTableModel)this.getModel()).removeRow(i);
            return;
        }
    }

    public void removeCanvasObject(String string) {
        for (int i = 0; i < this.mElements.size(); ++i) {
            CanvasObject canvasObject = this.mElements.get(i);
            if (!canvasObject.getControlId().equals(string)) continue;
            this.mElements.remove(canvasObject);
            ((DefaultTableModel)this.getModel()).removeRow(i);
            return;
        }
    }

    public void removeAllObject() {
        this.mElements.clear();
        this.removeAll();
        ((DefaultTableModel)this.getModel()).setRowCount(0);
    }

    public LinkedList<CanvasObject> getAllCanvasObjects() {
        return this.mElements;
    }

    public boolean hasCheckbox() {
        boolean bl = false;
        for (int i = 0; i < this.mElements.size(); ++i) {
            CanvasObject canvasObject = this.mElements.get(i);
            if (!(canvasObject instanceof CheckBoxObject) && !(canvasObject instanceof CheckBoxGroupObject)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void updateCanvasObject(CanvasObject canvasObject, String string, String string2, String string3) {
        int n;
        Object object;
        int n2;
        if (canvasObject == null) {
            return;
        }
        String string4 = canvasObject.getControlId();
        if (canvasObject instanceof SubDlgButtonObject) {
            n2 = this.getSelectedRow();
            object = "";
            if (n2 >= 0) {
                object = this.mElements.get(n2).getControlId();
            }
            SubDlgButtonDefinition subDlgButtonDefinition = (SubDlgButtonDefinition)((SubDlgButtonObject)canvasObject).getCtrlDef();
            PanelDefinition panelDefinition = subDlgButtonDefinition.getDialogDefinition().getCurrentPanel();
            boolean bl = false;
            if (panelDefinition.getElementCount() > 0) {
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    if (((String)object).equals(panelDefinition.getPanelElement(i).getControlId())) {
                        bl = true;
                        break;
                    }
                    if (!(panelDefinition.getPanelElement(i) instanceof PanelDefinition) || !((PanelDefinition)panelDefinition.getPanelElement(i)).containsControl((String)object)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    string4 = panelDefinition.getPanelElement(0).getControlId();
                }
            }
        }
        n2 = -1;
        object = null;
        for (n = 0; n < this.mElements.size(); ++n) {
            object = this.mElements.get(n);
            if (!((CanvasObject)object).getControlId().equals(string4)) continue;
            n2 = n;
        }
        if (n2 >= 0) {
            n = 0;
            int n3 = -1;
            String string5 = "";
            if (string == null && string2 == null && string3 == null) {
                this.setRowSelectionInterval(n2, n2);
                IdentifierTable.scrollRowToVisible(this, n2, 0);
            } else {
                if (string != null) {
                    n = 1;
                    n3 = 0;
                    string5 = string;
                }
                if (string2 != null) {
                    n = 1;
                    n3 = 1;
                    string5 = string2;
                }
                if (string3 != null) {
                    n = 1;
                    n3 = 3;
                    string5 = string3;
                }
            }
            if (n != 0) {
                this.mInLoadData = true;
                this.setValueAt(string5, n2, n3);
                this.refreshTable();
                this.mInLoadData = false;
            }
        }
    }

    public static void scrollRowToVisible(JTable jTable, int n, int n2) {
        if (!(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jTable.scrollRectToVisible(rectangle);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
        if (tableCellRenderer instanceof JComponent) {
            ((JComponent)((Object)tableCellRenderer)).setBackground(Color.white);
            if (this.mCellBorder == null) {
                this.mCellBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
            }
            ((JComponent)((Object)tableCellRenderer)).setBorder(this.mCellBorder);
        }
        return tableCellRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = super.getCellEditor(n, n2);
        return tableCellEditor;
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
        return this.mCellRenderer;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!super.isCellEditable(n, n2)) {
            return false;
        }
        return n2 == 1 || n2 == 3;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        Component component;
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && (component = this.getEditorComponent()) instanceof JTextField) {
            MouseEvent mouseEvent;
            final JTextField jTextField = (JTextField)component;
            jTextField.selectAll();
            if (eventObject instanceof MouseEvent && (mouseEvent = (MouseEvent)eventObject).getClickCount() > 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jTextField.selectAll();
                    }
                });
            }
        }
        return bl;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (!this.mInLoadData && object != null) {
            if (n2 == 1) {
                this.setControlTitle(n, object.toString());
            } else if (n2 == 3) {
                this.setControlSyntax(n, object.toString());
            }
        }
        super.setValueAt(object, n, n2);
    }

    @Override
    public void buttonPressed(long l, int n) {
        String string;
        String string2;
        this.mInLoadData = true;
        final int n2 = (int)l;
        int n3 = n;
        String string3 = this.getControlSyntax(n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ThisValue");
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            string2 = "IDS_CONTROL_SYNTAX_DESC";
            string = BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM_PROPERTY");
        } else {
            string2 = "IDS_CONTROL_SCRIPT_DESC";
            string = BuilderResUtil.getString("IDS_SCRIPT_DIAGRAM_PROPERTY");
        }
        this.mSyntaxDlg = new SyntaxDiagramDlg(this.mOwner, string, string3, arrayList, this.mOwner.getSyntaxCommand(), string2, new SyntaxDiagramDlg.SyntaxDiagramDlgCallback(){

            @Override
            public void syntaxModifiedNotification() {
                String string = IdentifierTable.this.mSyntaxDlg.getSyntax();
                IdentifierTable.this.setNewSyntax(n2, string);
                IdentifierTable.this.mOwner.setModified(true);
            }

            @Override
            public void showHelp() {
                BuilderUtil.getInstance().showHelp("clementine/idh_idd_uibuilder_syntemplate");
            }

            @Override
            public boolean showInvalidSyntaxWarning() {
                int n = BuilderAlertPane.showConfirmDialog((Window)((Object)IdentifierTable.this.mSyntaxDlg), BuilderResUtil.getString("IDS_INVALID_SYNTAX_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                return n == 2;
            }
        });
        this.mSyntaxDlg.setVisible(true);
        if (this.mSyntaxDlg.getModalResult()) {
            this.mOwner.getCanvas().fireSelectionChange(this.mElements.get(n2));
            this.mOwner.setModified(true);
            this.refreshTable();
        }
        this.mInLoadData = false;
    }

    private void setNewSyntax(int n, String string) {
        if (this.mElements.get(n) instanceof CheckBoxObject) {
            ((CheckBoxDefinition)this.mElements.get(n).getCtrlDef()).setCheckedSyntax(string);
        } else if (this.mElements.get(n) instanceof CheckBoxGroupObject) {
            ((CheckBoxGroupDefinition)this.mElements.get(n).getCtrlDef()).getControllerCheckBox().setCheckedSyntax(string);
        } else {
            this.mElements.get(n).setControlSyntax(string);
        }
    }

    private String getControlSyntax(int n) {
        String string = this.mElements.get(n) instanceof CheckBoxObject ? ((CheckBoxDefinition)this.mElements.get(n).getCtrlDef()).getCheckedSyntax() : (this.mElements.get(n) instanceof CheckBoxGroupObject ? ((CheckBoxGroupDefinition)this.mElements.get(n).getCtrlDef()).getControllerCheckBox().getCheckedSyntax() : this.mElements.get(n).getControlSyntax());
        return string;
    }

    private void setControlTitle(int n, String string) {
        if (n < 0 || n >= this.mElements.size()) {
            return;
        }
        this.mElements.get(n).setControlTitle(string);
        this.mOwner.getCanvas().fireSelectionChange(this.mElements.get(n));
        this.mOwner.setModified(true);
    }

    private void setControlSyntax(int n, String string) {
        if (n < 0 || n >= this.mElements.size()) {
            return;
        }
        this.setNewSyntax(n, string);
        this.mOwner.getCanvas().fireSelectionChange(this.mElements.get(n));
        this.mOwner.setModified(true);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.getTableHeader().setForeground(bl ? Color.black : Color.darkGray);
        super.setEnabled(bl);
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        super.columnMarginChanged(changeEvent);
    }

    private void init() {
        int n = 0;
        this.setAutoscrolls(true);
        this.setBackground(new Color(221, 221, 221));
        this.getTableHeader().setResizingAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setRowHeight(this.getRowHeight() + 2);
        TableColumn tableColumn = new TableColumn(n++);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_IDENTIFIER"));
        this.addColumn(tableColumn);
        tableColumn = new TableColumn(n++);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_TITLE"));
        this.addColumn(tableColumn);
        tableColumn = new TableColumn(n++);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_TYPE"));
        this.addColumn(tableColumn);
        tableColumn = new TableColumn(n++);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_SYNTAX"));
        this.addColumn(tableColumn);
        ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(3);
        buttonEditCtrl.setFont(this.getFont().deriveFont(2));
        buttonEditCtrl.setReadOnlyEdit(false);
        buttonEditCtrl.addButtonListener(this);
        tableColumn.setCellEditor(buttonEditCtrl);
        tableColumn.setPreferredWidth(100);
        this.setDefaultRenderer(String.class, this.mCellRenderer);
    }

    private void setupColumnWidths() {
        double[] dArray = new double[]{0.15, 0.175, 0.175, 0.5};
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (dArray == null || tableColumnModel.getColumnCount() != dArray.length) {
            return;
        }
        int n = this.getPreferredScrollableViewportSize().width;
        int n2 = 0;
        for (double d : dArray) {
            tableColumnModel.getColumn(n2).setPreferredWidth((int)((double)n * d));
            ++n2;
        }
    }

    private void loadRowData(CanvasObject canvasObject, int n) {
        this.mInLoadData = true;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        defaultTableModel.setColumnCount(4);
        int n2 = defaultTableModel.getRowCount();
        if (canvasObject != null) {
            defaultTableModel.setRowCount(++n2);
            String string = canvasObject.getControlId();
            String string2 = canvasObject.getControlTitle();
            String string3 = canvasObject.getCanvasType();
            String string4 = canvasObject.getControlSyntax();
            if (canvasObject instanceof CheckBoxObject) {
                string4 = ((CheckBoxDefinition)canvasObject.getCtrlDef()).getCheckedSyntax();
            } else if (canvasObject instanceof CheckBoxGroupObject) {
                string4 = ((CheckBoxGroupDefinition)canvasObject.getCtrlDef()).getControllerCheckBox().getCheckedSyntax();
            }
            if (string4.length() == 0) {
                string4 = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
            }
            this.setValueAt(string, n, 0);
            this.setValueAt(string2, n, 1);
            this.setValueAt(string3, n, 2);
            this.setValueAt(string4, n, 3);
            this.mInLoadData = false;
        }
    }

    class DefCellRenderer
    extends DefaultTableCellRenderer {
        Border mBorder = null;

        DefCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl4 = bl3 = jTable.isEnabled() && jTable.isCellEditable(n, n2);
            if (bl && !bl2) {
                this.setBackground(Color.lightGray);
            } else if (!bl || !bl2) {
                this.setBackground(jTable.isEnabled() ? Color.white : Color.lightGray);
            }
            this.setForeground(bl3 ? Color.black : Color.darkGray);
            if (component instanceof JComponent) {
                if (this.mBorder == null) {
                    this.mBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
                }
                ((JComponent)component).setBorder(this.mBorder);
            }
            return component;
        }
    }

    static enum ColType {
        identifier,
        name,
        tip,
        mnemonic,
        hasSubGroup,
        isDefault,
        syntax,
        contentType,
        tableWidth,
        defaultValue,
        separatorType,
        quoted,
        quoteHandle,
        enableRule;

    }
}

