/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ComponentsArrowButton;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.PlainList;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssArrowButton;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssButtonGroup;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.ui_builder.definition.DatasetSelectorDefinition;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.FieldChooserDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.TargetListDefinition;
import com.spss.uitools.ui_builder.definition.VarListDefinition;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class FieldSourceSelectDlg
extends BaseDialog
implements ActionListener,
ItemListener {
    private BuilderFrame mFrame;
    private VarListDefinition mVarListDef;
    private DialogDefinition mDlgDef;
    private JRadioButton mActiveDataset;
    private JRadioButton mTargetListRadio;
    private JRadioButton mSelectors;
    private JLabel mTargetListLabel;
    private PlainList mTargetList;
    private DefaultListModel mTargetListModel;
    private Vector<String> mTargetIDs;
    private Vector<FieldChooserDefinition> mFieldChooserDef;
    private JLabel mSelectedTargetListLabel;
    private PlainList mSelectedTargetList;
    private DefaultListModel mSelectedTargetListModel;
    private TargetArrowButton mTargetArrowButton;
    private JRadioButton mInSpecifiedRadio;
    private JRadioButton mNotInRadio;
    private JLabel mSelectorListLabel;
    private PlainList mSelectorList;
    private DefaultListModel mSelectorListModel;
    private Vector<String> mDatasetSelectorIDs;
    private JLabel mSelectedSelectorListLabel;
    private PlainList mSelectedSelectorList;
    private DefaultListModel mSelectedSelectorListModel;
    private TargetArrowButton mSelectorArrowButton;
    private JButton mOkButton;
    private boolean mIsOKPressed;

    public FieldSourceSelectDlg(BuilderFrame builderFrame, VarListDefinition varListDefinition) throws HeadlessException {
        super((JFrame)builderFrame, BuilderResUtil.getString("IDS_FIELD_SOURCE_TITLE"), true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.mFrame = builderFrame;
        this.mVarListDef = varListDefinition;
        this.mDlgDef = null;
        this.mIsOKPressed = false;
        this.createPanel();
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
    }

    public FieldSourceSelectDlg(BuilderFrame builderFrame, DialogDefinition dialogDefinition) throws HeadlessException {
        super((JFrame)builderFrame, BuilderResUtil.getString("IDS_FIELD_SOURCE_TITLE"), true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.mFrame = builderFrame;
        this.mVarListDef = null;
        this.mDlgDef = dialogDefinition;
        this.createPanel();
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
    }

    public void doHelp() {
        if (this.mDlgDef != null) {
            BuilderUtil.getInstance().showHelp("spss/base/idh_idd_uibuilder_datasource");
        } else {
            BuilderUtil.getInstance().showHelp("spss/base/idh_idd_uibuilder_fieldsource");
        }
    }

    protected void init() {
        super.init();
        this.initVars();
    }

    private void createPanel() {
        JPanel jPanel = this.getViewPanel();
        if (this.mVarListDef == null && this.mDlgDef != null) {
            this.createDlgDatasource(jPanel);
        } else {
            this.createChooserSource(jPanel);
        }
        this.setDefault();
    }

    public boolean isOKPressed() {
        return this.mIsOKPressed;
    }

    private void createChooserSource(JPanel jPanel) {
        int n = 16;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, n, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mTargetListLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mTargetList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(new Dimension(150, this.mTargetList.getFixedCellHeight() * 4));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, n, 10, 2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 8, 8, 8);
        DialogUtil.addUsingGBL(jPanel, this.mTargetArrowButton, gridBagConstraints, 1, 1, 1, 2, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSelectedTargetListLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        Dimension dimension = new Dimension(120, this.mSelectedTargetList.getFixedCellHeight() + 6);
        this.mSelectedTargetList.setMaximumSize(dimension);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSelectedTargetList);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setPreferredSize(dimension);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 2, 6, 2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        String string = BuilderResUtil.getString("IDS_FS_INCLUDE_PANEL_TITLE");
        TitledBorder titledBorder = new TitledBorder(string);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mInSpecifiedRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mNotInRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, 2, 10, 2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 2, 1, 1, n2, insets);
    }

    private void createDlgDatasource(JPanel jPanel) {
        int n = 16;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 2, 6, 2);
        DialogUtil.addUsingGBL(jPanel, this.mActiveDataset, gridBagConstraints, 0, 0, 3, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(12, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSelectors, gridBagConstraints, 0, 1, 3, 1, n2, insets);
        insets.set(1, n, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSelectorListLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSelectorList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(new Dimension(120, this.mSelectorList.getFixedCellHeight() * 6));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, n, 10, 2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 8, 8, 8);
        DialogUtil.addUsingGBL(jPanel, this.mSelectorArrowButton, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSelectedSelectorListLabel, gridBagConstraints, 2, 2, 1, 1, n2, insets);
        Dimension dimension = new Dimension(120, this.mSelectorList.getFixedCellHeight() + 6);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSelectedSelectorList);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setPreferredSize(dimension);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, 2, 10, 2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 3, 1, 1, n2, insets);
    }

    private void setDefault() {
        if (this.mDlgDef != null) {
            this.mActiveDataset.setSelected(true);
        } else {
            this.mTargetListRadio.setSelected(true);
        }
        this.enableTargetListControls(false);
        this.enableSelectorListControls(false);
    }

    private void initVars() {
        this.mActiveDataset = new JRadioButton(BuilderResUtil.getString("IDS_FS_ACTIVE_DATASET"));
        this.mActiveDataset.setMnemonic(BuilderResUtil.getAccessKey("IDK_FS_ACTIVE_DATASET"));
        this.mActiveDataset.addItemListener(this);
        this.mTargetListRadio = new JRadioButton(BuilderResUtil.getString("IDS_FS_TARGET_LIST"));
        this.mTargetListRadio.setMnemonic(BuilderResUtil.getAccessKey("IDK_FS_TARGET_LIST"));
        this.mTargetListRadio.addItemListener(this);
        this.mSelectors = new JRadioButton(BuilderResUtil.getString("IDS_FS_SELECTOR"));
        this.mSelectors.setMnemonic(BuilderResUtil.getAccessKey("IDK_FS_SELECTOR"));
        this.mSelectors.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mActiveDataset);
        spssButtonGroup.add(this.mTargetListRadio);
        spssButtonGroup.add(this.mSelectors);
        this.mTargetListLabel = DialogUtil.createLabel(this, "IDS_FS_TARGET_LIST_LABEL");
        this.mTargetList = new PlainList("IDS_FS_TARGET_LIST");
        this.mTargetListLabel.setLabelFor(this.mTargetList);
        this.mTargetListModel = new DefaultListModel();
        this.mTargetList.setModel(this.mTargetListModel);
        this.mTargetList.setSelectionMode(0);
        this.mSelectedTargetListLabel = DialogUtil.createLabel(this, "IDS_FS_SELECTED_TARGET_LIST_LABEL");
        this.mSelectedTargetList = new PlainList("IDS_FS_TARGET_SELECTED_LIST");
        this.mSelectedTargetListLabel.setLabelFor(this.mTargetList);
        this.mSelectedTargetListModel = new DefaultListModel();
        this.mSelectedTargetList.setModel(this.mSelectedTargetListModel);
        this.mSelectedTargetList.setSelectionMode(0);
        this.mTargetArrowButton = new TargetArrowButton();
        this.mTargetArrowButton.registerComponents(this.mTargetList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetArrowButton.registerComponents(this.mSelectedTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mTargetArrowButton.addActionListener(this);
        this.mInSpecifiedRadio = new JRadioButton(BuilderResUtil.getString("IDS_FS_INCLUDE_RADIO"));
        this.mInSpecifiedRadio.setMnemonic(BuilderResUtil.getAccessKey("IDK_FS_INCLUDE_RADIO"));
        this.mInSpecifiedRadio.setSelected(true);
        this.mNotInRadio = new JRadioButton(BuilderResUtil.getString("IDS_FS_NOT_INCLUDE_RADIO"));
        this.mNotInRadio.setMnemonic(BuilderResUtil.getAccessKey("IDK_FS_NOT_INCLUDE_RADIO"));
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mInSpecifiedRadio);
        spssButtonGroup2.add(this.mNotInRadio);
        this.mSelectorListLabel = DialogUtil.createLabel(this, "IDS_FS_SELECTOR_LIST_LABEL");
        this.mSelectorList = new PlainList("IDS_FS_SELECTOR_LIST");
        this.mSelectorListLabel.setLabelFor(this.mSelectorList);
        this.mSelectorListModel = new DefaultListModel();
        this.mSelectorList.setModel(this.mSelectorListModel);
        this.mSelectorList.setSelectionMode(0);
        this.mSelectedSelectorListLabel = DialogUtil.createLabel(this, "IDS_FS_SELECTED_SELECTOR_LIST_LABEL");
        this.mSelectedSelectorList = new PlainList("IDS_FS_SELECTOR_SELECTED_LIST");
        this.mSelectedSelectorListLabel.setLabelFor(this.mTargetList);
        this.mSelectedSelectorListModel = new DefaultListModel();
        this.mSelectedSelectorList.setModel(this.mSelectedSelectorListModel);
        this.mSelectedSelectorList.setSelectionMode(0);
        this.mSelectorArrowButton = new TargetArrowButton();
        this.mSelectorArrowButton.registerComponents(this.mSelectorList, SpssArrowButton.ButtonOrientation.right);
        this.mSelectorArrowButton.registerComponents(this.mSelectedSelectorList, SpssArrowButton.ButtonOrientation.left);
        this.mSelectorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mSelectorArrowButton.addActionListener(this);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private void loadData() {
        this.mTargetIDs = new Vector();
        this.mDatasetSelectorIDs = new Vector();
        this.mSelectorListModel.removeAllElements();
        this.mTargetListModel.removeAllElements();
        this.mFieldChooserDef = new Vector();
        DialogDefinition dialogDefinition = this.mFrame.getDialogDefinition();
        LinkedList linkedList = dialogDefinition.getPanels();
        boolean bl = this.mVarListDef != null && this.mVarListDef instanceof FieldChooserDefinition;
        for (PanelDefinition object : linkedList) {
            this.handleOnePanel(object, bl);
        }
        for (String string : this.mTargetIDs) {
            this.mTargetListModel.addElement(string);
        }
        this.mTargetList.setModel(this.mTargetListModel);
        for (String string : this.mDatasetSelectorIDs) {
            this.mSelectorListModel.addElement(string);
        }
        this.mSelectorList.setModel(this.mSelectorListModel);
        if (this.mTargetListModel.getSize() == 0) {
            this.mTargetListRadio.setSelected(false);
            this.mTargetListRadio.setEnabled(false);
        }
        if (this.mSelectorListModel.getSize() == 0 || this.mDlgDef == null) {
            this.mSelectors.setSelected(false);
            this.mSelectors.setEnabled(false);
        }
        String string = this.mVarListDef != null ? this.mVarListDef.getFieldSourceID() : this.mDlgDef.getDatasetSeletorId();
        boolean bl2 = true;
        if (string.length() > 0) {
            void var5_14;
            if (this.mDlgDef != null) {
                boolean bl3 = this.fillSelectedSelectorList(string);
            } else {
                boolean bl4 = this.fillSelectedSelectorList(string);
                if (!bl4) {
                    boolean bl5 = this.fillSelectedTargetList(string);
                }
            }
            if (var5_14 == false) {
                if (this.mVarListDef != null) {
                    this.mVarListDef.setFieldSourceID("");
                } else {
                    this.mDlgDef.setDatasetSeletorId("");
                }
            }
        }
    }

    private void handleOnePanel(PanelDefinition panelDefinition, boolean bl) {
        for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
            PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
            String string = panelElementDefinition.getControlId();
            if (bl && !string.equals(this.mVarListDef.getControlId())) {
                if (panelElementDefinition instanceof TargetListDefinition) {
                    this.mTargetIDs.add(string);
                    continue;
                }
                if (panelElementDefinition instanceof FieldChooserDefinition) {
                    this.mFieldChooserDef.add((FieldChooserDefinition)panelElementDefinition);
                    if (this.mVarListDef.getControlId().equals(((FieldChooserDefinition)panelElementDefinition).getFieldSourceID())) continue;
                    this.mTargetIDs.add(string);
                    continue;
                }
                if (!(panelElementDefinition instanceof PanelDefinition)) continue;
                this.handleOnePanel((PanelDefinition)panelElementDefinition, bl);
                continue;
            }
            if (!(panelElementDefinition instanceof DatasetSelectorDefinition)) continue;
            this.mDatasetSelectorIDs.add(string);
        }
    }

    private boolean fillSelectedSelectorList(String string) {
        boolean bl = false;
        int n = this.mDatasetSelectorIDs.indexOf(string);
        if (n >= 0) {
            this.mSelectors.setSelected(true);
            this.mSelectedSelectorListModel.addElement(string);
            this.mSelectorListModel.remove(n);
            this.mSelectorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.enableOKButton();
            bl = true;
        }
        return bl;
    }

    private boolean fillSelectedTargetList(String string) {
        boolean bl = false;
        int n = this.mTargetIDs.indexOf(string);
        if (n >= 0) {
            this.mTargetListRadio.setSelected(true);
            this.mSelectedTargetListModel.addElement(string);
            this.mTargetListModel.remove(n);
            this.mTargetArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.enableOKButton();
            boolean bl2 = ((FieldChooserDefinition)this.mVarListDef).isFieldSourceInclude();
            if (bl2) {
                this.mInSpecifiedRadio.setSelected(true);
            } else {
                this.mNotInRadio.setSelected(true);
            }
            bl = true;
        }
        return bl;
    }

    private void enableOKButton() {
        boolean bl = true;
        this.mOkButton.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof ComponentsArrowButton) {
            if (this.mTargetListRadio.isSelected()) {
                if (this.mTargetArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                    int n = this.mTargetList.getSelectedIndex();
                    if (n >= 0 && this.mSelectedTargetList.getModel().getSize() == 0) {
                        String string = this.mTargetListModel.getElementAt(n).toString();
                        this.mSelectedTargetListModel.addElement(this.mTargetListModel.getElementAt(n));
                        this.mTargetListModel.remove(n);
                        this.mTargetArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                    }
                } else {
                    int n = this.mSelectedTargetList.getSelectedIndex();
                    if (n >= 0) {
                        String string = this.mSelectedTargetListModel.getElementAt(n).toString();
                        int n2 = this.mTargetIDs.indexOf(string);
                        this.mTargetListModel.insertElementAt(string, n2);
                        this.mTargetList.setSelectedIndex(n2);
                        this.mSelectedTargetListModel.remove(n);
                    }
                    this.mTargetArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                }
            } else if (this.mSelectors.isSelected()) {
                if (this.mSelectorArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                    int n = this.mSelectorList.getSelectedIndex();
                    if (n >= 0 && this.mSelectedSelectorList.getModel().getSize() == 0) {
                        String string = this.mSelectorListModel.getElementAt(n).toString();
                        this.mSelectedSelectorListModel.addElement(this.mSelectorListModel.getElementAt(n));
                        this.mSelectorListModel.remove(n);
                        this.mSelectorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                    }
                } else {
                    int n = this.mSelectedSelectorList.getSelectedIndex();
                    if (n >= 0) {
                        String string = this.mSelectedSelectorListModel.getElementAt(n).toString();
                        int n3 = this.mDatasetSelectorIDs.indexOf(string);
                        this.mSelectorListModel.insertElementAt(string, n3);
                        this.mSelectorList.setSelectedIndex(n3);
                        this.mSelectedSelectorListModel.remove(n);
                    }
                    this.mSelectorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                }
            }
        }
        this.enableOKButton();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JRadioButton) {
            if (this.mActiveDataset.isSelected()) {
                this.enableTargetListControls(false);
                this.enableSelectorListControls(false);
            } else if (this.mTargetListRadio.isSelected()) {
                this.enableTargetListControls(true);
                this.enableSelectorListControls(false);
            } else if (this.mSelectors.isSelected()) {
                this.enableTargetListControls(false);
                this.enableSelectorListControls(true);
            }
        }
        this.enableOKButton();
    }

    private void enableTargetListControls(boolean bl) {
        bl = true;
        this.mTargetListLabel.setEnabled(bl);
        this.mTargetList.setEnabled(bl);
        this.mSelectedTargetListLabel.setEnabled(bl);
        this.mSelectedTargetList.setEnabled(bl);
        this.mTargetArrowButton.setEnabled(bl);
        this.mInSpecifiedRadio.setEnabled(bl);
        this.mNotInRadio.setEnabled(bl);
    }

    private void enableSelectorListControls(boolean bl) {
        this.mSelectorListLabel.setEnabled(bl);
        this.mSelectorList.setEnabled(bl);
        this.mSelectedSelectorListLabel.setEnabled(bl);
        this.mSelectedSelectorList.setEnabled(bl);
        this.mSelectorArrowButton.setEnabled(bl);
    }

    private boolean checkCircular(String string) {
        boolean bl = false;
        FieldChooserDefinition fieldChooserDefinition = this.getChooserCtrl(string);
        String string2 = string;
        while (fieldChooserDefinition != null && string2.length() > 0) {
            string2 = fieldChooserDefinition.getFieldSourceID();
            if (string2.length() == 0) {
                return false;
            }
            if (string2.equals(this.mVarListDef.getControlId())) {
                return true;
            }
            fieldChooserDefinition = this.getChooserCtrl(string2);
        }
        return bl;
    }

    private FieldChooserDefinition getChooserCtrl(String string) {
        for (int i = 0; i < this.mFieldChooserDef.size(); ++i) {
            if (!string.equals(this.mFieldChooserDef.get(i).getControlId())) continue;
            return this.mFieldChooserDef.get(i);
        }
        return null;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FieldSourceSelectDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FieldSourceSelectDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            if (FieldSourceSelectDlg.this.mDlgDef == null) {
                if (FieldSourceSelectDlg.this.mSelectedTargetListModel.getSize() > 0 && FieldSourceSelectDlg.this.checkCircular(string = FieldSourceSelectDlg.this.mSelectedTargetListModel.getElementAt(0).toString())) {
                    BuilderAlertPane.showWarningMessageDialog((Window)((Object)FieldSourceSelectDlg.this), BuilderResUtil.getString("IDS_FIELD_CHOOSER_CIRCULAR"), BuilderUtil.getInstance().getAppVersionString());
                    return;
                }
                ((FieldChooserDefinition)FieldSourceSelectDlg.this.mVarListDef).setFieldSourceInclude(FieldSourceSelectDlg.this.mInSpecifiedRadio.isSelected());
                FieldSourceSelectDlg.this.mVarListDef.setFieldSourceID(string);
            } else {
                if (FieldSourceSelectDlg.this.mSelectors.isSelected() && FieldSourceSelectDlg.this.mSelectedSelectorListModel.getSize() > 0) {
                    string = FieldSourceSelectDlg.this.mSelectedSelectorListModel.getElementAt(0).toString();
                }
                FieldSourceSelectDlg.this.mFrame.getDialogDefinition().setDatasetSeletorId(string);
                FieldSourceSelectDlg.this.mDlgDef.setDatasetSeletorId(string);
            }
            FieldSourceSelectDlg.this.mFrame.setModified(true);
            FieldSourceSelectDlg.this.mIsOKPressed = true;
            FieldSourceSelectDlg.this.dispose();
        }
    }

    class TargetArrowButton
    extends ComponentsArrowButton {
        TargetArrowButton() {
        }

        @Override
        protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
            if (srcDestHolder == null) {
                return;
            }
            this.setEnabled(true);
            if (this.getSrcHolderComponent() == FieldSourceSelectDlg.this.mTargetList) {
                if (this.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right && FieldSourceSelectDlg.this.mSelectedTargetListModel.getSize() == 1) {
                    this.setEnabled(false);
                }
            } else if (this.getSrcHolderComponent() == FieldSourceSelectDlg.this.mSelectorList && this.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right && FieldSourceSelectDlg.this.mSelectedSelectorListModel.getSize() == 1) {
                this.setEnabled(false);
            }
        }
    }
}

