/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ComponentsArrowButton;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.PlainList;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssArrowButton;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.ui_builder.definition.CheckBoxDefinition;
import com.spss.uitools.ui_builder.definition.CheckBoxGroupDefinition;
import com.spss.uitools.ui_builder.definition.ComboBoxDefinition;
import com.spss.uitools.ui_builder.definition.ControlCondition;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.FieldChooserDefinition;
import com.spss.uitools.ui_builder.definition.ListBoxDefinition;
import com.spss.uitools.ui_builder.definition.ListDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.TargetListDefinition;
import com.spss.uitools.util.AccessibleTextAreaPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class EnablingRuleDlg
extends BaseDialog
implements ActionListener {
    private BuilderFrame mFrame;
    private static String sCondition = "IDS_ENABLING_RULE_ENABLE_CONDITION";
    private static String sValue = "IDS_ENABLING_RULE_ENABLE_VALUE";
    private Vector<Component> mPanelComps;
    private Vector<PanelElementDefinition> mControlListDef;
    private PanelElementDefinition mCurrentDef;
    private AccessibleTextAreaPanel mInfoText;
    private Vector<ListDefinition.ListItem> mListItems;
    private Vector<RadioItemDefinition> mRadioItems;
    private JLabel mSelectorListLabel;
    private PlainList mSelectorList;
    private DefaultListModel mSelectorListModel;
    private JScrollPane mSelectorPane;
    private JLabel mSelectedSelectorListLabel;
    private PlainList mSelectedSelectorList;
    private DefaultListModel mSelectedSelectorListModel;
    private JScrollPane mSelectedSelectorPane;
    private TargetArrowButton mSelectorArrowButton;
    private JLabel mCondiLabel;
    private JComboBox mCondiCombo;
    private DefaultComboBoxModel mCondiModel;
    private JLabel mValueLabel;
    private JComboBox mValueCombo;
    private DefaultComboBoxModel mValueModel;
    private JButton mOkButton;
    private String mRadioGroupEnableID;

    public EnablingRuleDlg(BuilderFrame builderFrame, PanelElementDefinition panelElementDefinition) {
        this(builderFrame, panelElementDefinition, "");
    }

    public EnablingRuleDlg(BuilderFrame builderFrame, PanelElementDefinition panelElementDefinition, String string) throws HeadlessException {
        super((JFrame)builderFrame, BuilderResUtil.getString("IDS_ENABLING_RULE_TITLE"), true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.mFrame = builderFrame;
        this.mCurrentDef = panelElementDefinition;
        this.mRadioGroupEnableID = string;
        this.mListItems = new Vector();
        this.mRadioItems = new Vector();
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
    }

    public void doHelp() {
        BuilderUtil.getInstance().showHelp("spss/base/idh_idd_uibuilder_enablingrule");
    }

    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.fillPanel(jPanel, false, false);
    }

    private void fillPanel(JPanel jPanel, boolean bl, boolean bl2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mInfoText, gridBagConstraints, 0, 0, 3, 1, n, new Insets(2, 2, 10, 2));
        JPanel jPanel2 = this.createIdentifierListPanel(bl, bl2);
        int n2 = this.calculateListHeight(bl, bl2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, n2, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSelectorArrowButton, gridBagConstraints, 1, 1, 1, 1, n, new Insets(this.mSelectorListLabel.getFontMetrics(this.mSelectorListLabel.getFont()).getHeight(), 8, 8, 8));
        JPanel jPanel3 = this.createSelectedSelectorPanel(bl);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 1, 1, 1, n, insets);
        if (bl) {
            JPanel jPanel4 = this.createConditionPanel(bl2);
            DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 2, 2, 1, 1, n, insets);
            if (bl2) {
                JPanel jPanel5 = this.createEnablingPanel();
                DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 2, 3, 1, 1, n, insets);
            }
        }
        jPanel.validate();
        jPanel.repaint();
    }

    private int calculateListHeight(boolean bl, boolean bl2) {
        int n = 1;
        if (bl) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        return n;
    }

    private JPanel createIdentifierListPanel(boolean bl, boolean bl2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        Insets insets = new Insets(1, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, n, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSelectorListLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, n, 10, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSelectorPane, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel createSelectedSelectorPanel(boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(1, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSelectedSelectorListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = bl ? 0 : 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = bl ? 0.0 : 1.0;
        insets.set(1, 2, 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSelectedSelectorPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createConditionPanel(boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(1, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCondiLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = bl ? 0 : 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = bl ? 0.0 : 1.0;
        insets.set(1, 2, 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mCondiCombo, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createEnablingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(1, 2, 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mValueLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mValueCombo, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefault() {
        Vector vector = this.mCurrentDef.getCtrlConditions();
        if (vector != null && vector.size() > 0) {
            ControlCondition controlCondition = (ControlCondition)vector.get(0);
            String string = controlCondition.getControlName();
            int n = this.findIndex(string);
            if (n >= 0) {
                this.mSelectedSelectorListModel.addElement(string);
                this.mSelectorListModel.remove(n);
                boolean bl = this.fillComboModel(string, controlCondition);
                this.updateEnableCondition(true, bl);
                this.mSelectorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            } else {
                this.mCurrentDef.removeAllControlConditions();
            }
        }
        this.enableOKButton();
    }

    private void initVars() {
        this.mPanelComps = new Vector();
        URL uRL = BuilderResUtil.getImageResource("infodot.png");
        this.mInfoText = new AccessibleTextAreaPanel(BuilderResUtil.getString("IDS_ENABLING_RULE_MESG"), (Icon)new ImageIcon(uRL), null, true);
        this.mSelectorListLabel = DialogUtil.createLabel(this, "IDS_ENABLING_RULE_IDENTIFIER_LIST");
        this.mSelectorList = new PlainList("IDS_ENABLING_RULE_IDENTIFIER_LIST");
        this.mSelectorListLabel.setLabelFor(this.mSelectorList);
        this.mSelectorListModel = new DefaultListModel();
        this.mSelectorList.setModel(this.mSelectorListModel);
        this.mSelectorList.setSelectionMode(0);
        this.mSelectorPane = new JScrollPane(this.mSelectorList);
        this.mSelectorPane.setVerticalScrollBarPolicy(20);
        this.mSelectorPane.setHorizontalScrollBarPolicy(30);
        this.mSelectorPane.setPreferredSize(new Dimension(150, this.mSelectorList.getFixedCellHeight() * 6));
        this.mPanelComps.add(this.mSelectorListLabel);
        this.mPanelComps.add(this.mSelectorPane);
        this.mSelectedSelectorListLabel = DialogUtil.createLabel(this, "IDS_ENABLING_RULE_SELECTED_IDENTIFIER_LIST");
        this.mSelectedSelectorList = new PlainList("IDS_ENABLING_RULE_SELECTED_IDENTIFIER_LIST");
        Dimension dimension = new Dimension(180, this.mSelectedSelectorList.getFixedCellHeight() + 4);
        this.mSelectedSelectorList.setMinimumSize(dimension);
        this.mSelectedSelectorList.setPreferredSize(dimension);
        this.mSelectedSelectorListLabel.setLabelFor(this.mSelectedSelectorList);
        this.mSelectedSelectorListModel = new DefaultListModel();
        this.mSelectedSelectorList.setModel(this.mSelectedSelectorListModel);
        this.mSelectedSelectorList.setSelectionMode(0);
        this.mSelectedSelectorPane = new JScrollPane(this.mSelectedSelectorList);
        this.mSelectedSelectorPane.setVerticalScrollBarPolicy(21);
        this.mSelectedSelectorPane.setHorizontalScrollBarPolicy(31);
        this.mSelectedSelectorPane.setPreferredSize(dimension);
        this.mPanelComps.add(this.mSelectedSelectorListLabel);
        this.mPanelComps.add(this.mSelectedSelectorPane);
        this.mSelectorArrowButton = new TargetArrowButton();
        this.mSelectorArrowButton.registerComponents(this.mSelectorList, SpssArrowButton.ButtonOrientation.right);
        this.mSelectorArrowButton.registerComponents(this.mSelectedSelectorList, SpssArrowButton.ButtonOrientation.left);
        this.mSelectorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mSelectorArrowButton.addActionListener(this);
        this.mPanelComps.add(this.mSelectorArrowButton);
        this.mCondiLabel = DialogUtil.createLabel(this, "IDS_ENABLING_RULE_ENABLE_CONDITION");
        this.mCondiModel = new DefaultComboBoxModel();
        this.mCondiCombo = new JComboBox();
        this.mCondiCombo.setModel(this.mCondiModel);
        this.mPanelComps.add(this.mCondiLabel);
        this.mPanelComps.add(this.mCondiCombo);
        this.mValueLabel = DialogUtil.createLabel(this, "IDS_ENABLING_RULE_ENABLE_VALUE");
        this.mValueModel = new DefaultComboBoxModel();
        this.mValueCombo = new JComboBox(this.mValueModel);
        this.mPanelComps.add(this.mValueLabel);
        this.mPanelComps.add(this.mValueCombo);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        return jPanel;
    }

    private void loadData() {
        String string;
        int n;
        DialogDefinition dialogDefinition = this.mFrame.getDialogDefinition();
        this.mControlListDef = dialogDefinition.getAllEnableControls(this.mCurrentDef);
        this.mSelectorListModel.removeAllElements();
        int n2 = -1;
        if (this.mControlListDef.size() > 0) {
            for (n = 0; n < this.mControlListDef.size(); ++n) {
                string = this.mControlListDef.get(n).getControlId();
                if (!(this.mCurrentDef instanceof RadioItemDefinition) || !string.equals(this.mRadioGroupEnableID)) continue;
                n2 = n;
            }
        }
        if (n2 >= 0) {
            this.mControlListDef.remove(n2);
        }
        if (this.mControlListDef.size() > 0) {
            for (n = 0; n < this.mControlListDef.size(); ++n) {
                string = this.mControlListDef.get(n).getControlId();
                this.mSelectorListModel.addElement(string);
            }
            this.mSelectorList.setModel(this.mSelectorListModel);
        }
        this.setDefault();
    }

    private boolean isCircularReference(String string, String string2) {
        boolean bl = false;
        DialogDefinition dialogDefinition = this.mFrame.getDialogDefinition();
        LinkedList linkedList = dialogDefinition.getPanels();
        for (int i = 0; i < linkedList.size(); ++i) {
            Iterator iterator;
            Vector vector;
            PanelDefinition panelDefinition = (PanelDefinition)linkedList.get(i);
            PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(string2);
            if (panelElementDefinition == null || (vector = panelElementDefinition.getCtrlConditions()) == null || !(iterator = vector.iterator()).hasNext()) continue;
            ControlCondition controlCondition = (ControlCondition)iterator.next();
            if (controlCondition.getControlName().equals(string)) {
                bl = true;
                continue;
            }
            return this.isCircularReference(string, controlCondition.getControlName());
        }
        return bl;
    }

    private void enableOKButton() {
        boolean bl = this.mSelectedSelectorListModel.getSize() > 0 || this.mCurrentDef.getCtrlConditions().size() > 0 && this.mSelectedSelectorListModel.getSize() == 0;
        this.mOkButton.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof ComponentsArrowButton) {
            if (this.mSelectorArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                int n = this.mSelectorList.getSelectedIndex();
                if (n >= 0 && this.mSelectedSelectorList.getModel().getSize() == 0) {
                    String string = this.mSelectorListModel.getElementAt(n).toString();
                    this.mSelectedSelectorListModel.addElement(this.mSelectorListModel.getElementAt(n));
                    this.mSelectorListModel.remove(n);
                    boolean bl = this.fillComboModel(string);
                    this.updateEnableCondition(true, bl);
                    this.mSelectorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                }
            } else {
                int n = this.mSelectedSelectorList.getSelectedIndex();
                if (n >= 0) {
                    String string = this.mSelectedSelectorListModel.getElementAt(n).toString();
                    int n2 = this.findIndex(string);
                    this.mSelectorListModel.insertElementAt(string, n2);
                    this.mSelectorList.setSelectedIndex(n2);
                    this.mSelectedSelectorListModel.remove(n);
                    this.mCondiModel.removeAllElements();
                    this.mCondiCombo.setModel(new DefaultComboBoxModel());
                    this.mValueModel.removeAllElements();
                    this.mValueCombo.setModel(new DefaultComboBoxModel());
                    this.updateEnableCondition(false, false);
                }
                this.mSelectorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            }
        }
        this.enableOKButton();
    }

    private int findIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.mControlListDef.size(); ++i) {
            if (!string.equals(this.mControlListDef.get(i).getControlId())) continue;
            n = i;
            break;
        }
        return n;
    }

    private boolean fillComboModel(String string) {
        return this.fillComboModel(string, null);
    }

    private boolean fillComboModel(String string, ControlCondition controlCondition) {
        PanelElementDefinition panelElementDefinition = null;
        boolean bl = false;
        this.mRadioItems.clear();
        for (int i = 0; i < this.mControlListDef.size(); ++i) {
            if (!string.equals(this.mControlListDef.get(i).getControlId())) continue;
            panelElementDefinition = this.mControlListDef.get(i);
            break;
        }
        int n = -1;
        int n2 = -1;
        if (panelElementDefinition != null) {
            if (panelElementDefinition instanceof TargetListDefinition || panelElementDefinition instanceof FieldChooserDefinition || panelElementDefinition instanceof CheckBoxDefinition || panelElementDefinition instanceof CheckBoxGroupDefinition) {
                String[] stringArray;
                bl = false;
                this.mCondiModel.removeAllElements();
                if (panelElementDefinition instanceof TargetListDefinition || panelElementDefinition instanceof FieldChooserDefinition) {
                    stringArray = BuilderResUtil.getStringArray("IDS_ENABLING_RULE_FILED_LIST_CONDITION");
                    n = 1;
                } else {
                    stringArray = BuilderResUtil.getStringArray("IDS_ENABLING_RULE_CHECKBOX_CONDITION");
                }
                if (stringArray != null) {
                    for (String string2 : stringArray) {
                        this.mCondiModel.addElement(string2);
                    }
                }
                this.mCondiCombo.setModel(this.mCondiModel);
                if (controlCondition != null) {
                    n = this.getBooleanComboboxIndex(panelElementDefinition, controlCondition);
                    this.mCondiCombo.setSelectedIndex(n);
                } else if (n >= 0) {
                    this.mCondiCombo.setSelectedIndex(n);
                }
            } else {
                int n3;
                String[] stringArray;
                String[] stringArray2;
                bl = true;
                this.mCondiModel.removeAllElements();
                this.mValueModel.removeAllElements();
                if (controlCondition != null) {
                    n = this.getBooleanComboboxIndex(panelElementDefinition, controlCondition);
                }
                if (panelElementDefinition instanceof ComboBoxDefinition || panelElementDefinition instanceof ListBoxDefinition) {
                    stringArray2 = panelElementDefinition instanceof ListBoxDefinition && ((ListBoxDefinition)panelElementDefinition).getSelectionType() == ListBoxDefinition.SelectionType.multi_select ? BuilderResUtil.getStringArray("IDS_ENABLING_RULE_MULTI_LISTBOX_CONDITION") : BuilderResUtil.getStringArray("IDS_ENABLING_RULE_LISTBOX_CONDITION");
                    this.mListItems = panelElementDefinition instanceof ComboBoxDefinition ? ((ComboBoxDefinition)panelElementDefinition).getListItems() : ((ListBoxDefinition)panelElementDefinition).getListItems();
                    stringArray = new String[this.mListItems.size()];
                    for (n3 = 0; n3 < this.mListItems.size(); ++n3) {
                        stringArray[n3] = this.mListItems.get(n3).getTitle();
                        if (controlCondition == null || n2 != -1 || !controlCondition.getControlValue().equals(this.mListItems.get(n3).getIdentifier())) continue;
                        n2 = n3;
                    }
                } else {
                    stringArray2 = BuilderResUtil.getStringArray("IDS_ENABLING_RULE_RADIO_CONDITION");
                    n3 = ((RadioGroupDefinition)panelElementDefinition).radioItemCount();
                    stringArray = new String[n3];
                    for (int i = 0; i < n3; ++i) {
                        RadioItemDefinition radioItemDefinition = ((RadioGroupDefinition)panelElementDefinition).getRadioItem(i);
                        this.mRadioItems.add(radioItemDefinition);
                        stringArray[i] = radioItemDefinition.getTitle();
                        if (controlCondition == null || n2 != -1 || !controlCondition.getControlValue().equals(radioItemDefinition.getControlId())) continue;
                        n2 = i;
                    }
                }
                if (stringArray2 != null) {
                    for (String string3 : stringArray2) {
                        this.mCondiModel.addElement(string3);
                    }
                }
                if (stringArray != null) {
                    for (String string3 : stringArray) {
                        this.mValueModel.addElement(string3);
                    }
                }
                this.mCondiCombo.setModel(this.mCondiModel);
                this.mValueCombo.setModel(this.mValueModel);
                if (n2 >= 0) {
                    this.mValueCombo.setSelectedIndex(n2);
                }
                if (n >= 0) {
                    this.mCondiCombo.setSelectedIndex(n);
                }
            }
        }
        return bl;
    }

    private void updateEnableCondition(boolean bl, boolean bl2) {
        JPanel jPanel = this.getViewPanel();
        jPanel.removeAll();
        this.fillPanel(jPanel, bl, bl2);
        this.pack();
    }

    private int getBooleanComboboxIndex(PanelElementDefinition panelElementDefinition, ControlCondition controlCondition) {
        if (panelElementDefinition instanceof TargetListDefinition || panelElementDefinition instanceof FieldChooserDefinition) {
            if (controlCondition.getOperatorName().equals("isEmpty")) {
                return 0;
            }
            return 1;
        }
        if (panelElementDefinition instanceof CheckBoxDefinition || panelElementDefinition instanceof CheckBoxGroupDefinition) {
            if (controlCondition.getControlValue().equals("true")) {
                return 0;
            }
            return 1;
        }
        if (panelElementDefinition instanceof ComboBoxDefinition || panelElementDefinition instanceof ListBoxDefinition) {
            if (controlCondition.getOperatorName().equals("equals")) {
                return 0;
            }
            return 1;
        }
        if (panelElementDefinition instanceof RadioGroupDefinition) {
            if (controlCondition.getOperatorName().equals("equals")) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EnablingRuleDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EnablingRuleDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EnablingRuleDlg.this.mSelectedSelectorList.getModel().getSize() > 0) {
                String string = EnablingRuleDlg.this.mSelectedSelectorList.getModel().getElementAt(0).toString();
                if (EnablingRuleDlg.this.isCircularReference(EnablingRuleDlg.this.mCurrentDef.getControlId(), string)) {
                    BuilderAlertPane.showConfirmDialog((Window)((Object)EnablingRuleDlg.this), BuilderResUtil.getString("ERR_ENABLING_CIRCULAR_REF"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.OK_CANCEL_OPTION);
                    return;
                }
                int n = EnablingRuleDlg.this.findIndex(string);
                PanelElementDefinition panelElementDefinition = (PanelElementDefinition)EnablingRuleDlg.this.mControlListDef.get(n);
                String string2 = EnablingRuleDlg.this.mCondiCombo.getSelectedItem().toString();
                int n2 = EnablingRuleDlg.this.mCondiCombo.getSelectedIndex();
                String string3 = null;
                if (n2 < 0) {
                    return;
                }
                EnablingRuleDlg.this.mCurrentDef.removeAllControlConditions();
                if (panelElementDefinition instanceof TargetListDefinition || panelElementDefinition instanceof FieldChooserDefinition) {
                    String string4 = n2 == 0 ? "isEmpty" : "isNotEmpty";
                    ControlCondition controlCondition = new ControlCondition(panelElementDefinition.getControlId(), string4, "true");
                    EnablingRuleDlg.this.mCurrentDef.addCtrlCondition(controlCondition);
                } else if (panelElementDefinition instanceof CheckBoxDefinition || panelElementDefinition instanceof CheckBoxGroupDefinition) {
                    String string5 = "equals";
                    String string6 = n2 == 0 ? "true" : "false";
                    ControlCondition controlCondition = new ControlCondition(panelElementDefinition.getControlId(), string5, string6);
                    if (panelElementDefinition instanceof CheckBoxGroupDefinition) {
                        controlCondition.setChildControlName(((CheckBoxGroupDefinition)panelElementDefinition).getControllerCheckBox().getControlId());
                    }
                    EnablingRuleDlg.this.mCurrentDef.addCtrlCondition(controlCondition);
                } else if (panelElementDefinition instanceof ComboBoxDefinition || panelElementDefinition instanceof ListBoxDefinition) {
                    String string7 = n2 == 0 ? "equals" : "notEquals";
                    string3 = ((ListDefinition.ListItem)EnablingRuleDlg.this.mListItems.get(EnablingRuleDlg.this.mValueCombo.getSelectedIndex())).getIdentifier();
                    ControlCondition controlCondition = new ControlCondition(panelElementDefinition.getControlId(), string7, string3);
                    EnablingRuleDlg.this.mCurrentDef.addCtrlCondition(controlCondition);
                } else if (panelElementDefinition instanceof RadioGroupDefinition) {
                    String string8 = n2 == 0 ? "equals" : "notEquals";
                    string3 = ((RadioItemDefinition)EnablingRuleDlg.this.mRadioItems.get(EnablingRuleDlg.this.mValueCombo.getSelectedIndex())).getControlId();
                    ControlCondition controlCondition = new ControlCondition(panelElementDefinition.getControlId(), string8, string3);
                    EnablingRuleDlg.this.mCurrentDef.addCtrlCondition(controlCondition);
                }
            } else {
                EnablingRuleDlg.this.mCurrentDef.removeAllControlConditions();
            }
            EnablingRuleDlg.this.mFrame.setModified(true);
            EnablingRuleDlg.this.dispose();
        }
    }

    class TargetArrowButton
    extends ComponentsArrowButton {
        TargetArrowButton() {
        }

        @Override
        protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
            if (srcDestHolder == null) {
                return;
            }
            this.setEnabled(true);
            if (this.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right && EnablingRuleDlg.this.mSelectedSelectorListModel.getSize() == 1) {
                this.setEnabled(false);
            }
        }
    }
}

