/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssButtonGroup;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.StringTextField;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.ui_builder.definition.SpinnerDefinition;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class CurrentDateDlg
extends BaseDialog
implements ItemListener {
    private BuilderFrame mFrame;
    private SpinnerDefinition mSpinnerDef;
    private JRadioButton mCurrentDate;
    private JRadioButton mSpecifyDate;
    private JLabel mDateLabel;
    private StringTextField mDateValue;
    private SimpleDateFormat mDateFormatter;
    private JButton mOkButton;

    public CurrentDateDlg(BuilderFrame builderFrame, SpinnerDefinition spinnerDefinition) throws HeadlessException {
        super((JFrame)builderFrame, BuilderResUtil.getString("IDS_DATE_DEFAULT_DATE_TITLE"), true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.mFrame = builderFrame;
        this.mSpinnerDef = spinnerDefinition;
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
    }

    public void doHelp() {
        BuilderUtil.getInstance().showHelp("spss/base/uibuilder_controls_date_control");
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 23;
        int n2 = 15;
        this.mCurrentDate = new JRadioButton(BuilderResUtil.getString("IDS_DATE_SPINNER_DEFAULT_CURRENT"));
        this.mCurrentDate.setMnemonic(BuilderResUtil.getAccessKey("IDK_DATE_SPINNER_DEFAULT_CURRENT"));
        this.mSpecifyDate = new JRadioButton(BuilderResUtil.getString("IDS_DATE_SPINNER_DEFAULT_SPECIFY"));
        this.mSpecifyDate.setMnemonic(BuilderResUtil.getAccessKey("IDK_DATE_SPINNER_DEFAULT_SPECIFY"));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mCurrentDate);
        spssButtonGroup.add(this.mSpecifyDate);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCurrentDate, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(6, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSpecifyDate, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.mDateLabel = DialogUtil.createLabel(this, "IDS_DATE_SPINNER_DEFAULT_DATE_VALUE");
        insets.set(1, 8, 1, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mDateLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mDateValue = new StringTextField(12);
        this.mDateLabel.setLabelFor((Component)((Object)this.mDateValue));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mDateValue), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2, 8, 2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        return jPanel;
    }

    private void loadData() {
        this.mDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        this.mDateValue.setText(this.mDateFormatter.toPattern());
        this.mDateFormatter.setTimeZone(timeZone);
        this.mCurrentDate.addItemListener(this);
        this.mSpecifyDate.addItemListener(this);
        if (this.mSpinnerDef.getDefaultValue().length() == 0) {
            this.mCurrentDate.setSelected(true);
        } else {
            this.mSpecifyDate.setSelected(true);
            this.mDateValue.setText(this.mSpinnerDef.getDefaultValue());
        }
    }

    private void enableOKButton() {
        if (this.mCurrentDate.isSelected()) {
            this.mDateLabel.setEnabled(false);
            this.mDateValue.setEnabled(false);
        } else {
            this.mDateLabel.setEnabled(true);
            this.mDateValue.setEnabled(true);
        }
    }

    private Date isValidDateValue(String string) {
        Date date = null;
        try {
            date = this.mDateFormatter.parse(string);
        }
        catch (ParseException parseException) {
            String string2 = String.format(BuilderResUtil.getString("ERR_DATE_CURRENT_DATE_FORMAT"), string);
            BuilderAlertPane.showWarningMessageDialog((Window)((Object)this), string2, BuilderUtil.getInstance().getAppVersionString());
        }
        return date;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JRadioButton) {
            this.enableOKButton();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CurrentDateDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CurrentDateDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            boolean bl = true;
            Date date = null;
            if (CurrentDateDlg.this.mSpecifyDate.isSelected()) {
                string = CurrentDateDlg.this.mDateValue.getText();
                date = CurrentDateDlg.this.isValidDateValue(string);
                boolean bl2 = bl = date != null;
            }
            if (bl) {
                if (date != null) {
                    string = CurrentDateDlg.this.mDateFormatter.format(date);
                }
                CurrentDateDlg.this.mSpinnerDef.setDefaultValue(string);
                CurrentDateDlg.this.mFrame.setModified(true);
                CurrentDateDlg.this.dispose();
            } else {
                CurrentDateDlg.this.mDateValue.setSelectionStart(0);
                CurrentDateDlg.this.mDateValue.setSelectionEnd(string.length());
                CurrentDateDlg.this.mDateValue.requestFocusInWindow();
            }
        }
    }
}

