/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.props_ui;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class ControlTitleDlg
extends BaseDialog {
    private BuilderFrame mFrame;
    private PanelElementDefinition mControlDef;
    private String mDefaultTitleText = null;
    private boolean mIsOKPressed;
    private JLabel mPanelLabel;
    private JTextPane mTitlePane;
    private StyledDocument mPaneDocument;
    private JButton mOkButton;

    public ControlTitleDlg(BuilderFrame builderFrame, PanelElementDefinition panelElementDefinition) throws HeadlessException {
        this(builderFrame, panelElementDefinition, null);
    }

    public ControlTitleDlg(BuilderFrame builderFrame, PanelElementDefinition panelElementDefinition, String string) throws HeadlessException {
        super((JFrame)builderFrame, BuilderResUtil.getString("IDS_TITLE_PROPERTY"), true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.mFrame = builderFrame;
        this.mControlDef = panelElementDefinition;
        this.mDefaultTitleText = string != null ? string : this.mControlDef.getTitle();
        this.mIsOKPressed = false;
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
    }

    public void doHelp() {
    }

    public boolean isOKPressed() {
        return this.mIsOKPressed;
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 23;
        int n2 = 15;
        this.mPanelLabel = DialogUtil.createLabel(this, "IDS_CONTROL_TITLE_PANEL_TITLE");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(8, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mPanelLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mTitlePane = new JTextPane();
        this.mPanelLabel.setLabelFor(this.mPanelLabel);
        this.mPaneDocument = this.mTitlePane.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.mPaneDocument.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
        JScrollPane jScrollPane = new JScrollPane(this.mTitlePane);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(new Dimension(400, 60));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(jButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        return jPanel;
    }

    private void loadData() {
        try {
            String string = this.mDefaultTitleText;
            if (string.length() > 0) {
                string = string.replaceAll("\\\\n", "\n");
            }
            this.mPaneDocument.insertString(0, string, this.mPaneDocument.getStyle("regular"));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void enableOKButton() {
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ControlTitleDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ControlTitleDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ControlTitleDlg.this.mIsOKPressed = true;
            String string = ControlTitleDlg.this.mTitlePane.getText();
            string = string.replaceAll("(\\r|\\n|\\r\\n)+", "\\\\n");
            ControlTitleDlg.this.mControlDef.setTitle(string);
            ControlTitleDlg.this.mFrame.setModified(true);
            ControlTitleDlg.this.dispose();
        }
    }
}

