/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.preview;

import com.pasw.core.extension.feature.FeatureDescriptor;
import com.pasw.core.property.DefaultProperties;
import com.pasw.core.property.PresetPropertyDescriptor;
import com.pasw.core.property.PropertySetEvent;
import com.pasw.core.property.PropertySetListener;
import com.pasw.core.property.PropertySetProvider;
import com.pasw.framework.common.application.Application;
import com.pasw.framework.common.core.Properties;
import com.pasw.framework.common.core.ResourceProvider;
import com.pasw.framework.common.core.ValueDescriptor;
import com.pasw.framework.common.data.DataModelProvider;
import com.pasw.framework.common.extension.Extension;
import com.pasw.framework.common.extension.ExtensionManager;
import com.pasw.framework.common.extension.ExtensionObject;
import com.pasw.framework.common.extension.ExtensionObjectDescriptor;
import com.pasw.framework.common.extension.Feature;
import com.pasw.framework.common.session.Session;
import com.pasw.framework.ui.swing.ExtensionObjectSwingUI;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.peers.RStatsBuilderPeer;
import com.spss.shared.custom_gui.ui_builder.preview.PreviewDataModelProvider;
import com.spss.shared.custom_gui.ui_builder.preview.PreviewSession;
import com.spss.shared.custom_gui.ui_builder.preview.TestApplication;
import com.spss.shared.custom_gui.ui_builder.pyspark.PySparkBuilderPeer;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class PreviewDialog
extends JDialog {
    private File tempFolder;
    private TestApplication application;
    private BuilderFrame mFrame;
    private DialogDefinition mDialog;
    private final String XML_FILE_EXT = ".xml";
    private Feature mFeature;
    private ExtensionObjectSwingUI mFeatureUI;
    private File mAppExtFile;
    private boolean mNeedRandomID;

    public PreviewDialog(BuilderFrame builderFrame, boolean bl) throws HeadlessException {
        super(builderFrame, "", true);
        this.mNeedRandomID = bl;
        this.mFrame = builderFrame;
        this.mDialog = this.mFrame.getDialogDefinition();
        String string = "";
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            string = "statistics";
        } else if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            string = "modeler";
        }
        this.application = new TestApplication(string);
        this.application.getFrameworkApplicationSupport().startup();
        try {
            ExtensionManager extensionManager;
            String string2;
            File file = this.getSpecFilePath();
            Component component = null;
            if (file != null && file.exists() && (string2 = (extensionManager = this.application.getFrameworkApplicationSupport().getExtensionManager()).loadSpecificationFile(file)) != null) {
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS && this.mAppExtFile != null) {
                    extensionManager.loadSpecificationFile(this.mAppExtFile);
                }
                Locale locale = BuilderUtil.getInstance().getAppLocale();
                PreviewSession previewSession = new PreviewSession((Application)this.application, locale, locale, this.mFrame.getDlgExecutor());
                component = this.createNewFeature(previewSession);
            }
            if (component != null) {
                if (BuilderUtil.getInstance().getAppType() != AppType.STATS) {
                    this.init((JComponent)component);
                    this.pack();
                    this.setLocationRelativeTo(builderFrame);
                    component.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent keyEvent) {
                            if (keyEvent.getKeyChar() == '\u001b') {
                                PreviewDialog.this.standardClosing();
                            }
                        }
                    });
                }
            } else {
                BuilderAlertPane.showErrorMessageDialog(this.mFrame, BuilderResUtil.getString("IDS_PREVIEW_ERROR"), BuilderUtil.getInstance().getAppVersionString());
            }
        }
        catch (Exception exception) {
            String string3;
            String string4 = string3 = exception.getCause() != null ? exception.getCause().getLocalizedMessage() : exception.getLocalizedMessage();
            if (string3 == null) {
                string3 = exception.toString();
            }
            BuilderAlertPane.showErrorMessageDialog(this.mFrame, string3, BuilderUtil.getInstance().getAppVersionString());
        }
    }

    public Feature getFeature() {
        return this.mFeature;
    }

    public ExtensionObjectSwingUI getFeatureUI() {
        return this.mFeatureUI;
    }

    private void init(JComponent jComponent) {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add(jComponent);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add(new JButton(new OKAction()));
        jPanel.add(new JButton(new CancelAction()));
        jPanel.add(new JButton(new HelpAction()));
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        this.add(jPanel);
        Dimension dimension = new Dimension(jComponent.getPreferredSize().width + 80, jComponent.getPreferredSize().height + 80);
        this.setPreferredSize(dimension);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PreviewDialog.this.standardClosing();
            }
        });
    }

    private void standardClosing() {
        this.setVisible(false);
        BuilderUtil.getInstance().cleanTempFolder(this.tempFolder, false);
        this.application.getFrameworkApplicationSupport().shutdown();
        this.dispose();
    }

    private ExtensionObjectDescriptor getFeatureObject() {
        String[] stringArray;
        ExtensionObjectDescriptor extensionObjectDescriptor = null;
        ExtensionManager extensionManager = this.application.getFrameworkApplicationSupport().getExtensionManager();
        block0: for (String string : stringArray = extensionManager.getIDs().toArray(new String[extensionManager.getIDs().size()])) {
            if (!extensionManager.isExtensionID(string)) continue;
            Extension extension = extensionManager.getExtension(string);
            for (String string2 : extension.getExtensionObjectIDs()) {
                if (this.isRApplier(extension.getExtensionObjectDescriptor(string2)) || string2.startsWith("r_output_results") || string2.startsWith("pyspark_model") || string2.startsWith("pyspark_output_results")) continue;
                extensionObjectDescriptor = extension.getExtensionObjectDescriptor(string2);
                continue block0;
            }
        }
        return extensionObjectDescriptor;
    }

    private boolean isRApplier(ExtensionObjectDescriptor extensionObjectDescriptor) {
        FeatureDescriptor featureDescriptor;
        return extensionObjectDescriptor.getID().endsWith("model") && (featureDescriptor = (FeatureDescriptor)extensionObjectDescriptor).getPeerClassName().equals("com.spss.shared.custom_gui.ui_builder.peers.RStatsApplierPeer");
    }

    private JComponent createNewFeature(PreviewSession previewSession) {
        JComponent jComponent = null;
        ExtensionObjectDescriptor extensionObjectDescriptor = this.getFeatureObject();
        if (extensionObjectDescriptor != null) {
            try {
                this.mFeature = extensionObjectDescriptor.getExtension().newFeature(extensionObjectDescriptor.getID(), (DataModelProvider)new PreviewDataModelProvider(null), (Session)previewSession);
                ResourceProvider resourceProvider = extensionObjectDescriptor.getExtension().newResourceProvider((Session)previewSession);
                String string = resourceProvider.getString(this.mFeature.getExtensionObjectID() + ".TITLE");
                this.setTitle(string);
                this.mFeatureUI = previewSession.getFrameworkSwingSupport().newSwingUI((ExtensionObject)this.mFeature);
                this.mFeatureUI.refreshFromExtensionObject();
                jComponent = this.mFeatureUI.getRootComponent();
            }
            catch (Exception exception) {
                BuilderAlertPane.showErrorMessageDialog(this.mFrame, exception.getLocalizedMessage(), BuilderUtil.getInstance().getAppVersionString());
            }
        }
        return jComponent;
    }

    private File getSpecFilePath() throws IOException {
        try {
            this.tempFolder = BuilderUtil.getInstance().createTempFolder();
            this.tempFolder.delete();
            if (!this.tempFolder.mkdir()) {
                return null;
            }
            this.tempFolder.deleteOnExit();
        }
        catch (IOException iOException) {
            return null;
        }
        SpecificationWriter specificationWriter = new SpecificationWriter(this.mDialog, this.mNeedRandomID);
        String string = this.tempFolder.getPath() + File.separator + "extension" + ".xml";
        if (!specificationWriter.writeCFStream(string, false, false)) {
            return null;
        }
        File file = new File(string);
        String string2 = this.tempFolder.getPath() + File.separator + "app-extension" + ".xml";
        if (!specificationWriter.writeAppExtensionsStream(string2)) {
            return null;
        }
        this.mAppExtFile = new File(string2);
        string = this.tempFolder.getPath() + File.separator + "module" + ".xml";
        if (!specificationWriter.writeCFModuleStream(string)) {
            return null;
        }
        BuilderUtil.getInstance().writePropertiesFiles(this.tempFolder, specificationWriter.getRandomID(), BuilderUtil.getInstance().getAppLocale(), this.mDialog.getScriptType());
        return file;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderUtil.getInstance().showHelp("spss/base/idh_idd_uibuilder");
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PreviewDialog.this.standardClosing();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BuilderUtil.isDebugMode()) {
                Object object;
                boolean bl = true;
                if (PreviewDialog.this.mFeature.getProperties().getProperty("scriptType").toString().equals("R")) {
                    object = new RStatsBuilderPeer();
                } else {
                    object = new PySparkBuilderPeer();
                    bl = false;
                }
                Properties properties = this.mergeProperties(PreviewDialog.this.mFeatureUI.getControlValues(), PreviewDialog.this.mFeature.getProperties());
                PreviewDialog.this.mFeature.setProperties(properties);
                object.initExtensionObject((ExtensionObject)PreviewDialog.this.mFeature, properties, null);
                PropertySetEvent propertySetEvent = new PropertySetEvent(new PropertySetProvider(){

                    public void setRawProperties(Properties properties) {
                    }

                    public Properties getRawProperties() {
                        return null;
                    }

                    public boolean hasPresetProperties() {
                        return false;
                    }

                    public PresetPropertyDescriptor getPresetPropertyDescriptor() {
                        return null;
                    }

                    public Properties getPresetProperties(Object object) {
                        return null;
                    }

                    public void addPropertySetListener(PropertySetListener propertySetListener) {
                    }

                    public void removePropertySetListener(PropertySetListener propertySetListener) {
                    }

                    public void setProperty(String string, Object object) {
                    }

                    public void setProperties(Properties properties) {
                    }

                    public Set<String> propertyNames() {
                        return null;
                    }

                    public boolean containsProperty(String string) {
                        return false;
                    }

                    public Object getProperty(String string) {
                        return null;
                    }

                    public Properties getProperties() {
                        return null;
                    }

                    public ValueDescriptor getPropertyValueDescriptor(String string) {
                        return null;
                    }
                }, properties);
                ((PropertySetListener)object).propertySetChanged(propertySetEvent);
                if (bl) {
                    System.out.println(PreviewDialog.this.mFeature.getProperty("rbuilder.build_syntax"));
                } else {
                    System.out.println(PreviewDialog.this.mFeature.getProperty("buildScript"));
                }
            } else {
                PreviewDialog.this.standardClosing();
            }
        }

        private Properties mergeProperties(Properties properties, Properties properties2) {
            DefaultProperties defaultProperties = new DefaultProperties();
            defaultProperties.addProperties(properties2);
            for (String string : properties.propertyNames()) {
                if (properties.getProperty(string).toString().length() <= 0 || !defaultProperties.containsProperty(string)) continue;
                defaultProperties.addProperty(string, properties.getProperty(string));
            }
            return defaultProperties;
        }
    }
}

