/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.peers;

import com.pasw.core.FrameworkApplicationSupportImpl;
import com.pasw.core.datamodel.AddFieldImpl;
import com.pasw.core.extension.feature.FeatureImpl;
import com.pasw.core.extension.manager.ModuleDescriptor;
import com.pasw.core.extension.runtime.DataModelXML;
import com.pasw.core.extension.specification.AttributeSpecification;
import com.pasw.core.extension.specification.ExtensionSpecification;
import com.pasw.core.extension.specification.StructureSpecification;
import com.pasw.core.extension.specification.UserInterfaceSpecification;
import com.pasw.core.property.PropertySetEvent;
import com.pasw.core.property.PropertySetListener;
import com.pasw.core.property.descriptor.DefaultStructure;
import com.pasw.core.property.descriptor.StructureListProperty;
import com.pasw.framework.common.core.Properties;
import com.pasw.framework.common.core.ResourceProvider;
import com.pasw.framework.common.core.StructureDefinition;
import com.pasw.framework.common.core.ValueDescriptor;
import com.pasw.framework.common.data.DataModel;
import com.pasw.framework.common.data.Field;
import com.pasw.framework.common.data.MeasurementType;
import com.pasw.framework.common.data.RoleType;
import com.pasw.framework.common.data.StorageType;
import com.pasw.framework.common.extension.ExtensionObject;
import com.pasw.framework.common.extension.ExtensionObjectContext;
import com.pasw.framework.common.extension.ExtensionObjectEvent;
import com.pasw.framework.common.extension.Feature;
import com.pasw.framework.common.extension.XMLElement;
import com.pasw.framework.common.extension.data.DataModelOperation;
import com.pasw.framework.common.extension.data.FieldBase;
import com.pasw.framework.common.extension.interaction.Interactor;
import com.pasw.framework.common.extension.interaction.InteractorEvent;
import com.pasw.framework.common.extension.spi.ExtensionObjectPeer;
import com.pasw.framework.common.extension.spi.InteractorListener;
import com.pasw.framework.common.extension.spi.PaswDataModelException;
import com.spss.shared.custom_gui.ui_builder.peers.ErrorHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class RStatsExtensionObjPeer
implements ExtensionObjectPeer,
PropertySetListener,
InteractorListener {
    private static final String ESCAPE = "%%";
    private static final String SELFVALUE = "%%ThisValue%%";
    private static final String SEPARATOR = "\u00b1";
    protected static final String BUILD_SYNTAX = "build_syntax";
    protected static final String SCORE_SYNTAX = "score_syntax";
    protected static final String RINTERACTOR = "rinteractor";
    protected static final String SYNTAX = "syntax";
    protected static final String SCRIPT = "script";
    protected static final String SCORESCRIPT = "scoringScript";
    protected static final String RBUILDER = "rbuilder";
    protected static final String ROUTPUT = "routput";
    protected static final String RMODELAPPLIER = "rmodel";
    protected static final String RIMPORTER = "rimporter";
    protected static final String REXPORTER = "rexporter";
    protected static final String RPROCESS = "rprocess";
    protected static final String OUTPUT_DATAMODEL = "output_datamodel";
    protected static final String INPUT_DATAMODEL = "input_datamodel";
    protected static final String OUTPUT_MODE = "output_mode";
    protected static final String FILE_MODE = "File";
    protected static final String OUTPUT_TYPE = "output_type";
    protected static final String GRAPH_TYPE = "Graph";
    protected static final String TEXT_TYPE = "Text";
    protected static final String OUTPUT_FILE_TYPE = "output_file_type";
    protected static final String GRAPH_OUTPUT_TYPE = "graph_output_file_type";
    protected static final String TEXT_OUTPUT_TYPE = "text_output_file_type";
    protected static final String OUTPUT_CONTAINER_ID = "output_container_id";
    protected static final String OUTPUT_CONTAINER_TYPE = "output_container_type";
    protected static final String OUTPUT_CONTAINER_GRAPH = "HTMLOutput";
    protected static final String OUTPUT_CONTAINER_TEXT = "TextOutput";
    protected static final String CONTAINER_TYPE_HTML = "html";
    protected static final String CONTAINER_TYPE_TEXT = "txt";
    protected static final String FIELD_TAG = "Field";
    protected static final String NAME_TAG = "name";
    protected static final String DIS_LABEL_TAG = "displayLabel";
    protected static final String STORAGE_TAG = "storage";
    protected static final String MEASURE_TAG = "measure";
    protected static final String ROLE_TAG = "role";
    protected static final String R_UNKNOW_ERROR = "unknownerror";
    protected String errorMessage;
    protected int sleepTime = 100;
    protected Interactor interactor;
    protected ExtensionObject extensionObject;
    protected ResourceProvider moduleResourceProvider;

    public void initExtensionObject(ExtensionObject extensionObject, Properties properties, ExtensionObjectContext extensionObjectContext) {
        this.extensionObject = extensionObject;
        ((FeatureImpl)this.extensionObject).addPropertySetListener((PropertySetListener)this);
    }

    public void disposeExtensionObject() {
        this.extensionObject = null;
    }

    public void onExtensionObjectEvent(ExtensionObjectEvent extensionObjectEvent) {
        if (extensionObjectEvent.getEventData() == this && extensionObjectEvent.getEventType() == ExtensionObjectEvent.EventType.serverPreExecution) {
            this.setScirptProperty(extensionObjectEvent.getExtensionObject().getProperties());
        }
    }

    public void propertySetChanged(PropertySetEvent propertySetEvent) {
        Properties properties = propertySetEvent.getProperties();
        this.setScirptProperty(properties);
    }

    protected abstract void setSyntaxProperty(String var1);

    protected abstract void setInteractorSyntax();

    protected void setScoreSyntaxProperty(String string) {
        this.extensionObject.setProperty("rbuilder.score_syntax", (Object)string);
    }

    protected void setScirptProperty(Properties properties) {
        String string;
        String string2;
        Object object;
        if (properties.containsProperty(SCRIPT) && (object = this.extensionObject.getProperty(SCRIPT)) != null) {
            string2 = object.toString();
            string2 = string2.replaceAll("\\\\n", "\n");
            string = this.replaceControlEscapes(properties, string2);
            this.setSyntaxProperty(string);
        }
        if (properties.containsProperty(SCORESCRIPT) && (object = this.extensionObject.getProperty(SCORESCRIPT)) != null) {
            string2 = object.toString();
            string2 = string2.replaceAll("\\\\n", "\n");
            string = this.replaceControlEscapes(properties, string2);
            this.setScoreSyntaxProperty(string);
        }
    }

    protected void parseDataModel(String string, List<DataModelOperation> list) {
        Document document = this.parseDataModel(string);
        if (document != null) {
            NodeList nodeList = document.getElementsByTagName(FIELD_TAG);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                RoleType roleType;
                MeasurementType measurementType;
                StorageType storageType;
                Element element = (Element)nodeList.item(i);
                String string2 = element.getAttribute(NAME_TAG);
                String string3 = element.getAttribute(DIS_LABEL_TAG);
                String string4 = element.getAttribute(STORAGE_TAG);
                String string5 = element.getAttribute(MEASURE_TAG);
                String string6 = element.getAttribute(ROLE_TAG);
                try {
                    storageType = StorageType.valueOf((String)string4);
                }
                catch (Exception exception) {
                    storageType = StorageType.string;
                }
                try {
                    measurementType = MeasurementType.valueOf((String)string5);
                }
                catch (Exception exception) {
                    if (storageType == StorageType.unknown) {
                        measurementType = MeasurementType.typeless;
                    }
                    measurementType = storageType == StorageType.string ? MeasurementType.discrete : MeasurementType.continuous;
                }
                try {
                    roleType = RoleType.valueOf((String)string6);
                }
                catch (Exception exception) {
                    roleType = RoleType.input;
                }
                FieldBase fieldBase = new FieldBase();
                fieldBase.setFieldLabel(string3);
                fieldBase.setStorageType(storageType);
                fieldBase.setMeasurementType(measurementType);
                fieldBase.setRoleType(roleType);
                list.add((DataModelOperation)new AddFieldImpl(string2, (Field)fieldBase));
            }
        }
    }

    public void onInteractorEvent(InteractorEvent interactorEvent) {
        try {
            String string = new String(interactorEvent.getMessage(), "UTF-8");
            this.errorMessage = ErrorHelper.getErrorMessage(this.getModuleResourceProvider(), string);
        }
        catch (Exception exception) {
            this.errorMessage = null;
        }
    }

    protected void interact(Element element) {
        this.setInteractorSyntax();
        try {
            this.interactor = ((Feature)this.extensionObject).newInteractor(RINTERACTOR, (InteractorListener)this);
            if (this.interactor != null) {
                this.interactor.initInteractor();
                Properties properties = this.interactor.getInteractorProperties(this.extensionObject.getProperties());
                byte[] byArray = this.interactor.request("getDataModel", properties, this.toDataModelString(element).getBytes("UTF-8"));
                if (byArray == null || byArray.length == 0) {
                    for (int i = 0; i < 5 && this.errorMessage == null; ++i) {
                        try {
                            Thread.sleep(this.sleepTime);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    if (this.errorMessage == null) {
                        this.errorMessage = ErrorHelper.getBundleMessage(this.getModuleResourceProvider(), R_UNKNOW_ERROR);
                    }
                    throw new PaswDataModelException(this.errorMessage);
                }
                String string = new String(byArray, "UTF-8");
                this.extensionObject.setProperty("rinteractor.output_datamodel", (Object)string);
                this.interactor.disposeInteractor();
                this.interactor = null;
            }
        }
        catch (PaswDataModelException paswDataModelException) {
            throw paswDataModelException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInteractorSyntax();
    }

    protected ResourceProvider getModuleResourceProvider() {
        if (this.moduleResourceProvider == null) {
            this.moduleResourceProvider = this.getModuleDescriptor().newResourceProvider(this.getFeature().getSession());
        }
        return this.moduleResourceProvider;
    }

    protected ModuleDescriptor getModuleDescriptor() {
        return ((FrameworkApplicationSupportImpl)this.getFeature().getSession().getApplication().getFrameworkApplicationSupport()).getExtensionManager().getModuleDescriptor(this.interactor.getModuleID());
    }

    protected Feature getFeature() {
        return (Feature)this.extensionObject;
    }

    protected Document parseDataModel(String string) {
        try {
            if (string.length() > 0) {
                Document document = null;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputSource inputSource = new InputSource(new StringReader(string));
                document = documentBuilder.parse(inputSource);
                return document;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Element getMetaDataXML(DataModel dataModel) {
        try {
            Element element = DataModelXML.getDataModelXML((DataModel)dataModel, (boolean)true);
            return element;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String toDataModelString(Element element) {
        String string = "";
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataModelXML.getInstance().writeDocument((OutputStream)byteArrayOutputStream, element);
            string = byteArrayOutputStream.toString("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    protected String replaceControlEscapes(Properties properties, String string) {
        int n = 0;
        int n2 = ESCAPE.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        while (n > -1) {
            if ((n = stringBuffer.indexOf(ESCAPE, n)) <= -1) continue;
            int n3 = stringBuffer.indexOf(ESCAPE, n + 1);
            if (n3 > -1 && n + n2 > n3) {
                n3 = stringBuffer.indexOf(ESCAPE, n + 2);
            }
            if (n3 == -1) {
                n3 = stringBuffer.length();
            }
            String string2 = stringBuffer.subSequence(n + n2, n3).toString();
            if (SELFVALUE.equalsIgnoreCase(ESCAPE + string2 + ESCAPE)) {
                n = n3 + n2;
                continue;
            }
            if (properties.containsProperty(string2 + "_syntax")) {
                String string3 = this.extensionObject.getProperty(string2 + "_syntax").toString();
                if (string3.contains(SEPARATOR)) {
                    string3 = this.getCheckBoxSyntax(properties, string3, string2);
                }
                if (string3.contains(SELFVALUE)) {
                    string3 = this.replaceSelfValue(properties, string3, string2, stringBuffer.toString(), n);
                }
                if (string3.contains(ESCAPE)) {
                    string3 = this.replaceControlEscapes(properties, string3);
                }
                stringBuffer.replace(n, n3 + n2, string3);
                if (string3.length() != 0 || (n += string3.length()) >= stringBuffer.length() || stringBuffer.charAt(n) != ' ') continue;
                stringBuffer.replace(n, n + 1, "");
                continue;
            }
            n = n3 + n2;
        }
        return stringBuffer.toString();
    }

    private String replaceSelfValue(Properties properties, String string, String string2, String string3, int n) {
        Properties properties2 = properties;
        String string4 = string;
        if (properties2.containsProperty(string2)) {
            Object object;
            String string5 = "";
            if (this.extensionObject.getProperty(string2) != null) {
                string5 = this.extensionObject.getProperty(string2).toString();
                if (string5.startsWith("[{") && string5.endsWith("}]")) {
                    string5 = this.replaceTableValue(string2, this.getExteriorQuote(string2, string3, n));
                    string4 = this.replaceSelfValue(string4, string5);
                    return string4;
                }
                string5 = this.replaceListValue(properties2, string5);
                if (properties2.containsProperty(string2 + "_quotationmark")) {
                    object = properties2.getProperty(string2 + "_quotationmark").toString();
                    string5 = this.addFieldQuotation((String)object, string5);
                }
                if (properties2.containsProperty(string2 + "_separator")) {
                    object = properties2.getProperty(string2 + "_separator").toString();
                    string5 = this.replaceFieldSeparator((String)object, string5);
                }
                string5 = string5.replaceAll("\\\\", "/");
            }
            string4 = string4.replaceAll(SELFVALUE, string5);
            object = properties.getProperty(string2 + "_quoteType");
            if (object != null && (object.toString().equals("Python") || object.toString().equals("R"))) {
                char c = this.getExteriorQuote(string2, string3, n);
                if (c == '\"') {
                    string4 = string4.replaceAll("\"", "\\\\\\\"");
                } else if (c == '\'') {
                    string4 = string4.replaceAll("'", "\\\\\\'");
                }
            }
        } else if (properties2.containsProperty(string2 + "_children")) {
            String string6 = this.extensionObject.getProperty(string2 + "_children").toString();
            String[] stringArray = string6.split(";");
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray != null) {
                String string7 = stringArray[0];
                String string8 = "";
                if (properties2.containsProperty(string7 + "_syntax") && (string8 = properties2.getProperty(string7 + "_syntax").toString()).contains(SEPARATOR)) {
                    string8 = this.getCheckBoxSyntax(properties2, string8, string7);
                }
                if (string8.contains(SELFVALUE)) {
                    string8 = this.replaceSelfValue(properties2, string8, string7, string3, n);
                }
                stringBuffer.append(string8);
            }
            string4 = string4.replaceAll(SELFVALUE, stringBuffer.toString());
        }
        return string4;
    }

    protected String replaceTableValue(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        UserInterfaceSpecification userInterfaceSpecification = ((FeatureImpl)this.extensionObject).getFeatureDescriptor().getUserInterfaceSpecification();
        Iterator iterator = userInterfaceSpecification.findElements("TableControl");
        while (iterator.hasNext()) {
            ValueDescriptor valueDescriptor;
            XMLElement xMLElement = (XMLElement)iterator.next();
            Object object = xMLElement.getAttribute("property");
            if (object == null || !object.toString().equals(string) || !((valueDescriptor = this.extensionObject.getPropertyValueDescriptor(string)) instanceof StructureListProperty)) continue;
            StructureDefinition structureDefinition = ((StructureListProperty)valueDescriptor).getStructureDefinition();
            String string2 = structureDefinition.getID();
            ExtensionSpecification extensionSpecification = ((FeatureImpl)this.extensionObject).getFeatureDescriptor().getExtension().getExtensionSpecification();
            StructureSpecification structureSpecification = (StructureSpecification)extensionSpecification.findElement("Structure", string2);
            Iterator iterator2 = structureSpecification.findElements("Attribute");
            int n = 0;
            while (iterator2.hasNext()) {
                AttributeSpecification attributeSpecification = (AttributeSpecification)iterator2.next();
                String string3 = this.getColumnValues(string, n, attributeSpecification, c);
                String string4 = (String)attributeSpecification.getAttribute(SYNTAX);
                string4 = this.replaceSelfValue(string4, string3);
                stringBuilder.append(string4);
                stringBuilder.append(" ");
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    private String replaceSelfValue(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.indexOf(SELFVALUE);
        while (n > -1) {
            stringBuilder.append(string.substring(0, n));
            stringBuilder.append(string2);
            string = string.substring(n + SELFVALUE.length());
            n = string.indexOf(SELFVALUE);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private String getColumnValues(String string, int n, AttributeSpecification attributeSpecification, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList arrayList = (ArrayList)this.extensionObject.getProperty(string);
        String string2 = (String)attributeSpecification.getAttribute("delimiter");
        String string3 = (String)attributeSpecification.getAttribute("quoteType");
        for (DefaultStructure defaultStructure : arrayList) {
            stringBuilder.append(string2);
            if (string3.length() > 0) {
                stringBuilder.append("\"");
            }
            stringBuilder.append((String)defaultStructure.getAttributeValue(n));
            if (string3.length() <= 0) continue;
            stringBuilder.append("\"");
        }
        Object object = stringBuilder.toString().trim();
        if (!string2.equals(" ")) {
            object = ((String)object).substring(1);
        }
        object = ((String)object).replaceAll("\\\\", "/");
        if (string3.length() > 0) {
            if (c == '\"') {
                object = ((String)object).replaceAll("\"", "\\\\\\\"");
            } else if (c == '\'') {
                object = ((String)object).replaceAll("'", "\\\\\\'");
            }
        }
        return object;
    }

    private char getExteriorQuote(String string, String string2, int n) {
        char c;
        char c2;
        char c3 = ' ';
        String string3 = ESCAPE + string + ESCAPE;
        if (string2.indexOf(string3, n) == n && (c2 = this.getQuote(string2, n - 1, true)) == (c = this.getQuote(string2, n + string3.length(), false))) {
            c3 = c2;
        }
        return c3;
    }

    private char getQuote(String string, int n, boolean bl) {
        while (n < string.length() && n > -1) {
            char c = string.charAt(n);
            if (c == '\"' || c == '\'') {
                return c;
            }
            if (c != ' ') break;
            if (bl) {
                --n;
                continue;
            }
            ++n;
        }
        return ' ';
    }

    private String getCheckBoxSyntax(Properties properties, String string, String string2) {
        String string3 = string;
        Properties properties2 = properties;
        String string4 = string2;
        String[] stringArray = string3.split(SEPARATOR);
        if (properties2.containsProperty(string4)) {
            string3 = stringArray.length > 1 ? ("false".equals(properties2.getProperty(string4).toString()) ? stringArray[1] : stringArray[0]) : ("false".equals(properties2.getProperty(string4).toString()) ? "" : stringArray[0]);
        }
        return string3;
    }

    private String replaceListValue(Properties properties, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string;
        if (string2.contains("[") && string2.contains("]")) {
            int n = string2.indexOf("[") + 1;
            int n2 = string2.lastIndexOf("]");
            string2 = string2.substring(n, n2);
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i].trim();
                if (!properties.containsProperty(string3 + "_syntax")) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                String string4 = properties.getProperty(string3 + "_syntax").toString();
                stringBuffer.append(string4);
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        } else if (properties.containsProperty(string2 + "_syntax")) {
            return properties.getProperty(string2 + "_syntax").toString();
        }
        return string2;
    }

    private String addFieldQuotation(String string, String string2) {
        String string3 = string2;
        if (string != null && string.length() == 1 && string3.length() > 0) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string4 : stringArray = string3.split(",")) {
                stringBuilder.append(string);
                stringBuilder.append(string4.trim());
                stringBuilder.append(string);
                stringBuilder.append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    private String replaceFieldSeparator(String string, String string2) {
        String string3 = string2;
        if (string3.length() > 0) {
            string3 = string3.replaceAll(",", string);
        }
        return string3;
    }
}

