/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.peers;

import com.pasw.framework.common.container.Container;
import com.pasw.framework.common.core.Properties;
import com.pasw.framework.common.extension.interaction.InteractorEvent;
import com.pasw.framework.common.extension.spi.InteractorListener;
import com.pasw.framework.ui.swing.ManagedPanelContext;
import com.pasw.framework.ui.swing.spi.ManagedPanel;
import com.pasw.framework.ui.swing.spi.ManagedUIElement;
import com.spss.shared.custom_gui.ui_builder.peers.Copyright;
import com.spss.shared.custom_gui.ui_builder.peers.ManagedEmptyOutputArea;
import com.spss.shared.custom_gui.ui_builder.peers.ManagedHTMLOutputArea;
import com.spss.shared.custom_gui.ui_builder.peers.ManagedTextOutputArea;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComponent;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM SPSS Products: Modeler Common\r\n\r\n\u00a9 Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP\r\nSchedule Contract with IBM Corp.\r\n\r\n")
public class ManagedModelOutputPanel
implements ManagedPanel,
InteractorListener {
    public static final String BUILD_TEXT_OUTPUT = "buildTextOutputDisplay";
    public static final String BUILD_CONSOLE_OUTPUT = "buildConsoleOutputDisplay";
    public static final String BUILD_HTML_OUTPUT = "buildHTMLOutputDisplay";
    public static final String BUILD_MV_OUTPUT = "buildModelViewerDisplay";
    public static final String APPLIER_CONSOLE_OUTPUT = "applierConsoleOutputDisplay";
    public static final String BUILD_TEXT_CONTAINER_NAME = "TextOutput";
    public static final String BUILD_CONSOLE_CONTAINER_NAME = "ConsoleOutput";
    public static final String BUILD_HTML_CONTAINER_NAME = "HTMLOutput";
    public static final String BUILD_PMML_CONTAINER_NAME = "PMML";
    public static final String BUILD_STAT_XML_CONTAINER_NAME = "StatXML";
    public static final String APPLIER_CONSOLE_CONTAINER_NAME = "ApplierConsoleOutput";
    private ManagedTextOutputArea textOutput;
    private ManagedTextOutputArea consoleOutput;
    private ManagedHTMLOutputArea htmlOutput;
    private ManagedEmptyOutputArea emptyOutput;
    private HashMap<String, JComponent> componentMap = new HashMap();
    private ManagedPanelContext managedPanelContext = null;

    public void initManagedPanel(String string, Properties properties, ManagedPanelContext managedPanelContext) {
        this.managedPanelContext = managedPanelContext;
    }

    public ManagedUIElement createManagedUIElement(String string) {
        ManagedUIElement managedUIElement = null;
        if (BUILD_TEXT_OUTPUT.equals(string)) {
            managedUIElement = this.setupTextOutputControl();
        } else if (BUILD_CONSOLE_OUTPUT.equals(string) || APPLIER_CONSOLE_OUTPUT.equals(string)) {
            managedUIElement = this.setupConsoleOutputControl(string);
        } else if (BUILD_HTML_OUTPUT.equals(string)) {
            managedUIElement = this.setupHTMLOutputControl();
        } else if (BUILD_MV_OUTPUT.equals(string)) {
            managedUIElement = this.setupModelViewerControl();
        }
        return managedUIElement;
    }

    public void disposeManagedPanel() {
        this.componentMap.clear();
    }

    public void onInteractorEvent(InteractorEvent interactorEvent) {
    }

    private ManagedUIElement setupTextOutputControl() {
        this.textOutput = new ManagedTextOutputArea();
        this.textOutput.setName(BUILD_TEXT_OUTPUT);
        this.componentMap.put(this.textOutput.getName(), this.textOutput);
        String string = this.getTextContainerData(BUILD_TEXT_CONTAINER_NAME);
        if (string != null) {
            this.textOutput.setData(string);
            this.textOutput.setCaretPosition(0);
        } else {
            this.textOutput = null;
        }
        return this.textOutput;
    }

    private ManagedUIElement setupConsoleOutputControl(String string) {
        this.consoleOutput = new ManagedTextOutputArea();
        this.consoleOutput.setVisible(true);
        String string2 = null;
        if (BUILD_CONSOLE_OUTPUT.equals(string)) {
            this.consoleOutput.setName(BUILD_CONSOLE_OUTPUT);
            this.componentMap.put(this.consoleOutput.getName(), this.consoleOutput);
            string2 = this.getTextContainerData(BUILD_CONSOLE_CONTAINER_NAME);
        } else if (APPLIER_CONSOLE_OUTPUT.equals(string)) {
            this.consoleOutput.setName(APPLIER_CONSOLE_OUTPUT);
            this.componentMap.put(this.consoleOutput.getName(), this.consoleOutput);
            string2 = this.getTextContainerData(APPLIER_CONSOLE_CONTAINER_NAME);
        }
        if (string2 != null) {
            this.consoleOutput.setData(string2);
            this.consoleOutput.setCaretPosition(0);
        } else {
            this.consoleOutput.setVisible(false);
        }
        return this.consoleOutput;
    }

    public void updateConsoleOutputControl(String string) {
        String string2 = this.getTextContainerData(string);
        if (string2 != null) {
            this.consoleOutput.setData(string2);
            this.consoleOutput.setCaretPosition(0);
            this.consoleOutput.setVisible(true);
        } else {
            this.consoleOutput.setVisible(false);
        }
    }

    private ManagedUIElement setupHTMLOutputControl() {
        this.htmlOutput = new ManagedHTMLOutputArea();
        this.htmlOutput.setName(BUILD_HTML_OUTPUT);
        this.componentMap.put(this.htmlOutput.getName(), this.htmlOutput);
        Container container = this.managedPanelContext.getExtensionObjectUI().getExtensionObject().getContainer(BUILD_HTML_CONTAINER_NAME);
        if (container != null && !container.isEmpty()) {
            try {
                File file = File.createTempFile("html_output_zip", "tmp");
                File file2 = new File(file.getCanonicalPath());
                file.delete();
                file2.mkdir();
                file2.deleteOnExit();
                ManagedModelOutputPanel.extractHTMLCompoundContainer(container, file2.getCanonicalPath(), true);
                file.deleteOnExit();
                File file3 = ManagedModelOutputPanel.getHTMLFileTest(container, file2.getCanonicalPath(), true);
                if (file3 != null) {
                    this.htmlOutput.setData(file3.toURI().toURL());
                    this.htmlOutput.setCaretPosition(0);
                }
            }
            catch (Exception exception) {
                this.htmlOutput = null;
            }
        }
        return this.htmlOutput;
    }

    private ManagedUIElement setupModelViewerControl() {
        this.emptyOutput = new ManagedEmptyOutputArea();
        this.emptyOutput.setName(BUILD_MV_OUTPUT);
        this.componentMap.put(this.emptyOutput.getName(), this.emptyOutput);
        Container container = this.managedPanelContext.getExtensionObjectUI().getExtensionObject().getContainer(BUILD_PMML_CONTAINER_NAME);
        Container container2 = this.managedPanelContext.getExtensionObjectUI().getExtensionObject().getContainer(BUILD_STAT_XML_CONTAINER_NAME);
        if (container == null || container2 == null || container.isEmpty() || container2.isEmpty()) {
            this.emptyOutput = null;
        } else {
            try {
                container.getContentFromInputStream();
                container.getContentFromInputStream();
            }
            catch (Exception exception) {
                this.emptyOutput = null;
            }
        }
        return this.emptyOutput;
    }

    public String getTextContainerData(String string) {
        String string2 = null;
        Container container = this.managedPanelContext.getExtensionObjectUI().getExtensionObject().getContainer(string);
        if (container != null && !container.isEmpty()) {
            try {
                int n;
                InputStream inputStream = container.getContentFromInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[4096];
                while ((n = inputStreamReader.read(cArray)) != -1) {
                    stringBuffer.append(new String(cArray, 0, n));
                }
                ((Reader)inputStreamReader).close();
                string2 = stringBuffer.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public static boolean exportToHTML(Container container, String string) {
        boolean bl = false;
        File file = new File(string);
        if (file != null && container != null && !container.isEmpty()) {
            try {
                ManagedModelOutputPanel.extractHTMLCompoundContainer(container, file.getParent(), false);
                File file2 = ManagedModelOutputPanel.getHTMLFileTest(container, file.getParent(), false);
                if (file2 != null) {
                    file2.renameTo(new File(string));
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static File getHTMLFileTest(Container container, String string, boolean bl) throws IOException {
        File file = null;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        Iterator iterator = container.getKeyIterator();
        while (iterator.hasNext()) {
            int n;
            Container.Key key = (Container.Key)iterator.next();
            InputStream inputStream = container.getContentFromInputStream(key);
            String string2 = string + key.toString();
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[32768];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            inputStream.close();
            if (!key.toString().endsWith(".html")) continue;
            file = new File(string2);
            if (!bl) break;
            file.deleteOnExit();
            break;
        }
        return file;
    }

    private static void extractHTMLCompoundContainer(Container container, String string, boolean bl) throws IOException {
        Object object;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        Iterator iterator = container.getKeyIterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            int n;
            Container.Key key = (Container.Key)iterator.next();
            Object object2 = container.getContentFromInputStream(key);
            object = string + key.toString();
            arrayList.add(object);
            FileOutputStream fileOutputStream = new FileOutputStream((String)object);
            byte[] byArray = new byte[32768];
            while ((n = ((InputStream)object2).read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            ((InputStream)object2).close();
        }
        if (bl) {
            for (Object object2 : arrayList) {
                object = new File((String)object2);
                ((File)object).deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZip(String string, String string2, boolean bl) throws IOException {
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        try {
            while (enumeration.hasMoreElements()) {
                Object object;
                Object object2;
                Object object3;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                ArrayList<File> arrayList = new ArrayList<File>();
                for (object3 = new File(zipEntry.getName()); object3 != null; object3 = ((File)object3).getParentFile()) {
                    arrayList.add((File)object3);
                    if (!bl) continue;
                    ((File)object3).deleteOnExit();
                }
                Collections.reverse(arrayList);
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object2 = (File)object3.next();
                    if (!object3.hasNext()) break;
                    object = new File(string2 + ((File)object2).getPath());
                    if (bl) {
                        ((File)object).deleteOnExit();
                    }
                    ((File)object).mkdir();
                }
                object3 = new byte[1024];
                object2 = zipFile.getInputStream(zipEntry);
                object = new FileOutputStream(string2 + zipEntry.getName());
                File file = new File(string2 + zipEntry.getName());
                if (bl) {
                    file.deleteOnExit();
                }
                int n = ((InputStream)object2).read((byte[])object3);
                while (n >= 0) {
                    ((OutputStream)object).write((byte[])object3, 0, n);
                    n = ((InputStream)object2).read((byte[])object3);
                }
                ((InputStream)object2).close();
                ((OutputStream)object).close();
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static File getHTMLFile(String string, String string2, boolean bl) throws IOException {
        File file = null;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        try {
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".html")) continue;
                file = new File(string2 + zipEntry.getName());
                if (bl) {
                    file.deleteOnExit();
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }
}

