/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.peers;

import com.pasw.core.FrameworkApplicationSupportImpl;
import com.pasw.core.application.callback.FileSystemChooserRequest;
import com.pasw.core.application.callback.FileSystemChooserResponse;
import com.pasw.framework.common.core.Properties;
import com.pasw.framework.common.session.SessionCallbackRequest;
import com.pasw.framework.common.session.SessionCallbackResponse;
import com.pasw.framework.ui.common.SystemPanelType;
import com.pasw.framework.ui.common.UICallbackRequest;
import com.pasw.framework.ui.common.UIElement;
import com.pasw.framework.ui.common.UISession;
import com.pasw.framework.ui.swing.ExtensionObjectSwingUI;
import com.pasw.framework.ui.swing.FrameworkSwingSupport;
import com.pasw.framework.ui.swing.SwingResourceProvider;
import com.pasw.framework.ui.swing.SwingUIEvent;
import com.pasw.framework.ui.swing.component.DisplayPanel;
import com.pasw.ui.common.control.ControlManager;
import com.pasw.ui.swing.common.AlertOptionPane;
import com.pasw.ui.swing.common.AlertOptionType;
import com.pasw.ui.swing.common.DialogButtonGroup;
import com.pasw.ui.swing.common.DialogUtil;
import com.pasw.ui.swing.common.SwingFeatureUI;
import com.pasw.ui.swing.common.ToolMenu;
import com.pasw.ui.swing.common.actions.ExtensionAction;
import com.pasw.ui.swing.control.CFAnnotationsPanel;
import com.pasw.ui.swing.control.ModelViewerPanel;
import com.spss.shared.custom_gui.ui_builder.peers.Copyright;
import com.spss.shared.custom_gui.ui_builder.peers.ManagedHTMLOutputArea;
import com.spss.shared.custom_gui.ui_builder.peers.ManagedModelOutputPanel;
import com.spss.shared.custom_gui.ui_builder.peers.ManagedTextOutputArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.MenuEvent;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM SPSS Products: Modeler Common\r\n\r\n\u00a9 Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP\r\nSchedule Contract with IBM Corp.\r\n\r\n")
public class ActionHandler {
    private ExtensionObjectSwingUI extensionObjectSwingUI;
    private boolean bPrintAll;
    private int printScope = 3;
    String actionErrorMessage;

    public ActionHandler(ExtensionObjectSwingUI extensionObjectSwingUI) {
        this.extensionObjectSwingUI = extensionObjectSwingUI;
        this.actionErrorMessage = extensionObjectSwingUI.getSwingResourceProvider().getLabel("ErrorCompletingAction");
    }

    public void handleAction(String string, String string2) {
        if (string.equals("saveNode") || string.equals("storeNode")) {
            this.handleSaveNode(string);
        } else if (string.equals("save") || string.equals("store") || string.equals("saveAs")) {
            this.handleSaveNode(string);
        } else if (string.equals("headerAndFooter") || string.equals("pageSetup")) {
            this.handlePageSetup(string);
        } else if (string.equals("printView")) {
            this.handlePrintView();
        } else if (string.equals("printPreview") || string.equals("print")) {
            this.handlePrint(string, string2);
        } else if (string.equals("exportText")) {
            this.handleExportText(string2);
        } else if (string.equals("exportConsole")) {
            this.handleExportText(string2);
        } else if (string.equals("exportHTML")) {
            this.handleExportHTML("HTML");
        } else if (string.equals("exportModelViewer")) {
            this.handleExportHTML("modelViewer");
        } else if (string.equals("previewTable")) {
            this.handlePreviewTable(string);
        } else if (string.equals("saveToProject")) {
            this.handleSaveToProject(string);
        } else if (string.equals("helpButton")) {
            this.handleHelpButton();
        } else if (string.equals("updateContainer")) {
            this.handleUpdateContainer(string2);
        } else {
            UICallbackRequest uICallbackRequest = this.extensionObjectSwingUI.newUICallbackRequest(string, null);
            if (this.extensionObjectSwingUI.invokeUICallback(uICallbackRequest) == null) {
                JOptionPane.showMessageDialog(this.extensionObjectSwingUI.getRootComponent(), this.actionErrorMessage + " " + uICallbackRequest.getActionName());
            }
        }
    }

    private void handleExportHTML(String string) {
        ModelViewerPanel modelViewerPanel;
        String string2;
        DisplayPanel displayPanel;
        String string3 = this.extensionObjectSwingUI.getSwingResourceProvider().getLabel("SaveFileDialogHTMLDescription");
        String string4 = this.extensionObjectSwingUI.getSwingResourceProvider().getLabel("SaveFileDialogHTMLSuffix");
        if (string.equals("HTML")) {
            String string5 = this.launchSaveFileChooser(string3, new String[]{string4});
            if (string5 != null) {
                this.exportHTMLFile(string5);
            }
        } else if (string.equals("modelViewer") && (displayPanel = this.extensionObjectSwingUI.getDisplayPanel(string)) != null && displayPanel instanceof ModelViewerPanel && (string2 = (modelViewerPanel = (ModelViewerPanel)displayPanel).getExportHTML()) != null && string2.length() > 0) {
            String string6 = this.launchSaveFileChooser(string3, new String[]{string4});
            this.saveTextFile(string2, string6);
        }
    }

    private void handleExportText(String string) {
        String string2 = this.getTextContainerData(string);
        if (string2 == null || string2.length() > 0) {
            // empty if block
        }
        String string3 = "SaveFileDialogTextDescription";
        String string4 = "SaveFileDialogTextSuffix";
        if (string.equals("pmml")) {
            string3 = "SaveFileDialogPMMLDescription";
            string4 = "SaveFileDialogPMMLSuffix";
        }
        String string5 = this.launchSaveFileChooser(this.extensionObjectSwingUI.getSwingResourceProvider().getLabel(string3), new String[]{this.extensionObjectSwingUI.getSwingResourceProvider().getLabel(string4)});
        this.saveTextFile(string2, string5);
    }

    private void handlePrint(String string, String string2) {
        DisplayPanel displayPanel = this.extensionObjectSwingUI.getDisplayPanel(string2);
        DisplayPanel displayPanel2 = this.extensionObjectSwingUI.getSystemDisplayPanel(SystemPanelType.annotation);
        ManagedTextOutputArea managedTextOutputArea = (ManagedTextOutputArea)this.extensionObjectSwingUI.getManagedUIElement("applierConsoleOutputDisplay");
        ManagedTextOutputArea managedTextOutputArea2 = (ManagedTextOutputArea)this.extensionObjectSwingUI.getManagedUIElement("buildTextOutputDisplay");
        ManagedHTMLOutputArea managedHTMLOutputArea = (ManagedHTMLOutputArea)this.extensionObjectSwingUI.getManagedUIElement("buildHTMLOutputDisplay");
        JEditorPane jEditorPane = null;
        if (displayPanel2 != null && displayPanel2 instanceof CFAnnotationsPanel && ((CFAnnotationsPanel)displayPanel2).isShowing()) {
            jEditorPane = displayPanel2;
        } else if (managedTextOutputArea != null && managedTextOutputArea.isShowing()) {
            jEditorPane = managedTextOutputArea;
        } else if (managedTextOutputArea2 != null && managedTextOutputArea2.isShowing()) {
            jEditorPane = managedTextOutputArea2;
        } else if (managedHTMLOutputArea != null && managedHTMLOutputArea.isShowing()) {
            jEditorPane = managedHTMLOutputArea;
        } else if (displayPanel != null && displayPanel instanceof ModelViewerPanel) {
            jEditorPane = displayPanel;
        }
        if (jEditorPane != null) {
            UICallbackRequest uICallbackRequest = this.extensionObjectSwingUI.newUICallbackRequest(string, null);
            uICallbackRequest.setProperty("scope", (Object)this.printScope);
            uICallbackRequest.setProperty("printableProvider", (Object)jEditorPane);
            uICallbackRequest.setProperty("printableComp", (Object)jEditorPane);
            if (this.extensionObjectSwingUI.invokeUICallback(uICallbackRequest) == null) {
                JOptionPane.showMessageDialog(this.extensionObjectSwingUI.getRootComponent(), this.actionErrorMessage + " " + uICallbackRequest.getActionName());
            }
        }
    }

    private void handlePrintView() {
        int n;
        this.bPrintAll = this.printScope == 1;
        String string = this.extensionObjectSwingUI.getSwingResourceProvider().getLabel("PrintViewDialog");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ControlManager controlManager = null;
        if (this.extensionObjectSwingUI instanceof SwingFeatureUI) {
            controlManager = ((SwingFeatureUI)this.extensionObjectSwingUI).getControlManager();
        }
        if ((n = AlertOptionPane.showSubDialog((JComponent)this.extensionObjectSwingUI.getRootComponent(), (JComponent)this.createPrintViewPanel(arrayList), (String)string, (AlertOptionType)AlertOptionType.OK_CANCEL_OPTION, (SwingResourceProvider)this.extensionObjectSwingUI.getSwingResourceProvider(), (ControlManager)controlManager, null, null, (String)"[nativeHelp]print_view", (String)this.extensionObjectSwingUI.getExtensionObject().getExtensionID(), arrayList)) == 0) {
            this.printScope = this.bPrintAll ? 1 : 3;
        }
    }

    private void handlePageSetup(String string) {
        UICallbackRequest uICallbackRequest = this.extensionObjectSwingUI.newUICallbackRequest(string, null);
        if (this.extensionObjectSwingUI.invokeUICallback(uICallbackRequest) == null) {
            JOptionPane.showMessageDialog(this.extensionObjectSwingUI.getRootComponent(), this.actionErrorMessage + " " + uICallbackRequest.getActionName());
        }
    }

    private void handleSaveNode(String string) {
        UICallbackRequest uICallbackRequest = this.extensionObjectSwingUI.newUICallbackRequest(string, null);
        String string2 = "";
        String string3 = (String)this.extensionObjectSwingUI.getControlValue("pasw.annotation_label");
        if (string3 != null && string3.length() > 0) {
            string2 = string3 + ".nod";
        }
        uICallbackRequest.setProperty("default_name", (Object)string2);
        if (this.extensionObjectSwingUI.invokeUICallback(uICallbackRequest) == null) {
            JOptionPane.showMessageDialog(this.extensionObjectSwingUI.getRootComponent(), this.actionErrorMessage + " " + uICallbackRequest.getActionName());
        }
    }

    private void handlePreviewTable(String string) {
        UICallbackRequest uICallbackRequest = this.extensionObjectSwingUI.newUICallbackRequest(string, null);
        if (this.extensionObjectSwingUI.invokeUICallback(uICallbackRequest) == null) {
            JOptionPane.showMessageDialog(this.extensionObjectSwingUI.getRootComponent(), this.actionErrorMessage + " " + uICallbackRequest.getActionName());
        }
    }

    private void handleSaveToProject(String string) {
        UICallbackRequest uICallbackRequest = this.extensionObjectSwingUI.newUICallbackRequest(string, null);
        if (this.extensionObjectSwingUI.invokeUICallback(uICallbackRequest) == null) {
            JOptionPane.showMessageDialog(this.extensionObjectSwingUI.getRootComponent(), this.actionErrorMessage + " " + uICallbackRequest.getActionName());
        }
    }

    private void handleHelpButton() {
        ((FrameworkSwingSupport)this.getUISession().getFrameworkUISupport()).helpRequested(this.extensionObjectSwingUI);
    }

    private void exportHTMLFile(String string) {
        com.pasw.framework.common.container.Container container = this.extensionObjectSwingUI.getExtensionObject().getContainer("HTMLOutput");
        if (container != null && !container.isEmpty() && !ManagedModelOutputPanel.exportToHTML(container, string)) {
            JOptionPane.showMessageDialog(this.extensionObjectSwingUI.getRootComponent(), this.actionErrorMessage + " " + "exportHTML");
        }
    }

    private void saveTextFile(String string, String string2) {
        if (string2 != null && string != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                StringBuffer stringBuffer = new StringBuffer(string);
                fileOutputStream.write(stringBuffer.toString().getBytes("UTF-8"));
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private JPanel createPrintViewPanel(List<Object> list) {
        SwingResourceProvider swingResourceProvider = this.extensionObjectSwingUI.getSwingResourceProvider();
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        int n = 0;
        DialogButtonGroup dialogButtonGroup = new DialogButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(swingResourceProvider.getLabel("PrintViewDialog.visible"));
        Integer n2 = swingResourceProvider.getAccessKey("PrintViewDialog.visible");
        jRadioButton.setMnemonic(n2);
        JRadioButton jRadioButton2 = new JRadioButton(swingResourceProvider.getLabel("PrintViewDialog.all"));
        n2 = swingResourceProvider.getAccessKey("PrintViewDialog.all");
        jRadioButton2.setMnemonic(n2);
        dialogButtonGroup.add((AbstractButton)jRadioButton);
        dialogButtonGroup.add((AbstractButton)jRadioButton2);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JRadioButton)actionEvent.getSource()).isSelected()) {
                    ActionHandler.this.bPrintAll = false;
                }
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JRadioButton)actionEvent.getSource()).isSelected()) {
                    ActionHandler.this.bPrintAll = true;
                }
            }
        });
        if (this.bPrintAll) {
            jRadioButton2.setSelected(true);
        } else {
            jRadioButton.setSelected(true);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, 0, 0, 0);
        list.add(dialogButtonGroup);
        DialogUtil.addUsingGBL((Container)jPanel, (JComponent)jRadioButton, (GridBagConstraints)gridBagConstraints, (int)0, (int)n++, (int)1, (int)1, (int)17, (Insets)insets);
        DialogUtil.addUsingGBL((Container)jPanel, (JComponent)jRadioButton2, (GridBagConstraints)gridBagConstraints, (int)0, (int)n, (int)1, (int)1, (int)17, (Insets)insets);
        return jPanel;
    }

    public String launchSaveFileChooser(String string, String[] stringArray) {
        if (this.useApplicationFileChoosers()) {
            FileSystemChooserRequest fileSystemChooserRequest = new FileSystemChooserRequest((Component)this.extensionObjectSwingUI.getRootComponent(), this.getSaveDialogTitle());
            fileSystemChooserRequest.addFileFilter(string, stringArray);
            FileSystemChooserResponse fileSystemChooserResponse = new FileSystemChooserResponse();
            this.configureSaveChooserCallback(fileSystemChooserRequest);
            if (this.getUISession().handleCallback((SessionCallbackRequest)fileSystemChooserRequest, (SessionCallbackResponse)fileSystemChooserResponse)) {
                return fileSystemChooserResponse.getSelectedPath();
            }
            return null;
        }
        JFileChooser jFileChooser = new JFileChooser();
        this.configureSaveFileChooser(jFileChooser);
        if (jFileChooser.showDialog(this.extensionObjectSwingUI.getRootComponent(), this.getApproveButtonText()) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private void configureSaveFileChooser(JFileChooser jFileChooser) {
        jFileChooser.setDialogTitle(this.getSaveDialogTitle());
        jFileChooser.resetChoosableFileFilters();
        jFileChooser.setDialogType(1);
    }

    private void configureSaveChooserCallback(FileSystemChooserRequest fileSystemChooserRequest) {
        fileSystemChooserRequest.setServerChooser(false);
        fileSystemChooserRequest.setOpenChooser(false);
        fileSystemChooserRequest.setApproveButtonText(this.getApproveButtonText());
        fileSystemChooserRequest.setDefaultFilterIndex(0);
        fileSystemChooserRequest.setFileName(this.getDefaultFileName());
    }

    private String getSaveDialogTitle() {
        return this.extensionObjectSwingUI.getSwingResourceProvider().getLabel("SaveFileDialogTitle");
    }

    private String getApproveButtonText() {
        return this.extensionObjectSwingUI.getSwingResourceProvider().getLabel("SaveFileDialogApproveText");
    }

    private boolean useApplicationFileChoosers() {
        Properties properties = ((FrameworkApplicationSupportImpl)this.getUISession().getApplication().getFrameworkApplicationSupport()).getApplicationProperties();
        Object object = properties.getProperty("useApplicationFileSystemChoosers");
        return object instanceof Boolean && object.equals(Boolean.TRUE);
    }

    private UISession getUISession() {
        return this.extensionObjectSwingUI.getSwingResourceProvider().getUISession();
    }

    public void onSwingUIEvent(SwingUIEvent swingUIEvent) {
        block8: {
            MenuEvent menuEvent;
            Object object;
            Object object2;
            block7: {
                if (swingUIEvent.getEventType() != SwingUIEvent.EventType.apply) break block7;
                if (!(this.extensionObjectSwingUI instanceof SwingFeatureUI)) break block8;
                Iterator iterator = ((SwingFeatureUI)this.extensionObjectSwingUI).getControlManager().getUIElementIDs();
                while (iterator.hasNext()) {
                    UIElement uIElement = ((SwingFeatureUI)this.extensionObjectSwingUI).getControlManager().getUIElement((String)iterator.next());
                    if (!(uIElement instanceof DisplayPanel)) continue;
                    ((DisplayPanel)uIElement).onSwingUIEvent(swingUIEvent);
                }
                break block8;
            }
            if (swingUIEvent.getEventType() == SwingUIEvent.EventType.menuSelected && (object2 = swingUIEvent.getEventData()) instanceof MenuEvent && (object = (menuEvent = (MenuEvent)object2).getSource()) instanceof ToolMenu) {
                ToolMenu toolMenu = (ToolMenu)object;
                for (int i = 0; i < toolMenu.getItemCount(); ++i) {
                    JMenuItem jMenuItem = toolMenu.getItem(i);
                    if (jMenuItem == null || !(jMenuItem.getAction() instanceof ExtensionAction)) continue;
                    ExtensionAction extensionAction = (ExtensionAction)jMenuItem.getAction();
                    if (extensionAction.getActionDescriptor().getID().equals("selectNode")) {
                        jMenuItem.setEnabled(this.isSelectNode());
                        continue;
                    }
                    if (extensionAction.getActionDescriptor().getID().equals("exportText")) {
                        jMenuItem.setEnabled(this.isExportText("text"));
                        continue;
                    }
                    if (extensionAction.getActionDescriptor().getID().equals("exportConsole")) {
                        jMenuItem.setEnabled(this.isExportText("applier_console"));
                        continue;
                    }
                    if (extensionAction.getActionDescriptor().getID().equals("exportPMML")) {
                        jMenuItem.setEnabled(this.isExportText("pmml"));
                        continue;
                    }
                    if (!extensionAction.getActionDescriptor().getID().equals("exportHTML")) continue;
                    jMenuItem.setEnabled(this.isExportHTML());
                }
            }
        }
    }

    private String getTextContainerData(String string) {
        ManagedModelOutputPanel managedModelOutputPanel;
        String string2 = null;
        String string3 = null;
        if (string.equals("text")) {
            string2 = "managed_text_output_panel";
            string3 = "TextOutput";
        } else if (string.equals("console")) {
            string2 = "managed_console_output_panel";
            string3 = "ConsoleOutput";
        } else if (string.equals("applier_console")) {
            string2 = "managed_applier_console_output_panel";
            string3 = "ApplierConsoleOutput";
        } else if (string.equals("pmml")) {
            string2 = "managed_model_output_panel";
            string3 = "PMML";
        }
        String string4 = null;
        if (string2 != null && string3 != null && (managedModelOutputPanel = (ManagedModelOutputPanel)this.extensionObjectSwingUI.getManagedPanel(string2)) != null) {
            string4 = managedModelOutputPanel.getTextContainerData(string3);
        }
        return string4;
    }

    private boolean isExportText(String string) {
        boolean bl = false;
        String string2 = this.getTextContainerData(string);
        if (string2 != null) {
            bl = string2.length() != 0;
        }
        return bl;
    }

    private boolean isExportHTML() {
        boolean bl = false;
        com.pasw.framework.common.container.Container container = this.extensionObjectSwingUI.getExtensionObject().getContainer("HTMLOutput");
        if (container != null) {
            bl = !container.isEmpty();
        }
        return bl;
    }

    private boolean isSelectNode() {
        boolean bl = false;
        ModelViewerPanel modelViewerPanel = this.getModelViewerPanel();
        if (modelViewerPanel != null) {
            int n = 1;
            String string = modelViewerPanel.getExpression(n);
            if (string == null) {
                n = 2;
                string = modelViewerPanel.getExpression(n);
            }
            bl = string != null;
        }
        return bl;
    }

    private ModelViewerPanel getModelViewerPanel() {
        ModelViewerPanel modelViewerPanel = null;
        if (this.extensionObjectSwingUI instanceof SwingFeatureUI) {
            Iterator iterator = ((SwingFeatureUI)this.extensionObjectSwingUI).getControlManager().getUIElementIDs();
            while (iterator.hasNext()) {
                UIElement uIElement = ((SwingFeatureUI)this.extensionObjectSwingUI).getControlManager().getUIElement((String)iterator.next());
                if (!(uIElement instanceof ModelViewerPanel)) continue;
                modelViewerPanel = (ModelViewerPanel)uIElement;
                break;
            }
        }
        return modelViewerPanel;
    }

    private String getDefaultFileName() {
        String string = "";
        ModelViewerPanel modelViewerPanel = this.getModelViewerPanel();
        if (modelViewerPanel != null) {
            string = modelViewerPanel.getDefaultFileName();
        }
        return string;
    }

    private void handleUpdateContainer(String string) {
        String string2;
        ManagedModelOutputPanel managedModelOutputPanel;
        if (string != null && string.equals("ConsoleOutput") && (managedModelOutputPanel = (ManagedModelOutputPanel)this.extensionObjectSwingUI.getManagedPanel(string2 = "managed_console_output_panel")) != null) {
            managedModelOutputPanel.updateConsoleOutputControl(string);
        }
        if (string.equals("ApplierConsoleOutput") && (managedModelOutputPanel = (ManagedModelOutputPanel)this.extensionObjectSwingUI.getManagedPanel(string2 = "managed_applier_console_output_panel")) != null) {
            managedModelOutputPanel.updateConsoleOutputControl(string);
        }
    }
}

