/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.extension;

import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.extension.OptionSwapperPanel;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OptionSidebarSelectorPanel
extends JPanel
implements ListSelectionListener {
    protected static Border sNoFocusBorder = null;
    protected static Border sFocusBorder = null;
    protected static final Dimension sMinListSize = new Dimension(100, 20);
    protected JList itemList;
    protected JScrollPane listScrollPane;
    protected DefaultListModel listModel;
    protected OptionSwapperPanel swapperPanel;
    private BaseDialog mParent;

    public OptionSidebarSelectorPanel(BaseDialog baseDialog, String string, String string2, Integer n) {
        super(new GridBagLayout(), true);
        this.mParent = baseDialog;
        this.setName(string);
        this.initialize(string2, n);
    }

    public int addUIElement(JPanel jPanel, String string) {
        if (jPanel instanceof JPanel) {
            String string2 = string;
            this.addPanel(jPanel, string2 != null ? string2 : string);
        }
        return this.getPanelCount() - 1;
    }

    public int getSelectedIndex() {
        return this.getSelectedPanel();
    }

    public JPanel getUIElementAt(int n) {
        return (JPanel)this.swapperPanel.getComponent(n);
    }

    public JPanel getUIElement(String string) {
        int n = this.swapperPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.swapperPanel.getComponent(i);
            if (!(component instanceof JPanel) || !string.equals(((JPanel)component).getUIClassID())) continue;
            return (JPanel)component;
        }
        return null;
    }

    public int getUIElementCount() {
        return this.getPanelCount();
    }

    public void removeAllUIElements() {
        this.removeAllPanels();
    }

    public boolean removeUIElement(int n) {
        return this.removePanel(n);
    }

    public void setSelectedIndex(int n) {
        this.setSelectedPanel(n);
    }

    public Component getSelectedComponent() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.swapperPanel.getComponent(n);
    }

    public void addPanel(JPanel jPanel, String string) {
        this.addPanel(jPanel, string, null, "", "", -1);
    }

    public void addPanel(JPanel jPanel, String string, Icon icon, String string2, String string3) {
        this.addPanel(jPanel, string, icon, string2, string3, -1);
    }

    public void addPanel(JPanel jPanel, String string, Icon icon, String string2, String string3, int n) {
        if (n < 0 || n > this.listModel.size()) {
            n = this.listModel.size();
        }
        this.listModel.add(n, new PanelItem(jPanel, string, icon, string2, string3));
        this.swapperPanel.addPanel(jPanel, string);
        this.recalcPreferredListSize();
        if (this.listModel.size() == 1) {
            this.setSelectedPanel(n);
        }
    }

    public boolean removePanel(String string) {
        return this.removePanel(this.findPanelIndex(string));
    }

    public boolean removePanel(int n) {
        if (n < 0 || n > this.listModel.size()) {
            return false;
        }
        boolean bl = this.itemList.getSelectedIndex() == n;
        PanelItem panelItem = (PanelItem)this.listModel.remove(n);
        this.swapperPanel.remove(panelItem.getPanel());
        this.recalcPreferredListSize();
        if (bl && this.listModel.size() > 0) {
            this.setSelectedPanel(0);
        }
        return true;
    }

    public void removeAllPanels() {
        this.listModel.clear();
        this.swapperPanel.removeAll();
    }

    public int getPanelCount() {
        return this.listModel.size();
    }

    public boolean setSelectedPanel(String string) {
        return this.setSelectedPanel(this.findPanelIndex(string));
    }

    public boolean setSelectedPanel(int n) {
        if (n < 0 || n >= this.listModel.size()) {
            return false;
        }
        this.itemList.setSelectedIndex(n);
        return true;
    }

    public int getSelectedPanel() {
        return this.itemList.getSelectedIndex();
    }

    public PanelItem getPanelItem(int n) {
        if (n < 0 || n >= this.listModel.size()) {
            return null;
        }
        return (PanelItem)this.listModel.get(n);
    }

    public int findPanelIndex(String string) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            PanelItem panelItem = this.getPanelItem(i);
            if (!panelItem.getListName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean changeListItemName(int n, String string) {
        if (n < 0 || n >= this.listModel.size()) {
            return false;
        }
        int n2 = this.itemList.getSelectedIndex();
        PanelItem panelItem = this.getPanelItem(n);
        panelItem.setListName(string);
        this.swapperPanel.removePanel(panelItem.getPanel());
        this.swapperPanel.addPanel(panelItem.getPanel(), string);
        if (n2 == n) {
            this.swapperPanel.setActivePanel(string);
        }
        this.recalcPreferredListSize();
        return true;
    }

    public boolean isRequired() {
        return false;
    }

    public void setRequired(boolean bl) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.itemList.getSelectedIndex();
        if (listSelectionEvent.getValueIsAdjusting() || n < 0) {
            return;
        }
        PanelItem panelItem = this.getPanelItem(n);
        this.swapperPanel.setActivePanel(panelItem.getListName());
    }

    public JComponent asComponent() {
        return this;
    }

    public String getID() {
        return this.getName();
    }

    public JList getItemList() {
        return this.itemList;
    }

    protected void initialize(String string, Integer n) {
        JLabel jLabel = new JLabel(string);
        this.listModel = new DefaultListModel();
        this.itemList = new JList(this.listModel);
        this.itemList.setSelectionMode(0);
        this.itemList.setFixedCellHeight(26);
        this.itemList.setCellRenderer(new SelectorCellRenderer());
        this.itemList.setPreferredSize(sMinListSize);
        this.listScrollPane = new JScrollPane(this.itemList);
        this.listScrollPane.setMinimumSize(sMinListSize);
        this.listScrollPane.setHorizontalScrollBarPolicy(31);
        this.swapperPanel = new OptionSwapperPanel();
        this.swapperPanel.setMinimumSize(new Dimension(550, 550));
        this.swapperPanel.setPreferredSize(new Dimension(550, 550));
        if (n != null) {
            jLabel.setDisplayedMnemonic(n);
            jLabel.setLabelFor(this.itemList);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        Insets insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, 0, 0, 4);
        DialogUtil.addUsingGBL(this, this.listScrollPane, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, 4, 0, 0);
        DialogUtil.addUsingGBL(this, this.swapperPanel, gridBagConstraints, 1, 1, 1, 2, n2, insets);
        this.itemList.addListSelectionListener(this);
    }

    protected void recalcPreferredListSize() {
        int n;
        int n2 = OptionSidebarSelectorPanel.sMinListSize.width;
        Insets insets = this.itemList.getInsets();
        int n3 = insets.left + insets.right;
        int n4 = 6;
        Component component = this.itemList.getCellRenderer().getListCellRendererComponent(this.itemList, "", 0, false, false);
        if (component instanceof JLabel) {
            Insets insets2 = ((JLabel)component).getInsets();
            n4 = insets2.left + insets2.right;
        }
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            PanelItem panelItem = (PanelItem)this.listModel.getElementAt(i);
            n = SwingUtilities.computeStringWidth(this.itemList.getFontMetrics(this.itemList.getFont()), panelItem.getListName());
            n2 = Math.max(n2, n + n3 + n4);
        }
        JScrollBar jScrollBar = this.listScrollPane.getVerticalScrollBar();
        int n5 = jScrollBar.isVisible() ? jScrollBar.getWidth() : 0;
        n = Math.max(OptionSidebarSelectorPanel.sMinListSize.height, this.itemList.getFixedCellHeight() * this.listModel.getSize());
        this.itemList.setPreferredSize(new Dimension((n2 += n5) + 10, n));
        this.listScrollPane.setMinimumSize(new Dimension(n2 + 10, n + 4));
        this.itemList.invalidate();
    }

    class SelectorCellRenderer
    extends JLabel
    implements ListCellRenderer {
        SelectorCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            if (object instanceof PanelItem) {
                this.setIcon(((PanelItem)object).getItemIcon());
            }
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (OptionSidebarSelectorPanel.this.itemList.hasFocus()) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            } else {
                this.setOpaque(false);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.handleBorder(jList, bl2);
            return this;
        }

        @Override
        public void setText(String string) {
            super.setText(string);
        }

        @Override
        public void setToolTipText(String string) {
            super.setToolTipText(string);
        }

        private void handleBorder(JList jList, boolean bl) {
            if (sNoFocusBorder == null || sFocusBorder == null) {
                this.createBorders();
            }
            Border border = bl && jList.isEnabled() ? sFocusBorder : sNoFocusBorder;
            this.setBorder(border);
        }

        private void createBorders() {
            Border border = BorderFactory.createEmptyBorder(0, 2, 0, 2);
            Border border2 = UIManager.getBorder("List.focusCellHighlightBorder");
            sFocusBorder = BorderFactory.createCompoundBorder(border2, border);
            border2 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            sNoFocusBorder = BorderFactory.createCompoundBorder(border2, border);
        }
    }

    public static class PanelItem {
        private String listName;
        private Icon icon;
        private String itemDesc;
        private JPanel panel;
        private String helpId;

        public PanelItem(JPanel jPanel, String string, Icon icon, String string2, String string3) {
            this.panel = jPanel;
            this.listName = string;
            this.icon = icon;
            this.itemDesc = string2;
            this.helpId = string3;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public String getListName() {
            return this.listName;
        }

        public void setListName(String string) {
            this.listName = string;
        }

        public Icon getItemIcon() {
            return this.icon;
        }

        public String getItemDesc() {
            return this.itemDesc;
        }

        public void setItemDesc(String string) {
        }

        public String getHelpID() {
            return this.helpId;
        }

        public void setHelpID(String string) {
        }

        public String toString() {
            return this.getListName();
        }
    }
}

