/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.extension;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.FileTextField;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SerializableEditableList;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.TextFieldAction;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RefFileFilter;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RemoteFileChooser;
import com.spss.shared.custom_gui.ui_builder.extension.ExtensionPropertyDlg;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.LimitedPlainDocument;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.BaseSpssTab;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.ui_builder.definition.AppType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class ExtensionPropertyRequiredTab
extends BaseSpssTab
implements ActionListener,
KeyListener,
ListDataListener,
ListSelectionListener,
FocusListener {
    public static final String REQUIRED_NAME_TEXT_KEY = "IDK_NAME_TEXT";
    public static final String REQUIRED_FILES_KEY = "IDK_EXTENSION_BUNDLE_REQUIRED_TAB_FILES";
    public static final String REQUIRED_SUMMARY_TEXT_KEY = "IDK_SUMMARY_TEXT";
    public static final String REQUIRED_DESC_TEXT_KEY = "IDK_DESC_TEXT";
    public static final String REQUIRED_AUTHOR_TEXT_KEY = "IDK_AUTHOR_TEXT";
    public static final String REQUIRED_VERSION_TEXT_KEY = "IDK_VERSION_TEXT";
    public static final String REQUIRED_VERSION_COMBO_KEY = "IDK_VERSION_COMBO";
    public static final String REQUIRED_TARGET_FILE_TEXT_KEY = "IDK_TARGET_FILE_TEXT";
    static final String REQUIRED_OPEN_DIALOG_FILTER = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_OPEN_DIALOG_FILTER";
    static final String REQUIRED_OPEN_DIALOG_EXTENSION = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_OPEN_DIALOG_EXTENSION";
    static final String REQUIRED_OPEN_DIALOG_TITLE = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_OPEN_DIALOG_TITLE";
    static final String REQUIRED_SPE_DIALOG_FILTER = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SPE_DIALOG_FILTER";
    static final String REQUIRED_SPE_DIALOG_EXTENSION = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SPE_DIALOG_EXTENSION";
    static final String REQUIRED_SPE_DIALOG_TITLE = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SPE_DIALOG_TITLE";
    static final String REQUIRED_FIRST_INFO_TEXT = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_FIRST_INFO_TEXT";
    static final String REQUIRED_INFO_TEXT = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_INFO_TEXT";
    static final String REQUIRED_SECOND_INFO_TEXT = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SECOND_INFO_TEXT";
    static final String REQUIRED_NAME_THREE_WORDS_LIMIT_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_NAME_THREE_WORDS_LIMIT";
    static final String REQUIRED_SPD_FILE_DUPLICATION_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_SPD_FILE_DUPLICATION";
    static final String REQUIRED_FILE_DUPLICATION_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_FILE_DUPLICATION";
    static final String REQUIRED_REQUIRED_FILES_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_REQUIRED_FILES";
    static final String REQUIRED_REQUIRED_SUB_FILES_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_REQUIRED_SUB_FILES";
    static final String REQUIRED_VERSION_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_VERSION";
    static final String REQUIRED_FILE_NOT_FOUND_MSG = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_FILE_NOT_FOUND_MSG";
    static final String REQUIRED_ACCESS_DENIED = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_ACCESS_DENIED";
    static final String REQUIRED_ENTER_FILE = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_ENTER_FILE";
    private JLabel mInfoTextImageLabel;
    private JTextArea mInfoTextAreaOne;
    private JLabel mInfoTextImageLabel2;
    private JTextArea mInfoTextAreaTwo;
    private JLabel mNameFieldLabel;
    private JTextField mNameField;
    private JLabel mFilesLabel;
    private SerializableEditableList mFilesList;
    private JScrollPane mFilesListScrollPane;
    private JButton mAddButton;
    private JButton mRemoveButton;
    private JButton mExtractButton;
    private JLabel mSummaryFieldLabel;
    private JTextField mSummaryField;
    private JLabel mVersionLabel;
    private JTextField mVersionField;
    private JLabel mSpssVersionLabel;
    private IntTextField mSpssVersionField;
    private JTextField mTargetFilePath;
    private JButton mBrowseButton;
    private Vector<String> mDialogSpecsVector = new Vector();
    private Vector<String> mCommandSpecsVector = new Vector();
    private Vector<String> mCodeFilesVector = new Vector();
    private Vector<String> mMiscFilesVector = new Vector();
    private Vector<String> mAllFilesVector = new Vector();
    ExtensionPropertyDlg mParent;
    private boolean mModified = false;

    public ExtensionPropertyRequiredTab(ExtensionPropertyDlg extensionPropertyDlg, boolean bl) {
        super((BaseDialog)extensionPropertyDlg, false);
        this.mParent = extensionPropertyDlg;
        this.initPanel();
        if (bl) {
            this.setDefaults();
        }
    }

    public String getDialogHelpID() {
        return "idh_required";
    }

    public void initPanel() {
        super.initPanel();
        this.initVariables();
        this.setupPanel();
        this.enableUIItems();
        this.setFocusTraversalPolicy();
    }

    public void aboutToShowTab() {
        this.mParent.preloadRequiredTab();
    }

    private void initVariables() {
        TextFieldListener textFieldListener = new TextFieldListener();
        this.mInfoTextAreaOne = new JTextArea(this.getResString(REQUIRED_FIRST_INFO_TEXT));
        if (BuilderUtil.getInstance().isStandalone()) {
            this.mInfoTextAreaOne = new JTextArea(this.getResString(REQUIRED_INFO_TEXT));
        }
        this.mInfoTextAreaOne.setEditable(false);
        this.mInfoTextAreaOne.setOpaque(false);
        this.mInfoTextAreaOne.setFocusable(false);
        this.mInfoTextAreaOne.setWrapStyleWord(true);
        this.mInfoTextAreaOne.setLineWrap(true);
        URL uRL = BuilderResUtil.getImageResource("infodotNew.png");
        this.mInfoTextImageLabel = new JLabel();
        this.mInfoTextImageLabel.setIcon(new ImageIcon(uRL));
        this.mInfoTextAreaTwo = new JTextArea(this.getResString(REQUIRED_SECOND_INFO_TEXT));
        this.mInfoTextAreaTwo.setEditable(false);
        this.mInfoTextAreaTwo.setOpaque(false);
        this.mInfoTextAreaTwo.setFocusable(false);
        this.mInfoTextAreaTwo.setWrapStyleWord(true);
        this.mInfoTextAreaTwo.setLineWrap(true);
        this.mInfoTextImageLabel2 = new JLabel();
        this.mInfoTextImageLabel2.setIcon(new ImageIcon(uRL));
        this.mNameField = new JTextField();
        this.mNameField.addKeyListener(this);
        this.mNameField.getDocument().addDocumentListener(textFieldListener);
        this.mNameField.setAction(new TextFieldAction(this.mParent, REQUIRED_NAME_TEXT_KEY));
        this.mNameField.setPreferredSize(new Dimension(325, this.mNameField.getMinimumSize().height));
        this.mNameFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_NAME");
        this.mNameFieldLabel.setLabelFor(this.mNameField);
        this.mFilesList = new SerializableEditableList(REQUIRED_FILES_KEY);
        this.mFilesList.addListSelectionListener(this);
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        defaultListModel.addListDataListener(this);
        this.mFilesListScrollPane = new JScrollPane(this.mFilesList);
        this.mFilesListScrollPane.setPreferredSize(new Dimension(325, 102));
        this.mFilesListScrollPane.getVerticalScrollBar().setEnabled(true);
        this.mFilesLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_FILES");
        this.mFilesLabel.setLabelFor(this.mFilesList);
        this.mAddButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_ADD", this);
        this.mRemoveButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_REMOVE", this);
        this.mExtractButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_EXTRACT", this);
        this.mSummaryField = new JTextField();
        this.mSummaryField.getDocument().addDocumentListener(textFieldListener);
        this.mSummaryField.setAction(new TextFieldAction(this.mParent, REQUIRED_SUMMARY_TEXT_KEY));
        this.mSummaryField.setPreferredSize(new Dimension(325, this.mSummaryField.getMinimumSize().height));
        this.mSummaryFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SUMMARY");
        this.mSummaryFieldLabel.setLabelFor(this.mSummaryField);
        this.mVersionField = new JTextField();
        this.mVersionField.setDocument((Document)new LimitedPlainDocument(8));
        this.mVersionField.setAction(new TextFieldAction(this.mParent, REQUIRED_VERSION_TEXT_KEY));
        this.mVersionField.addKeyListener(this);
        this.mVersionField.getDocument().addDocumentListener(textFieldListener);
        this.mVersionField.setPreferredSize(new Dimension(53, this.mVersionField.getMinimumSize().height));
        this.mVersionLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_VERSION");
        this.mVersionLabel.setLabelFor(this.mVersionField);
        this.mSpssVersionField = new IntTextField(18, Integer.MAX_VALUE, true);
        this.mSpssVersionLabel = BuilderUtil.getInstance().getAppType() == AppType.MODELER ? DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_PASW_MODELER_VERSION") : DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_PASW_STATISTICS_VERSION");
        this.mSpssVersionLabel.setLabelFor((Component)this.mSpssVersionField);
        this.mTargetFilePath = new FileTextField();
        this.mBrowseButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_BROWSE", this);
    }

    private String getFileNameExt(String string) {
        String string2 = "";
        if (string.lastIndexOf(".") >= 0 && string.lastIndexOf(".") < string.length() - 1) {
            string2 = string.substring(string.lastIndexOf(".") + 1);
        }
        return string2;
    }

    private void setupPanel() {
        this.setLayout(new GridBagLayout());
        int n = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        Insets insets = new Insets(4, 10, n * 2, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL((Container)((Object)this), this.createIconPanel(this.mInfoTextImageLabel, this.mInfoTextAreaOne, 2), gridBagConstraints, 1, 0, 6, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        insets.set(2, 10, n * 3, 4);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mNameFieldLabel, gridBagConstraints, 0, 1, 2, 1, n2, insets);
        insets.set(2, 4, n * 3, 10);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mNameField, gridBagConstraints, 2, 1, 3, 1, n2, insets);
        insets.set(2, 10, n * 3, 4);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mSummaryFieldLabel, gridBagConstraints, 0, 2, 2, 1, n2, insets);
        insets.set(2, 4, n * 3, 10);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mSummaryField, gridBagConstraints, 2, 2, 3, 1, n2, insets);
        insets.set(2, 10, n * 3, 4);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mVersionLabel, gridBagConstraints, 0, 3, 2, 1, n2, insets);
        gridBagConstraints.fill = 0;
        insets.set(2, 4, n * 3, 10);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mVersionField, gridBagConstraints, 2, 3, 1, 1, n2, insets);
        insets.set(2, 10, n * 3, 4);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mSpssVersionLabel, gridBagConstraints, 3, 3, 1, 1, n2, insets);
        insets.set(2, 4, n * 3, 10);
        DialogUtil.addUsingGBL((Container)((Object)this), (JComponent)this.mSpssVersionField, gridBagConstraints, 4, 3, 1, 1, n2, insets);
        if (!BuilderUtil.getInstance().isStandalone()) {
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            insets.set(n * 2, 10, n, 4);
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL((Container)((Object)this), this.createIconPanel(this.mInfoTextImageLabel2, this.mInfoTextAreaTwo, 0), gridBagConstraints, 1, 4, 6, 1, n2, insets);
        }
        gridBagConstraints.fill = 0;
        insets.set(2, 10, n * 2, 4);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mFilesLabel, gridBagConstraints, 0, 5, 2, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, 4, n * 2, 2);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mFilesListScrollPane, gridBagConstraints, 2, 5, 3, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(2, 2, n * 2, n * 3);
        DialogUtil.addUsingGBL((Container)((Object)this), this.setupAddRemoveButtonsPanel(), gridBagConstraints, 5, 5, 1, 1, n2, insets);
        if (BuilderUtil.getInstance().isStandalone()) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            insets.set(n * 2, 10, n, 4);
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL((Container)((Object)this), this.setupTargetFileFolderPanel(), gridBagConstraints, 1, 6, 6, 1, n2, insets);
        }
    }

    private JPanel createIconPanel(JLabel jLabel, JTextArea jTextArea, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(1, 0, n2, 4);
        int n3 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets.set(2 + n, 4, n2, 4);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 0, 1, 1, n3, insets);
        return jPanel;
    }

    private JPanel setupAddRemoveButtonsPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        jPanel.setLayout(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mExtractButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private JPanel setupTargetFileFolderPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_TARGET_FILE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n, n, n);
        int n2 = 20;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetFilePath, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        n2 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        this.addToComponentOrder(this.mNameField);
        this.addToComponentOrder(this.mFilesList);
        this.addToComponentOrder(this.mAddButton);
        this.addToComponentOrder(this.mRemoveButton);
        this.addToComponentOrder(this.mExtractButton);
        this.addToComponentOrder(this.mSummaryField);
        this.addToComponentOrder(this.mVersionField);
        this.addToComponentOrder(this.mSpssVersionField);
        this.addAllToComponentOrder(new Vector<Component>(Arrays.asList(this.mParent.getCmdButtonPanel().getComponents())));
    }

    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public void setDefaults() {
        this.mNameField.setText("");
        ((DefaultListModel)this.mFilesList.getModel()).clear();
        this.mSummaryField.setText("");
        this.mVersionField.setText("1.0.0");
        this.setInitialized(true);
    }

    String getExtensionName() {
        return this.mNameField.getText();
    }

    String getExtensionSummary() {
        return this.mSummaryField.getText();
    }

    String getExtensionVersion() {
        return this.mVersionField.getText();
    }

    String getMinStatsVersion() {
        return this.mSpssVersionField.getText();
    }

    public Vector<String> getDialogSpecs() {
        return this.mDialogSpecsVector;
    }

    public Vector<String> getCommandSpecs() {
        return this.mCommandSpecsVector;
    }

    public Vector<String> getCodeFiles() {
        return this.mCodeFilesVector;
    }

    public Vector<String> getMiscFiles() {
        return this.mMiscFilesVector;
    }

    public Vector<String> getAllFiles() {
        return this.mAllFilesVector;
    }

    public JTextField getNameField() {
        return this.mNameField;
    }

    public SerializableEditableList getFilesList() {
        return this.mFilesList;
    }

    public JTextField getSummaryField() {
        return this.mSummaryField;
    }

    public String getTargetFilePath() {
        return this.mTargetFilePath.getText();
    }

    public JTextField getVersionField() {
        return this.mVersionField;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void setNameField(String string) {
        this.mNameField.setText(string);
    }

    public void setFilesList(Set<String> set) {
        Iterator<String> iterator = set.iterator();
        String string = BuilderUtil.getInstance().getTempDir().getPath();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string2.startsWith(string)) {
                string2 = new File(string2).getName();
            }
            this.addListItemAt(-1, string2);
        }
    }

    public void setVersionField(String string) {
        this.mVersionField.setText(string);
    }

    public void setSpssVersionField(String string) {
        this.mSpssVersionField.setText(string);
    }

    public void setSummaryField(String string) {
        this.mSummaryField.setText(string);
    }

    public void setTargetFilePath(String string) {
        if (BuilderUtil.getInstance().isStandalone()) {
            this.mTargetFilePath.setText(string);
        }
    }

    boolean isTabModified() {
        if (!this.mModified) {
            return this.mParent.isBundleNameChanged(this.mNameField.getText()) || this.mParent.isSummaryChanged(this.mSummaryField.getText()) || this.mParent.isVersionChanged(this.mVersionField.getText()) || this.mParent.isMinStatsVersionChanged(this.mSpssVersionField.getText());
        }
        return this.mModified;
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == (DefaultListModel)this.mFilesList.getModel()) {
            DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
            defaultListModel.removeListDataListener(this);
            String string = this.getListItemAt(listDataEvent.getIndex0());
            if (string.trim().length() == 0) {
                this.removeListItemAt(listDataEvent.getIndex0());
            }
            defaultListModel.addListDataListener(this);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private void removeListItemAt(int n) {
        ((DefaultListModel)this.mFilesList.getModel()).removeElementAt(n);
    }

    private String getListItemAt(int n) {
        return this.mFilesList.getModel().getElementAt(n).toString();
    }

    public void addListItemAt(int n, String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        if (string.equals("")) {
            string = " ";
        }
        if (n < 0) {
            n = defaultListModel.getSize();
        }
        defaultListModel.add(n, string);
        if (string.endsWith(".cfe")) {
            this.mParent.updateCDBFileList(string, true);
        }
    }

    private void setListItemAt(int n, String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        if (string.equals("")) {
            string = " ";
        }
        defaultListModel.setElementAt(string, n);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mNameField && keyEvent.getKeyChar() >= ' ' && keyEvent.getKeyChar() <= '\u007f') {
            String string = "\"*:/<>?\\|";
            if (string.contains("" + keyEvent.getKeyChar())) {
                Toolkit.getDefaultToolkit().beep();
                keyEvent.consume();
            }
        } else if (keyEvent.getSource() == this.mVersionField && !Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '.' && keyEvent.getKeyChar() != '\u007f' && keyEvent.getKeyChar() != '\b' && keyEvent.getKeyChar() != '\n') {
            Toolkit.getDefaultToolkit().beep();
            keyEvent.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mAddButton) {
            this.processAddButton();
        } else if (object == this.mRemoveButton) {
            this.processRemoveButton();
        } else if (object == this.mExtractButton) {
            this.processExtractButton();
        } else if (object == this.mBrowseButton) {
            this.processBrowseButton();
        }
    }

    private void processBrowseButton() {
        File file = this.mParent.getFilePath(1, this.getResString(REQUIRED_SPE_DIALOG_TITLE), this.getResString(REQUIRED_SPE_DIALOG_EXTENSION), this.getResString(REQUIRED_SPE_DIALOG_FILTER), "");
        if (file != null) {
            String string = file.getAbsolutePath();
            if ((string = string.trim()) != null && string.length() > 0) {
                this.mTargetFilePath.setText(string);
                this.mModified = true;
                this.mParent.enableUIItems();
            }
        }
    }

    private void processAddButton() {
        File file;
        String string = (String)this.mFilesList.getSelectedValue();
        if (string == null) {
            string = "";
        }
        if ((file = this.mParent.getFilePath(0, this.getResString(REQUIRED_OPEN_DIALOG_TITLE), this.getResString(REQUIRED_OPEN_DIALOG_EXTENSION), this.getResString(REQUIRED_OPEN_DIALOG_FILTER), string)) == null) {
            return;
        }
        String string2 = file.getAbsolutePath();
        if ((string2 = string2.trim()) != null && string2.length() > 0) {
            String string3 = file.getName().trim();
            String string4 = this.getFileNameExt(string2);
            string2 = this.mParent.getPESpath(file);
            DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
            int n = defaultListModel.size();
            for (int i = 0; i < n; ++i) {
                String string5 = this.getListItemAt(i);
                String string6 = "";
                String string7 = this.getFileNameExt(string5);
                int n2 = string5.length() - string3.length();
                if (n2 >= 0) {
                    string6 = string5.substring(n2);
                }
                if (string4.equalsIgnoreCase("spd") && string7.equalsIgnoreCase("spd")) {
                    JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_SPD_FILE_DUPLICATION_ERR), BuilderUtil.getInstance().getAppVersionString(), -1, 1);
                    this.mFilesList.clearSelection();
                    this.mFilesList.setSelectedIndex(i);
                    return;
                }
                if (!string3.equalsIgnoreCase(string6)) continue;
                JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_FILE_DUPLICATION_ERR), BuilderUtil.getInstance().getAppVersionString(), -1, 1);
                this.mFilesList.clearSelection();
                this.mFilesList.setSelectedIndex(i);
                return;
            }
            this.addListItemAt(n, string2);
            this.mFilesList.clearSelection();
            this.mFilesList.setSelectedIndex(n);
            this.mParent.enableUIItems();
            this.mModified = true;
        }
    }

    private void processRemoveButton() {
        int n = this.mFilesList.getSelectionModel().getMaxSelectionIndex();
        int n2 = this.mFilesList.getSelectionModel().getMinSelectionIndex();
        boolean bl = true;
        for (int i = n2; i >= 0 && i <= n; ++i) {
            if (!this.mFilesList.getSelectionModel().isSelectedIndex(i)) continue;
            Object e = this.mFilesList.getModel().getElementAt(i);
            boolean bl2 = bl = !this.mParent.isActiveCFEFile(e.toString());
            if (!bl) {
                BuilderAlertPane.showWarningMessageDialog((JComponent)((Object)this), BuilderResUtil.getString("IDS_REMOVE_ACTIVE_DLG_EXT_PROP"), BuilderUtil.getInstance().getAppVersionString());
                continue;
            }
            if (e.toString().endsWith(".cfe") || e.toString().endsWith(".spd")) {
                this.mParent.updateCDBFileList(e.toString(), false);
            }
            this.removeListItemAt(i);
        }
        if (bl) {
            this.mParent.enableUIItems();
            this.mFilesList.clearSelection();
            this.mFilesList.requestFocusInWindow();
            this.mModified = true;
        }
    }

    private void processExtractButton() {
        File file = this.mParent.getFilePath(2, this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_EXTRACT_DIALOG_TITLE"), "", "", "");
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        if ((string = string.trim()) != null && string.length() > 0) {
            DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
            int[] nArray = this.mFilesList.getSelectedIndices();
            if (nArray != null) {
                for (int n : nArray) {
                    this.copyFile(defaultListModel.getElementAt(n).toString(), string);
                }
            }
        }
    }

    private void copyFile(String string, String string2) {
        try {
            int n;
            File file = new File(string);
            if (!file.exists() && string.indexOf(File.separator) < 0) {
                string = this.mParent.getNameDirectory() + File.separator + string;
                file = new File(string);
            }
            String string3 = file.getName();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            string2 = string2 + string3;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.mParent.enableUIItems();
        }
    }

    protected boolean validateTab() {
        boolean bl = false;
        if (super.validateTab() && this.validateNameField() && this.validateFilesListField() && this.validateVersionField()) {
            bl = true;
        }
        return bl;
    }

    private boolean validateNameField() {
        boolean bl = true;
        String string = this.mNameField.getText().trim();
        bl = !this.hasInvalidChar(string);
        String string2 = "";
        if (bl) {
            String[] stringArray = string.split(" ");
            int n = 0;
            for (String string3 : stringArray) {
                if (string3.equals("")) continue;
                string2 = string2 + string3 + " ";
                ++n;
            }
            if (string2.endsWith(" ")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (n > 3) {
                bl = false;
            }
        }
        if (!bl) {
            JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_NAME_THREE_WORDS_LIMIT_ERR), BuilderUtil.getInstance().getAppVersionString(), -1, 1);
            this.mNameField.requestFocusInWindow();
        } else {
            this.mNameField.setText(string2);
        }
        return bl;
    }

    private boolean hasInvalidChar(String string) {
        char[] cArray;
        String string2 = "\"*:/<>?\\|";
        boolean bl = false;
        for (char c : cArray = string.toCharArray()) {
            if (!string2.contains("" + c)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean validateFilesListField() {
        boolean bl = true;
        if (this.mFilesList != null && this.mFilesList.isEnabled()) {
            DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
            defaultListModel.removeListDataListener(this);
            for (int i = 0; i < defaultListModel.size(); ++i) {
                String string = this.getListItemAt(i);
                if (this.mParent.isActiveCFEFile(string)) continue;
                if (string.trim().length() > 0) {
                    string = string.trim();
                    this.setListItemAt(i, string);
                    if (!string.contains(File.separator)) {
                        string = this.mParent.getNameDirectory().getPath() + File.separator + string;
                    }
                    File file = new File(string.trim());
                    if (bl) continue;
                    this.mFilesList.setSelectedIndex(i);
                    this.mFilesList.requestFocusInWindow();
                    BuilderAlertPane.showInformationMessageDialog((Window)((Object)this.mParent), this.getResString(REQUIRED_FILE_NOT_FOUND_MSG), BuilderUtil.getInstance().getAppVersionString());
                    break;
                }
                this.removeListItemAt(i);
                --i;
            }
            defaultListModel.addListDataListener(this);
        }
        if (bl) {
            bl = this.validateFilesListFieldForValidFileTypes();
        }
        return bl;
    }

    private boolean validateFilesListFieldForValidFileTypes() {
        boolean bl = true;
        int n = this.getNumOfFileTypesInList("cfe");
        if (n == 0 && !BuilderUtil.getInstance().isStandalone()) {
            JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_REQUIRED_FILES_ERR), BuilderUtil.getInstance().getAppVersionString(), -1, 1);
            bl = false;
        }
        if (bl) {
            this.copyFileListItemsIntoVectors();
        }
        return bl;
    }

    private void copyFileListItemsIntoVectors() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        int n = defaultListModel.size();
        this.mDialogSpecsVector.clear();
        this.mCommandSpecsVector.clear();
        this.mCodeFilesVector.clear();
        this.mMiscFilesVector.clear();
        this.mAllFilesVector.clear();
        for (int i = 0; i < n; ++i) {
            File file;
            String string;
            String string2;
            String string3 = this.getListItemAt(i);
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS && this.mParent.isActiveCFEFile(string3)) continue;
            if (!string3.contains(File.separator)) {
                string3 = this.mParent.getNameDirectory().getPath() + File.separator + string3;
            }
            if ((string2 = this.getFileNameExt(string = (file = new File(string3)).getName())) != null) {
                if (string2.equalsIgnoreCase("spd") || string2.equalsIgnoreCase("cfe")) {
                    this.mDialogSpecsVector.add(string);
                } else if (string2.equalsIgnoreCase("xml")) {
                    this.mCommandSpecsVector.add(string);
                } else if (string2.equalsIgnoreCase("py") || string2.equalsIgnoreCase("pyc") || string2.equalsIgnoreCase("pyo") || string2.equalsIgnoreCase("R") || string2.equalsIgnoreCase("class") || string2.equalsIgnoreCase("jar")) {
                    this.mCodeFilesVector.add(string);
                } else {
                    this.mMiscFilesVector.add(string);
                }
                this.mAllFilesVector.add(string3);
                continue;
            }
            if (string == null) continue;
            this.mMiscFilesVector.add(string);
            this.mAllFilesVector.add(string3);
        }
    }

    private int getNumOfFileTypesInList(String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        int n = defaultListModel.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = this.getFileNameExt(this.getListItemAt(i));
            if (!string2.equalsIgnoreCase(string)) continue;
            ++n2;
        }
        return n2;
    }

    private boolean validateVersionField() {
        boolean bl = true;
        String string = this.mVersionField.getText().trim();
        String[] stringArray = string.split("\\.");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (String string2 : arrayList) {
            if (!string2.equals("")) continue;
            bl = false;
            break;
        }
        if (bl) {
            if (arrayList.size() > 3 || arrayList.size() == 0) {
                bl = false;
            } else if (arrayList.size() == 1) {
                arrayList.add(1, "0");
                arrayList.add(2, "0");
            } else if (arrayList.size() == 2) {
                arrayList.add(2, "0");
            }
        }
        if (bl) {
            String string3 = (String)arrayList.get(0) + "." + (String)arrayList.get(1) + "." + (String)arrayList.get(2);
            this.mVersionField.setText(string3);
        } else {
            JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_VERSION_ERR), BuilderUtil.getInstance().getAppVersionString(), -1, 1);
            bl = false;
            this.mVersionField.requestFocusInWindow();
        }
        return bl;
    }

    private RemoteFileChooser showFileDialog(boolean bl, String string, String string2, String string3, String string4) {
        RemoteFileChooser remoteFileChooser = bl ? new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, "", false) : new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, string4, false, false, true);
        remoteFileChooser.setDialogTitle(string3);
        remoteFileChooser.setFileSelectionMode(0);
        RefFileFilter refFileFilter = new RefFileFilter(string2, string);
        remoteFileChooser.addChoosableFileFilter(refFileFilter);
        if (bl) {
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            if (string4.trim().length() != 0) {
                remoteFileChooser.setCurrentDirectory(new File(string4));
            }
        } else {
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
        }
        remoteFileChooser.setFileFilter(refFileFilter);
        int n = bl ? remoteFileChooser.showSaveDialog((Component)((Object)this.mParent)) : remoteFileChooser.showOpenDialog((Component)((Object)this.mParent));
        if (n == 0) {
            return remoteFileChooser;
        }
        return null;
    }

    boolean isComplete() {
        boolean bl = false;
        if (BuilderUtil.getInstance().isStandalone() && this.mNameField.getText().length() > 0 && this.mSummaryField.getText().length() > 0 && this.mVersionField.getText().length() > 0 && this.mTargetFilePath.getText().length() > 0) {
            if (this.mFilesList.getModel().getSize() > 0) {
                bl = true;
            }
        } else if (!BuilderUtil.getInstance().isStandalone() && this.mNameField.getText().length() > 0 && this.mSummaryField.getText().length() > 0 && this.mVersionField.getText().length() > 0 && this.mFilesList.getModel().getSize() > 0) {
            bl = true;
        }
        return bl;
    }

    void enableUIItems() {
        this.enableRemoveButton();
        this.enableVersionCombo();
    }

    private boolean enableRemoveButton() {
        boolean bl = this.mFilesList.getSelectedValue() != null;
        this.mRemoveButton.setEnabled(bl);
        this.mExtractButton.setEnabled(bl);
        return bl;
    }

    private boolean enableVersionCombo() {
        boolean bl = true;
        this.mSpssVersionLabel.setEnabled(bl);
        this.mSpssVersionField.setEnabled(bl);
        return bl;
    }

    private class TextFieldListener
    implements DocumentListener {
        private TextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ExtensionPropertyRequiredTab.this.mParent.enableUIItems();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ExtensionPropertyRequiredTab.this.mParent.enableUIItems();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ExtensionPropertyRequiredTab.this.mParent.enableUIItems();
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JCheckBox) {
                ExtensionPropertyRequiredTab.this.mParent.enableUIItems();
            }
        }
    }
}

