/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.extension;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.DefaultListCellEditor;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.FileTextField;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SerializableEditableList;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssButtonGroup;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.TextFieldAction;
import com.spss.shared.custom_gui.ui_builder.extension.ExtensionPropertyDlg;
import com.spss.shared.custom_gui.ui_builder.extension.OptionSidebarSelectorPanel;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.controls.CETextArea;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.BaseSpssTab;
import com.spss.uitools.ui_builder.definition.AppType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExtensionPropertyOptionalTab
extends BaseSpssTab
implements ActionListener,
KeyListener,
ListDataListener,
ListSelectionListener {
    public static final String OPTIONAL_RELEASE_DATE_TEXT_KEY = "IDK_RELEASE_DATE_TEXT";
    public static final String OPTIONAL_AUTHOR_TEXT_KEY = "IDK_AUTHOR_TEXT";
    public static final String OPTIONAL_LINKS_TEXT_KEY = "IDK_LINKS_TEXT";
    public static final String OPTIONAL_KEYWORD_TEXT_KEY = "IDK_KEYWORD_TEXT";
    public static final String OPTIONAL_PLATFORM_TEXT_KEY = "IDK_PLATFORM_TEXT";
    public static final String OPTIONAL_R_PACKAGES_LIST_KEY = "IDK_R_PACKAGES_LIST";
    public static final String OPTIONAL_PYTHON_MODULES_LIST_KEY = "IDK_PYTHON_MODULES_LIST";
    public static final String OPTIONAL_REQUIRED_EXT_LIST_KEY = "IDK_REQUIRED_EXT_LIST";
    public static final String OPTIONAL_CDB_FILE_KEY = "IDS_OPTIONAL_CDB_FILE_LIST";
    public static final String OPTIONAL_TRANSLATION_CATALOGUES_FOLDER_TEXT_KEY = "IDK_TRANSLATION_CATALOGUES_FOLDER_TEXT";
    public static final String OPTIONAL_PYTHON_CHECKBOX_KEY = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PYTHON_CHECKBOX";
    public static final String OPTIONAL_R_CHECKBOX_KEY = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_R_CHECKBOX";
    static final String OPTIONAL_TCF_DIALOG_FILTER = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TCF_DIALOG_FILTER";
    static final String OPTIONAL_TCF_DIALOG_EXTENSION = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TCF_DIALOG_EXTENSION";
    static final String OPTIONAL_TCF_DIALOG_TITLE = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TCF_DIALOG_TITLE";
    private static String LINE_SEPERATOR = System.getProperty("line.separator");
    private OptionSidebarSelectorPanel mSidebarSelector;
    private JPanel mGeneralPanel;
    private JPanel mDepencyPanel;
    private JPanel mLocalizationPanel;
    private JLabel mDescFieldLabel;
    private NoCRLFTextArea mDescField;
    private JScrollPane mDescFieldScrollPane;
    private JLabel mDateLabel;
    private JTextField mDateField;
    private JLabel mAuthorFieldLabel;
    private JTextField mAuthorField;
    private JLabel mLinksLabel;
    private JTextField mLinksField;
    private JLabel mKeywordLabel;
    private JTextField mKeywordField;
    private JLabel mPlatformLabel;
    private JTextField mPlatformField;
    private JLabel mSpssVersionLabel;
    private IntTextField mMaxSpssVersionField;
    private JCheckBox mPythonCheckbox;
    private JCheckBox mRCheckbox;
    private JLabel mRPackagesListLabel;
    private SerializableEditableList mRPackagesList;
    private JScrollPane mRPackagesListScrollPane;
    private JLabel mPythonModulesListLabel;
    private SerializableEditableList mPythonModulesList;
    private JScrollPane mPythonModulesListScrollPane;
    private JPanel mPythonRadioPanel;
    private JRadioButton mPython2Radio;
    private JRadioButton mPython3Radio;
    private JLabel mRequiredExtensionListLabel;
    private SerializableEditableList mRequiredExtensionList;
    private JScrollPane mRequiredExtensionListScrollPane;
    private JLabel mCDBFilesLabel;
    private JList mCDBFilesList;
    private JScrollPane mCDBFilesListScrollPane;
    private JButton mAddTranButton;
    private JLabel mTranslationCataloguesFolderLabel;
    private FileTextField mTranslationCataloguesFolderText;
    private JButton mBrowseButton;
    ExtensionPropertyDlg mParent;
    private Hashtable<String, String> mCFEWithTranFolders;

    public ExtensionPropertyOptionalTab(ExtensionPropertyDlg extensionPropertyDlg, boolean bl) {
        super((BaseDialog)extensionPropertyDlg, false);
        this.mParent = extensionPropertyDlg;
        this.initPanel();
        if (bl) {
            this.setDefaults();
        }
        this.mDateField.requestFocusInWindow();
        this.mCFEWithTranFolders = new Hashtable();
    }

    public String getDialogHelpID() {
        return "idh_optional";
    }

    public void initPanel() {
        super.initPanel();
        this.initVariables();
        this.setupPanel();
        this.enableUIItems();
        this.setFocusTraversalPolicy();
    }

    public boolean isOptionTabModified() {
        boolean bl = this.isGeneralPanelModified();
        if (!bl) {
            bl = this.isDependencyPanelModifed();
        }
        if (!bl) {
            bl = this.isLocalePanelModified();
        }
        return bl;
    }

    private boolean isGeneralPanelModified() {
        return this.mParent.isOptionGenralPanelChanged(this.getDescription(), this.getDate(), this.getAuthor(), this.getLinks(), this.getKeywords(), this.getPlatforms());
    }

    private boolean isDependencyPanelModifed() {
        return this.mParent.isOptionDependencyPanelModified(this.getMaxStatsVersion(), this.isPythonRequired(), this.getPythonVersion(), this.getPythonModuleList(), this.isRRequired(), this.getRequiredExtList(), this.getRequiredExtList());
    }

    private boolean isLocalePanelModified() {
        return this.mParent.isLocalePanelChanged(this.getTranslationCataloguesPath());
    }

    private void initVariables() {
        this.mSidebarSelector = new OptionSidebarSelectorPanel(this.mParent, "ExtensionOption_id", this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_SIDEBAR_LABEL"), 83);
        this.initGeneralPanelVars();
        this.initDependencyPanelVars();
        this.initLocalizationPanelVars();
    }

    private void initGeneralPanelVars() {
        TextFieldListener textFieldListener = new TextFieldListener();
        this.mDateField = new JTextField();
        this.mDateField.getDocument().addDocumentListener(textFieldListener);
        this.mDateField.setAction(new TextFieldAction(this.mParent, OPTIONAL_RELEASE_DATE_TEXT_KEY));
        this.mDateField.setPreferredSize(new Dimension(66, this.mDateField.getMinimumSize().height));
        this.mDateLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_RELEASE_DATE");
        this.mDateLabel.setLabelFor(this.mDateField);
        this.mAuthorField = new JTextField();
        this.mAuthorField.getDocument().addDocumentListener(textFieldListener);
        this.mAuthorField.setAction(new TextFieldAction(this.mParent, OPTIONAL_AUTHOR_TEXT_KEY));
        this.mAuthorField.setPreferredSize(new Dimension(66, this.mAuthorField.getMinimumSize().height));
        this.mAuthorFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_AUTHOR");
        this.mAuthorFieldLabel.setLabelFor(this.mAuthorField);
        this.mDescField = new NoCRLFTextArea();
        this.mDescField.addKeyListener(this);
        this.mDescField.getDocument().addDocumentListener(textFieldListener);
        this.mDescField.setLineWrap(true);
        this.mDescField.setWrapStyleWord(true);
        this.mDescField.setRows(3);
        this.mDescFieldScrollPane = new JScrollPane((Component)((Object)this.mDescField));
        this.mDescFieldScrollPane.setHorizontalScrollBarPolicy(31);
        this.mDescFieldScrollPane.setPreferredSize(new Dimension(325, 50));
        this.mDescFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_DESCRIPTION");
        this.mDescFieldLabel.setLabelFor((Component)((Object)this.mDescField));
        this.mLinksField = new JTextField();
        this.mLinksField.getDocument().addDocumentListener(textFieldListener);
        this.mLinksField.setAction(new TextFieldAction(this.mParent, OPTIONAL_LINKS_TEXT_KEY));
        this.mLinksField.setPreferredSize(new Dimension(325, this.mLinksField.getMinimumSize().height));
        this.mLinksLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_LINKS");
        this.mLinksLabel.setLabelFor(this.mLinksField);
        this.mKeywordField = new JTextField();
        this.mKeywordField.getDocument().addDocumentListener(textFieldListener);
        this.mKeywordField.setAction(new TextFieldAction(this.mParent, OPTIONAL_KEYWORD_TEXT_KEY));
        this.mKeywordField.setPreferredSize(new Dimension(325, this.mKeywordField.getMinimumSize().height));
        this.mKeywordLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_KEYWORD");
        this.mKeywordLabel.setLabelFor(this.mKeywordField);
        this.mPlatformField = new JTextField();
        this.mPlatformField.getDocument().addDocumentListener(textFieldListener);
        this.mPlatformField.setAction(new TextFieldAction(this.mParent, OPTIONAL_PLATFORM_TEXT_KEY));
        this.mPlatformField.setPreferredSize(new Dimension(66, this.mPlatformField.getMinimumSize().height));
        this.mPlatformLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PLATFORM");
        this.mPlatformLabel.setLabelFor(this.mPlatformField);
    }

    private void initDependencyPanelVars() {
        this.mMaxSpssVersionField = new IntTextField(18, Integer.MAX_VALUE, true);
        this.mSpssVersionLabel = BuilderUtil.getInstance().getAppType() == AppType.MODELER ? DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_MODELER_VERSION") : DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_STATISTICS_VERSION");
        this.mSpssVersionLabel.setLabelFor((Component)this.mMaxSpssVersionField);
        this.mPythonCheckbox = DialogUtil.createCheckBox(this.mParent, OPTIONAL_PYTHON_CHECKBOX_KEY, this);
        this.mRCheckbox = DialogUtil.createCheckBox(this.mParent, OPTIONAL_R_CHECKBOX_KEY, this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mPythonCheckbox);
        spssButtonGroup.add(this.mRCheckbox);
        int n = 19;
        int n2 = 8;
        this.mPythonModulesList = new SerializableEditableList(OPTIONAL_PYTHON_MODULES_LIST_KEY);
        DefaultListCellEditor defaultListCellEditor = (DefaultListCellEditor)this.mPythonModulesList.getListCellEditor();
        n = defaultListCellEditor.getComponent().getFont().getSize() + n2;
        this.mPythonModulesList.setFixedCellHeight(n);
        this.mPythonModulesList.addListSelectionListener(this);
        this.mPythonModulesList.addKeyListener(this);
        DefaultListModel defaultListModel = (DefaultListModel)this.mPythonModulesList.getModel();
        defaultListModel.addListDataListener(this);
        this.mPythonModulesListScrollPane = new JScrollPane(this.mPythonModulesList);
        this.mPythonModulesListScrollPane.setPreferredSize(new Dimension(75, 102));
        this.mPythonModulesListScrollPane.getVerticalScrollBar().setEnabled(true);
        this.mPythonModulesListLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PYTHON_MODULES_LIST");
        this.mPythonModulesListLabel.setLabelFor(this.mPythonModulesList);
        this.mRPackagesList = new SerializableEditableList(OPTIONAL_R_PACKAGES_LIST_KEY);
        defaultListCellEditor = (DefaultListCellEditor)this.mRPackagesList.getListCellEditor();
        n = defaultListCellEditor.getComponent().getFont().getSize() + n2;
        this.mRPackagesList.setFixedCellHeight(n);
        this.mRPackagesList.addListSelectionListener(this);
        this.mRPackagesList.addKeyListener(this);
        defaultListModel = (DefaultListModel)this.mRPackagesList.getModel();
        defaultListModel.addListDataListener(this);
        this.mRPackagesListScrollPane = new JScrollPane(this.mRPackagesList);
        this.mRPackagesListScrollPane.setPreferredSize(new Dimension(75, 102));
        this.mRPackagesListScrollPane.getVerticalScrollBar().setEnabled(true);
        this.mRPackagesListLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_R_PACKAGES_LIST");
        this.mRPackagesListLabel.setLabelFor(this.mRPackagesList);
        this.mRequiredExtensionList = new SerializableEditableList(OPTIONAL_REQUIRED_EXT_LIST_KEY);
        defaultListCellEditor = (DefaultListCellEditor)this.mRequiredExtensionList.getListCellEditor();
        n = defaultListCellEditor.getComponent().getFont().getSize() + n2;
        this.mRequiredExtensionList.setFixedCellHeight(n);
        this.mRequiredExtensionList.addListSelectionListener(this);
        this.mRequiredExtensionList.addKeyListener(this);
        defaultListModel = (DefaultListModel)this.mRequiredExtensionList.getModel();
        defaultListModel.addListDataListener(this);
        this.mRequiredExtensionListScrollPane = new JScrollPane(this.mRequiredExtensionList);
        this.mRequiredExtensionListScrollPane.setPreferredSize(new Dimension(75, 102));
        this.mRequiredExtensionListScrollPane.getVerticalScrollBar().setEnabled(true);
        this.mRequiredExtensionListLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_REQUIRED_EXT_LIST");
        this.mRequiredExtensionListLabel.setLabelFor(this.mRequiredExtensionList);
        this.mPythonRadioPanel = new JPanel();
        this.mPython2Radio = DialogUtil.createRadioButton(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PYTHON2", null);
        this.mPython3Radio = DialogUtil.createRadioButton(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PYTHON3", null);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mPython2Radio);
        spssButtonGroup2.add(this.mPython3Radio);
    }

    private void initLocalizationPanelVars() {
        this.mCDBFilesList = new JList(new DefaultListModel());
        this.mCDBFilesList.setSelectionMode(0);
        this.mCDBFilesList.addListSelectionListener(this);
        DefaultListModel defaultListModel = (DefaultListModel)this.mCDBFilesList.getModel();
        defaultListModel.addListDataListener(this);
        this.mCDBFilesListScrollPane = new JScrollPane(this.mCDBFilesList);
        this.mCDBFilesListScrollPane.setMinimumSize(new Dimension(320, 102));
        this.mCDBFilesListScrollPane.setPreferredSize(new Dimension(320, 102));
        this.mCDBFilesListScrollPane.getVerticalScrollBar().setEnabled(true);
        this.mAddTranButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_ADD_TRAN_FILES", this);
        this.mTranslationCataloguesFolderText = new FileTextField();
        this.mTranslationCataloguesFolderText.setColumns(20);
        this.mTranslationCataloguesFolderText.setEditable(false);
        this.mTranslationCataloguesFolderText.setOpaque(false);
        this.mTranslationCataloguesFolderText.setFocusable(false);
        this.mTranslationCataloguesFolderLabel = new JLabel(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TRANSLATION_CATALOGUES_FOLDER"));
        this.mTranslationCataloguesFolderLabel.setLabelFor((Component)((Object)this.mTranslationCataloguesFolderText));
        this.mBrowseButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_BROWSE", this);
    }

    private void setupPanel() {
        this.setupGeneralPanel();
        this.setupDependencyPanel();
        this.setupLocalizationPanel();
        this.mSidebarSelector.addPanel(this.mGeneralPanel, this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_GENERAL_TITLE"));
        this.mSidebarSelector.addPanel(this.mDepencyPanel, this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_DEPENDENCY_TITLE"));
        this.mSidebarSelector.addPanel(this.mLocalizationPanel, this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_LOCALIZATION_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, n2 * 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, n2, 2, 0);
        DialogUtil.addUsingGBL((Container)((Object)this), this.mSidebarSelector, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setDefaults();
    }

    private void setupGeneralPanel() {
        this.mGeneralPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, n2, n2, insets.right);
        Insets insets3 = new Insets(0, insets.left, n2, n2);
        this.mGeneralPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_INFORMATIONAL_FIELDS")));
        this.mGeneralPanel.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mDescFieldLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mDescFieldScrollPane, gridBagConstraints, 1, 0, 3, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mDateLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mDateField, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mAuthorFieldLabel, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mAuthorField, gridBagConstraints, 3, 1, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mLinksLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mLinksField, gridBagConstraints, 1, 2, 3, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mKeywordLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mKeywordField, gridBagConstraints, 1, 3, 3, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mPlatformLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mGeneralPanel, this.mPlatformField, gridBagConstraints, 1, 4, 3, 1, n, insets3);
    }

    private void setupDependencyPanel() {
        this.mDepencyPanel = new JPanel();
        this.mDepencyPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        this.mPythonRadioPanel = new JPanel();
        this.mPythonRadioPanel.setLayout(new GridBagLayout());
        this.mPythonRadioPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PYTHON_TITLE")));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mPythonRadioPanel, this.mPython2Radio, gridBagConstraints, 0, 0, 1, 1, n, new Insets(n2 * 2, 0, insets.bottom, n2));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mPythonRadioPanel, this.mPython3Radio, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, 0, insets.bottom, n2));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mPythonRadioPanel, new JPanel(), gridBagConstraints, 1, 0, 1, 2, n, new Insets(0, 0, insets.bottom, n2));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PLUG_INS")));
            DialogUtil.addUsingGBL(jPanel, this.mPythonCheckbox, gridBagConstraints, 0, 0, 2, 1, n, new Insets(0, 2, insets.bottom, n2));
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.4;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mPythonRadioPanel, gridBagConstraints, 0, 1, 1, 2, n, new Insets(3, n2 * 3, insets.bottom, n2));
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mPythonModulesListLabel, gridBagConstraints, 1, 1, 1, 1, n, new Insets(0, n2 * 2, insets.bottom, n2));
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.6;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mPythonModulesListScrollPane, gridBagConstraints, 1, 2, 1, 1, n, new Insets(0, n2 * 2, n2, n2));
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mRCheckbox, gridBagConstraints, 0, 3, 2, 1, n, new Insets(n2, 2, insets.bottom, n2));
        DialogUtil.addUsingGBL(jPanel, this.mRPackagesListLabel, gridBagConstraints, 0, 4, 1, 1, n, new Insets(3, n2 * 3, insets.bottom, n2 * 3));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mRPackagesListScrollPane, gridBagConstraints, 0, 5, 1, 1, n, new Insets(0, n2 * 3, n2, n2 * 3));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.mSpssVersionLabel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, n2, insets.bottom, n2));
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mMaxSpssVersionField, gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, n2, insets.bottom, n2));
        DialogUtil.addUsingGBL(this.mDepencyPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, n2, insets.bottom, 0));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mDepencyPanel, jPanel, gridBagConstraints, 0, 1, 2, 1, n, new Insets(0, n2, n2, n2 * 3));
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(this.mDepencyPanel, this.mRequiredExtensionListLabel, gridBagConstraints, 0, 2, 1, 1, n, new Insets(n2, n2, 0, n2));
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.2;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(this.mDepencyPanel, this.mRequiredExtensionListScrollPane, gridBagConstraints, 0, 3, 1, 1, n, new Insets(0, n2, n2, n2));
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mDepencyPanel, new JPanel(), gridBagConstraints, 1, 2, 1, 2, n, new Insets(0, n2, n2, n2 * 3));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mDepencyPanel, new JPanel(), gridBagConstraints, 0, 4, 2, 1, n, new Insets(0, n2, n2, n2 * 3));
    }

    private void setupLocalizationPanel() {
        this.mLocalizationPanel = new JPanel();
        this.mLocalizationPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 2, n3, n3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_CDB_FILES_MODELER")));
        } else {
            jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_CDB_FILES")));
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 2, n3 * 2, 2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mCDBFilesListScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, 2, n3 * 2, n3 * 6);
        DialogUtil.addUsingGBL(jPanel, this.mAddTranButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, n3, 2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mLocalizationPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3 * 3, 0, n3, n3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mLocalizationPanel, this.setupTranslationCataloguesFolderPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setupTranslationCataloguesFolderPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_EXTENSION_FILES")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(n, 0, n * 2, insets.right);
        Insets insets3 = new Insets(n, 0, n * 2, n);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        int n2 = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTranslationCataloguesFolderLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        n2 = 25;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTranslationCataloguesFolderText), gridBagConstraints, 1, 0, 1, 1, n2, insets3);
        n2 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        insets2.set(n, 0, n * 2, n);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        this.addToComponentOrder(this.mDateField);
        this.addToComponentOrder(this.mLinksField);
        this.addToComponentOrder(this.mKeywordField);
        this.addToComponentOrder(this.mPythonCheckbox);
        this.addToComponentOrder(this.mRCheckbox);
        this.addToComponentOrder(this.mRPackagesList);
        this.addToComponentOrder(this.mPythonModulesList);
        this.addToComponentOrder(this.mBrowseButton);
        this.addAllToComponentOrder(new Vector<Component>(Arrays.asList(this.mParent.getCmdButtonPanel().getComponents())));
    }

    public void aboutToShowTab() {
        this.mParent.preloadOptionTab();
    }

    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public void setDefaults() {
        this.mDateField.setText("");
        this.mLinksField.setText("");
        this.mKeywordField.setText("");
        this.mPythonCheckbox.setSelected(false);
        this.mRCheckbox.setSelected(false);
        ((DefaultListModel)this.mRPackagesList.getModel()).clear();
        this.addListItemAt(this.mRPackagesList, 0, "");
        ((DefaultListModel)this.mPythonModulesList.getModel()).clear();
        this.addListItemAt(this.mPythonModulesList, 0, "");
        ((DefaultListModel)this.mRequiredExtensionList.getModel()).clear();
        this.addListItemAt(this.mRequiredExtensionList, 0, "");
        this.mPython2Radio.setSelected(true);
        this.setPythonAndRSelectionDefaults();
        this.mTranslationCataloguesFolderText.setText("");
        this.setInitialized(true);
        this.enableAddTranButton();
        this.enablePythonControls();
        this.enalbleRControls();
    }

    public void setPythonAndRSelectionDefaults() {
        this.mRPackagesList.setSelectedIndex(0);
        this.mPythonModulesList.setSelectedIndex(0);
        this.mRequiredExtensionList.setSelectedIndex(0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mRPackagesList.getModel()) {
            this.removeOrTrimListItem(this.mRPackagesList, listDataEvent.getIndex0());
        } else if (listDataEvent.getSource() == this.mPythonModulesList.getModel()) {
            this.removeOrTrimListItem(this.mPythonModulesList, listDataEvent.getIndex0());
        } else if (listDataEvent.getSource() == this.mRequiredExtensionList.getModel()) {
            this.removeOrTrimListItem(this.mRequiredExtensionList, listDataEvent.getIndex0());
        }
    }

    public void setDescField(String string) {
        this.mDescField.setText(string);
    }

    public void setDateField(String string) {
        this.mDateField.setText(string);
    }

    public void setAuthorField(String string) {
        this.mAuthorField.setText(string);
    }

    public void setLinksField(String string) {
        this.mLinksField.setText(string);
    }

    public void setKeywordField(String string) {
        this.mKeywordField.setText(string);
    }

    public void setPlatformField(String string) {
        this.mPlatformField.setText(string);
    }

    public void setMaxSpssVersionField(String string) {
        this.mMaxSpssVersionField.setText(string);
    }

    public void setPythonCheckbox(boolean bl) {
        this.mPythonCheckbox.setSelected(bl);
        this.enablePythonControls();
    }

    public void setRCheckbox(boolean bl) {
        this.mRCheckbox.setSelected(bl);
        this.enalbleRControls();
    }

    public void setRPackagesList(Set<String> set) {
        if (set == null) {
            return;
        }
        Iterator<String> iterator = set.iterator();
        this.mRPackagesList.removeAll();
        while (iterator.hasNext()) {
            this.addListItemAt(this.mRPackagesList, -1, iterator.next());
        }
    }

    public void setPythonModulesList(Set<String> set) {
        if (set == null) {
            return;
        }
        this.mPythonModulesList.removeAll();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            this.addListItemAt(this.mPythonModulesList, -1, iterator.next());
        }
    }

    public void setPythonVersion(String string) {
        if (string == null) {
            return;
        }
        if (string.endsWith("3")) {
            this.mPython3Radio.setSelected(true);
        } else {
            this.mPython2Radio.setSelected(true);
        }
    }

    public void setRequiredExtensionList(Set<String> set) {
        if (set == null) {
            return;
        }
        Iterator<String> iterator = set.iterator();
        this.mRequiredExtensionList.removeAll();
        while (iterator.hasNext()) {
            this.addListItemAt(this.mRequiredExtensionList, -1, iterator.next());
        }
    }

    public void setTranslationCataloguesFolderText(String string) {
        this.mTranslationCataloguesFolderText.setText(string);
    }

    String getDescription() {
        return this.mDescField.getText();
    }

    String getDate() {
        return this.mDateField.getText();
    }

    String getAuthor() {
        return this.mAuthorField.getText();
    }

    String getLinks() {
        return this.mLinksField.getText();
    }

    String getKeywords() {
        return this.mKeywordField.getText();
    }

    String getPlatforms() {
        return this.mPlatformField.getText();
    }

    String getMaxStatsVersion() {
        return this.mMaxSpssVersionField.getText();
    }

    boolean isPythonRequired() {
        return this.mPythonCheckbox.isSelected();
    }

    String getPythonVersion() {
        if (this.isPythonRequired()) {
            if (this.mPython2Radio.isSelected()) {
                return "2";
            }
            return "3";
        }
        return "";
    }

    SerializableEditableList getPythonModuleList() {
        return this.mPythonModulesList;
    }

    JList getCDBFileList() {
        return this.mCDBFilesList;
    }

    String getCDBFileTransFolder(String string) {
        return this.mCFEWithTranFolders.get(string);
    }

    Vector<String> getModulesListContent(SerializableEditableList serializableEditableList) {
        Vector<String> vector = new Vector<String>();
        DefaultListModel defaultListModel = (DefaultListModel)serializableEditableList.getModel();
        int n = defaultListModel.size() - 1;
        for (int i = 0; i < n; ++i) {
            vector.add(this.getListItemAt(serializableEditableList, i));
        }
        return vector;
    }

    boolean isRRequired() {
        return this.mRCheckbox.isSelected();
    }

    SerializableEditableList getRModuleList() {
        return this.mRPackagesList;
    }

    SerializableEditableList getRequiredExtList() {
        return this.mRequiredExtensionList;
    }

    public String getTranslationCataloguesPath() {
        return this.mTranslationCataloguesFolderText.getText();
    }

    public FileTextField getTranslationCatalogues() {
        return this.mTranslationCataloguesFolderText;
    }

    private void removeOrTrimListItem(SerializableEditableList serializableEditableList, int n) {
        boolean bl = false;
        DefaultListModel defaultListModel = (DefaultListModel)serializableEditableList.getModel();
        defaultListModel.removeListDataListener(this);
        String string = this.getListItemAt(serializableEditableList, n);
        if (string.trim().length() == 0) {
            this.removeListItemAt(serializableEditableList, n);
            bl = true;
        } else {
            this.setListItemAt(serializableEditableList, n, string.trim());
        }
        this.maybeAppendEmptyItemToList(serializableEditableList, defaultListModel);
        if (bl) {
            serializableEditableList.setSelectedIndex(n);
        }
        defaultListModel.addListDataListener(this);
    }

    private void removeListItemAt(JList jList, int n) {
        ((DefaultListModel)jList.getModel()).removeElementAt(n);
    }

    public void removeListItem(JList jList, Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        int n = defaultListModel.indexOf(object);
        if (n >= 0) {
            ((DefaultListModel)jList.getModel()).removeElementAt(n);
            if (jList == this.mCDBFilesList) {
                this.mCFEWithTranFolders.remove(object);
            }
        }
    }

    private String getListItemAt(JList jList, int n) {
        return jList.getModel().getElementAt(n).toString();
    }

    public void addListItemAt(JList jList, int n, String string) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        if (n < 0) {
            if (defaultListModel.getSize() == 1 && defaultListModel.getElementAt(0).toString().length() == 0) {
                n = 0;
            } else {
                n = defaultListModel.getSize();
                if (defaultListModel.getElementAt(n - 1).toString().length() == 0) {
                    --n;
                }
            }
        }
        defaultListModel.add(n, string);
    }

    private void setListItemAt(JList jList, int n, String string) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        defaultListModel.setElementAt(string, n);
    }

    private void deleteItemInList(SerializableEditableList serializableEditableList, KeyEvent keyEvent) {
        int n = serializableEditableList.getSelectedIndex();
        if (n >= 0) {
            DefaultListModel defaultListModel = (DefaultListModel)serializableEditableList.getModel();
            defaultListModel.removeListDataListener(this);
            this.removeListItemAt(serializableEditableList, n);
            this.maybeAppendEmptyItemToList(serializableEditableList, defaultListModel);
            serializableEditableList.setSelectedIndex(n);
            defaultListModel.addListDataListener(this);
            keyEvent.consume();
        }
    }

    private void maybeAppendEmptyItemToList(SerializableEditableList serializableEditableList, DefaultListModel defaultListModel) {
        boolean bl = true;
        for (int i = 0; i < defaultListModel.size(); ++i) {
            String string = this.getListItemAt(serializableEditableList, i);
            if (string.trim().length() != 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.addListItemAt(serializableEditableList, defaultListModel.size(), "");
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mRPackagesList && keyEvent.getKeyChar() == '\u007f') {
            this.deleteItemInList(this.mRPackagesList, keyEvent);
        } else if (keyEvent.getSource() == this.mPythonModulesList && keyEvent.getKeyChar() == '\u007f') {
            this.deleteItemInList(this.mPythonModulesList, keyEvent);
        } else if (keyEvent.getSource() == this.mRequiredExtensionList && keyEvent.getKeyChar() == '\u007f') {
            this.deleteItemInList(this.mRequiredExtensionList, keyEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mBrowseButton) {
            this.processBrowseButton();
        } else if (object == this.mAddTranButton) {
            this.processAddTranButton();
        } else if (object == this.mPythonCheckbox) {
            this.enablePythonControls();
        } else if (object == this.mRCheckbox) {
            this.enalbleRControls();
        }
    }

    private void processBrowseButton() {
        File file = this.mParent.getFilePath(2, this.getResString(OPTIONAL_TCF_DIALOG_TITLE), "", "", "");
        if (file != null) {
            String string = file.getAbsolutePath();
            String string2 = string.toLowerCase();
            int n = string2.indexOf(this.getResString(OPTIONAL_TCF_DIALOG_EXTENSION));
            if (n == -1) {
                string = string.concat(this.getResString(OPTIONAL_TCF_DIALOG_EXTENSION));
            } else if (string2.substring(n).compareToIgnoreCase(this.getResString(OPTIONAL_TCF_DIALOG_EXTENSION)) != 0) {
                string = string.concat(this.getResString(OPTIONAL_TCF_DIALOG_EXTENSION));
            }
            this.mTranslationCataloguesFolderText.setText(string);
        }
    }

    private void enablePythonControls() {
        boolean bl = this.mPythonCheckbox.isSelected();
        this.mPython2Radio.setEnabled(bl);
        this.mPython3Radio.setEnabled(bl);
        this.mPythonModulesListLabel.setEnabled(bl);
        this.mPythonModulesList.setEnabled(bl);
    }

    private void enalbleRControls() {
        boolean bl = this.mRCheckbox.isSelected();
        this.mRPackagesListLabel.setEnabled(bl);
        this.mRPackagesList.setEnabled(bl);
    }

    private void processAddTranButton() {
        File file = this.mParent.getFilePath(2, this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_ADD_TRAN_TITLE"), "", "", "");
        if (file == null) {
            return;
        }
        String string = this.mCDBFilesList.getSelectedValue().toString();
        if (string.indexOf(File.separator) >= 0) {
            string = new File(string).getName();
        }
        if (string.endsWith(".cfe")) {
            string = string.substring(0, string.length() - 4);
        }
        String string2 = file.getAbsolutePath();
        string2 = string2.trim();
        File file2 = new File(string2);
        File[] fileArray = file2.listFiles();
        boolean bl = false;
        for (int i = 0; i < fileArray.length; ++i) {
            String string3;
            File file3 = fileArray[i];
            if (!file3.isFile() || !file3.exists() || !BuilderFrame.isValidResFile(string3 = file3.getName(), string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.mCFEWithTranFolders.put(this.mCDBFilesList.getSelectedValue().toString(), string2);
        } else {
            BuilderAlertPane.showWarningMessageDialog((JComponent)((Object)this), BuilderResUtil.getString("IDS_NO_TRANSLATION_FILE_WARNING"), BuilderUtil.getInstance().getAppVersionString());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.enableUIItems();
        } else if (listSelectionEvent.getSource() == this.mCDBFilesList) {
            this.enableAddTranButton();
        }
    }

    protected boolean validateTab() {
        return true;
    }

    boolean isComplete() {
        boolean bl = false;
        if (this.mTranslationCataloguesFolderText.getText().length() > 0) {
            bl = true;
        }
        return bl;
    }

    void enableUIItems() {
    }

    void enableAddTranButton() {
        boolean bl = this.mCDBFilesList.getSelectedIndex() >= 0;
        this.mAddTranButton.setEnabled(bl);
    }

    String buildKeyValuePairsFromList(String string, SerializableEditableList serializableEditableList) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("");
        DefaultListModel defaultListModel = (DefaultListModel)serializableEditableList.getModel();
        int n = defaultListModel.size() - 1;
        if (n > 0) {
            if (string.length() > 0) {
                stringBuffer.append(string).append(": ");
            }
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.getListItemAt(serializableEditableList, i)).append(",");
            }
            stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        return (string2 = stringBuffer.toString()).equals("") ? null : string2;
    }

    public class NoCRLFTextArea
    extends CETextArea {
        public void paste() {
            super.paste();
            String string = this.getText();
            string = string.replaceAll(LINE_SEPERATOR, " ");
            if (string.contains("\n")) {
                string = string.replaceAll("\n", " ");
            } else if (string.contains("\r")) {
                string = string.replaceAll("\r", " ");
            }
            this.setText(string);
        }
    }

    private class TextFieldListener
    implements DocumentListener {
        private TextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ExtensionPropertyOptionalTab.this.mParent.enableUIItems();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ExtensionPropertyOptionalTab.this.mParent.enableUIItems();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ExtensionPropertyOptionalTab.this.mParent.enableUIItems();
        }
    }
}

