/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.extension;

import com.spss.shared.custom_gui.ui_builder.BaseDialogExecutor;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SerializableEditableList;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RefFileFilter;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RemoteFileChooser;
import com.spss.shared.custom_gui.ui_builder.app.fopen.SpssFile;
import com.spss.shared.custom_gui.ui_builder.extension.ExtensionPropertyContainer;
import com.spss.shared.custom_gui.ui_builder.extension.ExtensionPropertyOptionalTab;
import com.spss.shared.custom_gui.ui_builder.extension.ExtensionPropertyRequiredTab;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.BaseSpssTab;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.definition.AppType;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExtensionPropertyDlg
extends BaseDialog
implements ChangeListener {
    public static final String NAME_KEY = "Name";
    public static final String DIALOG_SPECS_KEY = "Dialog-Specs";
    public static final String COMMAND_SPECS_KEY = "Command-Specs";
    public static final String CODE_FILES_KEY = "Code-Files";
    public static final String MISC_FILES_KEY = "Misc-Files";
    public static final String SUMMARY_KEY = "Summary";
    public static final String DESCRIPTION_KEY = "Description";
    public static final String AUTHOR_KEY = "Author";
    public static final String VERSION_KEY = "Version";
    public static final String PRODUCT_VERSION_KEY = "Product-Version";
    public static final String PRODUCT_VERSION_MAX_KEY = "Product-Version-Maximum";
    public static final String DATE_KEY = "Date";
    public static final String LINKS_KEY = "Links";
    public static final String CATEGORIES_KEY = "Categories";
    public static final String PLATFORM_KEY = "Platforms";
    public static final String PLUGINS_KEY = "Plugins";
    public static final String R_PACKAGES_KEY = "R-Packages";
    public static final String PYTHON_VERSION_KEY = "Python-Version";
    public static final String PYTHON_MODULES_KEY = "Python-Modules";
    public static final String EXTENSION_BUNDULES_KEY = "Extension-Bundles";
    public static final String TRANSLATION_CATALOGUES_KEY = "Translation-Catalogues";
    static final String EDIT_READING_SPE_MSG = "ERR_EDIT_EXTENSION_BUNDLE_READING_SPE_MSG";
    static final String EDIT_SAVING_SPE_TOO_TEMP_LOC_MSG = "ERR_EDIT_EXTENSION_BUNDLE_SAVING_SPE_TOO_TEMP_LOC_MSG";
    private JTabbedPane mTabbedPane;
    private ExtensionPropertyRequiredTab mRequiredTab;
    private ExtensionPropertyOptionalTab mOptionalTab;
    private JButton mContinueButton;
    private JButton mCancelButton;
    private boolean bHaveWrittenTranslationCataloguesRelPath = false;
    private File mNameDirectory = null;
    private ExtensionPropertyContainer mContainerHelper;
    private Boolean mContinuePressed = false;
    private BuilderFrame mFrame;
    private JFrame mSpssFrame;
    private String mActiveCFEFile;
    private BaseDialogExecutor mDialogExecutor;

    public ExtensionPropertyDlg(JFrame jFrame, ExtensionPropertyContainer extensionPropertyContainer, String string, boolean bl) {
        super(jFrame, BuilderResUtil.getString("IDS_EXTENSION_BUNDLE_TITLE"), true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.mFrame = (BuilderFrame)jFrame;
        this.mActiveCFEFile = string;
        this.mContinuePressed = false;
        this.pack();
        this.setLocationRelativeTo(jFrame);
        if (extensionPropertyContainer == null) {
            this.mContainerHelper = new ExtensionPropertyContainer();
        } else {
            this.mContainerHelper = extensionPropertyContainer;
            this.mNameDirectory = this.mContainerHelper.getTempNameDirectory();
            this.initDialog();
        }
        if (bl) {
            this.mRequiredTab.addListItemAt(-1, this.mActiveCFEFile);
        }
        this.enableContinueButton();
    }

    public ExtensionPropertyDlg(JFrame jFrame, ExtensionPropertyContainer extensionPropertyContainer, BaseDialogExecutor baseDialogExecutor) {
        this(null, extensionPropertyContainer, "", false);
        this.mDialogExecutor = baseDialogExecutor;
        this.mSpssFrame = jFrame;
    }

    File getFilePath(int n, String string, String string2, String string3, String string4) {
        RemoteFileChooser remoteFileChooser;
        if (this.mFrame != null && this.mFrame.getDlgExecutor() != null) {
            return this.mFrame.getDlgExecutor().getFilePath(n, this, string, string2, string3, string4);
        }
        if (this.mDialogExecutor != null) {
            return this.mDialogExecutor.getFilePath(n, this, string, string2, string3, string4);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (n == RemoteFileChooser.ChooserType.SaveFile.ordinal()) {
            remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, string4, false);
            bl = true;
        } else if (n == RemoteFileChooser.ChooserType.OpenFile.ordinal()) {
            remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, string4, false, false, true);
            bl2 = true;
        } else if (n == RemoteFileChooser.ChooserType.OpenFolder.ordinal()) {
            remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.Generic, string4, true);
        } else {
            return null;
        }
        remoteFileChooser.setDialogTitle(string);
        if (bl || bl2) {
            remoteFileChooser.setFileSelectionMode(0);
            RefFileFilter refFileFilter = new RefFileFilter(string3, string2);
            remoteFileChooser.addChoosableFileFilter(refFileFilter);
            if (bl) {
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                if (string4.trim().length() != 0) {
                    remoteFileChooser.setCurrentDirectory(new File(string4));
                }
            } else {
                remoteFileChooser.setAcceptAllFileFilterUsed(true);
            }
            remoteFileChooser.setFileFilter(refFileFilter);
        } else {
            remoteFileChooser.setSelectedFile(remoteFileChooser.getCurrentDirectory());
        }
        int n2 = bl ? remoteFileChooser.showSaveDialog(this.mFrame) : remoteFileChooser.showOpenDialog(this.mFrame);
        if (n2 == 0) {
            return remoteFileChooser.getSelectedFile();
        }
        return null;
    }

    String getPESpath(File file) {
        if (this.mFrame != null && this.mFrame.getDlgExecutor() != null) {
            return this.mFrame.getDlgExecutor().getPESPath(file);
        }
        if (this.mDialogExecutor != null) {
            return this.mDialogExecutor.getPESPath(file);
        }
        return file.getAbsolutePath().trim();
    }

    void setBuilderModified(boolean bl) {
        if (this.mFrame != null) {
            this.mFrame.setModified(bl);
        }
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.setupTabbedPane(jPanel);
        for (int i = 0; i < this.mTabbedPane.getTabCount(); ++i) {
            this.mTabbedPane.setSelectedIndex(i);
        }
        this.mTabbedPane.setSelectedIndex(0);
        this.pack();
    }

    public void dispose() {
        super.dispose();
    }

    private void setTabPolicy() {
        Vector vector = new Vector();
    }

    public void doHelp() {
        BaseSpssTab baseSpssTab = (BaseSpssTab)this.mTabbedPane.getSelectedComponent();
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, baseSpssTab.getDialogHelpID());
        } else {
            BuilderUtil.getInstance().showHelp("spss/base/" + baseSpssTab.getDialogHelpID());
        }
    }

    boolean isActiveCFEFile(String string) {
        return string.equals(this.mActiveCFEFile);
    }

    public boolean continuePressed() {
        return this.mContinuePressed;
    }

    public void initDialog() {
        if (this.mContainerHelper != null && this.mContainerHelper.isSpeFileOK()) {
            this.preloadRequiredTab();
            this.preloadOptionTab();
        }
    }

    public void preloadRequiredTab() {
        if (this.mRequiredTab == null || this.mContainerHelper == null) {
            return;
        }
        String string = this.mContainerHelper.getName();
        if (string != null) {
            this.mRequiredTab.setNameField(string);
        }
        if ((string = this.mContainerHelper.getSummary()) != null) {
            this.mRequiredTab.setSummaryField(string);
        }
        if ((string = this.mContainerHelper.getVersion()) != null) {
            this.mRequiredTab.setVersionField(string);
        }
        if ((string = this.mContainerHelper.getStatsVersion()) != null) {
            this.mRequiredTab.setSpssVersionField(string);
        }
        if (BuilderUtil.getInstance().isStandalone() && (string = this.mContainerHelper.getTargetFilePath()) != null) {
            this.mRequiredTab.setTargetFilePath(string);
        }
        Set<String> set = this.mContainerHelper.getAllFileWithPath();
        this.mRequiredTab.setFilesList(set);
    }

    public void preloadOptionTab() {
        if (this.mOptionalTab == null || this.mContainerHelper == null) {
            return;
        }
        String string = this.mContainerHelper.getDescription();
        if (string != null) {
            this.mOptionalTab.setDescField(string);
        }
        if ((string = this.mContainerHelper.getAuthor()) != null) {
            this.mOptionalTab.setAuthorField(string);
        }
        if ((string = this.mContainerHelper.getReleaseDate()) != null) {
            this.mOptionalTab.setDateField(string);
        }
        if ((string = this.mContainerHelper.getLinks()) != null) {
            this.mOptionalTab.setLinksField(string);
        }
        if ((string = this.mContainerHelper.getPlatforms()) != null) {
            this.mOptionalTab.setPlatformField(string);
        }
        if ((string = this.mContainerHelper.getKeywords()) != null) {
            this.mOptionalTab.setKeywordField(string);
        }
        if ((string = this.mContainerHelper.getMaxStatsVersion()) != null) {
            this.mOptionalTab.setMaxSpssVersionField(string);
        }
        boolean bl = this.mContainerHelper.requiresPython();
        this.mOptionalTab.setPythonCheckbox(bl);
        string = this.mContainerHelper.getPythonVersion();
        if (string != null) {
            this.mOptionalTab.setPythonVersion(string);
        }
        this.mOptionalTab.setPythonModulesList(this.mContainerHelper.getPythonModulesSet());
        this.mOptionalTab.setRCheckbox(this.mContainerHelper.requiresR());
        this.mOptionalTab.setRPackagesList(this.mContainerHelper.getRLocationSet());
        this.mOptionalTab.setRequiredExtensionList(this.mContainerHelper.getRequiredExtensions());
        string = this.mContainerHelper.getTranslationCataloguesPath();
        if (string != null) {
            this.mOptionalTab.setTranslationCataloguesFolderText(string);
        }
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mContinueButton = BuilderUtil.getInstance().isStandalone() ? new JButton(new OkAction()) : new JButton(new ContinueAction());
        this.mContinueButton.setEnabled(false);
        this.mCancelButton = new JButton(new CancelAction());
        JButton jButton = new JButton((Action)this.createHelpAction());
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                DialogUtil.setupMacHelpButton(jButton);
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mContinueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mContinueButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(jButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mContinueButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mContinueButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    void enableUIItems() {
        if (this.mRequiredTab != null) {
            this.mRequiredTab.enableUIItems();
        }
        if (this.mOptionalTab != null) {
            this.mOptionalTab.enableUIItems();
        }
        this.enableContinueButton();
    }

    private boolean enableContinueButton() {
        boolean bl = this.mRequiredTab.isComplete();
        this.mContinueButton.setEnabled(bl);
        return bl;
    }

    private void setupTabbedPane(JPanel jPanel) {
        this.mTabbedPane = new JTabbedPane();
        this.mTabbedPane.setFocusable(true);
        this.mTabbedPane.addChangeListener(this);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ExtensionPropertyDlg.this.mTabbedPane.repaint();
            }
        };
        this.mTabbedPane.addFocusListener(focusAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ExtensionPropertyDlg.this.mTabbedPane.requestFocusInWindow();
            }
        };
        this.mTabbedPane.addMouseListener(mouseAdapter);
        this.mTabbedPane.setTabLayoutPolicy(0);
        this.mRequiredTab = new ExtensionPropertyRequiredTab(this, false);
        this.mRequiredTab.setDefaults();
        this.mTabbedPane.addTab(this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_TITLE"), (Component)((Object)this.mRequiredTab));
        this.mOptionalTab = new ExtensionPropertyOptionalTab(this, true);
        this.mOptionalTab.setDefaults();
        this.mTabbedPane.addTab(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TITLE"), (Component)((Object)this.mOptionalTab));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    public void updateCDBFileList(String string, boolean bl) {
        JList jList = this.mOptionalTab.getCDBFileList();
        int n = jList.getModel().getSize() - 1;
        if (n < 1) {
            n = 0;
        }
        if (bl) {
            this.mOptionalTab.addListItemAt(jList, n, string);
        } else {
            this.mOptionalTab.removeListItem(jList, string);
        }
    }

    boolean isBundleNameChanged(String string) {
        return !this.mContainerHelper.getName().equals(string);
    }

    boolean isSummaryChanged(String string) {
        return !this.mContainerHelper.getSummary().equals(string);
    }

    boolean isVersionChanged(String string) {
        return !this.mContainerHelper.getVersion().equals(string);
    }

    boolean isMinStatsVersionChanged(String string) {
        return !this.mContainerHelper.getStatsVersion().equals(string);
    }

    boolean isOptionGenralPanelChanged(String string, String string2, String string3, String string4, String string5, String string6) {
        return !this.mContainerHelper.getDescription().equals(string) || !this.mContainerHelper.getReleaseDate().equals(string2) || !this.mContainerHelper.getAuthor().equals(string3) || !this.mContainerHelper.getLinks().equals(string4) || !this.mContainerHelper.getKeywords().equals(string5) || !this.mContainerHelper.getPlatforms().equals(string6);
    }

    boolean isOptionDependencyPanelModified(String string, boolean bl, String string2, SerializableEditableList serializableEditableList, boolean bl2, SerializableEditableList serializableEditableList2, SerializableEditableList serializableEditableList3) {
        boolean bl3;
        boolean bl4 = bl3 = !this.mContainerHelper.getMaxStatsVersion().equals(string);
        if (!bl3) {
            bl3 = !bl && !this.mContainerHelper.requiresPython() ? false : (bl && this.mContainerHelper.requiresPython() ? !this.mContainerHelper.getPythonVersion().equals(string2) || this.isListChanged(this.mContainerHelper.getPythonModulesSet(), serializableEditableList) : true);
        }
        if (!bl3) {
            bl3 = !bl2 && !this.mContainerHelper.requiresR() ? false : (bl2 && this.mContainerHelper.requiresR() ? this.isListChanged(this.mContainerHelper.getRLocationSet(), serializableEditableList2) : true);
        }
        if (!bl3) {
            bl3 = this.isListChanged(this.mContainerHelper.getRequiredExtensions(), serializableEditableList3);
        }
        return bl3;
    }

    boolean isLocalePanelChanged(String string) {
        boolean bl;
        boolean bl2 = bl = !this.mContainerHelper.getTranslationCataloguesPath().equals(string);
        if (!bl) {
            Vector<String> vector = this.mRequiredTab.getDialogSpecs();
            for (String string2 : vector) {
                String string3 = this.mOptionalTab.getCDBFileTransFolder(string2);
                String string4 = this.mContainerHelper.getCDBTranfolder(string2);
                bl = string3 != null && string4.length() > 0 ? !string3.equals(string4) : string3 != null || string4.length() != 0;
                if (!bl) continue;
                return bl;
            }
        }
        return bl;
    }

    private boolean isListChanged(Set<String> set, SerializableEditableList serializableEditableList) {
        boolean bl = false;
        if (set == null || set.size() == 0) {
            return serializableEditableList.getModel().getSize() > 1;
        }
        if (set.size() > 0 && serializableEditableList.getModel().getSize() <= 1) {
            return true;
        }
        if (set.size() != serializableEditableList.getModel().getSize() - 1) {
            return true;
        }
        Object[] objectArray = set.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].toString().equals(serializableEditableList.getModel().getElementAt(i))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void updatePropertyContainer() {
        boolean bl;
        boolean bl2 = bl = this.mRequiredTab.isTabModified() || this.mOptionalTab.isOptionTabModified();
        if (bl && this.mFrame != null) {
            this.mContainerHelper.setModified(true);
        }
        this.updateRequiredFields();
        this.updateOptionalFields();
        File file = this.mContainerHelper.getSPEfile();
        if (file == null) {
            if (BuilderUtil.getInstance().isStandalone()) {
                String string = this.mContainerHelper.getTargetFilePath();
                file = new File(string);
                if (file.isDirectory()) {
                    string = this.mContainerHelper.getTargetFilePath() + File.separator + this.mContainerHelper.getName() + BuilderUtil.getInstance().getExtName();
                    file = new File(string);
                }
                this.mContainerHelper.setSPEfile(file);
                this.mContainerHelper.createExtensionPackage(file, this.mSpssFrame);
            } else {
                String string = this.mContainerHelper.getTempNameDirectory() + File.separator + this.mContainerHelper.getName() + BuilderUtil.getInstance().getExtName();
                file = new File(string);
                this.mContainerHelper.setSPEfile(file);
                this.mContainerHelper.createExtensionPackage(file, this.mFrame);
            }
        } else if (BuilderUtil.getInstance().isStandalone()) {
            this.saveSPEFile();
        }
    }

    private void updateRequiredFields() {
        Vector<String> vector;
        Vector<String> vector2;
        this.mContainerHelper.setName(this.mRequiredTab.getExtensionName());
        this.mContainerHelper.setSummary(this.mRequiredTab.getExtensionSummary());
        this.mContainerHelper.setVersion(this.mRequiredTab.getExtensionVersion());
        this.mContainerHelper.setStatsVersion(this.mRequiredTab.getMinStatsVersion());
        if (BuilderUtil.getInstance().isStandalone()) {
            this.mContainerHelper.setTargetFilePath(this.mRequiredTab.getTargetFilePath());
        }
        Vector<String> vector3 = this.mRequiredTab.getDialogSpecs();
        this.mContainerHelper.setDialogSpecsSet(new HashSet<String>(vector3));
        Vector<String> vector4 = this.mRequiredTab.getCommandSpecs();
        if (vector4.size() > 0) {
            this.mContainerHelper.setCommandSpecsSet(new HashSet<String>(vector4));
        }
        if ((vector2 = this.mRequiredTab.getCodeFiles()).size() > 0) {
            this.mContainerHelper.setCodeFilesSet(new HashSet<String>(vector2));
        }
        if ((vector = this.mRequiredTab.getMiscFiles()).size() > 0) {
            this.mContainerHelper.setMiscFilesSet(new HashSet<String>(vector));
        } else {
            this.mContainerHelper.getMiscFilesSet().clear();
        }
        Vector<String> vector5 = this.mRequiredTab.getAllFiles();
        HashSet<String> hashSet = vector5 != null && vector5.size() > 0 ? new HashSet<String>(vector5) : new HashSet<String>();
        this.mContainerHelper.setAllFileWithPath(hashSet);
        for (String string : vector5) {
            String string2 = this.mOptionalTab.getCDBFileTransFolder(string);
            if (string2 == null) continue;
            this.mContainerHelper.addCBDTransFolder(new File(string).getName(), string2);
        }
    }

    private void updateOptionalFields() {
        Object object;
        String string = this.mOptionalTab.getDescription();
        this.mContainerHelper.setDescription(string);
        string = this.mOptionalTab.getDate();
        this.mContainerHelper.setReleaseDate(string);
        string = this.mOptionalTab.getAuthor();
        this.mContainerHelper.setAuthor(string);
        string = this.mOptionalTab.getLinks();
        this.mContainerHelper.setLinks(string);
        string = this.mOptionalTab.getKeywords();
        this.mContainerHelper.setKeywords(string);
        string = this.mOptionalTab.getPlatforms();
        this.mContainerHelper.setPlatforms(string);
        string = this.mOptionalTab.getMaxStatsVersion();
        this.mContainerHelper.setMaxStatsVersion(string);
        boolean bl = this.mOptionalTab.isPythonRequired();
        this.mContainerHelper.setRequiresPython(bl);
        if (bl) {
            object = this.mOptionalTab.getPythonVersion();
            this.mContainerHelper.setPythonVersion((String)object);
            object = this.mOptionalTab.buildKeyValuePairsFromList("", this.mOptionalTab.getPythonModuleList());
            if (object != null && ((String)object).length() > 0) {
                this.mContainerHelper.setPythonPackages((String)object);
                this.mContainerHelper.setPythonModulesSet(new HashSet<String>(this.mOptionalTab.getModulesListContent(this.mOptionalTab.getPythonModuleList())));
            }
        }
        bl = this.mOptionalTab.isRRequired();
        this.mContainerHelper.setRequiresR(bl);
        if (bl && (object = this.mOptionalTab.buildKeyValuePairsFromList("", this.mOptionalTab.getRModuleList())) != null && ((String)object).length() > 0) {
            this.mContainerHelper.setRPackages((String)object);
            this.mContainerHelper.setRLocationSet(new HashSet<String>(this.mOptionalTab.getModulesListContent(this.mOptionalTab.getRModuleList())));
        }
        if (((Vector)(object = this.mOptionalTab.getModulesListContent(this.mOptionalTab.getRequiredExtList()))).size() > 0) {
            this.mContainerHelper.setRequiredExtensions(new HashSet<String>((Collection<String>)object));
        }
        string = this.mOptionalTab.getTranslationCataloguesPath();
        this.mContainerHelper.setTranslationCataloguesPath(string);
    }

    public void zipDir(String string, ZipOutputStream zipOutputStream) {
        try {
            File file = new File(string);
            String[] stringArray = file.list();
            byte[] byArray = new byte[2156];
            int n = 0;
            for (String string2 : stringArray) {
                Object object;
                File file2 = new File(file, string2);
                if (file2.isDirectory()) {
                    object = file2.getPath();
                    this.zipDir((String)object, zipOutputStream);
                    continue;
                }
                object = new FileInputStream(file2);
                ZipEntry zipEntry = new ZipEntry(file2.getPath());
                zipOutputStream.putNextEntry(zipEntry);
                while ((n = ((FileInputStream)object).read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                ((FileInputStream)object).close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        BaseSpssTab baseSpssTab = (BaseSpssTab)this.mTabbedPane.getSelectedComponent();
        baseSpssTab.setEnabled(true);
        baseSpssTab.setFocusable(true);
        Vector vector = baseSpssTab.mComponentOrder;
        if (!vector.contains(this.mTabbedPane)) {
            vector.add(this.mTabbedPane);
        }
    }

    public File getNameDirectory() {
        return this.mNameDirectory;
    }

    private void close() {
        if (this.validateTabs()) {
            this.mContinuePressed = true;
            this.updatePropertyContainer();
            this.dispose();
        }
    }

    private void saveSPEFile() {
        File file = this.mContainerHelper.getTargetFile();
        if (file != null && file.getPath() != null && file.getPath().length() > 0) {
            this.mContainerHelper.createExtensionPackage(file, this.mSpssFrame, true);
        }
    }

    boolean validateTabs() {
        return this.mRequiredTab.validateTab() && this.mOptionalTab.validateTab();
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue(ExtensionPropertyDlg.NAME_KEY, BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BuilderUtil.getInstance().isStandalone() && ExtensionPropertyDlg.this.mNameDirectory != null && BuilderUtil.getInstance().getAppType() != AppType.MODELER) {
                String string = ExtensionPropertyDlg.this.mOptionalTab.getTranslationCataloguesPath();
                if (string == null || string.length() == 0) {
                    SpssFile.recursiveDelete(ExtensionPropertyDlg.this.mNameDirectory);
                }
                ExtensionPropertyDlg.this.mNameDirectory = null;
                ExtensionPropertyDlg.this.mContinuePressed = false;
            }
            ExtensionPropertyDlg.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue(ExtensionPropertyDlg.NAME_KEY, BuilderResUtil.getString("IDS_OK"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExtensionPropertyDlg.this.close();
        }
    }

    private class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue(ExtensionPropertyDlg.NAME_KEY, BuilderResUtil.getString("IDS_CONTINUE"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExtensionPropertyDlg.this.close();
        }
    }
}

