/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.extension;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.extension.SPEManifestHelper;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.util.PASWFileUtil;
import com.spss.uitools.util.StreamCopier;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExtensionPropertyContainer {
    private File mExtensionZipFile;
    private String mName;
    private String mSummary;
    private String mDescription;
    private String mAuthor;
    private String mReleaseDate;
    private String mVersion;
    private String mStatsVersion;
    private String mTargetFilePath;
    private String mLinks;
    private String mKeywords;
    private String mPlatforms;
    private String mTranslationCataloguesPath;
    private String mMaxStatsVersion;
    private Vector<String> mExtensionCommands;
    private boolean mRequiresPython;
    private String mPythonPackages;
    private String mPythonVersion;
    private boolean mRequiresR;
    private String mRPackages;
    private String mActionId = null;
    private String mCommandSpecs;
    private Set<String> mDialogSpecsSet;
    private Set<String> mCommandSpecsSet;
    private Set<String> mCodeFilesSet;
    private Set<String> mMiscFilesSet;
    private Set<String> mRLocationSet;
    private Set<String> mPythonModulesSet;
    private Set<String> mRequiredExtensions;
    private Set<String> mAllFileWithPath;
    private TreeMap<String, String> mCDBWithTranFolder;
    private static final String XML_FILE_EXT = ".xml";
    private SPEManifestHelper mManifestHelper;
    private static final String TERMS_OF_USE_ENTRY = "dWTermsOfUse/dWTermsOfUse.html";
    public static final String TERMS_OF_USE_FILE_NAME = "dWTermsOfUse.html";
    public static final String TERMS_OF_USE_FOLDER_NAME = "dWTermsOfUse";
    private boolean bHaveWrittenTranslationCataloguesRelPath = false;
    private File mNameDirectory = null;
    private boolean mIsSpecfileOK = true;
    private boolean mIsModified;

    public ExtensionPropertyContainer(String string) throws IOException {
        this.mExtensionZipFile = new File(string);
        try {
            this.mIsSpecfileOK = true;
            this.createNameDirectoryInTempDirectory();
            this.mManifestHelper = new SPEManifestHelper(this.mExtensionZipFile);
            this.mName = this.mManifestHelper.getBundleName();
            this.mSummary = this.mManifestHelper.getSummary();
            this.mDescription = this.mManifestHelper.getDescription();
            this.mAuthor = this.mManifestHelper.getAuthor();
            this.mReleaseDate = this.mManifestHelper.getDate();
            this.mVersion = this.mManifestHelper.getVersion();
            this.mStatsVersion = this.mManifestHelper.getProductVersion();
            this.mTargetFilePath = this.mManifestHelper.getTargetFilePath();
            this.mLinks = this.mManifestHelper.getLinks();
            this.mKeywords = this.mManifestHelper.getKeywords();
            this.mPlatforms = this.mManifestHelper.getPlatforms();
            this.mMaxStatsVersion = this.mManifestHelper.getMaxStatsVersion();
            this.mRequiresPython = this.mManifestHelper.isPythonPluginInstalled();
            this.mPythonVersion = this.mManifestHelper.getPythonVersion();
            this.mRequiresR = this.mManifestHelper.isRPluginInstalled();
            this.mTranslationCataloguesPath = this.mManifestHelper.getTranslationCataloguesPath();
            this.mPythonPackages = this.mManifestHelper.getAttributes().getValue("Python-Modules");
            this.mRPackages = this.mManifestHelper.getAttributes().getValue("R-Packages");
            this.mCommandSpecs = this.mManifestHelper.getAttributes().getValue("Command-Specs");
            this.mDialogSpecsSet = new HashSet<String>(this.mManifestHelper.getDialogSpecsSet());
            this.mCommandSpecsSet = new HashSet<String>(this.mManifestHelper.getCommandSpecsSet());
            this.mCodeFilesSet = new HashSet<String>(this.mManifestHelper.getCodeFilesSet());
            this.mMiscFilesSet = new HashSet<String>(this.mManifestHelper.getMiscFilesSet());
            this.mRLocationSet = new HashSet<String>(this.mManifestHelper.getRLocationSet());
            this.mPythonModulesSet = new HashSet<String>(this.mManifestHelper.getPythonModulesSet());
            this.mRequiredExtensions = new HashSet<String>(this.mManifestHelper.getRequiredExtensionModulesSet());
            this.mIsSpecfileOK = this.writeFilesToDirectory(this.mCodeFilesSet, this.mNameDirectory);
            if (this.mIsSpecfileOK) {
                this.mIsSpecfileOK = this.writeFilesToDirectory(this.mCommandSpecsSet, this.mNameDirectory);
            }
            if (this.mIsSpecfileOK) {
                this.mIsSpecfileOK = this.writeFilesToDirectory(this.mMiscFilesSet, this.mNameDirectory);
            }
            if (this.mIsSpecfileOK) {
                this.mIsSpecfileOK = this.writeFilesToDirectory(this.mDialogSpecsSet, this.mNameDirectory);
            }
            this.addToAllFile();
            if (this.mIsSpecfileOK) {
                this.mIsSpecfileOK = this.unzipTranslationCataloguesDirectory(this.mNameDirectory);
            }
            this.mIsModified = false;
        }
        catch (IOException iOException) {
            this.mIsSpecfileOK = false;
            iOException.printStackTrace();
        }
    }

    public ExtensionPropertyContainer() {
        try {
            this.createNameDirectoryInTempDirectory();
            this.mManifestHelper = new SPEManifestHelper();
            this.mName = "";
            this.mSummary = "";
            this.mDescription = "";
            this.mAuthor = "";
            this.mReleaseDate = "";
            this.mVersion = "";
            this.mStatsVersion = "";
            this.mTargetFilePath = "";
            this.mLinks = "";
            this.mKeywords = "";
            this.mPlatforms = "";
            this.mMaxStatsVersion = "";
            this.mRequiresPython = false;
            this.mPythonVersion = "";
            this.mRequiresR = false;
            this.mTranslationCataloguesPath = "";
            this.mPythonPackages = "";
            this.mRPackages = "";
            this.mCommandSpecs = "";
            this.mDialogSpecsSet = new HashSet<String>();
            this.mCommandSpecsSet = new HashSet<String>();
            this.mCodeFilesSet = new HashSet<String>();
            this.mMiscFilesSet = new HashSet<String>();
            this.mRLocationSet = new HashSet<String>();
            this.mPythonModulesSet = new HashSet<String>();
            this.mRequiredExtensions = new HashSet<String>();
            this.mCDBWithTranFolder = new TreeMap();
            this.mAllFileWithPath = new HashSet<String>();
            this.mIsSpecfileOK = true;
            this.mIsModified = false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isModified() {
        return this.mIsModified;
    }

    public void setModified(boolean bl) {
        this.mIsModified = bl;
    }

    public boolean isSpeFileOK() {
        return this.mIsSpecfileOK;
    }

    public String getName() {
        if (this.mName == null) {
            return "";
        }
        return this.mName;
    }

    public String getSummary() {
        if (this.mSummary == null) {
            return "";
        }
        return this.mSummary;
    }

    public String getEnglishSummary() {
        return this.mManifestHelper.getEnglishSummary();
    }

    public String getEnglishDescription() {
        return this.mManifestHelper.getEnglishDescription();
    }

    public String getDescription() {
        if (this.mDescription == null) {
            return "";
        }
        return this.mDescription;
    }

    public String getAuthor() {
        if (this.mAuthor == null) {
            return "";
        }
        return this.mAuthor;
    }

    public String getReleaseDate() {
        if (this.mReleaseDate == null) {
            return "";
        }
        return this.mReleaseDate;
    }

    public String getVersion() {
        if (this.mVersion == null) {
            return "";
        }
        return this.mVersion;
    }

    public String getStatsVersion() {
        if (this.mStatsVersion == null) {
            return "";
        }
        return this.mStatsVersion;
    }

    public File getTargetFile() {
        return new File(this.mTargetFilePath);
    }

    public String getTargetFilePath() {
        if (this.mTargetFilePath == null) {
            return "";
        }
        return this.mTargetFilePath;
    }

    public String getLinks() {
        if (this.mLinks == null) {
            return "";
        }
        return this.mLinks;
    }

    public String getKeywords() {
        if (this.mKeywords == null) {
            return "";
        }
        return this.mKeywords;
    }

    public String getPlatforms() {
        if (this.mPlatforms == null) {
            return "";
        }
        return this.mPlatforms;
    }

    public String getMaxStatsVersion() {
        if (this.mMaxStatsVersion == null) {
            return "";
        }
        return this.mMaxStatsVersion;
    }

    public boolean requiresPython() {
        return this.mRequiresPython;
    }

    public String getPythonVersion() {
        if (this.mPythonVersion == null) {
            return "";
        }
        return this.mPythonVersion;
    }

    public String getPythonPackages() {
        if (this.mPythonPackages == null) {
            return "";
        }
        return this.mPythonPackages;
    }

    public boolean requiresR() {
        return this.mRequiresR;
    }

    public String getRPackages() {
        if (this.mRPackages == null) {
            return "";
        }
        return this.mRPackages;
    }

    public String getTranslationCataloguesPath() {
        if (this.mTranslationCataloguesPath == null) {
            return "";
        }
        return this.mTranslationCataloguesPath;
    }

    public String getTranlationFolderName() {
        File file = new File(this.getTranslationCataloguesPath());
        if (file.exists()) {
            return file.getName();
        }
        return "";
    }

    public Set<String> getDialogSpecsSet() {
        return this.mDialogSpecsSet;
    }

    public boolean isDialogExist(String string) {
        return this.mDialogSpecsSet.contains(string);
    }

    public void removeOneDialogSpec(String string) {
        if (this.isDialogExist(string)) {
            this.mDialogSpecsSet.remove(string);
        }
    }

    public void removeOneDialogPath(String string) {
        if (this.mAllFileWithPath.contains(string)) {
            this.mAllFileWithPath.remove(string);
        }
    }

    public Set<String> getCommandSpecsSet() {
        return this.mCommandSpecsSet;
    }

    public Set<String> getCodeFilesSet() {
        return this.mCodeFilesSet;
    }

    public Set<String> getMiscFilesSet() {
        return this.mMiscFilesSet;
    }

    public Set<String> getRLocationSet() {
        return this.mRLocationSet;
    }

    public Set<String> getPythonModulesSet() {
        return this.mPythonModulesSet;
    }

    public Set<String> getRequiredExtensions() {
        return this.mRequiredExtensions;
    }

    public Set<String> getAllFileWithPath() {
        return this.mAllFileWithPath;
    }

    public void setSPEfile(File file) {
        this.mExtensionZipFile = file;
    }

    public File getSPEfile() {
        return this.mExtensionZipFile;
    }

    public File getTempNameDirectory() {
        if (!this.mNameDirectory.exists()) {
            this.createNameDirectoryInTempDirectory();
        }
        return this.mNameDirectory;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public void setSummary(String string) {
        this.mSummary = string;
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    public void setAuthor(String string) {
        this.mAuthor = string;
    }

    public void setReleaseDate(String string) {
        this.mReleaseDate = string;
    }

    public void setVersion(String string) {
        this.mVersion = string;
    }

    public void setStatsVersion(String string) {
        this.mStatsVersion = string;
    }

    public void setTargetFilePath(String string) {
        this.mTargetFilePath = string;
    }

    public void setLinks(String string) {
        this.mLinks = string;
    }

    public void setKeywords(String string) {
        this.mKeywords = string;
    }

    public void setPlatforms(String string) {
        this.mPlatforms = string;
    }

    public void setMaxStatsVersion(String string) {
        this.mMaxStatsVersion = string;
    }

    public void setTranslationCataloguesPath(String string) {
        this.mTranslationCataloguesPath = string;
    }

    public void setExtensionCommands(Vector<String> vector) {
        this.mExtensionCommands = vector;
    }

    public void setRequiresPython(boolean bl) {
        this.mRequiresPython = bl;
    }

    public void setPythonVersion(String string) {
        this.mPythonVersion = string;
    }

    public void setPythonPackages(String string) {
        this.mPythonPackages = string;
    }

    public void setRequiresR(boolean bl) {
        this.mRequiresR = bl;
    }

    public void setRPackages(String string) {
        this.mRPackages = string;
    }

    public void setActionId(String string) {
        this.mActionId = string;
    }

    public void setCommandSpecs(String string) {
        this.mCommandSpecs = string;
    }

    public void setDialogSpecsSet(Set<String> set) {
        this.mDialogSpecsSet = set;
    }

    public void addOneCFEfileName(String string) {
        this.mDialogSpecsSet.add(string);
    }

    public void setCommandSpecsSet(Set<String> set) {
        this.mCommandSpecsSet = set;
    }

    public void setCodeFilesSet(Set<String> set) {
        this.mCodeFilesSet = set;
    }

    public void setMiscFilesSet(Set<String> set) {
        this.mMiscFilesSet = set;
    }

    public void setRLocationSet(Set<String> set) {
        this.mRLocationSet = set;
    }

    public void setPythonModulesSet(Set<String> set) {
        this.mPythonModulesSet = set;
    }

    public void setRequiredExtensions(Set<String> set) {
        this.mRequiredExtensions = set;
    }

    public void setAllFileWithPath(Set<String> set) {
        this.mAllFileWithPath = set;
    }

    public void addToAllFileWithPath(Set<String> set) {
        for (String string : set) {
            this.mAllFileWithPath.add(string);
        }
    }

    public void addCFEfileWithPath(String string) {
        this.mAllFileWithPath.add(string);
    }

    public void addCBDTransFolder(String string, String string2) {
        String string3 = this.mCDBWithTranFolder.get(string);
        if (string3 != null) {
            this.mCDBWithTranFolder.remove(string);
        }
        this.mCDBWithTranFolder.put(string, string2);
    }

    public String getCDBTranfolder(String string) {
        String string2 = "";
        if (this.mCDBWithTranFolder != null && this.mCDBWithTranFolder.size() > 0) {
            string2 = this.mCDBWithTranFolder.get(string);
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private boolean createNameDirectoryInTempDirectory() {
        boolean bl = false;
        try {
            File file = BuilderUtil.getInstance().createTempFolder();
            if (file != null && file.delete()) {
                bl = file.mkdir();
            }
            if (bl) {
                this.mNameDirectory = file;
                this.mNameDirectory.deleteOnExit();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    private void createManifestContents(StringBuffer stringBuffer) {
        String string = "";
        if (this.getName().length() > 0) {
            string = "Name: " + this.getName() + "\n";
            stringBuffer.append(this.make72Safe(string));
        }
        if (this.getDialogSpecsSet().size() > 0) {
            stringBuffer.append(this.make72Safe(this.buildKeyValuePairsFromListOfFiles("Dialog-Specs", this.getDialogSpecsSet())));
        }
        if (this.getCommandSpecsSet().size() > 0) {
            stringBuffer.append(this.make72Safe(this.buildKeyValuePairsFromListOfFiles("Command-Specs", this.getCommandSpecsSet())));
        }
        if (this.getCodeFilesSet().size() > 0) {
            stringBuffer.append(this.make72Safe(this.buildKeyValuePairsFromListOfFiles("Code-Files", this.getCodeFilesSet())));
        }
        if (this.getMiscFilesSet().size() > 0) {
            stringBuffer.append(this.make72Safe(this.buildKeyValuePairsFromListOfFiles("Misc-Files", this.getMiscFilesSet())));
        }
        if (this.getSummary().length() > 0) {
            stringBuffer.append(this.make72Safe("Summary: " + this.getSummary() + "\n"));
        }
        if (this.getDescription().length() > 0) {
            stringBuffer.append(this.make72Safe("Description: " + this.getDescription() + "\n"));
        }
        if (this.getAuthor().length() > 0) {
            stringBuffer.append(this.make72Safe("Author: " + this.getAuthor() + "\n"));
        }
        if (this.getVersion().length() > 0) {
            stringBuffer.append(this.make72Safe("Version: " + this.getVersion() + "\n"));
        }
        if (this.getStatsVersion().length() > 0) {
            stringBuffer.append(this.make72Safe("Product-Version: " + this.getStatsVersion() + "\n"));
        }
        if (this.getReleaseDate().length() > 0) {
            stringBuffer.append(this.make72Safe("Date: " + this.getReleaseDate() + "\n"));
        }
        if (this.getMaxStatsVersion().length() > 0) {
            stringBuffer.append(this.make72Safe("Product-Version-Maximum: " + this.getMaxStatsVersion() + "\n"));
        }
        if (this.getPlatforms().length() > 0) {
            stringBuffer.append(this.make72Safe("Platforms: " + this.getPlatforms() + "\n"));
        }
        if (this.getKeywords().length() > 0) {
            stringBuffer.append(this.make72Safe("Categories: " + this.getKeywords() + "\n"));
        }
        if ((string = this.getPluginsKeyValuePairs()).length() > 0) {
            stringBuffer.append(this.make72Safe(string));
        }
        if (this.requiresPython()) {
            stringBuffer.append(this.make72Safe("Python-Version: " + this.getPythonVersion() + "\n"));
            if (this.getPythonModulesSet().size() > 0) {
                stringBuffer.append(this.make72Safe(this.buildKeyValuePairsFromListOfFiles("Python-Modules", this.getPythonModulesSet())));
            }
        }
        if (this.requiresR() && this.getRLocationSet().size() > 0) {
            stringBuffer.append(this.make72Safe(this.buildKeyValuePairsFromListOfFiles("R-Packages", this.getRLocationSet())));
        }
        if (this.getLinks().length() > 0) {
            stringBuffer.append(this.make72Safe("Links: " + this.getLinks() + "\n"));
        }
        if (this.getRequiredExtensions().size() > 0) {
            stringBuffer.append(this.make72Safe(this.buildKeyValuePairsFromListOfFiles("Extension-Bundles", this.getRequiredExtensions())));
        }
        if (this.getTranslationCataloguesPath().length() > 0) {
            stringBuffer.append(this.make72Safe("Translation-Catalogues: " + this.getTranlationFolderName() + "\n"));
        }
    }

    private String getPluginsKeyValuePairs() {
        String string = "";
        if (this.requiresPython() || this.requiresR()) {
            string = "Plugins: ";
            String string2 = this.requiresPython() && this.requiresR() ? "Python,R\n" : (this.requiresPython() ? "Python\n" : "R\n");
            string = string + string2;
        }
        return string;
    }

    private String buildKeyValuePairsFromListOfFiles(String string, Set<String> set) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        if (set.size() > 0) {
            stringBuffer.append(string).append(": ");
            object = set.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                stringBuffer.append(string2).append(",");
            }
            stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        return ((String)(object = stringBuffer.toString())).equals("") ? null : object;
    }

    StringBuffer make72Safe(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        if (n > 72) {
            int n2 = 70;
            while (n2 < n - 2) {
                stringBuffer.insert(n2, "\r\n ");
                n2 += 72;
                n += 3;
            }
        }
        return stringBuffer;
    }

    public boolean createExtensionPackage(File file, JFrame jFrame) {
        return this.createExtensionPackage(file, jFrame, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createExtensionPackage(File file, JFrame jFrame, boolean bl) {
        boolean bl2 = true;
        ZipOutputStream zipOutputStream = null;
        try {
            String string;
            Object object;
            Object object2;
            if (file.exists()) {
                boolean bl3;
                object2 = "";
                object = BuilderUtil.getInstance().getAppVersionString();
                if (bl && (bl3 = BuilderAlertPane.showConfirmDialog(jFrame, (String)(object2 = String.format(BuilderResUtil.getString("ERR_FILE_EXISTS_WARNING"), file.getName())), (String)object, BuilderAlertPane.IconType.eWarning, BuilderAlertPane.OptionType.YES_NO_OPTION))) {
                    boolean bl4 = false;
                    return bl4;
                }
                if (!PASWFileUtil.isWritable((String)file.getAbsolutePath()) && !file.delete() && bl) {
                    object2 = String.format(BuilderResUtil.getString("ERR_FILE_READ_ONLY_FILE_MESSAGE"), file.getName());
                    BuilderAlertPane.showConfirmDialog(jFrame, (String)object2, (String)object, BuilderAlertPane.IconType.eInformation, BuilderAlertPane.OptionType.OK_CANCEL_OPTION);
                    bl3 = false;
                    return bl3;
                }
            }
            object2 = new FileOutputStream(file, false);
            zipOutputStream = new JarOutputStream((OutputStream)object2);
            zipOutputStream.setMethod(0);
            this.saveManifestToJar((JarOutputStream)zipOutputStream);
            object = this.getAllFileWithPath();
            File[] fileArray = new File[object.size()];
            int n = 0;
            Object object3 = object.iterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                fileArray[n++] = new File(string);
            }
            this.saveFilesToJar((JarOutputStream)zipOutputStream, fileArray);
            object3 = this.mNameDirectory + File.separator + TERMS_OF_USE_FOLDER_NAME + File.separator + TERMS_OF_USE_FILE_NAME;
            if (new File((String)object3).isFile()) {
                this.jarDirectory((JarOutputStream)zipOutputStream, this.mNameDirectory + File.separator + TERMS_OF_USE_FOLDER_NAME, TERMS_OF_USE_FOLDER_NAME);
            }
            if ((string = this.getTranslationCataloguesPath()) == null) return bl2;
            if (string.length() <= 0) return bl2;
            if (!string.contains(File.separator)) {
                string = this.mNameDirectory + File.separator + string;
            }
            File file2 = new File(string);
            this.jarDirectory((JarOutputStream)zipOutputStream, string, file2.getName());
            return bl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
            return bl2;
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Vector<String> getFiles(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (String string2 : stringArray) {
            String string3 = string + File.separator + string2;
            vector.add(string3);
        }
        return vector;
    }

    private void jarDirectory(JarOutputStream jarOutputStream, String string, String string2) {
        File file = new File(string);
        String[] stringArray = file.list();
        Vector<String> vector = this.getFiles(string, stringArray);
        File[] fileArray = new File[vector.size()];
        int n = 0;
        for (String string3 : vector) {
            fileArray[n++] = new File(string3);
        }
        if (!this.bHaveWrittenTranslationCataloguesRelPath) {
            try {
                this.bHaveWrittenTranslationCataloguesRelPath = true;
                byte[] iOException = new byte[]{};
                CRC32 cRC32 = new CRC32();
                cRC32.update(iOException);
                JarEntry jarEntry = new JarEntry(string2 + "/");
                jarEntry.setSize(0L);
                jarEntry.setCrc(cRC32.getValue());
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.closeEntry();
            }
            catch (IOException exception) {
                this.bHaveWrittenTranslationCataloguesRelPath = false;
                exception.printStackTrace();
                return;
            }
        }
        try {
            for (File file2 : fileArray) {
                Object object;
                Object object2;
                Object object3;
                String string4;
                if (file2.isFile() && !file2.isHidden()) {
                    Object object4;
                    String string5;
                    Object object5;
                    Object object6;
                    Closeable closeable;
                    string4 = Locale.getDefault().toString();
                    object3 = file2.getAbsolutePath();
                    if (((String)object3).contains((String)(object2 = File.separator) + string4 + (String)object2) && ((String)object3).endsWith(".properties")) {
                        object = new Properties();
                        closeable = new FileInputStream((String)object3);
                        ((Properties)object).load((InputStream)closeable);
                        ((InputStream)closeable).close();
                        object6 = new BufferedReader(new InputStreamReader(new FileInputStream((String)object3)));
                        object5 = new StringBuilder();
                        string5 = null;
                        while ((string5 = ((BufferedReader)object6).readLine()) != null) {
                            if (!string5.trim().startsWith("#")) continue;
                            ((StringBuilder)object5).append(string5 + "\r\n");
                        }
                        ((BufferedReader)object6).close();
                        object4 = new FileOutputStream((String)object3);
                        ((OutputStream)object4).write(((StringBuilder)object5).toString().getBytes());
                        ((Properties)object).setProperty("Summary", this.getSummary());
                        ((Properties)object).store((OutputStream)object4, "");
                        ((OutputStream)object4).close();
                    }
                    object = new FileInputStream(file2);
                    closeable = new ByteArrayOutputStream();
                    StreamCopier.copyStream((InputStream)object, (OutputStream)closeable);
                    object6 = ((ByteArrayOutputStream)closeable).toByteArray();
                    if (((byte[])object6).length <= 0) {
                        throw new Exception("Can't read input bytes");
                    }
                    object5 = new CRC32();
                    object5.update((byte[])object6);
                    string5 = string2 + File.separator + file2.getName();
                    object4 = new JarEntry(string5);
                    ((ZipEntry)object4).setSize(((Object)object6).length);
                    ((ZipEntry)object4).setCrc(((CRC32)object5).getValue());
                    jarOutputStream.putNextEntry((ZipEntry)object4);
                    jarOutputStream.write((byte[])object6);
                    jarOutputStream.closeEntry();
                    continue;
                }
                if (!file2.isDirectory() || file2.isHidden()) continue;
                string4 = string2 + File.separator + file2.getName();
                object3 = new byte[0];
                object2 = new CRC32();
                object2.update((byte[])object3);
                object = new JarEntry(string4 + "/");
                ((ZipEntry)object).setSize(0L);
                ((ZipEntry)object).setCrc(((CRC32)object2).getValue());
                jarOutputStream.putNextEntry((ZipEntry)object);
                jarOutputStream.closeEntry();
                this.jarDirectory(jarOutputStream, file2.getAbsolutePath(), string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getAllFiles(Set<String> set, Vector<String> vector) {
        for (String string : set) {
            vector.add(string);
        }
    }

    private void saveManifestToJar(JarOutputStream jarOutputStream) throws IOException {
        String string = "META-INF/MANIFEST.MF";
        JarEntry jarEntry = new JarEntry(string);
        StringBuffer stringBuffer = new StringBuffer();
        this.createManifestContents(stringBuffer);
        String string2 = stringBuffer.toString();
        byte[] byArray = string2.getBytes("UTF-8");
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        jarEntry.setSize(byArray.length);
        jarEntry.setCrc(cRC32.getValue());
        jarOutputStream.putNextEntry(jarEntry);
        jarOutputStream.write(byArray);
        jarOutputStream.closeEntry();
    }

    private void saveFilesToJar(JarOutputStream jarOutputStream, File[] fileArray) throws Exception {
        for (File file : fileArray) {
            try {
                Object object;
                Object object2;
                Object object3;
                if (file.isFile()) {
                    object3 = new FileInputStream(file);
                    object2 = new ByteArrayOutputStream();
                    StreamCopier.copyStream((InputStream)object3, (OutputStream)object2);
                    object = ((ByteArrayOutputStream)object2).toByteArray();
                    if (((byte[])object).length <= 0) {
                        throw new Exception("Can't read input bytes");
                    }
                    CRC32 cRC32 = new CRC32();
                    cRC32.update((byte[])object);
                    JarEntry jarEntry = new JarEntry(file.getName());
                    jarEntry.setSize(((Object)object).length);
                    jarEntry.setCrc(cRC32.getValue());
                    jarOutputStream.putNextEntry(jarEntry);
                    jarOutputStream.write((byte[])object);
                    jarOutputStream.closeEntry();
                    continue;
                }
                if (!file.isDirectory()) continue;
                object3 = new byte[0];
                object2 = new CRC32();
                object2.update((byte[])object3);
                object = new JarEntry(file.getName() + "/");
                ((ZipEntry)object).setSize(0L);
                ((ZipEntry)object).setCrc(((CRC32)object2).getValue());
                jarOutputStream.putNextEntry((ZipEntry)object);
                jarOutputStream.closeEntry();
            }
            catch (ZipException zipException) {
                // empty catch block
            }
        }
    }

    public boolean unzipTranslationCataloguesDirectory(File file) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.getTargetFile());
            zipInputStream = new JarInputStream(fileInputStream);
            String string = this.mManifestHelper.getTranslationCataloguesPath();
            bl = ExtensionPropertyContainer.unJarTranslationCataloguesToDirectory((JarInputStream)zipInputStream, file.getAbsolutePath(), string);
            zipInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            iOException.printStackTrace();
        }
        return bl;
    }

    public static boolean unJarTranslationCataloguesToDirectory(JarInputStream jarInputStream, String string, String string2) throws IOException {
        boolean bl = true;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        boolean bl2 = false;
        while (jarEntry != null) {
            Object object;
            if (jarEntry.isDirectory()) {
                object = jarEntry.getName().substring(0, jarEntry.getName().length() - 1);
                object = ExtensionPropertyContainer.getOSTypeSlashifiedPath((String)object);
                if (bl2) {
                    bl = ExtensionPropertyContainer.makeDirectoryFromFullAndRelativePaths(string, (String)object);
                    if (!bl) {
                        break;
                    }
                } else if (!((String)object).equals("META-INF") && string2 != null && string2.equals(object)) {
                    bl2 = true;
                    bl = ExtensionPropertyContainer.makeDirectoryFromFullAndRelativePaths(string, (String)object);
                    if (!bl) {
                        break;
                    }
                }
            } else if (bl2) {
                String string3 = ExtensionPropertyContainer.getOSTypeSlashifiedPath(jarEntry.getName());
                if (string3.contains(TERMS_OF_USE_FILE_NAME)) {
                    object = string + File.separator + TERMS_OF_USE_FOLDER_NAME;
                    new File((String)object).mkdirs();
                }
                object = ExtensionPropertyContainer.readEntry(jarInputStream);
                String string4 = string + File.separator + string3;
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                try {
                    fileOutputStream.write(((ByteBuffer)object).array());
                }
                catch (IOException iOException) {
                    fileOutputStream.close();
                    bl = false;
                    break;
                }
                fileOutputStream.close();
            }
            jarInputStream.closeEntry();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        jarInputStream.close();
        return bl;
    }

    private static boolean makeDirectoryFromFullAndRelativePaths(String string, String string2) {
        String string3 = string + File.separator + string2;
        boolean bl = new File(string3).mkdir();
        if (bl) {
            // empty if block
        }
        return bl;
    }

    private static String getOSTypeSlashifiedPath(String string) {
        string = OSInfo.getOSType() == OSInfo.OSType.WIN ? string.replace('/', File.separatorChar) : string.replace('\\', File.separatorChar);
        return string;
    }

    public boolean writeFilesToDirectory(Set<String> set, File file) {
        Vector<String> vector = new Vector<String>();
        vector.add(file.getAbsolutePath());
        boolean bl = this.writeFilesToFirstWritableDirectory(set, vector);
        return bl;
    }

    public boolean writeFilesToFirstWritableDirectory(Set<String> set, Vector<String> vector) {
        boolean bl = true;
        boolean bl2 = false;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : vector) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory() || !PASWFileUtil.isWritable((File)file)) continue;
            File file2 = this.getTargetFile();
            for (String string2 : set) {
                if (this.readAndWriteBundleFile(file2, file, string2) != null) continue;
                hashSet.add(string2);
            }
            if (hashSet.size() > 0) {
                set.removeAll(hashSet);
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    private File readAndWriteBundleFile(File file, File file2, String string) {
        File file3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            file3 = this.readAndWriteFromJar(jarInputStream, file2, string);
            jarInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file3;
    }

    private File readAndWriteFromJar(JarInputStream jarInputStream, File file, String string) throws IOException {
        File file2 = null;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string2 = jarEntry.getName();
            if (string2.equals(string)) {
                ByteBuffer byteBuffer = ExtensionPropertyContainer.readEntry(jarInputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file.getPath() + File.separator + string2);
                fileOutputStream.write(byteBuffer.array());
                fileOutputStream.close();
                jarInputStream.closeEntry();
                file2 = new File(file.getPath() + File.separator + string2);
                break;
            }
            jarInputStream.closeEntry();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    public static ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[50000];
        try {
            int n = jarInputStream.read(byArray, 0, 50000);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 50000);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private String getXmlFilePath() {
        return new File(this.mExtensionZipFile.getParent()).getParentFile().getAbsolutePath();
    }

    public boolean hasReadMeFile() throws IOException {
        boolean bl = false;
        JarFile jarFile = new JarFile(this.mExtensionZipFile);
        String string = BuilderUtil.getInstance().getAppLocale().getLanguage();
        JarEntry jarEntry = jarFile.getJarEntry("ReadMe_" + string + ".txt");
        if (jarEntry == null) {
            jarEntry = jarFile.getJarEntry("ReadMe.txt");
        }
        if (jarEntry != null) {
            bl = true;
        }
        jarFile.close();
        return bl;
    }

    public boolean hasTermOfUseFile() throws IOException {
        boolean bl = false;
        JarFile jarFile = new JarFile(this.mExtensionZipFile);
        String string = BuilderUtil.getInstance().getAppLocale().getLanguage();
        JarEntry jarEntry = jarFile.getJarEntry(TERMS_OF_USE_ENTRY);
        if (jarEntry != null) {
            bl = true;
        }
        jarFile.close();
        return bl;
    }

    public String getReadMeFileContents() throws IOException {
        JarFile jarFile = new JarFile(this.mExtensionZipFile);
        StringBuilder stringBuilder = new StringBuilder();
        String string = BuilderUtil.getInstance().getAppLocale().getLanguage();
        JarEntry jarEntry = jarFile.getJarEntry("ReadMe_" + string + ".txt");
        if (jarEntry == null) {
            jarEntry = jarFile.getJarEntry("ReadMe.txt");
        }
        if (jarEntry != null) {
            String string2;
            InputStreamReader inputStreamReader;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append(System.getProperty("line.separator"));
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }
        jarFile.close();
        return stringBuilder.toString();
    }

    public String getTermsOfUseFileContents() throws IOException {
        JarFile jarFile = new JarFile(this.mExtensionZipFile);
        StringBuilder stringBuilder = new StringBuilder();
        String string = BuilderUtil.getInstance().getAppLocale().getLanguage();
        JarEntry jarEntry = jarFile.getJarEntry(TERMS_OF_USE_ENTRY);
        if (jarEntry != null) {
            String string2;
            InputStreamReader inputStreamReader;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append(System.getProperty("line.separator"));
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }
        jarFile.close();
        return stringBuilder.toString();
    }

    public String getActionId() {
        if (this.mActionId == null) {
            String string = this.getName().replace(' ', '_');
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(BuilderUtil.getInstance().getAppdataCustomDialogDirectory());
            stringBuilder.append(File.separator);
            stringBuilder.append(string);
            stringBuilder.append(File.separator);
            stringBuilder.append(string);
            stringBuilder.append(XML_FILE_EXT);
            File file = new File(stringBuilder.toString());
            if (file.exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.mActionId = this.getActionIdFromXmlInputStream(fileInputStream);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            } else {
                try {
                    JarFile jarFile = new JarFile(this.mExtensionZipFile);
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        int n;
                        JarEntry jarEntry = enumeration.nextElement();
                        if (!jarEntry.getName().endsWith(".spd") && !jarEntry.getName().endsWith(".cfe")) continue;
                        String string2 = BuilderUtil.getInstance().getTempDir().getAbsolutePath();
                        if (!string2.endsWith(File.separator)) {
                            string2 = string2 + File.separatorChar;
                        }
                        InputStream inputStream = jarFile.getInputStream(jarEntry);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(string2 + jarEntry.getName()));
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        byte[] byArray = new byte[4096];
                        while ((n = bufferedInputStream.read(byArray)) != -1) {
                            bufferedOutputStream.write(byArray, 0, n);
                        }
                        bufferedInputStream.close();
                        bufferedOutputStream.close();
                        JarFile jarFile2 = new JarFile(string2 + jarEntry.getName());
                        Enumeration<JarEntry> enumeration2 = jarFile2.entries();
                        while (enumeration2.hasMoreElements()) {
                            JarEntry jarEntry2 = enumeration2.nextElement();
                            String string3 = jarEntry2.getName();
                            if (!XML_FILE_EXT.regionMatches(true, 0, string3, string3.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) continue;
                            InputStream inputStream2 = jarFile2.getInputStream(jarEntry2);
                            this.mActionId = this.getActionIdFromXmlInputStream(inputStream2);
                            if (this.mActionId == null) continue;
                            break;
                        }
                        jarFile2.close();
                        new File(string2 + jarEntry.getName()).deleteOnExit();
                        new File(string2 + jarEntry.getName()).delete();
                    }
                    jarFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            }
        }
        return this.mActionId;
    }

    private String getActionIdFromXmlInputStream(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        String string = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("UserInterface");
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                NodeList nodeList2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (nodeList2 = (element = (Element)node).getElementsByTagName("MenuItem")) == null) continue;
                Element element2 = (Element)nodeList2.item(0);
                string = element2.getAttribute("action");
                string = string.replace("_action", "");
                break;
            }
        }
        return string;
    }

    public Vector<String> getExtensionCommands() {
        if (this.mExtensionCommands == null && this.mCommandSpecs != null) {
            String[] stringArray;
            this.mExtensionCommands = new Vector();
            for (String string : stringArray = this.mCommandSpecs.split(",")) {
                String string2 = this.getXmlFilePath() + File.separator + string.replace(' ', '_');
                try {
                    FileInputStream fileInputStream = new FileInputStream(new File(string2));
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(fileInputStream);
                    document.getDocumentElement().normalize();
                    Element element = document.getDocumentElement();
                    String string3 = element.getAttribute("Name");
                    if (string3 == null) continue;
                    this.mExtensionCommands.add(string3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            }
        }
        return this.mExtensionCommands;
    }

    public static void makeFilePathFullAccessable(String string) {
        if (OSInfo.isWindows7() || OSInfo.isWindowsVista()) {
            String string2 = "cmd /c icacls " + string + " /grant Everyone:F /t";
            try {
                Runtime.getRuntime().exec(string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addToAllFile() {
        this.mAllFileWithPath = new HashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getDialogSpecsSet());
        hashSet.addAll(this.getCommandSpecsSet());
        hashSet.addAll(this.getCodeFilesSet());
        hashSet.addAll(this.getMiscFilesSet());
        for (String string : hashSet) {
            if (!string.contains(File.separator)) {
                string = this.mNameDirectory + File.separator + string;
            }
            this.mAllFileWithPath.add(string);
        }
    }

    public void clearAllFile() {
        this.mAllFileWithPath = new HashSet<String>();
    }
}

