/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.canvas.BuilderCanvas;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.TextAreaDefinition;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;

public class TextAreaCtrlObject
extends CanvasObject {
    private BuilderCanvas.CanvasType mCanvasType;
    private String sNormalHelpMesg = BuilderResUtil.getString("IDS_CDB_HELP_INFORMATION");
    private String sHeaderFooterMesg = BuilderResUtil.getString("IDS_CDB_HEADER_FOOTER_HELP_INFORMATION");

    public TextAreaCtrlObject(TextAreaDefinition textAreaDefinition, BuilderCanvas.CanvasType canvasType) {
        super((PanelElementDefinition)textAreaDefinition);
        this.mCanvasType = canvasType;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mCanvasType == BuilderCanvas.CanvasType.HeaderFooter) {
            return new Dimension(440, 25);
        }
        if (((TextAreaDefinition)this.getCtrlDef()).isBundle()) {
            return new Dimension(500, 190);
        }
        return new Dimension(500, 160);
    }

    @Override
    void render(Graphics2D graphics2D) {
        Insets insets = this.getBorder().getBorderInsets(this);
        this.renderTitle(graphics2D, insets.left, insets.top);
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        Font font2 = font.deriveFont(0, 14.0f);
        int n3 = font.getSize();
        graphics2D.setFont(font2);
        String string = this.getTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y);
        rectangle.grow(-n, -n2);
        CommonUtil.drawWrappedText((Graphics)graphics2D, (String)string, (Rectangle)rectangle, (int)2);
    }

    private String getTitle() {
        if (this.mCanvasType == BuilderCanvas.CanvasType.HeaderFooter) {
            return this.sHeaderFooterMesg;
        }
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            this.sNormalHelpMesg = BuilderResUtil.getString("IDS_CDB_HELP_INFORMATION_MODELER");
        }
        if (((TextAreaDefinition)this.getCtrlDef()).isBundle()) {
            return this.sNormalHelpMesg + BuilderResUtil.getString("IDS_CDB_HELP_INFORMATION_BUNDLE");
        }
        return this.sNormalHelpMesg + BuilderResUtil.getString("IDS_CDB_HELP_INFORMATION_DIALOG");
    }
}

