/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.TableDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class TableCtrlObject
extends CanvasObject {
    private static ImageIcon sItemImage = null;

    public TableCtrlObject(TableDefinition tableDefinition) {
        super((PanelElementDefinition)tableDefinition);
        try {
            if (sItemImage == null) {
                sItemImage = new ImageIcon(BuilderResUtil.getImageResource("table.png"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        String string = this.getControlTitle();
        int n = sItemImage.getIconHeight();
        return new Dimension(this.getObjectWidth(), n + 20);
    }

    @Override
    void render(Graphics2D graphics2D) {
        Insets insets = this.getBorder().getBorderInsets(this);
        String string = this.getControlTitle();
        boolean bl = string != null && string.length() > 0;
        Rectangle rectangle = this.getBounds();
        int n = rectangle.height - sItemImage.getIconHeight() - insets.bottom;
        sItemImage.paintIcon(this, graphics2D, insets.left, n);
        if (bl) {
            this.renderTitle(graphics2D, insets.left, insets.top - 2);
        }
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y + 2);
        rectangle.height = 24;
        rectangle.x += n + 2;
        rectangle.grow(n, n2);
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }
}

