/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertDialog;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssButtonGroup;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ToggleButtonAction;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.canvas.DraggableTabbedPane;
import com.spss.shared.custom_gui.ui_builder.canvas.ISelectionListener;
import com.spss.shared.custom_gui.ui_builder.canvas.TabObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabComponent
extends JPanel {
    private JButton mCloseButton;
    private JLabel mLabel;
    private BuilderFrame mFrame;
    private DraggableTabbedPane mPane;
    private TabObject mObj;
    private Vector<ISelectionListener> mSelectionListeners;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }
    };
    private final MouseListener labelMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = TabComponent.this.mPane.indexOfTabComponent(TabComponent.this);
            if (n != -1) {
                TabComponent.this.mFrame.activateTab(TabComponent.this, n);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TabComponent.this.mPane.mouseReleased(TabComponent.this.translateEventPoint(mouseEvent));
        }
    };
    private final MouseMotionListener labelMouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = TabComponent.this.mPane.indexOfTabComponent(TabComponent.this);
            if (n != -1) {
                TabComponent.this.mPane.mouseDragged(TabComponent.this.translateEventPoint(mouseEvent), n);
            }
        }
    };

    public TabComponent(TabObject tabObject, BuilderFrame builderFrame) {
        super(new FlowLayout(0, 0, 0));
        boolean bl;
        this.mFrame = builderFrame;
        if (this.mFrame == null) {
            throw new NullPointerException("BuilderFrame is null");
        }
        this.mPane = builderFrame.getTabbedPane();
        this.mObj = tabObject;
        this.setOpaque(false);
        this.mLabel = new JLabel(){

            @Override
            public String getText() {
                int n = TabComponent.this.mPane.indexOfTabComponent(TabComponent.this);
                if (n != -1) {
                    return TabComponent.this.mPane.getTitleAt(n);
                }
                return null;
            }
        };
        this.mLabel.addMouseListener(this.labelMouseListener);
        this.mLabel.addMouseMotionListener(this.labelMouseMotionListener);
        this.add(this.mLabel);
        this.mLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.mCloseButton = new TabCloseButton();
        boolean bl2 = bl = BuilderUtil.getInstance().getAppType() == AppType.MODELER && this.mPane.getTabCount() > 1 || BuilderUtil.getInstance().getAppType() == AppType.STATS && this.mPane.getTabCount() >= 1;
        if (bl) {
            this.add(this.mCloseButton);
        }
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.mSelectionListeners = new Vector();
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        if (!this.mSelectionListeners.contains(iSelectionListener)) {
            this.mSelectionListeners.add(iSelectionListener);
        }
    }

    public void fireSelectionChange(CanvasObject canvasObject) {
        for (ISelectionListener iSelectionListener : this.mSelectionListeners) {
            iSelectionListener.selectionChanged(canvasObject);
        }
    }

    public void setTitle(String string) {
        this.mLabel.setText(string);
        int n = this.mPane.indexOfTabComponent(this);
        if (n != -1) {
            this.mPane.setTitleAt(n, string);
        }
    }

    public void setToolTip(String string) {
        int n = this.mPane.indexOfTabComponent(this);
        if (n != -1) {
            this.mPane.setToolTipTextAt(n, string);
        }
        this.mLabel.setToolTipText(string);
    }

    public CanvasObject getTabObject() {
        return this.mObj;
    }

    protected void removeButton() {
        this.remove(this.mCloseButton);
    }

    public void addButton() {
        if (this.mPane.getTabCount() > 1) {
            this.add(this.mCloseButton);
        }
    }

    private MouseEvent translateEventPoint(MouseEvent mouseEvent) {
        Point point = mouseEvent.getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(point, this.mPane);
        return new MouseEvent(this.mPane, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    class TabCloseAlertDlg
    extends BuilderAlertDialog {
        private JRadioButton mDeleteButton;
        private JRadioButton mConvertButton;

        public TabCloseAlertDlg(JFrame jFrame, String string, String string2) {
            super(jFrame, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), string, string2, BuilderAlertPane.IconType.eQuestion, BuilderAlertPane.OptionType.OK_CANCEL_OPTION, null, null);
            this.setLocationRelativeTo(jFrame);
        }

        public boolean isDelectedSelected() {
            return this.mDeleteButton.isSelected();
        }

        @Override
        protected void initVars() {
            super.initVars();
            SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
            ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_LAST_TAB_ALERT_DELETE_BUTTON");
            this.mDeleteButton = new JRadioButton(toggleButtonAction);
            toggleButtonAction = new ToggleButtonAction(this, "IDS_LAST_TAB_ALERT_CONVERT_BUTTON");
            this.mConvertButton = new JRadioButton(toggleButtonAction);
            spssButtonGroup.add(this.mDeleteButton);
            spssButtonGroup.add(this.mConvertButton);
            this.mDeleteButton.setSelected(true);
        }

        @Override
        protected void addComponents(boolean bl) {
            super.addComponents(bl);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            int n2 = DialogUtil.getGroupBoxInnerMargin();
            Insets insets = new Insets(n2 * 2, n2 * 3, 0, n2);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(this.mViewPanel, this.mDeleteButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
            gridBagConstraints.weighty = 1.0;
            insets.set(n2 * 2, n2 * 3, n2 * 3, n2);
            DialogUtil.addUsingGBL(this.mViewPanel, this.mConvertButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        }
    }

    private class TabCloseButton
    extends JButton
    implements ActionListener {
        public TabCloseButton() {
            int n = 16;
            this.setPreferredSize(new Dimension(n, n));
            this.setToolTipText(BuilderResUtil.getTooltip("tab_close"));
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TabComponent.this.mPane.indexOfTabComponent(TabComponent.this);
            DialogDefinition dialogDefinition = TabComponent.this.mFrame.getDialogDefinition();
            TabComponent.this.mFrame.setModified(true);
            if (TabComponent.this.mPane.getTabCount() == 1 && n == 0) {
                boolean bl = dialogDefinition.getCurrentPanel().getElementCount() == 0;
                TabCloseAlertDlg tabCloseAlertDlg = null;
                int n2 = 3;
                if (!bl) {
                    tabCloseAlertDlg = new TabCloseAlertDlg(TabComponent.this.mFrame, BuilderResUtil.getString("IDS_LAST_TAB_ALERT_MESG"), BuilderUtil.getInstance().getAppVersionString());
                    tabCloseAlertDlg.setVisible(true);
                    n2 = tabCloseAlertDlg.getButtonPressedValue();
                }
                if (bl || n2 == 0) {
                    boolean bl2 = false;
                    TabComponent.this.mPane.remove(n);
                    if (tabCloseAlertDlg != null && tabCloseAlertDlg.isDelectedSelected() || bl) {
                        PanelDefinition panelDefinition = (PanelDefinition)TabComponent.this.mFrame.getDialogDefinition().getPanels().get(n);
                        TabComponent.this.mFrame.removePanelFromTemplate(panelDefinition);
                        TabComponent.this.mFrame.getDialogDefinition().removePanel(panelDefinition);
                        bl2 = true;
                    }
                    BuilderUtil.getInstance().setTabbed(false);
                    TabComponent.this.mPane.removeAll();
                    TabComponent.this.mPane = null;
                    TabComponent.this.mFrame.recreatePanelCanvas(false);
                    TabComponent.this.mFrame.getCanvas().setDialogDefinition(dialogDefinition);
                    if (bl2) {
                        TabComponent.this.mFrame.getCanvas().createTextAreaObject();
                    }
                }
            } else {
                if (n != -1) {
                    TabComponent.this.mPane.remove(n);
                    PanelDefinition panelDefinition = (PanelDefinition)TabComponent.this.mFrame.getDialogDefinition().getPanels().get(n);
                    TabComponent.this.mFrame.removePanelFromTemplate(panelDefinition);
                    TabComponent.this.mFrame.getDialogDefinition().removePanel(panelDefinition);
                }
                if (n > 1) {
                    TabComponent.this.mFrame.updateDropListenerByTabIndex(n - 1);
                }
                if (BuilderUtil.getInstance().getAppType() != AppType.STATS && TabComponent.this.mPane.getTabCount() == 1) {
                    ((TabComponent)TabComponent.this.mPane.getTabComponentAt(0)).removeButton();
                    TabComponent.this.mFrame.updateDropListenerByTabIndex(0);
                }
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.getModel().isPressed()) {
                graphics2D.translate(1, 1);
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                graphics2D.setColor(Color.RED);
            }
            int n = 6;
            graphics2D.drawLine(n, n, this.getWidth() - n - 1, this.getHeight() - n - 1);
            graphics2D.drawLine(this.getWidth() - n - 1, n, n, this.getHeight() - n - 1);
            graphics2D.dispose();
        }
    }
}

