/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.ItemGroupDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class ItemGroupObject
extends CanvasObject {
    protected ItemGroupDefinition mItemGroupDef;

    public ItemGroupObject(ItemGroupDefinition itemGroupDefinition) {
        super((PanelElementDefinition)itemGroupDefinition);
        this.mItemGroupDef = itemGroupDefinition;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
    }

    public void addItem(CanvasObject canvasObject) {
        this.insertItem(canvasObject, this.getComponentCount());
    }

    public void insertItem(CanvasObject canvasObject, int n) {
        if (n < 0 || n > this.getComponentCount()) {
            n = this.getComponentCount();
        }
        this.addItemInternal(canvasObject, n);
        this.mItemGroupDef.insertPanelElement(canvasObject.getCtrlDef(), n);
    }

    public void removeItem(CanvasObject canvasObject) {
        int n = this.getComponentIndex(canvasObject);
        if (n < 0) {
            return;
        }
        this.mItemGroupDef.removePanelElement(canvasObject.getCtrlDef());
        this.remove(canvasObject);
        canvasObject.getCtrlDef().getConstraints().insets = PanelElementDefinition.getStandardInsets();
        this.reindex();
    }

    public int getComponentIndex(CanvasObject canvasObject) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != canvasObject) continue;
            return i;
        }
        return -1;
    }

    public int pointToItemIndex(Point point) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).getBounds().contains(point)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasTitle() {
        String string = this.getControlTitle();
        return string != null && string.length() > 0;
    }

    public boolean hasGroupBox() {
        return this.hasTitle();
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        for (Component component : this.getComponents()) {
            Dimension dimension = component.getPreferredSize();
            n += dimension.height + 2;
        }
        n = this.hasGroupBox() ? (n += 30) : (n += 10);
        return new Dimension(this.getObjectWidth(), n);
    }

    @Override
    void render(Graphics2D graphics2D) {
        Insets insets = this.getBorder().getBorderInsets(this);
        Rectangle rectangle = this.getBounds();
        boolean bl = this.hasGroupBox();
        int n = insets.left;
        int n2 = insets.top;
        rectangle.translate(-rectangle.x, -rectangle.y);
        rectangle.grow(-n, -n2);
        if (bl) {
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(rectangle.x, rectangle.y + 10, rectangle.width - 1, rectangle.height - 11);
            if (this.hasTitle() && this.getControlTitle().trim().length() > 0) {
                String string = " " + this.getControlTitle() + " ";
                Font font = this.getFont();
                this.setFont(font);
                graphics2D.setColor(this.getParent().getBackground());
                Rectangle rectangle2 = font.getStringBounds(string, graphics2D.getFontRenderContext()).getBounds();
                rectangle2.width = Math.min(rectangle2.width, rectangle.width - 3);
                Rectangle rectangle3 = new Rectangle(rectangle.x + 3, rectangle.y, rectangle2.width, 18);
                graphics2D.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                graphics2D.setColor(Color.black);
                CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle3, null, (String)string, (int)2);
            }
        }
    }

    protected void addItemInternal(CanvasObject canvasObject, int n) {
        Insets insets = PanelElementDefinition.getStandardInsets();
        GridBagConstraints gridBagConstraints = canvasObject.getCtrlDef().getConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.left = insets.left;
        gridBagConstraints.insets.bottom = 2;
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        if (n == 0) {
            gridBagConstraints.insets.top = -6;
            gridBagConstraints2.insets.top = 18;
        }
        this.add(canvasObject, gridBagConstraints2, n);
        this.reindex();
        this.invalidate();
    }

    protected void reindex() {
        GridBagLayout gridBagLayout;
        GridBagLayout gridBagLayout2 = gridBagLayout = this.getLayout() instanceof GridBagLayout ? (GridBagLayout)this.getLayout() : null;
        if (gridBagLayout == null) {
            return;
        }
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            CanvasObject canvasObject = (CanvasObject)this.getComponent(i);
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(canvasObject);
            GridBagConstraints gridBagConstraints2 = canvasObject.getCtrlDef().getConstraints();
            gridBagConstraints.gridy = i;
            gridBagConstraints2.gridy = i;
            gridBagConstraints.weighty = i == n - 1 ? 1.0 : 0.0;
            gridBagConstraints2.weighty = i == n - 1 ? 1.0 : 0.0;
            gridBagConstraints.insets.top = i == 0 ? 18 : 2;
            gridBagLayout.setConstraints(canvasObject, gridBagConstraints);
        }
    }
}

