/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.FieldChooserDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class FieldChooserObject
extends CanvasObject {
    private ImageIcon mSingleImage;
    private ImageIcon mMultipImage;

    public FieldChooserObject(FieldChooserDefinition fieldChooserDefinition) {
        super((PanelElementDefinition)fieldChooserDefinition);
        try {
            this.mSingleImage = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image.png"));
            this.mMultipImage = new ImageIcon(BuilderResUtil.getImageResource("check_box_image.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getChooserDef().getChooserType() == FieldChooserDefinition.ChooserType.single) {
            String string = this.getControlTitle();
            int n = string != null && string.length() > 0 ? 20 : 0;
            return new Dimension(this.getObjectWidth(), n + 25);
        }
        String string = this.getControlTitle();
        int n = string != null && string.length() > 0 ? 20 : 0;
        return new Dimension(this.getObjectWidth(), n += 100);
    }

    public FieldChooserDefinition getChooserDef() {
        return (FieldChooserDefinition)this.getCtrlDef();
    }

    @Override
    void render(Graphics2D graphics2D) {
        if (this.getChooserDef().getChooserType() == FieldChooserDefinition.ChooserType.single) {
            Insets insets = this.getBorder().getBorderInsets(this);
            String string = this.getControlTitle();
            boolean bl = string != null && string.length() > 0;
            Rectangle rectangle = this.getBounds();
            ImageIcon imageIcon = this.getItemImage();
            int n = rectangle.height - imageIcon.getIconHeight() - insets.bottom;
            imageIcon.paintIcon(this, graphics2D, insets.left, n);
            if (bl) {
                this.renderTitle(graphics2D, insets.left, insets.top);
            }
        } else {
            Insets insets = this.getBorder().getBorderInsets(this);
            Rectangle rectangle = this.getBounds();
            String string = this.getControlTitle();
            boolean bl = string != null && string.length() > 0;
            int n = bl ? 20 : 0;
            Rectangle rectangle2 = new Rectangle(insets.left, insets.top + n, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom - n);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            if (bl) {
                this.renderTitle(graphics2D, insets.left, insets.top);
            }
        }
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y + 2);
        rectangle.height = 24;
        rectangle.grow(0, -n2);
        rectangle.x += n;
        rectangle.width -= n;
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }

    private ImageIcon getItemImage() {
        if (this.getChooserDef().getChooserType() == FieldChooserDefinition.ChooserType.single) {
            return this.mSingleImage;
        }
        return this.mMultipImage;
    }
}

