/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.EditCtrlDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class EditCtrlObject
extends CanvasObject {
    private static ImageIcon sSpinnerImage = null;
    private static ImageIcon sPasswordImage = null;
    private static ImageIcon sTextLeftImage = null;

    public EditCtrlObject(EditCtrlDefinition editCtrlDefinition) {
        super((PanelElementDefinition)editCtrlDefinition);
        try {
            if (sSpinnerImage == null) {
                sSpinnerImage = new ImageIcon(BuilderResUtil.getImageResource("spinner.png"));
            }
            if (sPasswordImage == null) {
                sPasswordImage = new ImageIcon(BuilderResUtil.getImageResource("password.png"));
            }
            if (sTextLeftImage == null) {
                sTextLeftImage = new ImageIcon(BuilderResUtil.getImageResource("textbox.png"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        String string = this.getControlTitle();
        int n2 = 26;
        int n3 = 0;
        if (((EditCtrlDefinition)this.getCtrlDef()).isPasswordField() || ((EditCtrlDefinition)this.getCtrlDef()).getDisplayType() == EditCtrlDefinition.DisplayType.Spinner) {
            if (string.length() > 0 && this.getCtrlDef().isLabelAbove()) {
                n2 = 28;
            } else {
                n2 = 6;
                n3 = 4;
            }
            n = 20;
        } else {
            n = string != null && string.length() > 0 ? 20 : 0;
            n2 = 10;
            if (this.getCtrlDef().isLabelAbove() || n == 0) {
                n2 = 26;
            }
        }
        return new Dimension(this.getObjectWidth() + 4, n + n2);
    }

    @Override
    void render(Graphics2D graphics2D) {
        if (((EditCtrlDefinition)this.getCtrlDef()).getDisplayType() == EditCtrlDefinition.DisplayType.Spinner || ((EditCtrlDefinition)this.getCtrlDef()).isPasswordField()) {
            if (((EditCtrlDefinition)this.getCtrlDef()).isLabelAbove()) {
                if (((EditCtrlDefinition)this.getCtrlDef()).getDisplayType() == EditCtrlDefinition.DisplayType.Spinner) {
                    this.renderLabelAboveControl(graphics2D, sSpinnerImage);
                } else {
                    this.renderLabelAboveControl(graphics2D, sPasswordImage);
                }
            } else if (((EditCtrlDefinition)this.getCtrlDef()).getDisplayType() == EditCtrlDefinition.DisplayType.Spinner) {
                this.renderSpinner(graphics2D, sSpinnerImage);
            } else {
                this.renderSpinner(graphics2D, sPasswordImage);
            }
        } else {
            int n;
            Insets insets = this.getBorder().getBorderInsets(this);
            Rectangle rectangle = this.getBounds();
            String string = this.getControlTitle();
            boolean bl = string != null && string.length() > 0;
            int n2 = n = bl ? 20 : 0;
            if (this.getCtrlDef().isLabelAbove()) {
                Rectangle rectangle2 = new Rectangle(insets.left, insets.top + n, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom - n);
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
                graphics2D.setColor(Color.gray);
                graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
                if (bl) {
                    this.renderTitle(graphics2D, insets.left, insets.top);
                }
            } else {
                this.renderSpinner(graphics2D, sTextLeftImage);
            }
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y + 2);
        rectangle.height = 24;
        rectangle.grow(-n, -n2);
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }

    void renderSpinner(Graphics2D graphics2D, ImageIcon imageIcon) {
        Insets insets = this.getBorder().getBorderInsets(this);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        int n = (rectangle.height - imageIcon.getIconHeight()) / 2;
        int n2 = rectangle.width - imageIcon.getIconWidth() - insets.right * 2;
        imageIcon.paintIcon(this, graphics2D, n2, n);
        if (string != null && string.length() > 0) {
            this.renderSpinnerTitle(graphics2D, imageIcon.getIconWidth(), insets.top);
        }
    }

    private void renderSpinnerTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y);
        Insets insets = this.getBorder().getBorderInsets(this);
        rectangle.x = insets.left;
        rectangle.y += n2;
        rectangle.width -= n + insets.left + insets.right;
        rectangle.height -= n2 * 2;
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }

    void renderLabelAboveControl(Graphics2D graphics2D, ImageIcon imageIcon) {
        Insets insets = this.getBorder().getBorderInsets(this);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        boolean bl = string != null && string.length() > 0;
        int n = bl ? 20 : 0;
        int n2 = n + insets.top;
        int n3 = insets.left + 2;
        imageIcon.paintIcon(this, graphics2D, n3, n2);
        if (string != null && string.length() > 0) {
            this.renderTitle(graphics2D, insets.left + 2, insets.top);
        }
    }
}

