/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.canvas.BuilderCanvas;
import com.spss.shared.custom_gui.ui_builder.tools.ToolItem;
import com.spss.shared.custom_gui.ui_builder.tools.ToolType;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class DraggableTabbedPane
extends JTabbedPane
implements IDropListener {
    private BuilderFrame mFrame;
    private boolean dragging = false;
    private Image tabImage = null;
    private Point currentMouseLocation = null;
    private int draggedTabIndex = -1;
    private final MouseMotionListener motionListener = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!DraggableTabbedPane.this.dragging) {
                if (DraggableTabbedPane.this.draggedTabIndex == -1) {
                    DraggableTabbedPane.this.draggedTabIndex = DraggableTabbedPane.this.getUI().tabForCoordinate(DraggableTabbedPane.this, mouseEvent.getX(), mouseEvent.getY());
                }
                if (DraggableTabbedPane.this.draggedTabIndex >= 0) {
                    Rectangle rectangle = DraggableTabbedPane.this.getUI().getTabBounds(DraggableTabbedPane.this, DraggableTabbedPane.this.draggedTabIndex);
                    BufferedImage bufferedImage = new BufferedImage(DraggableTabbedPane.this.getWidth(), DraggableTabbedPane.this.getHeight(), 2);
                    Graphics graphics = ((Image)bufferedImage).getGraphics();
                    graphics.setClip(rectangle);
                    DraggableTabbedPane.this.setDoubleBuffered(false);
                    DraggableTabbedPane.this.paintComponent(graphics);
                    DraggableTabbedPane.this.tabImage = new BufferedImage(rectangle.width, rectangle.height, 2);
                    Graphics graphics2 = DraggableTabbedPane.this.tabImage.getGraphics();
                    graphics2.drawImage(bufferedImage, 0, 0, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, DraggableTabbedPane.this);
                    DraggableTabbedPane.this.dragging = true;
                    DraggableTabbedPane.this.repaint();
                }
            } else {
                DraggableTabbedPane.this.currentMouseLocation = mouseEvent.getPoint();
                DraggableTabbedPane.this.repaint();
            }
        }
    };
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (DraggableTabbedPane.this.dragging) {
                int n = DraggableTabbedPane.this.getTargetTabIndex(mouseEvent);
                if (n == -1) {
                    n = DraggableTabbedPane.this.getTabCount() - 1;
                }
                DraggableTabbedPane.this.mFrame.tabOrderChanged(DraggableTabbedPane.this.draggedTabIndex, n, true);
            }
            DraggableTabbedPane.this.dragging = false;
            DraggableTabbedPane.this.tabImage = null;
            DraggableTabbedPane.this.draggedTabIndex = -1;
        }
    };

    public DraggableTabbedPane(BuilderFrame builderFrame) {
        this.mFrame = builderFrame;
        this.addMouseMotionListener(this.motionListener);
        this.addMouseListener(this.mouseListener);
        this.setUI(new SpacedTabbedPaneUI());
    }

    public BuilderCanvas[] getAllCanvas() {
        BuilderCanvas[] builderCanvasArray = new BuilderCanvas[this.getTabCount()];
        for (int i = 0; i < builderCanvasArray.length; ++i) {
            BuilderCanvas builderCanvas = this.findCanvas(this.getComponentAt(i));
            if (builderCanvas == null) continue;
            builderCanvasArray[i] = builderCanvas;
        }
        return builderCanvasArray;
    }

    private BuilderCanvas findCanvas(Component component) {
        JSplitPane jSplitPane;
        Component component2;
        BuilderCanvas builderCanvas = null;
        if (component instanceof BuilderCanvas) {
            builderCanvas = (BuilderCanvas)component;
        } else if (component instanceof JSplitPane && (component2 = (jSplitPane = (JSplitPane)component).getLeftComponent()) instanceof JSplitPane) {
            Component component3 = ((JSplitPane)component2).getRightComponent();
            if (component3 instanceof BuilderCanvas) {
                builderCanvas = (BuilderCanvas)component3;
            } else if (component3 instanceof JScrollPane) {
                builderCanvas = (BuilderCanvas)((JViewport)((JScrollPane)component3).getComponent(0)).getComponent(0);
            }
        }
        return builderCanvas;
    }

    public void mouseDragged(MouseEvent mouseEvent, int n) {
        this.draggedTabIndex = n;
        this.motionListener.mouseDragged(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseListener.mouseReleased(mouseEvent);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.dragging && this.currentMouseLocation != null && this.tabImage != null) {
            graphics.drawImage(this.tabImage, this.currentMouseLocation.x, this.currentMouseLocation.y, this);
        }
    }

    private int getTargetTabIndex(Point point) {
        int n = point.y;
        TabbedPaneUI tabbedPaneUI = this.getUI();
        Rectangle rectangle = tabbedPaneUI.getTabBounds(this, 0);
        if (n < rectangle.y || n >= rectangle.y + rectangle.height) {
            return -1;
        }
        int n2 = point.x;
        for (int i = 0; i < this.getTabCount(); ++i) {
            rectangle = tabbedPaneUI.getTabBounds(this, i);
            if (n2 >= rectangle.x) continue;
            if (this.draggedTabIndex < i) {
                return i - 1;
            }
            return i;
        }
        return this.getTabCount() - 1;
    }

    private int getTargetTabIndex(DropEvent dropEvent) {
        Point point = dropEvent.getDropLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        return this.getTargetTabIndex(point);
    }

    public int getTargetTabIndex(MouseEvent mouseEvent) {
        return this.getTargetTabIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        ToolItem toolItem;
        Object object = dragDropAdapter.getTransferData();
        return object instanceof ToolItem && (toolItem = (ToolItem)object).getToolType() == ToolType.DIALOG_TAB_CONTROL;
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        if (this.contains(point)) {
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point2, this);
            if (!this.canDrop(dragDropAdapter)) {
                Cursor cursor;
                try {
                    cursor = Cursor.getSystemCustomCursor("CopyNoDrop32x32");
                }
                catch (AWTException aWTException) {
                    aWTException.printStackTrace();
                    cursor = Cursor.getPredefinedCursor(3);
                }
                return cursor;
            }
            return Cursor.getPredefinedCursor(12);
        }
        return null;
    }

    @Override
    public boolean contains(Point point) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this);
        Rectangle rectangle = this.getTabComponentAt(0).getBounds();
        Rectangle rectangle2 = this.getBounds();
        Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, (int)rectangle2.getWidth(), (int)rectangle.getHeight());
        return rectangle3.contains(point2);
    }

    public void itemDropped(DropEvent dropEvent) {
        if (!this.canDrop(dropEvent.getDragSourceAdapter())) {
            return;
        }
        if (this.contains(dropEvent.getDropLocation())) {
            int n = this.getTargetTabIndex(dropEvent);
            BuilderUtil.getInstance().createDialogTab(this.mFrame, n + 1);
        }
    }

    public class SpacedTabbedPaneUI
    extends BasicTabbedPaneUI {
        private static final int SPACE_BETWEEN_TAB = 5;

        @Override
        protected void installDefaults() {
            super.installDefaults();
            this.selectedTabPadInsets.left = 5;
            this.selectedTabPadInsets.right = 5;
        }

        @Override
        protected LayoutManager createLayoutManager() {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                return super.createLayoutManager();
            }
            return new BasicTabbedPaneUI.TabbedPaneLayout(){

                @Override
                protected void padSelectedTab(int n, int n2) {
                    for (Rectangle rectangle : SpacedTabbedPaneUI.this.rects) {
                        Insets insets = SpacedTabbedPaneUI.this.getSelectedTabPadInsets(n);
                        rectangle.x += insets.left;
                        rectangle.width -= insets.left + insets.right;
                        rectangle.y -= insets.top;
                        rectangle.height += insets.top + insets.bottom;
                    }
                }
            };
        }
    }
}

