/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ItemGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.RadioGroupObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.ComboBoxDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ComboBoxObject
extends CanvasObject {
    private static ImageIcon sItemImage = null;
    private static ImageIcon sItemImageSmall = null;
    private static ImageIcon sItemImageSmaller = null;
    private static ImageIcon sItemImageLeft = null;
    private static ImageIcon sItemImageSmallLeft = null;
    private static ImageIcon sItemImageSmallerLeft = null;

    public ComboBoxObject(ComboBoxDefinition comboBoxDefinition) {
        super((PanelElementDefinition)comboBoxDefinition);
        try {
            if (sItemImage == null) {
                sItemImage = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image.png"));
            }
            if (sItemImageSmall == null) {
                sItemImageSmall = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image_small.png"));
            }
            if (sItemImageSmaller == null) {
                sItemImageSmaller = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image_smaller.png"));
            }
            if (sItemImageSmallLeft == null) {
                sItemImageSmallLeft = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image_small_left.png"));
            }
            if (sItemImageSmallerLeft == null) {
                sItemImageSmallerLeft = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image_smaller_left.png"));
            }
            if (sItemImageLeft == null) {
                sItemImageLeft = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image_left.png"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ComboBoxDefinition getComboDef() {
        return (ComboBoxDefinition)this.getCtrlDef();
    }

    @Override
    public Dimension getPreferredSize() {
        String string = this.getControlTitle();
        int n = string != null && string.length() > 0 ? 20 : 0;
        int n2 = 10;
        if (this.getCtrlDef().isLabelAbove() || n == 0) {
            n2 = 26;
        }
        return new Dimension(this.getObjectWidth(), n + n2);
    }

    @Override
    void render(Graphics2D graphics2D) {
        Insets insets = this.getBorder().getBorderInsets(this);
        String string = this.getControlTitle();
        boolean bl = string != null && string.length() > 0;
        Rectangle rectangle = this.getBounds();
        ImageIcon imageIcon = this.getImageIcon();
        if (this.getCtrlDef().isLabelAbove()) {
            int n = rectangle.height - imageIcon.getIconHeight() - insets.bottom;
            imageIcon.paintIcon(this, graphics2D, insets.left, n);
            if (bl) {
                this.renderTitle(graphics2D, insets.left, insets.top);
            }
        } else {
            int n = (rectangle.height - imageIcon.getIconHeight()) / 2;
            int n2 = rectangle.width - imageIcon.getIconWidth() - insets.right * 2;
            imageIcon.paintIcon(this, graphics2D, n2, n);
            if (string != null && string.length() > 0) {
                this.renderTitleLeft(graphics2D, imageIcon.getIconWidth(), insets.top);
            }
        }
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y + 2);
        rectangle.height = 24;
        rectangle.grow(-n, -n2);
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }

    private void renderTitleLeft(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y);
        Insets insets = this.getBorder().getBorderInsets(this);
        rectangle.x = insets.left;
        rectangle.y += n2;
        rectangle.width -= n + insets.left + insets.right;
        rectangle.height -= n2 * 2;
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }

    private ImageIcon getImageIcon() {
        if (this.getParent() instanceof ItemGroupObject) {
            if (this.getCtrlDef().isLabelAbove()) {
                return sItemImageSmall;
            }
            return sItemImageSmallLeft;
        }
        if (this.getParent().getParent() instanceof RadioGroupObject) {
            if (this.getCtrlDef().isLabelAbove()) {
                return sItemImageSmaller;
            }
            return sItemImageSmallerLeft;
        }
        if (!this.getCtrlDef().isLabelAbove()) {
            return sItemImageLeft;
        }
        return sItemImage;
    }
}

