/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.ColorPickerDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ColorPickerCtrlObject
extends CanvasObject {
    private static ImageIcon sItemImage = null;

    public ColorPickerCtrlObject(ColorPickerDefinition colorPickerDefinition) {
        super((PanelElementDefinition)colorPickerDefinition);
        try {
            if (sItemImage == null) {
                sItemImage = new ImageIcon(BuilderResUtil.getImageResource("colorpicker.png"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        String string = this.getControlTitle();
        int n = 20;
        int n2 = 18;
        if (this.getCtrlDef().isLabelAbove() && string.length() > 0) {
            n2 = 28;
        }
        return new Dimension(this.getObjectWidth(), n + n2);
    }

    @Override
    void render(Graphics2D graphics2D) {
        Insets insets = this.getBorder().getBorderInsets(this);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        if (this.getCtrlDef().isLabelAbove()) {
            boolean bl = string != null && string.length() > 0;
            int n = bl ? 20 : 0;
            int n2 = n + insets.top;
            int n3 = insets.left + 2;
            sItemImage.paintIcon(this, graphics2D, n3, n2);
            if (string != null && string.length() > 0) {
                this.renderTitleTop(graphics2D, insets.left + 2, insets.top);
            }
        } else {
            int n = (rectangle.height - sItemImage.getIconHeight()) / 2;
            int n4 = rectangle.width - sItemImage.getIconWidth() - insets.right * 2;
            sItemImage.paintIcon(this, graphics2D, n4, n);
            if (string != null && string.length() > 0) {
                this.renderTitle(graphics2D, sItemImage.getIconWidth(), insets.top);
            }
        }
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y);
        Insets insets = this.getBorder().getBorderInsets(this);
        rectangle.x = insets.left;
        rectangle.y += n2;
        rectangle.width -= n + insets.left + insets.right;
        rectangle.height -= n2 * 2;
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }

    private void renderTitleTop(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y + 2);
        rectangle.height = 20;
        rectangle.grow(-n, -n2);
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }

    private ImageIcon getImageIcon() {
        return sItemImage;
    }
}

